/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jpws.front.HistoryHandler;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.global.UUID;

public class Exchange {
    public static Object getFieldContent(PwsRecord pwsRecord, DataField dataField) {
        if (pwsRecord == null | dataField == null) {
            return null;
        }
        Object object = null;
        switch (dataField.getName()) {
            case 1: {
                object = pwsRecord.getGroup();
                break;
            }
            case 2: {
                object = pwsRecord.getTitle();
                break;
            }
            case 3: {
                object = pwsRecord.getUsernamePws();
                break;
            }
            case 4: {
                object = pwsRecord.getPassword();
                break;
            }
            case 5: {
                object = pwsRecord.getNotesPws();
                break;
            }
            case 7: {
                object = pwsRecord.getRecordID();
                break;
            }
            case 8: {
                object = pwsRecord.getUrlPws();
                break;
            }
            case 9: {
                object = Exchange.historyListValue(pwsRecord.getHistory());
                break;
            }
            case 33: {
                object = new Long(pwsRecord.getCreateTime());
                break;
            }
            case 34: {
                object = new Long(pwsRecord.getModifiedTime());
                break;
            }
            case 35: {
                object = new Long(pwsRecord.getAccessTime());
                break;
            }
            case 37: {
                object = new Long(pwsRecord.getPassLifeTime());
                break;
            }
            case 36: {
                object = new Long(pwsRecord.getPassModTime());
            }
        }
        return object;
    }

    private static String historyListValue(String string) {
        if (string == null) {
            return null;
        }
        char c = ',';
        HistoryHandler historyHandler = new HistoryHandler(string);
        String[] stringArray = new String[historyHandler.getListSize()];
        Iterator iterator = historyHandler.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = ((HistoryHandler.Entry)iterator.next()).toExportString(c);
            ++n;
        }
        String string2 = Util.CSV.encodeLine(stringArray, c);
        return string2;
    }

    public static List getNormalizedFieldList(FieldSet fieldSet) {
        ArrayList<DataField> arrayList = new ArrayList<DataField>();
        if (fieldSet == null) {
            return null;
        }
        Iterator iterator = fieldSet.iterator();
        while (iterator.hasNext()) {
            DataField dataField = (DataField)iterator.next();
            int n = arrayList.size();
            for (int i = 0; i < arrayList.size(); ++i) {
                DataField dataField2 = (DataField)arrayList.get(i);
                if (dataField.getName() >= dataField2.getName()) continue;
                arrayList.add(i, dataField);
                break;
            }
            if (arrayList.size() != n) continue;
            arrayList.add(dataField);
        }
        return arrayList;
    }

    public static FieldSet allFields() {
        FieldSet fieldSet = new FieldSet();
        fieldSet.add(new DataField(1));
        fieldSet.add(new DataField(2));
        fieldSet.add(new DataField(3));
        fieldSet.add(new DataField(4));
        fieldSet.add(new DataField(5));
        fieldSet.add(new DataField(7));
        fieldSet.add(new DataField(8));
        fieldSet.add(new DataField(9));
        fieldSet.add(new DataField(33));
        fieldSet.add(new DataField(34));
        fieldSet.add(new DataField(36));
        fieldSet.add(new DataField(37));
        fieldSet.add(new DataField(35));
        return fieldSet;
    }

    public static FieldSet essentialFields() {
        FieldSet fieldSet = new FieldSet();
        fieldSet.add(new DataField(1));
        fieldSet.add(new DataField(2));
        fieldSet.add(new DataField(3));
        fieldSet.add(new DataField(4));
        fieldSet.add(new DataField(8));
        fieldSet.add(new DataField(5));
        fieldSet.add(new DataField(37));
        return fieldSet;
    }

    public static class DataField {
        public static final int GROUP = 1;
        public static final int TITLE = 2;
        public static final int USER = 3;
        public static final int PASSWORD = 4;
        public static final int NOTES = 5;
        public static final int UUID = 7;
        public static final int URL = 8;
        public static final int HISTORY = 9;
        public static final int T_CREATED = 33;
        public static final int T_MODIFIED = 34;
        public static final int T_PASSACCESS = 35;
        public static final int T_PASSMODIFIED = 36;
        public static final int T_PASSEXPIRY = 37;
        private int name;

        public DataField(int n) {
            this.name = n;
        }

        public String toString() {
            return DataField.stringForName(this.name);
        }

        public int getName() {
            return this.name;
        }

        public static String stringForName(int n) {
            String string = null;
            switch (n) {
                case 1: {
                    string = "GROUP";
                    break;
                }
                case 2: {
                    string = "TITLE";
                    break;
                }
                case 3: {
                    string = "USER";
                    break;
                }
                case 4: {
                    string = "PASSWORD";
                    break;
                }
                case 5: {
                    string = "NOTES";
                    break;
                }
                case 7: {
                    string = "UUID";
                    break;
                }
                case 8: {
                    string = "URL";
                    break;
                }
                case 9: {
                    string = "PWHISTORY";
                    break;
                }
                case 33: {
                    string = "T_CREATED";
                    break;
                }
                case 34: {
                    string = "T_MODIFIED";
                    break;
                }
                case 35: {
                    string = "T_PASSACCESS";
                    break;
                }
                case 37: {
                    string = "T_PASSEXPIRY";
                    break;
                }
                case 36: {
                    string = "T_PASSMODIFIED";
                }
            }
            return string;
        }
    }

    public static class FieldSet
    extends HashSet {
        public boolean add(Object object) {
            if (!(object instanceof DataField)) {
                throw new IllegalArgumentException("object is not a DataField");
            }
            return super.add(object);
        }
    }

    public static class RecordSet
    extends HashSet {
        public boolean add(Object object) {
            if (!(object instanceof UUID)) {
                throw new IllegalArgumentException("object is not a UUID");
            }
            return super.add(object);
        }
    }
}

