/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.UIManager;
import org.jpws.data.Options;
import org.jpws.front.Global;
import org.jpws.front.MenuHandler;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.StatusBar;
import org.jpws.front.util.RecentList;

public class DisplayManager {
    private static HashMap fontStore;
    private static String[] avFonts;
    private static Font defaultFont;
    private static Font menuDefault;
    private static Font passwordDefault;
    private static Font displayDefault;

    public static void init() {
        fontStore = new HashMap();
        defaultFont = Font.decode("Dialog-PLAIN-12");
        passwordDefault = Font.decode("DialogInput-BOLD-14");
        menuDefault = Font.decode("Comic Sans MS-ITALIC-13");
        displayDefault = DisplayManager.isSystemFontFamily("Trebuchet MS") ? Font.decode("Trebuchet MS-PLAIN-13") : defaultFont;
        DisplayManager.initCanonFont("menu");
        DisplayManager.initCanonFont("control");
        DisplayManager.initCanonFont("tooltip");
        DisplayManager.initCanonFont("display");
        DisplayManager.initCanonFont("data");
        DisplayManager.initCanonFont("password");
        DisplayManager.initCanonFont("notes");
    }

    private static void initCanonFont(String string) {
        Font font = DisplayManager.fontForToken("Font." + string);
        if (font == null) {
            font = DisplayManager.getDefaultFont(string);
        }
        DisplayManager.setFont(string, font);
    }

    private static boolean isSystemFontFamily(String string) {
        for (int i = 0; i < avFonts.length; ++i) {
            if (!avFonts[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static void setDisplayFont(Font font) {
        if (font == null) {
            return;
        }
        UIManager.put("TextField.font", font);
        UIManager.put("FormattedTextField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("Tree.font", font);
        UIManager.put("List.font", font);
        PwsFileContainer pwsFileContainer = Global.getSelectedFile();
        if (pwsFileContainer != null) {
            pwsFileContainer.setFont(font);
        }
    }

    private static void setControlFont(Font font) {
        if (font == null) {
            return;
        }
        Font font2 = font.deriveFont(1);
        Font font3 = font.deriveFont(0);
        Font font4 = font.deriveFont(1 + (font.isItalic() ? 2 : 0));
        UIManager.put("Label.font", font4);
        UIManager.put("CheckBox.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("Button.font", font2);
        UIManager.put("ComboBox.font", font2);
        UIManager.put("ProgressBar.font", font2);
        UIManager.put("Spinner.font", font2);
        UIManager.put("TabbedPane.font", font2);
        StatusBar statusBar = Global.getStatusBar();
        if (statusBar != null) {
            statusBar.setFont(font3);
        }
    }

    public static Font getFont(String string) {
        Font font = (Font)fontStore.get(string);
        if (font != null) {
            return font;
        }
        return null;
    }

    public static Font getDefaultFont(String string) {
        Font font = defaultFont;
        if (string.equals("menu")) {
            font = menuDefault;
        } else if (string.equals("tooltip")) {
            font = menuDefault.deriveFont(0, 14.0f);
        } else if (string.equals("password")) {
            font = passwordDefault;
        } else if (string.equals("display")) {
            font = displayDefault;
        }
        return font;
    }

    public static void setFont(String string, Font font) {
        if (string == null || string.length() == 0 || font == null) {
            throw new IllegalArgumentException();
        }
        fontStore.put(string, font);
        if (string.equals("display")) {
            DisplayManager.setDisplayFont(font);
        } else if (string.equals("control")) {
            DisplayManager.setControlFont(font);
        } else if (string.equals("tooltip")) {
            UIManager.put("ToolTip.font", font);
        } else if (string.equals("menu")) {
            MenuHandler.setMenuFont(font);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Font fontForToken(String string) {
        RecentList recentList;
        Font font = null;
        if (Global.isPortable() && (recentList = Options.getOptionHistory(string)) != null && recentList.getSize() != 0) {
            Iterator iterator = recentList.iterator();
            while (iterator.hasNext()) {
                try {
                    String string2 = (String)iterator.next();
                    if (!DisplayManager.isSystemFontFamily(string2.substring(0, string2.indexOf(45)))) continue;
                    return Font.decode(string2);
                }
                catch (Exception exception) {
                    System.out.println("*** FAULTY FONT ENTRY in option history: " + string);
                }
            }
            return font;
        }
        String string3 = Options.getOption(string);
        if (string3.length() == 0) return font;
        try {
            if (!DisplayManager.isSystemFontFamily(string3.substring(0, string3.indexOf(45)))) return font;
            return Font.decode(string3);
        }
        catch (Exception exception) {
            System.out.println("*** FAULTY FONT ENTRY in options: " + string);
        }
        return font;
    }

    public static void storeFont(String string, Font font) {
        if (string == null | font == null) {
            throw new NullPointerException();
        }
        Options.setOption("Font." + string, DisplayManager.fontCode(font));
    }

    public static String fontCode(Font font) {
        if (font == null) {
            return null;
        }
        int n = font.getStyle();
        String string = "PLAIN";
        if (n == 1) {
            string = "BOLD";
        } else if (n == 2) {
            string = "ITALIC";
        } else if (n == 3) {
            string = "BOLDITALIC";
        }
        return font.getFamily() + "-" + string + "-" + font.getSize();
    }

    static {
        avFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }
}

