/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.SortedMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jpws.data.Options;
import org.jpws.data.UserBreakException;
import org.jpws.front.ActionHandler;
import org.jpws.front.FileOpenDialog;
import org.jpws.front.Global;
import org.jpws.front.PasswordDialog;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.HtmlBrowserDialog;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.front.util.VerticalFlowLayout;
import org.jpws.pwslib.data.PwsPassphrase;

public class GUIService {
    public static final int ANYFILE_CHOOSER = 0;
    public static final int PWSFILE_CHOOSER = 1;
    public static final int BACKUPFILE_CHOOSER = 2;
    public static final int EXECFILE_CHOOSER = 3;
    private static HashMap objectMap = new HashMap();

    private GUIService() {
    }

    public static void infoMessage(Component component, String string, String string2) {
        if (string == null) {
            string = "dlg.information";
        }
        if (component == null) {
            component = Global.getActiveFrame();
        }
        String string3 = ResourceLoader.codeOrRealDisplay(string);
        String string4 = ResourceLoader.codeOrRealDisplay(string2);
        JOptionPane.showMessageDialog(component, string4, string3, 1);
        ActionHandler.resetIdleTime();
    }

    public static void warningMessage(Component component, String string, String string2) {
        if (string == null) {
            string = "dlg.warning";
        }
        if (component == null) {
            component = Global.getActiveFrame();
        }
        String string3 = ResourceLoader.codeOrRealDisplay(string);
        String string4 = ResourceLoader.codeOrRealDisplay(string2);
        JOptionPane.showMessageDialog(component, string4, string3, 2);
        ActionHandler.resetIdleTime();
    }

    public static void statusConfirm(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        if (string != null) {
            string3 = ResourceLoader.getDisplay(string);
            stringBuffer.append(string3);
        }
        if (string3 != null & string2 != null) {
            stringBuffer.append(" ");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        Global.setStatusText(stringBuffer.toString());
    }

    public static void statusConfirm(String string) {
        GUIService.statusConfirm(string, null);
    }

    public static int editBrowserOption() {
        File file;
        FileOpenDialog fileOpenDialog = new FileOpenDialog(4, System.getProperty("user.home"));
        fileOpenDialog.setDialogTitle(ResourceLoader.getDisplay("dlg.choosebrowser"));
        int n = fileOpenDialog.showOpenDialog(Global.mainFrame);
        fileOpenDialog.dispose();
        ActionHandler.resetIdleTime();
        if (n == 0 && (file = fileOpenDialog.getSelectedFile()) != null) {
            String string;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = "";
            }
            Options.setOption("browserApplication", string);
        }
        return n;
    }

    public static PwsPassphrase enterNewPassphrase(String string) {
        block4: {
            PwsPassphrase pwsPassphrase;
            while (true) {
                char[] cArray;
                PasswordDialog passwordDialog;
                if ((passwordDialog = new PasswordDialog((Frame)Global.mainFrame, string, 1)).isOkPressed()) {
                    cArray = passwordDialog.getEnteredPassword();
                    if (cArray.length < 5 | Util.textVariance(cArray) < 5) {
                        GUIService.infoMessage("dlg.badvalue", "msg.badpassformat");
                        continue;
                    }
                } else {
                    return null;
                }
                pwsPassphrase = new PwsPassphrase(cArray);
                passwordDialog = new PasswordDialog((Frame)Global.mainFrame, string, 2);
                if (!passwordDialog.isOkPressed()) break block4;
                cArray = passwordDialog.getEnteredPassword();
                if (new PwsPassphrase(cArray).equals(pwsPassphrase)) break;
                GUIService.infoMessage("dlg.badvalue", "msg.badpassconfirm");
            }
            return pwsPassphrase;
        }
        return null;
    }

    public static URL chooseSaveFilePath(Component component, String string, int n, int n2, File file) {
        File file2;
        if (n < 0 | n > 3) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = n == 1 ? 3 : (n == 2 ? 2 : (n == 3 ? 4 : 0));
        }
        File file3 = Global.currentDir;
        if (n == 2) {
            file3 = Global.backDir;
        }
        FileOpenDialog fileOpenDialog = new FileOpenDialog(n2, file3);
        if (string != null) {
            fileOpenDialog.setDialogTitle(string);
        }
        if (file != null) {
            fileOpenDialog.setSelectedFile(file);
        }
        if (component == null) {
            component = Global.getActiveFrame();
        }
        if (fileOpenDialog.showSaveDialog(component) == 0 && (file2 = fileOpenDialog.getSelectedFile()) != null) {
            String string2;
            file3 = fileOpenDialog.getCurrentDirectory();
            if (n == 2) {
                Global.backDir = file3;
            } else if (n != 3) {
                Global.currentDir = file3;
            }
            String string3 = null;
            if (n == 1) {
                string3 = ".dat";
            }
            if (n == 2) {
                string3 = ".bak";
            }
            if (string3 != null && (string2 = file2.getPath()).lastIndexOf(".") == -1) {
                file2 = new File(string2 + string3);
            }
            try {
                return Util.makeFileURL(file2.getPath());
            }
            catch (Exception exception) {
                GUIService.failureMessage("msg.url.formerror", exception);
                return null;
            }
        }
        return null;
    }

    public static void infoMessage(String string, String string2) {
        GUIService.infoMessage(null, string, string2);
    }

    public static boolean overwriteConfirm(Component component, File file) {
        return GUIService.overwriteConfirm(component, file.getAbsolutePath());
    }

    public static boolean overwriteConfirm(Component component, URL uRL) {
        return GUIService.overwriteConfirm(component, Global.getFilePath(uRL));
    }

    public static boolean overwriteConfirm(Component component, String string) {
        String string2;
        String string3 = ResourceLoader.getDisplay("msg.ask.overwritefile");
        boolean bl = JOptionPane.showConfirmDialog(component, string3 = Util.substituteText(string3, "$file", string), string2 = ResourceLoader.getDisplay("dlg.confirm"), 0) == 0;
        ActionHandler.resetIdleTime();
        return bl;
    }

    public static boolean passwordControl(PwsPassphrase pwsPassphrase, String string, boolean bl) {
        if (pwsPassphrase == null) {
            return true;
        }
        while (true) {
            PasswordDialog passwordDialog;
            if (!(passwordDialog = new PasswordDialog(Global.getActiveFrame(), string, 3, bl)).isOkPressed()) {
                return false;
            }
            PwsPassphrase pwsPassphrase2 = new PwsPassphrase(passwordDialog.getEnteredPassword());
            if (pwsPassphrase2.equals(pwsPassphrase)) break;
            GUIService.infoMessage("dlg.badvalue", "msg.failpassword");
        }
        return true;
    }

    public static boolean passwordControl(PwsFileContainer pwsFileContainer, boolean bl) {
        return GUIService.passwordControl(pwsFileContainer.getPassphrase(), pwsFileContainer.getDatabaseName(), bl);
    }

    public static boolean passwordControl(PwsFileContainer pwsFileContainer) {
        return GUIService.passwordControl(pwsFileContainer.getPassphrase(), pwsFileContainer.getDatabaseName(), false);
    }

    public static void failureMessage(String string, Exception exception) {
        String string2 = ResourceLoader.codeOrRealDisplay(string) + (exception == null ? "" : "\r\n" + exception);
        String string3 = ResourceLoader.getDisplay("dlg.operfailure");
        JOptionPane.showMessageDialog(Global.mainFrame, string2, string3, 0);
        ActionHandler.resetIdleTime();
    }

    public static boolean userConfirm(Component component, String string) {
        if (component == null) {
            component = Global.getActiveFrame();
        }
        String string2 = ResourceLoader.getDisplay("dlg.confirm");
        boolean bl = JOptionPane.showConfirmDialog(component, string = ResourceLoader.codeOrRealDisplay(string), string2, 0) == 0;
        ActionHandler.resetIdleTime();
        return bl;
    }

    public static boolean userConfirm(String string) {
        return GUIService.userConfirm(null, string);
    }

    public static int userConfirmOption(Component component, String string) {
        if (component == null) {
            component = Global.getActiveFrame();
        }
        ActionHandler.resetIdleTime();
        String string2 = ResourceLoader.getDisplay("dlg.confirm");
        string = ResourceLoader.codeOrRealDisplay(string);
        int n = JOptionPane.showConfirmDialog(component, string, string2, 1);
        if (n == -1) {
            n = 2;
        }
        ActionHandler.resetIdleTime();
        return n;
    }

    public static int userConfirmOption(String string) {
        return GUIService.userConfirmOption(null, string);
    }

    public static String userInput(Component component, String string, String string2, String string3) {
        if (component == null) {
            component = Global.getActiveFrame();
        }
        if (string == null) {
            string = "dlg.input";
        }
        string = ResourceLoader.codeOrRealDisplay(string);
        string2 = ResourceLoader.codeOrRealDisplay(string2);
        return (String)JOptionPane.showInputDialog(component, string2, string, 3, null, null, string3);
    }

    public static int userCombiInput(Component component, String string, String string2, Component[] componentArray) {
        if (componentArray == null) {
            throw new NullPointerException();
        }
        if (component == null) {
            component = Global.getActiveFrame();
        }
        if (string == null) {
            string = "dlg.input";
        }
        string = ResourceLoader.codeOrRealDisplay(string);
        JPanel jPanel = new JPanel(new VerticalFlowLayout(10));
        if (string2 != null) {
            JLabel jLabel = new JLabel(string2);
            jPanel.add(jLabel);
        }
        for (int i = 0; i < componentArray.length; ++i) {
            jPanel.add(componentArray[i]);
        }
        int n = JOptionPane.showConfirmDialog(component, jPanel, string, 2);
        return n == 0 ? 0 : 2;
    }

    public static JComboBox getListedCharsetsCombo() {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Object[] objectArray = sortedMap.values().toArray();
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setSelectedItem(Charset.forName(Global.getDefaultCharset()));
        return jComboBox;
    }

    public static int integerInput(Component component, String string, String string2, int n, int n2, int n3) throws UserBreakException {
        int n4;
        string = ResourceLoader.codeOrRealDisplay(string == null ? "dlg.input" : string);
        if (string2 == null) {
            string2 = ResourceLoader.getDisplay("dlg.input.integer.range");
            string2 = Util.substituteText(string2, "$lowbound", String.valueOf(n));
            string2 = Util.substituteText(string2, "$highbound", String.valueOf(n2));
        } else {
            string2 = ResourceLoader.codeOrRealDisplay(string2);
        }
        while (true) {
            String string3 = String.valueOf(n3);
            string3 = (String)JOptionPane.showInputDialog(component, string2, string, 3, null, null, string3);
            ActionHandler.resetIdleTime();
            if (string3 == null) {
                throw new UserBreakException();
            }
            try {
                n4 = Integer.parseInt(string3.trim());
                if (!(n4 < n | n4 > n2)) break;
                string3 = ResourceLoader.getDisplay("msg.illegalinteger.range");
                string3 = Util.substituteText(string3, "$lowbound", String.valueOf(n));
                string3 = Util.substituteText(string3, "$highbound", String.valueOf(n2));
                GUIService.infoMessage(component, "dlg.badvalue", string3);
            }
            catch (NumberFormatException numberFormatException) {
                GUIService.infoMessage(component, "dlg.badvalue", "msg.badintegervalue");
            }
        }
        return n4;
    }

    public static void startHelpDialog(Window window, String string) {
        HelpDialog helpDialog = null;
        String string2 = "bounds_".concat(string);
        String string3 = "html.file.".concat(string);
        try {
            helpDialog = (HelpDialog)objectMap.get(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (helpDialog == null) {
            helpDialog = window instanceof Dialog ? new HelpDialog((Dialog)window, string) : new HelpDialog((Frame)window, string);
            helpDialog.setBoundsToken(string2, true);
            try {
                String string4 = "#standards/" + ResourceLoader.getCommand(string3);
                helpDialog.setPage(ResourceLoader.getResourceURL(string4));
                objectMap.put(string, helpDialog);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        helpDialog.moveRelatedTo(window);
        helpDialog.show();
    }

    private static class HelpDialog
    extends HtmlBrowserDialog {
        private String name;

        public HelpDialog(Dialog dialog, String string) throws HeadlessException {
            super(dialog, ResourceLoader.getDisplay(string), false);
            this.name = string;
        }

        public HelpDialog(Frame frame, String string) throws HeadlessException {
            super(frame, ResourceLoader.getDisplay(string), false);
            this.name = string;
        }

        public void dispose() {
            super.dispose();
            objectMap.remove(this.name);
        }
    }
}

