/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;

public class HistoryHandler
extends JPanel {
    private static final int MAX_ENTRIES = 255;
    private RecentList pwlist;
    private JScrollPane scrollPane;
    private JTextArea textArea = new JTextArea();
    private boolean isOff;

    public HistoryHandler() {
        super(new BorderLayout(0, 2));
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.add((Component)this.scrollPane, "Center");
        JLabel jLabel = new JLabel("2005-24-13 23:28  ");
        Font font = jLabel.getFont();
        font = font.deriveFont(0, font.getSize2D() - 1.0f);
        jLabel.setFont(this.textArea.getFont());
        int n = jLabel.getPreferredSize().width;
        int n2 = jLabel.getPreferredSize().height;
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jLabel = new JLabel(ResourceLoader.getDisplay("table.created"));
        jLabel.setPreferredSize(new Dimension(n, n2));
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jLabel = new JLabel(ResourceLoader.getDisplay("table.password"));
        jLabel.setFont(font);
        jPanel.add(jLabel);
        this.add((Component)jPanel, "North");
        this.pwlist = new RecentList(16);
    }

    public HistoryHandler(String string) {
        this();
        this.setContentPw3(string);
    }

    public void pushPassword(String string, long l) {
        if (!this.isOff) {
            this.pwlist.pushRecent(new Entry(string, l));
            this.updateDisplay();
        }
    }

    public void clear() {
        this.pwlist.clear();
        this.updateDisplay();
    }

    public Iterator iterator() {
        return this.pwlist.iterator();
    }

    public boolean isActive() {
        return !this.isOff;
    }

    public void setActive(boolean bl) {
        this.isOff = !bl;
    }

    public void setMaxItems(int n) {
        boolean bl = (n = Math.max(Math.min(n, 255), 0)) < this.pwlist.getSize();
        this.pwlist.setMaxEntries(n);
        if (bl) {
            this.updateDisplay();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.textArea != null) {
            this.textArea.setFont(font);
        }
    }

    private void updateDisplay() {
        String string = "";
        Iterator iterator = this.pwlist.iterator();
        while (iterator.hasNext()) {
            string = string + "\r\n".concat(iterator.next().toString());
        }
        this.textArea.setText(string);
    }

    public int getListSize() {
        return this.pwlist.getSize();
    }

    public int getMaxEntries() {
        return this.pwlist.getMaxEntries();
    }

    public void setContentPw3(String string) {
        this.pwlist.clear();
        if (string == null || string.length() == 0) {
            return;
        }
        this.isOff = string.charAt(0) == '0';
        int n = Integer.valueOf(string.substring(1, 3), 16);
        int n2 = Integer.valueOf(string.substring(3, 5), 16);
        this.setMaxItems(n);
        int n3 = 5;
        for (int i = 0; i < n2; ++i) {
            String string2 = string.substring(n3, n3 + 8);
            long l = Long.valueOf(string2, 16) * 1000L;
            string2 = string.substring(n3 + 8, n3 + 12);
            int n4 = Integer.valueOf(string2, 16);
            String string3 = string.substring(n3 + 12, n3 + 12 + n4);
            this.pwlist.pushRecent(new Entry(string3, l));
            n3 += 12 + n4;
        }
        this.updateDisplay();
    }

    public String getContentPw3() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isOff ? (char)'0' : '1');
        stringBuffer.append(Util.byteToHex(this.getMaxEntries()));
        stringBuffer.append(Util.byteToHex(this.getListSize()));
        Object[] objectArray = this.pwlist.getContent();
        for (int i = objectArray.length; i > 0; --i) {
            String string = ((Entry)objectArray[i - 1]).toPW3String();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static class Entry {
        private String pwd;
        private long time;

        Entry(String string, long l) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.pwd = string;
            this.time = l;
        }

        public String toString() {
            String string = this.time == 0L ? "------------------" : Util.standardTimeString(this.time).substring(0, 16);
            return string + "  " + this.pwd;
        }

        public String toPW3String() {
            String string = Util.intToHex(this.time / 1000L) + Util.shortToHex(this.pwd.length()) + this.pwd;
            return string;
        }

        public String toExportString(char c) {
            String[] stringArray = new String[]{Util.xmlTimeString(this.time), this.pwd};
            return Util.CSV.encodeLine(stringArray, c);
        }

        public String getPassword() {
            return this.pwd;
        }

        public long getTime() {
            return this.time;
        }
    }
}

