/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jpws.front.DisplayManager;
import org.jpws.front.Global;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.DefaultButtonBarListener;
import org.jpws.front.util.ResourceLoader;

public class PasswordDialog
extends ButtonBarDialog {
    public static final int ACCESS = 0;
    public static final int DEFINE = 1;
    public static final int CONFIRM = 2;
    public static final int CONTROL = 3;
    private JButton exitButton;
    private JPasswordField enteredPassword;

    public PasswordDialog(Frame frame, String string, int n) throws HeadlessException {
        this(frame, string, n, false);
    }

    public PasswordDialog(Frame frame, String string, int n, boolean bl) throws HeadlessException {
        super(frame, 3, true);
        String string2 = "dlg.password.access";
        String string3 = "pwdlg.enter";
        if (n == 1) {
            string2 = "dlg.password.define";
            string3 = "pwdlg.define";
        } else if (n == 2) {
            string2 = "dlg.password.define";
            string3 = "pwdlg.confirm";
        } else if (n == 3) {
            string2 = "dlg.password.control";
            string3 = "pwdlg.control";
        }
        this.setTitle(ResourceLoader.getDisplay(string2));
        this.buildButtonPanel(bl);
        this.buildCentrePanel(string, ResourceLoader.getDisplay(string3));
        this.setVisible(true);
    }

    private void buildButtonPanel(boolean bl) {
        if (bl) {
            this.exitButton = new JButton(ResourceLoader.getCommand("menu.file.exit"));
            this.exitButton.setToolTipText(ResourceLoader.getCommand("toolbar.exit.tooltip"));
            this.getButtonBar().add(this.exitButton);
        }
        DefaultButtonBarListener defaultButtonBarListener = new DefaultButtonBarListener(this){

            public boolean extraButtonPerformed(Object object) {
                if (object == PasswordDialog.this.exitButton & object != null) {
                    Global.exit(true);
                }
                return false;
            }
        };
        this.setButtonBarListener(defaultButtonBarListener);
    }

    private void buildCentrePanel(String string, String string2) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(20, 20, 8, 20));
        this.enteredPassword = new JPasswordField(20);
        this.enteredPassword.enableInputMethods(true);
        this.enteredPassword.setFont(DisplayManager.getFont("password"));
        if (string == null) {
            string = "?";
        }
        String string3 = "<html><font color=\"green\" size=\"+1\">" + string + "</font></html>";
        JLabel jLabel = new JLabel(string3);
        jPanel.add(jLabel);
        jPanel.add(new JLabel(string2));
        jPanel.add(this.enteredPassword);
        this.setDialogPanel(jPanel);
    }

    public char[] getEnteredPassword() {
        return this.enteredPassword.getPassword();
    }

    public void destroy() {
        try {
            Document document = this.enteredPassword.getDocument();
            document.remove(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

