/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jpws.data.Exchange;
import org.jpws.data.Options;
import org.jpws.front.FileOpenDialog;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.HistoryHandler;
import org.jpws.front.util.HtmlBrowserDialog;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.data.PwsRecordList;
import org.jpws.pwslib.global.UUID;

public class Service {
    public static final String SERVER_PROP_URL = "http://jpws.sourceforge.net/support/jpwsinfo.properties";
    private static final int TITLE_Field = 0;
    private static final int GROUP_Field = 1;
    private static final int USER_Field = 2;
    private static final int PASSWORD_Field = 3;
    private static final int NOTES_Field = 4;
    private static final int URL_Field = 5;
    private static final int CREATED_Field = 6;
    private static final int MODIFIED_Field = 7;
    private static final int EXPIRY_Field = 8;
    private static final int PASSACCESS_Field = 9;
    private static final int PASSMODIFIED_Field = 10;
    private static final int UUID_Field = 11;
    private static final int HISTORY_Field = 12;

    public static void controlProjectNews(boolean bl) {
        boolean bl2 = false;
        System.out.println("- running CONTROL PROJECT NEWS");
        long l = System.currentTimeMillis();
        try {
            long l2;
            long l3;
            InputStream inputStream;
            URL uRL = new URL(SERVER_PROP_URL);
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                if (bl) {
                    GUIService.infoMessage("dlg.connect.failure", "msg.checknews.connectfail");
                }
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            long l4 = Util.longFromString(properties.getProperty("PUBLICBUILD"));
            long l5 = Options.getLongOption("buildWarnTime");
            if (bl | l5 < l) {
                if (l4 > 500000L) {
                    String string = ResourceLoader.getDisplay("msg.checknews.newrelease");
                    if (GUIService.userConfirm(string = Util.substituteText(string, "$name", properties.getProperty("PUBLICNAME", "")))) {
                        uRL = new URL(ResourceLoader.getCommand("html.progdownload"));
                        Global.startBrowser(uRL);
                    }
                    bl2 = true;
                }
                int n = 5;
                l5 = l + (long)n * 86400000L;
                Options.setLongOption("buildWarnTime", l5);
            }
            if ((l3 = Util.timeFromString(properties.getProperty("NEWSTIME"), Util.GMT)) > (l2 = Options.getLongOption("lastNewsTime"))) {
                if (GUIService.userConfirm("msg.checknews.newspage")) {
                    uRL = new URL(ResourceLoader.getCommand("html.supportpage"));
                    Global.startBrowser(uRL);
                }
                bl2 = true;
            }
            if (bl & !bl2) {
                GUIService.infoMessage(null, "msg.checknews.nothing");
            }
            Options.setLongOption("lastNewsTime", l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void csvUserWarning() {
        String string = ResourceLoader.getDisplay("dlg.csvwarning");
        HtmlBrowserDialog htmlBrowserDialog = new HtmlBrowserDialog(Global.getActiveFrame(), string, true);
        try {
            String string2 = "#standards/" + ResourceLoader.getCommand("html.file.csvwarning");
            htmlBrowserDialog.setPage(ResourceLoader.getResourceURL(string2));
            htmlBrowserDialog.show();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean csvExportRecords(OutputStream outputStream, PwsFile pwsFile, Exchange.FieldSet fieldSet, Exchange.RecordSet recordSet, Charset charset, int n) throws IOException {
        PwsPassphrase pwsPassphrase;
        List list = new ArrayList();
        if (fieldSet == null) {
            fieldSet = Exchange.allFields();
        }
        if (outputStream == null | pwsFile == null | fieldSet.size() == 0) {
            return false;
        }
        if (charset == null) {
            charset = Charset.forName(Global.getDefaultCharset());
        }
        if ((pwsPassphrase = pwsFile.getPassphrase()) == null) {
            GUIService.failureMessage("Illegal CSV output access", null);
            return false;
        }
        String string = Util.fileNameOfPath(pwsFile.getFilePath());
        if (!GUIService.passwordControl(pwsPassphrase, string, false)) {
            return false;
        }
        char c = n == 1 ? (char)';' : ',';
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charset));
        int n2 = fieldSet.size();
        list = Exchange.getNormalizedFieldList(fieldSet);
        string = "# JPWS-EXPORT MIME type=\"text/csv\" charset=\"" + charset.name() + "\" header=\"present\" delim=\"" + Integer.toHexString(c).toUpperCase() + "\"\r\n";
        bufferedWriter.write(string);
        string = "# RECORDS=" + pwsFile.getRecordCount() + " OUTPUT=" + (n == 1 ? "SPREADSHEET" : "RFC4180") + "\r\n";
        bufferedWriter.write(string);
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            string = ((Exchange.DataField)iterator.next()).toString();
            if (n3 != 0) {
                ((Writer)bufferedWriter).write(c);
            }
            bufferedWriter.write(string);
            ++n3;
        }
        bufferedWriter.write("\r\n");
        Iterator iterator2 = pwsFile.iterator();
        while (iterator2.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator2.next();
            if (recordSet != null && recordSet.contains(pwsRecord.getRecordID())) continue;
            String[] stringArray = new String[n2];
            iterator = list.iterator();
            n3 = 0;
            while (iterator.hasNext()) {
                Exchange.DataField dataField = (Exchange.DataField)iterator.next();
                Object object = Exchange.getFieldContent(pwsRecord, dataField);
                if (object != null) {
                    long l;
                    string = object instanceof PwsPassphrase ? ((PwsPassphrase)object).getString() : (object instanceof Long ? ((l = ((Long)object).longValue()) == 0L ? "" : (n == 1 ? Util.xmlTimeString(l) : Long.toString(l / 1000L))) : object.toString());
                    if (n == 1) {
                        string = Util.substituteText(string, "\r\n", " ");
                        string = Util.substituteText(string, "\n", " ");
                    }
                    stringArray[n3] = string;
                }
                ++n3;
            }
            string = Util.CSV.encodeLine(stringArray, c);
            bufferedWriter.write(string);
            bufferedWriter.write("\r\n");
        }
        ((Writer)bufferedWriter).flush();
        return true;
    }

    private static String readQuoteContainingLine(Reader reader, char c) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(512);
        boolean bl = false;
        while (true) {
            stringBuffer.append(c);
            if (!bl && c == '\n') {
                return stringBuffer.toString();
            }
            if (c == '\"') {
                boolean bl2 = bl = !bl;
            }
            if (!reader.ready()) break;
            c = (char)reader.read();
        }
        return bl ? null : stringBuffer.toString();
    }

    private static int[] detectFieldPattern(String[] stringArray) throws StreamCorruptedException {
        String string;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = new int[13];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n].toUpperCase();
            if (string.equals("TITLE") && nArray[0] == -1) {
                nArray[0] = n;
                bl2 = true;
                continue;
            }
            if (string.equals("PASSWORD") && nArray[3] == -1) {
                nArray[3] = n;
                bl = true;
                continue;
            }
            if (string.equals("GROUP") && nArray[1] == -1) {
                nArray[1] = n;
                continue;
            }
            if (string.equals("USER") && nArray[2] == -1) {
                nArray[2] = n;
                continue;
            }
            if (string.equals("NOTES") && nArray[4] == -1) {
                nArray[4] = n;
                continue;
            }
            if (string.equals("UUID") && nArray[11] == -1) {
                nArray[11] = n;
                continue;
            }
            if (string.equals("URL") && nArray[5] == -1) {
                nArray[5] = n;
                continue;
            }
            if (string.equals("PWHISTORY") && nArray[12] == -1) {
                nArray[12] = n;
                continue;
            }
            if (string.equals("T_CREATED") && nArray[6] == -1) {
                nArray[6] = n;
                continue;
            }
            if (string.equals("T_MODIFIED") && nArray[7] == -1) {
                nArray[7] = n;
                continue;
            }
            if (string.equals("T_PASSACCESS") && nArray[9] == -1) {
                nArray[9] = n;
                continue;
            }
            if (string.equals("T_PASSMODIFIED") && nArray[10] == -1) {
                nArray[10] = n;
                continue;
            }
            if (!string.equals("T_PASSEXPIRY") || nArray[8] != -1) continue;
            nArray[8] = n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n].toUpperCase();
            if (string.equals("ACCOUNT") && nArray[0] == -1) {
                nArray[0] = n;
                bl2 = true;
                continue;
            }
            if (string.equals("PASSWORD GROUPS") && nArray[1] == -1) {
                nArray[1] = n;
                continue;
            }
            if (string.equals("LOGIN NAME") && nArray[2] == -1) {
                nArray[2] = n;
                continue;
            }
            if (string.equals("COMMENTS") && nArray[4] == -1) {
                nArray[4] = n;
                continue;
            }
            if (string.equals("CREATION TIME") && nArray[6] == -1) {
                nArray[6] = n;
                continue;
            }
            if (string.equals("LAST MODIFICATION") && nArray[7] == -1) {
                nArray[7] = n;
                continue;
            }
            if (string.equals("LAST ACCESS") && nArray[9] == -1) {
                nArray[9] = n;
                continue;
            }
            if (string.equals("EXPIRES") && nArray[8] == -1) {
                nArray[8] = n;
                continue;
            }
            if (!string.equals("WEB SITE") || nArray[5] != -1) continue;
            nArray[5] = n;
        }
        if (!(bl2 & bl)) {
            throw new StreamCorruptedException("missing essential HEADER LINE fields");
        }
        return nArray;
    }

    private static InputStream clearUTF(InputStream inputStream, Charset charset) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4);
        if (charset.equals(Charset.forName("UTF-8"))) {
            byte[] byArray = new byte[3];
            int n = pushbackInputStream.read(byArray);
            if (!(byArray[0] == -17 & byArray[1] == -69 & byArray[2] == -65)) {
                pushbackInputStream.unread(byArray);
            }
        } else if (charset.equals(Charset.forName("UTF-16BE"))) {
            byte[] byArray = new byte[2];
            int n = pushbackInputStream.read(byArray);
            if (!(byArray[0] == -2 & byArray[1] == -1)) {
                pushbackInputStream.unread(byArray);
            }
        } else if (charset.equals(Charset.forName("UTF-16LE"))) {
            byte[] byArray = new byte[2];
            int n = pushbackInputStream.read(byArray);
            if (!(byArray[0] == -1 & byArray[1] == -2)) {
                pushbackInputStream.unread(byArray);
            }
        }
        return pushbackInputStream;
    }

    private static long getTimeValue(String string) throws ParseException {
        long l;
        block5: {
            l = 0L;
            if (string.length() == 0) {
                return 0L;
            }
            try {
                l = Long.parseLong(string) * 1000L;
            }
            catch (Exception exception) {
                try {
                    Date date = DateFormat.getDateInstance().parse(string);
                    l = date.getTime();
                }
                catch (ParseException parseException) {
                    l = Util.timeFromString(string, Util.GMT);
                    if (l != -1L) break block5;
                    throw parseException;
                }
            }
        }
        return l;
    }

    public static PwsRecordList csvImportRecords(InputStream inputStream, Charset charset, int n, Util.BufferInt bufferInt, PrintWriter printWriter) throws IOException {
        inputStream = Service.clearUTF(inputStream, charset);
        PwsRecordList pwsRecordList = new PwsRecordList();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        char c = n == 1 ? (char)';' : ',';
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = null;
        boolean bl = true;
        while (bufferedReader.ready()) {
            block21: {
                char c2 = (char)bufferedReader.read();
                ++n5;
                if (bl && c2 == '#') {
                    bufferedReader.readLine();
                    continue;
                }
                bl = false;
                String string = Service.readQuoteContainingLine(bufferedReader, c2);
                if (string == null) {
                    throw new StreamCorruptedException("CSV fatal corrupted line: " + n5);
                }
                String[] stringArray = Util.CSV.decodeLine(string, 0, c);
                if (n4 == 0) {
                    n2 = stringArray.length;
                    nArray = Service.detectFieldPattern(stringArray);
                } else {
                    String string2;
                    if (stringArray.length != n2) {
                        if (printWriter != null) {
                            string2 = ResourceLoader.getDisplay("msg.import.error.invalidline");
                            string2 = Util.substituteText(string2, "$record", String.valueOf(n4));
                            string2 = Util.substituteText(string2, "$fields", String.valueOf(stringArray.length));
                            string2 = Util.substituteText(string2, "$expected", String.valueOf(n2));
                            printWriter.println(string2);
                            printWriter.println(string);
                        }
                        ++n4;
                        ++n3;
                        continue;
                    }
                    PwsRecord pwsRecord = new PwsRecord();
                    try {
                        pwsRecord.setTitle(stringArray[nArray[0]]);
                        pwsRecord.setPassword(new PwsPassphrase(stringArray[nArray[3]]));
                        pwsRecord.setImportStatus(1);
                        int n6 = nArray[1];
                        if (n6 != -1) {
                            pwsRecord.setGroup(stringArray[n6]);
                        }
                        if ((n6 = nArray[2]) != -1) {
                            pwsRecord.setUsername(stringArray[n6]);
                        }
                        if ((n6 = nArray[4]) != -1) {
                            pwsRecord.setNotes(stringArray[n6]);
                        }
                        if ((n6 = nArray[5]) != -1) {
                            pwsRecord.setUrl(stringArray[n6]);
                        }
                        if ((n6 = nArray[11]) != -1) {
                            pwsRecord.setRecordID(new UUID(Util.condensedNumber(stringArray[n6], 16)));
                        }
                        if ((n6 = nArray[12]) != -1) {
                            pwsRecord.setHistory(Service.extractedHistory(stringArray[n6]));
                        }
                        if ((n6 = nArray[6]) != -1) {
                            pwsRecord.setCreateTime(Service.getTimeValue(stringArray[n6]));
                        }
                        if ((n6 = nArray[8]) != -1) {
                            pwsRecord.setPassLifeTime(Service.getTimeValue(stringArray[n6]));
                        }
                        if ((n6 = nArray[9]) != -1) {
                            pwsRecord.setAccessTime(Service.getTimeValue(stringArray[n6]));
                        }
                        if ((n6 = nArray[10]) != -1) {
                            pwsRecord.setPassModTime(Service.getTimeValue(stringArray[n6]));
                        }
                        if ((n6 = nArray[7]) != -1) {
                            pwsRecord.setModifyTime(Service.getTimeValue(stringArray[n6]));
                        }
                        pwsRecordList.addRecord(pwsRecord);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (printWriter == null) break block21;
                        string2 = ResourceLoader.getDisplay("msg.import.error.invalidrec");
                        string2 = Util.substituteText(string2, "$record", String.valueOf(n4));
                        string2 = Util.substituteText(string2, "$exc", exception.toString());
                        printWriter.println(string2);
                        printWriter.println(string);
                        ++n3;
                    }
                }
            }
            ++n4;
        }
        if (bufferInt != null) {
            bufferInt.value = n3;
        }
        return pwsRecordList;
    }

    private static String extractedHistory(String string) {
        if (string == null | string.length() == 0) {
            return null;
        }
        char c = ',';
        HistoryHandler historyHandler = new HistoryHandler();
        String[] stringArray = Util.CSV.decodeLine(string, 0, c);
        historyHandler.setMaxItems(Math.max(stringArray.length, 16));
        for (int i = stringArray.length; i > 0; --i) {
            String[] stringArray2 = Util.CSV.decodeLine(stringArray[i - 1], 0, c);
            if (stringArray2.length < 2) continue;
            long l = Util.timeFromString(stringArray2[0], Util.GMT);
            String string2 = stringArray2[1];
            historyHandler.pushPassword(string2, l);
        }
        return historyHandler.getContentPw3();
    }

    public static void secureWipeFile() {
        FileOpenDialog fileOpenDialog = new FileOpenDialog(0, Global.currentDir);
        fileOpenDialog.setDialogTitle(ResourceLoader.getDisplay("dlg.wipefile"));
        if (fileOpenDialog.showOpenDialog(Global.getActiveFrame()) != 0) {
            return;
        }
        Global.currentDir = fileOpenDialog.getCurrentDirectory();
        String string = fileOpenDialog.getSelectedFile().getAbsolutePath();
        File file = fileOpenDialog.getSelectedFile();
        if (!file.isFile()) {
            String string2 = ResourceLoader.getDisplay("msg.filenotfound");
            string2 = Util.substituteText(string2, "$path", string);
            GUIService.infoMessage(null, string2);
            return;
        }
        try {
            URL uRL = Util.makeFileURL(string);
            if (!Global.requestCriticalPhase(uRL)) {
                return;
            }
            String string3 = ResourceLoader.getDisplay("msg.perform.wipefile");
            if (!GUIService.userConfirm(string3 = Util.substituteText(string3, "$file", file.getAbsolutePath()))) {
                Global.endCriticalPhase(uRL);
                return;
            }
            Util.wipeAFile(file);
            Global.endCriticalPhase(uRL);
            string3 = ResourceLoader.getDisplay("msg.confirm.filewipe");
            string3 = Util.substituteText(string3, "$file", file.getAbsolutePath());
            GUIService.infoMessage(null, string3);
        }
        catch (IOException iOException) {
            GUIService.failureMessage("Cannot wipe the file!", iOException);
        }
    }

    public static String normalizedFilepath(String string, String string2) throws IOException {
        if (string == null) {
            return null;
        }
        if (string2 != null && string.lastIndexOf(".") == -1) {
            string = string + string2;
        }
        return Global.getFilePath(Util.makeFileURL(string));
    }
}

