/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpws.data.PwsFileSocket;
import org.jpws.front.ActionHandler;
import org.jpws.front.Global;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;

public class ToolbarHandler {
    private static JToolBar toolBar;
    private static JButton buttonAdd;
    private static JButton buttonEdit;
    private static JButton buttonDelete;
    private static JButton buttonCopyPass;
    private static JButton buttonCopyUser;
    private static JButton fileSave;
    private static JButton clearClipboard;
    private static JButton webstartURL;
    private static Listener listener;

    private ToolbarHandler() {
    }

    public static void init() {
        toolBar = new JToolBar();
        listener = new Listener();
        toolBar.setFloatable(false);
        JButton jButton = ToolbarHandler.makeButton("filenew", "toolbar.new");
        jButton.setActionCommand("menu.file.new");
        toolBar.add(jButton);
        jButton = ToolbarHandler.makeButton("fileopen", "toolbar.open");
        jButton.setActionCommand("menu.file.open");
        toolBar.add(jButton);
        fileSave = ToolbarHandler.makeButton("filesave", "toolbar.save");
        fileSave.setEnabled(false);
        fileSave.setActionCommand("menu.file.save");
        toolBar.add(fileSave);
        toolBar.addSeparator();
        buttonCopyPass = ToolbarHandler.makeButton("copypass", "toolbar.copypass");
        buttonCopyPass.setEnabled(false);
        buttonCopyPass.setActionCommand("menu.edit.copypass");
        toolBar.add(buttonCopyPass);
        buttonCopyUser = ToolbarHandler.makeButton("copyuser", "toolbar.copyuser");
        buttonCopyUser.setEnabled(false);
        buttonCopyUser.setActionCommand("menu.edit.copyuser");
        toolBar.add(buttonCopyUser);
        clearClipboard = ToolbarHandler.makeButton(ActionHandler.getClearClipAction());
        toolBar.add(clearClipboard);
        ActionHandler.clipboardUpdated();
        webstartURL = ToolbarHandler.makeButton("webstarter", "toolbar.webstart.record");
        webstartURL.setEnabled(false);
        webstartURL.setActionCommand("menu.edit.starturl");
        toolBar.add(webstartURL);
        toolBar.addSeparator();
        buttonAdd = ToolbarHandler.makeButton("add", "toolbar.add");
        buttonAdd.setEnabled(false);
        buttonAdd.setActionCommand("menu.edit.psw.add");
        toolBar.add(buttonAdd);
        buttonEdit = ToolbarHandler.makeButton("edit", "toolbar.edit");
        buttonEdit.setEnabled(false);
        buttonEdit.setActionCommand("menu.edit.psw.edit");
        toolBar.add(buttonEdit);
        buttonDelete = ToolbarHandler.makeButton("delete", "toolbar.delete");
        buttonDelete.setEnabled(false);
        buttonDelete.setActionCommand("menu.edit.delete");
        toolBar.add(buttonDelete);
        toolBar.addSeparator();
        jButton = ToolbarHandler.makeButton("exit", "toolbar.exit");
        jButton.setActionCommand("menu.file.exit");
        toolBar.add(jButton);
    }

    private static void fileMounted(PwsFileContainer pwsFileContainer) {
        if (pwsFileContainer == null) {
            return;
        }
        boolean bl = pwsFileContainer.getOperationMode() == 2;
        int n = pwsFileContainer.getSelectionStatus();
        buttonAdd.setEnabled(bl);
        fileSave.setEnabled(bl & pwsFileContainer.isModified());
        if (!bl) {
            ToolbarHandler.rowSelected(pwsFileContainer);
        }
    }

    private static void rowSelected(PwsFileContainer pwsFileContainer) {
        int n = pwsFileContainer.getSelectionStatus();
        boolean bl = n == 2;
        buttonEdit.setEnabled(bl);
        buttonCopyUser.setEnabled(bl);
        buttonCopyPass.setEnabled(bl);
        buttonDelete.setEnabled(n != 0);
        webstartURL.setEnabled(bl && Util.extractURL(pwsFileContainer.getSelectedRecord().getUrl()) != null);
    }

    private static void fileUpdated(PwsFileContainer pwsFileContainer) {
        boolean bl = pwsFileContainer.isModified();
        fileSave.setEnabled(bl);
    }

    public static JButton makeButton(String string, String string2) {
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(0, 3, 0, 3));
        jButton.setPreferredSize(new Dimension(20, 23));
        jButton.setToolTipText(ResourceLoader.getCommand(string2 + ".tooltip"));
        ImageIcon imageIcon = ResourceLoader.getImageIcon(string);
        imageIcon.setDescription(ResourceLoader.getDisplay(string2));
        jButton.setIcon(imageIcon);
        jButton.addActionListener(Global.mainActionListener);
        return jButton;
    }

    public static JButton makeButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setMargin(new Insets(0, 3, 0, 3));
        jButton.setPreferredSize(new Dimension(20, 23));
        jButton.setText(null);
        return jButton;
    }

    public static JToolBar getToolBar() {
        return toolBar;
    }

    public static void registerFile(PwsFileContainer pwsFileContainer) {
        if (pwsFileContainer != null) {
            pwsFileContainer.addChangeListener(listener);
        }
    }

    public static void unregisterFile(PwsFileContainer pwsFileContainer) {
        if (pwsFileContainer != null) {
            pwsFileContainer.removeChangeListener(listener);
        }
    }

    private static class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(final ChangeEvent changeEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (changeEvent instanceof PwsFileSocket.ChangeEvent && changeEvent.getSource() != null && changeEvent.getSource() instanceof PwsFileContainer) {
                        PwsFileContainer pwsFileContainer = (PwsFileContainer)changeEvent.getSource();
                        switch (((PwsFileSocket.ChangeEvent)changeEvent).getState()) {
                            case 1: {
                                ToolbarHandler.fileMounted(pwsFileContainer);
                                break;
                            }
                            case 2: {
                                ToolbarHandler.rowSelected(pwsFileContainer);
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                ToolbarHandler.fileUpdated(pwsFileContainer);
                            }
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

