/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.jpws.front.ActionHandler;
import org.jpws.front.util.ButtonBar;
import org.jpws.front.util.ButtonBarListener;
import org.jpws.front.util.ResourceLoader;

public class DialogButtonBar
extends ButtonBar
implements ActionListener {
    public static final int NO_BUTTON = 0;
    public static final int OK_BUTTON = 1;
    public static final int CLOSE_BUTTON = 2;
    public static final int OK_CANCEL_BUTTON = 3;
    public static final int OK_CANCEL_HELP_BUTTON = 4;
    private static final int LAST_BUTTON = 4;
    private ButtonBarListener listener;
    private ArrayList buttonThreads = new ArrayList();
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private boolean okPressed;
    private boolean cancelPressed;
    private boolean synchronous;

    public DialogButtonBar(int n) {
        if (n < 0 | n > 4) {
            throw new IllegalArgumentException();
        }
        if (n >= 1) {
            this.okButton = new JButton(ResourceLoader.getDisplay(n == 2 ? "button.close" : "button.ok"));
            this.okButton.addActionListener(this);
            super.add(this.okButton);
        }
        if (n >= 3) {
            this.cancelButton = new JButton(ResourceLoader.getDisplay("button.cancel"));
            this.cancelButton.addActionListener(this);
            super.add(this.cancelButton);
        }
        if (n >= 4) {
            this.helpButton = new JButton(ResourceLoader.getDisplay("button.help"));
            this.helpButton.addActionListener(this);
            super.add(this.helpButton);
        }
    }

    public DialogButtonBar(int n, boolean bl) {
        this(n);
        this.synchronous = bl;
    }

    public void destruct() {
        this.listener = null;
        if (this.cancelButton != null) {
            this.okButton.removeActionListener(this);
            this.okButton = null;
        }
        if (this.cancelButton != null) {
            this.cancelButton.removeActionListener(this);
            this.cancelButton = null;
        }
        if (this.helpButton != null) {
            this.helpButton.removeActionListener(this);
            this.helpButton = null;
        }
    }

    public void performButton(Object object) {
        if (object != null) {
            this.actionPerformed(new ActionEvent(object, 0, null));
        }
    }

    private void performButtonIntern(Object object) {
        this.okPressed = false;
        this.cancelPressed = false;
        if (object == null) {
            return;
        }
        if (object == this.okButton) {
            this.okPressed = true;
            if (this.listener != null) {
                this.okButton.setEnabled(false);
                this.listener.okButtonPerformed();
                if (this.okButton != null) {
                    this.okButton.setEnabled(true);
                }
            } else {
                this.disposeDialog();
            }
        } else if (object == this.cancelButton) {
            this.cancelPressed = true;
            if (this.listener != null) {
                this.cancelButton.setEnabled(false);
                this.listener.cancelButtonPerformed();
                if (this.cancelButton != null) {
                    this.cancelButton.setEnabled(true);
                }
            } else {
                this.disposeDialog();
            }
        } else if (object == this.helpButton) {
            if (this.listener != null) {
                this.helpButton.setEnabled(false);
                this.listener.helpButtonPerformed();
                if (this.helpButton != null) {
                    this.helpButton.setEnabled(true);
                }
            }
        } else if (this.listener != null) {
            Component component = (Component)object;
            component.setEnabled(false);
            component.setEnabled(this.listener.extraButtonPerformed(component));
        }
    }

    public void disposeDialog() {
        Container container = this;
        while ((container = container.getParent()) != null && !(container instanceof JDialog)) {
        }
        try {
            ((JDialog)container).dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        if (this.listener != null & !this.synchronous) {
            Thread thread = new Thread("ButtonBarPerformer"){

                public void run() {
                    ActionHandler.resetIdleTime();
                    DialogButtonBar.this.performButtonIntern(actionEvent.getSource());
                    ActionHandler.resetIdleTime();
                }
            };
            this.buttonThreads.add(thread);
            thread.start();
        } else {
            ActionHandler.resetIdleTime();
            this.performButtonIntern(actionEvent.getSource());
            ActionHandler.resetIdleTime();
        }
    }

    public void joinButtonThreads() {
        do {
            Iterator iterator = this.buttonThreads.iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                if (thread.isAlive()) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                iterator.remove();
            }
        } while (this.buttonThreads.size() != 0);
    }

    public void setButtonBarListener(ButtonBarListener buttonBarListener) {
        this.listener = buttonBarListener;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public Component add(Component component) {
        this.remove(component);
        Component component2 = super.add(component);
        if (component instanceof JButton) {
            ((JButton)component).addActionListener(this);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(this);
        }
        return component2;
    }

    public Component add(Component component, int n) {
        this.remove(component);
        Component component2 = super.add(component, n);
        if (component instanceof JButton) {
            ((JButton)component).addActionListener(this);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(this);
        }
        return component2;
    }

    public void remove(Component component) {
        super.remove(component);
        if (component instanceof JButton) {
            ((JButton)component).removeActionListener(this);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).removeActionListener(this);
        }
    }

    public void remove(int n) {
        super.remove(n);
    }
}

