/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;
import org.jpws.data.Options;
import org.jpws.front.util.ResourceLoader;

public class NotesTextArea
extends JTextArea {
    private static HashMap actionLookup;
    private UndoManager undoManager = new UndoManager();
    private PopupListener popupListener = new PopupListener();
    private boolean isPopupActive = true;

    public NotesTextArea() {
        this.init();
    }

    public NotesTextArea(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public NotesTextArea(String string) {
        super(string);
        this.init();
    }

    public NotesTextArea(String string, int n, int n2) {
        super(string, n, n2);
        this.init();
    }

    public NotesTextArea(Document document) {
        super(document);
        this.init();
    }

    public NotesTextArea(Document document, String string, int n, int n2) {
        super(document, string, n, n2);
        this.init();
    }

    private void init() {
        if (actionLookup == null) {
            Action[] actionArray = this.getActions();
            actionLookup = new HashMap();
            for (int i = 0; i < actionArray.length; ++i) {
                actionLookup.put(actionArray[i].getValue("Name"), actionArray[i]);
            }
        }
        this.addMouseListener(this.popupListener);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.modifyKeystrokes();
        this.setLineWrap(Options.isOptionSet("editLineWrap"));
        this.setWrapStyleWord(true);
    }

    private void modifyKeystrokes() {
        Keymap keymap = this.getKeymap();
        Keymap keymap2 = JTextComponent.addKeymap("JPWS_TextAreaKeymap", keymap);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(87, 2);
        Action action = (Action)actionLookup.get("select-word");
        keymap2.addActionForKeyStroke(keyStroke, action);
        keyStroke = KeyStroke.getKeyStroke(76, 2);
        action = (Action)actionLookup.get("select-line");
        keymap2.addActionForKeyStroke(keyStroke, action);
        keyStroke = KeyStroke.getKeyStroke(80, 2);
        action = (Action)actionLookup.get("select-paragraph");
        keymap2.addActionForKeyStroke(keyStroke, action);
        keyStroke = KeyStroke.getKeyStroke(90, 2);
        keymap2.addActionForKeyStroke(keyStroke, new UndoAction());
        keyStroke = KeyStroke.getKeyStroke(89, 2);
        keymap2.addActionForKeyStroke(keyStroke, new RedoAction());
        this.setKeymap(keymap2);
    }

    public void clearUndoList() {
        this.undoManager.discardAllEdits();
    }

    public void setPopupActive(boolean bl) {
        this.isPopupActive = bl;
    }

    public boolean getPopupActive() {
        return this.isPopupActive;
    }

    protected JPopupMenu getPopupMenu() {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.requestFocus();
        if (this.undoManager.canUndo()) {
            jMenuItem = new JMenuItem(new UndoAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
            jPopupMenu.add(jMenuItem);
        }
        if (this.undoManager.canRedo()) {
            jMenuItem = new JMenuItem(new RedoAction());
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
            jPopupMenu.add(jMenuItem);
        }
        if (this.undoManager.canUndo() || this.undoManager.canRedo()) {
            jPopupMenu.addSeparator();
        }
        jMenuItem = new JMenuItem(ResourceLoader.getCommand("menu.edit.cut"));
        Action action = (Action)actionLookup.get("cut-to-clipboard");
        jMenuItem.addActionListener(action);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(ResourceLoader.getCommand("menu.edit.copy"));
        action = (Action)actionLookup.get("copy-to-clipboard");
        jMenuItem.addActionListener(action);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(ResourceLoader.getCommand("menu.edit.paste"));
        action = (Action)actionLookup.get("paste-from-clipboard");
        jMenuItem.addActionListener(action);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem(ResourceLoader.getCommand("menu.edit.linewrap"));
        jMenuItem.setSelected(this.getLineWrap());
        jMenuItem.addActionListener(new LineWrapAction());
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(ResourceLoader.getCommand("menu.edit.selectall"));
        action = (Action)actionLookup.get("select-all");
        jMenuItem.addActionListener(action);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && NotesTextArea.this.getPopupActive()) {
                NotesTextArea.this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class LineWrapAction
    extends TextAction {
        public LineWrapAction() {
            super(ResourceLoader.getCommand("menu.edit.linewrap"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NotesTextArea.this.setLineWrap(!NotesTextArea.this.getLineWrap());
        }
    }

    private class RedoAction
    extends TextAction {
        public RedoAction() {
            super(NotesTextArea.this.undoManager.getRedoPresentationName());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NotesTextArea.this.undoManager.canRedo()) {
                NotesTextArea.this.undoManager.redo();
            }
        }
    }

    private class UndoAction
    extends TextAction {
        public UndoAction() {
            super(NotesTextArea.this.undoManager.getUndoPresentationName());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NotesTextArea.this.undoManager.canUndo()) {
                NotesTextArea.this.undoManager.undo();
            }
        }
    }
}

