/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jpws.front.ActionHandler;
import org.jpws.front.util.Util;

public class RecentList
extends AbstractListModel
implements ComboBoxModel,
MenuListener,
Cloneable {
    protected ArrayList vlist = new ArrayList();
    protected JMenuItem menuFinalItem;
    protected int maxEntries;
    protected int maxDisplay;
    protected String command;
    protected Object selected;
    private boolean modified;

    public RecentList() {
        this.maxEntries = 8;
        this.maxDisplay = 8;
    }

    public RecentList(int n) {
        this.maxEntries = n;
        this.maxDisplay = n;
    }

    public RecentList(String string) {
        this.maxEntries = 8;
        this.maxDisplay = 8;
        this.command = string;
    }

    public RecentList(String string, int n) {
        this.command = string;
        this.maxEntries = n;
        this.maxDisplay = n;
    }

    public RecentList(String string, int n, int n2) {
        this.command = string;
        this.maxEntries = n;
        this.maxDisplay = n2;
    }

    public Object clone() {
        RecentList recentList = null;
        try {
            recentList = (RecentList)super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        recentList.vlist = (ArrayList)this.vlist.clone();
        return recentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(String string) {
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            this.vlist.clear();
            String[] stringArray = Util.CSV.decodeLine(string, 0, ';');
            int n = 0;
            while (n < stringArray.length & n < this.maxEntries) {
                String string2 = stringArray[n];
                if (!string2.equals("")) {
                    this.vlist.add(string2);
                }
                ++n;
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(Object[] objectArray) {
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            this.vlist.clear();
            int n = 0;
            while (n < objectArray.length & n < this.maxEntries) {
                Object object = objectArray[n];
                if (object != null) {
                    this.vlist.add(object);
                }
                ++n;
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public void setMenuFinalItem(JMenuItem jMenuItem) {
        this.menuFinalItem = jMenuItem;
    }

    public String getStringContent() {
        return Util.CSV.encodeLine(this.toStringArray(), ';');
    }

    public Object[] getContent() {
        return this.vlist.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] toStringArray() {
        String[] stringArray;
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            int n = this.getSize();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.vlist.get(i).toString();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMenu(JMenu jMenu) {
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            Iterator iterator = this.iterator();
            jMenu.removeAll();
            int n = 0;
            while (iterator.hasNext() && n < this.maxDisplay) {
                String string;
                Object e = iterator.next();
                if (e == null || (string = e.toString()).equals("")) continue;
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setActionCommand(this.command + string);
                jMenuItem.addActionListener(ActionHandler.getMainActionListener());
                jMenu.add(jMenuItem);
                ++n;
            }
            if (this.menuFinalItem != null && this.vlist.size() != 0) {
                jMenu.addSeparator();
                jMenu.add(this.menuFinalItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            int n = this.getSize();
            this.vlist.clear();
            this.fireContentsChanged(this, 0, n - 1);
            this.modified |= n != this.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntries(int n) {
        this.maxEntries = Math.max(0, n);
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            int n2;
            while ((n2 = this.vlist.size()) > this.maxEntries) {
                int n3 = n2 - 1;
                this.vlist.remove(n3);
                this.fireIntervalRemoved(this, n3, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRecent(Object object) {
        if (object == null) {
            return false;
        }
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            int n = this.vlist.indexOf(object);
            if (n != -1) {
                this.vlist.remove(n);
                this.fireIntervalRemoved(this, n, n);
                this.modified = true;
                return true;
            }
        }
        return false;
    }

    public Object getFirst() {
        return this.vlist.size() == 0 ? null : this.vlist.get(0);
    }

    public String getStringValue(int n) {
        if (n < 0 | n > this.getSize() - 1) {
            return null;
        }
        return this.vlist.get(n).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRecent(Object object) {
        ArrayList arrayList = this.vlist;
        synchronized (arrayList) {
            if (!object.equals(this.getFirst())) {
                int n;
                this.removeRecent(object);
                this.vlist.add(0, object);
                this.fireIntervalAdded(this, 0, 0);
                this.modified = true;
                while ((n = this.vlist.size()) > this.maxEntries) {
                    int n2 = n - 1;
                    this.vlist.remove(n2);
                    this.fireIntervalRemoved(this, n2, n2);
                }
            }
        }
    }

    public void replaceRecent(Object object, Object object2) {
        int n = this.vlist.lastIndexOf(object);
        if (n != -1) {
            this.vlist.set(n, object2);
            this.fireContentsChanged(this, n, n);
        }
    }

    public Iterator iterator() {
        return this.vlist.iterator();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public Object getElementAt(int n) {
        if (n < 0 | n > this.getSize() - 1) {
            return null;
        }
        return this.vlist.get(n);
    }

    public int getSize() {
        return this.vlist.size();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public void setSelectedItem(Object object) {
        this.selected = object;
        this.pushRecent(object);
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        this.updateMenu(jMenu);
    }
}

