/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jpws.front.util.AutomoveDialog;
import org.jpws.front.util.DialogButtonBar;
import org.jpws.front.util.Util;

public class ReporterWindow
extends AutomoveDialog {
    public static final Dimension DEFAULT_DIMENSION = new Dimension(400, 250);
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private WindowWriter writer = new WindowWriter();
    private DialogButtonBar buttonBar;

    public ReporterWindow() throws HeadlessException {
        this.init(null);
    }

    public ReporterWindow(Frame frame) throws HeadlessException {
        super(frame);
        this.init(frame);
    }

    public ReporterWindow(Frame frame, String string) throws HeadlessException {
        super(frame, string);
        this.init(frame);
    }

    public ReporterWindow(Dialog dialog) throws HeadlessException {
        super(dialog);
        this.init(dialog);
    }

    public ReporterWindow(Dialog dialog, String string) throws HeadlessException {
        super(dialog, string);
        this.init(dialog);
    }

    private void init(Object object) {
        Dimension dimension = (Dimension)DEFAULT_DIMENSION.clone();
        if (object != null) {
            Rectangle rectangle = ((Component)object).getBounds();
            dimension.height = rectangle.height;
            Point point = new Point(rectangle.x - dimension.width, rectangle.y);
            Util.setCorrectedLocation(this, point);
        }
        this.textArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.textArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
        this.setSize(dimension);
    }

    public void addButtonBar() {
        if (this.buttonBar == null) {
            this.buttonBar = new DialogButtonBar(2);
            this.getContentPane().add((Component)this.buttonBar, "South");
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void clearText() {
        this.textArea.setText(null);
    }

    private class WindowWriter
    extends Writer {
        private WindowWriter() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (!ReporterWindow.this.isShowing()) {
                ReporterWindow.this.setVisible(true);
            }
            ReporterWindow.this.textArea.append(new String(cArray, n, n2));
        }
    }
}

