/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.jpws.front.Global;

public class ResourceLoader {
    public static String[][] substTokens;
    private static List resPaths;
    private static Hashtable bundleTable;
    private static Properties imageTable;
    private static URL defaultFailImage;
    static /* synthetic */ Class class$org$jpws$front$util$ResourceLoader;

    private ResourceLoader() {
    }

    public static void setTokens(String[][] stringArray) {
        substTokens = stringArray;
    }

    public static void addResourcePath(String string) {
        if (string != null) {
            if (!string.equals("") && !string.endsWith("/")) {
                string = string + "/";
            }
            resPaths.add(string);
        }
    }

    private static ResourceBundle openBundle(String string) {
        ResourceBundle resourceBundle = null;
        Iterator iterator = resPaths.iterator();
        while (iterator.hasNext() && resourceBundle == null) {
            String string2 = (String)iterator.next() + "bundles/" + string;
            try {
                resourceBundle = ResourceBundle.getBundle(string2, Global.locale);
            }
            catch (Exception exception) {
                System.out.println("*** failed bundle search: " + string2);
            }
        }
        if (resourceBundle == null) {
            Global.exit("*** MISSING RESOURCE BUNDLE *** : " + string, true);
        }
        bundleTable.put(string, resourceBundle);
        return resourceBundle;
    }

    public static String getString(String string, String string2) {
        String string3;
        if (string2 == null) {
            return "";
        }
        ResourceBundle resourceBundle = (ResourceBundle)bundleTable.get(string);
        if (resourceBundle == null) {
            resourceBundle = ResourceLoader.openBundle(string);
        }
        try {
            string3 = resourceBundle.getString(string2);
        }
        catch (Exception exception) {
            return "FIXME";
        }
        return string3;
    }

    public static String getCommand(String string) {
        return ResourceLoader.getString("action", string);
    }

    public static String getDisplay(String string) {
        return ResourceLoader.getString("display", string);
    }

    public static String getMessage(String string) {
        return ResourceLoader.getString("message", string);
    }

    public static String codeOrRealMsg(String string) {
        String string2 = ResourceLoader.getString("message", string);
        if (string2.equals("FIXME")) {
            string2 = string;
        }
        return string2;
    }

    public static String codeOrRealDisplay(String string) {
        String string2 = ResourceLoader.getString("display", string);
        if (string2.equals("FIXME")) {
            string2 = string;
        }
        return string2;
    }

    public static void init(String string) {
        if (string != null) {
            ResourceLoader.addResourcePath(string);
        }
        ResourceLoader.getString("action", "testvalue");
        ResourceLoader.getString("display", "testvalue");
        imageTable = new Properties();
        try {
            imageTable.load(ResourceLoader.getResourceStream("#standards/imagemap.properties"));
        }
        catch (Exception exception) {
            Global.exit("*** MISSING RESOURCE *** : imagemap.properties\r\n" + exception, true);
        }
        defaultFailImage = ResourceLoader.getImageURL("default_fail");
    }

    public static URL getImageURL(String string) {
        String string2 = imageTable.getProperty(string);
        if (string2 == null) {
            System.err.println("*** missing image association: " + string);
            return null;
        }
        return ResourceLoader.getResourceURL(string2);
    }

    public static ImageIcon getImageIcon(String string) {
        URL uRL = ResourceLoader.getImageURL(string);
        if (uRL == null) {
            uRL = defaultFailImage;
        }
        return uRL == null ? null : new ImageIcon(uRL);
    }

    public static ImageIcon getDefaultImageIcon(String string, String string2) {
        ImageIcon imageIcon = (ImageIcon)UIManager.getIcon(string);
        if (imageIcon == null) {
            imageIcon = ResourceLoader.getImageIcon(string2);
        }
        return imageIcon;
    }

    public static InputStream getResourceStream(String string) throws IOException {
        URL uRL = ResourceLoader.getResourceURL(string);
        if (uRL == null) {
            return null;
        }
        return uRL.openStream();
    }

    public static URL getResourceURL(String string) {
        URL uRL = null;
        if (string == null) {
            throw new IllegalArgumentException("path = null");
        }
        if (string.startsWith("#")) {
            for (int i = 0; i < resPaths.size() && uRL == null; ++i) {
                String string2 = (String)resPaths.get(i) + string.substring(1);
                uRL = (class$org$jpws$front$util$ResourceLoader == null ? ResourceLoader.class$("org.jpws.front.util.ResourceLoader") : class$org$jpws$front$util$ResourceLoader).getClassLoader().getResource(string2);
            }
        } else {
            uRL = (class$org$jpws$front$util$ResourceLoader == null ? (class$org$jpws$front$util$ResourceLoader = ResourceLoader.class$("org.jpws.front.util.ResourceLoader")) : class$org$jpws$front$util$ResourceLoader).getClassLoader().getResource(string);
        }
        if (uRL == null) {
            System.err.println("*** failed locating resource: " + string);
            return null;
        }
        return uRL;
    }

    public static String[] getResourcePaths() {
        Object[] objectArray = resPaths.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        resPaths = new LinkedList();
        bundleTable = new Hashtable();
    }
}

