/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.data.PwsBlockInputStream;

class BlockInputStream
implements PwsBlockInputStream {
    private InputStream input;
    private PwsCipher cipher;
    private byte[] nextBlock;
    private int blocksize;
    private int blockCount;

    public BlockInputStream(InputStream inputStream, PwsCipher pwsCipher) throws IOException {
        this.cipher = pwsCipher;
        this.blocksize = pwsCipher.getBlockSize();
        this.input = inputStream;
        try {
            this.readNextBlock();
        }
        catch (EOFException eOFException) {
            throw new StreamCorruptedException("unable to read first block");
        }
    }

    private void readNextBlock() throws IOException {
        this.nextBlock = null;
        byte[] byArray = new byte[this.blocksize];
        int n = this.input.read(byArray);
        if (n == -1) {
            return;
        }
        if (n < this.blocksize) {
            throw new EOFException("illegal received block length: " + n);
        }
        this.nextBlock = this.cipher.decrypt(byArray);
    }

    public void close() {
        this.input = null;
        this.nextBlock = null;
    }

    public int getBlockSize() {
        return this.blocksize;
    }

    public int getCount() {
        return this.blockCount;
    }

    public void resetCounter() {
        this.blockCount = 0;
    }

    public boolean isAvailable() {
        return this.nextBlock != null;
    }

    public byte[] peekBlock() {
        return this.nextBlock != null ? (byte[])this.nextBlock.clone() : null;
    }

    public byte[] readBlock() throws IOException {
        byte[] byArray = null;
        if (this.nextBlock != null) {
            byArray = this.nextBlock;
            this.readNextBlock();
            ++this.blockCount;
        } else {
            this.close();
        }
        return byArray;
    }

    public byte[] readBlocks(int n) throws IOException {
        int n2;
        if (n < 0 | (n2 = n * this.blocksize) < 0) {
            throw new IllegalArgumentException("invalid block request: " + n);
        }
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            if (n == 1) {
                return this.readBlock();
            }
            if (this.nextBlock == null) {
                this.close();
                return null;
            }
            System.arraycopy(this.nextBlock, 0, byArray, 0, this.blocksize);
            this.nextBlock = null;
            int n3 = n2 - this.blocksize;
            byte[] byArray2 = new byte[n3];
            int n4 = this.input.read(byArray2);
            if (n4 < n3) {
                throw new EOFException("block length (remainder)");
            }
            byArray2 = this.cipher.decrypt(byArray2);
            System.arraycopy(byArray2, 0, byArray, this.blocksize, n3);
            this.readNextBlock();
            this.blockCount += n;
        }
        return byArray;
    }
}

