/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jpws.pwslib.exception.ApplicationFailureException;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.persist.ApplicationAdapter;
import org.jpws.pwslib.persist.StreamFactory;

public class ContextFile {
    private ApplicationAdapter adapter;
    private String filepath;
    private long fileTime;
    private long fileLength;
    private boolean hasRefreshed;

    public ContextFile(ApplicationAdapter applicationAdapter, String string) {
        if (applicationAdapter == null || string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("filepath is empty");
        }
        this.adapter = applicationAdapter;
        this.filepath = string;
    }

    public void refresh() throws IOException {
        this.fileTime = this.adapter.getModifiedTime(this.filepath);
        this.fileLength = this.adapter.getFileLength(this.filepath);
        this.hasRefreshed = true;
    }

    public long modifyTime() {
        try {
            if (!this.hasRefreshed) {
                this.refresh();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.fileTime;
    }

    public long length() {
        try {
            if (!this.hasRefreshed) {
                this.refresh();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.fileLength;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        ContextFile contextFile = (ContextFile)object;
        return this.adapter.equals(contextFile.adapter) && this.filepath.equals(contextFile.filepath);
    }

    public int hashCode() {
        return this.adapter.hashCode() ^ this.filepath.hashCode();
    }

    public ApplicationAdapter getAdapter() {
        return this.adapter;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public boolean delete() throws IOException {
        return this.adapter.deleteFile(this.filepath);
    }

    public boolean renameTo(String string) throws IOException {
        return this.adapter.renameFile(this.filepath, string);
    }

    public boolean exists() throws IOException {
        return this.adapter.existsFile(this.filepath);
    }

    public InputStream getInputStream() throws IOException, ApplicationFailureException {
        return StreamFactory.getInputStream(this.adapter, this.filepath);
    }

    public OutputStream getOutputStream() throws IOException, ApplicationFailureException {
        return StreamFactory.getOutputStream(this.adapter, this.filepath);
    }

    public boolean canWrite() {
        return this.adapter.canWrite(this.filepath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(ContextFile contextFile) throws IOException, ApplicationFailureException {
        OutputStream outputStream = null;
        InputStream inputStream = this.getInputStream();
        try {
            outputStream = contextFile.getOutputStream();
            Util.copyStream(inputStream, outputStream);
            outputStream.close();
        }
        catch (Exception exception) {
            if (outputStream != null) {
                outputStream.close();
                try {
                    contextFile.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ApplicationFailureException) {
                throw (ApplicationFailureException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
        }
        finally {
            inputStream.close();
        }
    }

    public void copyTo(String string) throws IOException, ApplicationFailureException {
        this.copyTo(new ContextFile(this.adapter, string));
    }
}

