/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.jpws.pwslib.crypto.SHA256;
import org.jpws.pwslib.data.ContextFile;
import org.jpws.pwslib.data.HeaderFieldList;
import org.jpws.pwslib.data.PwsFileFactory;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.data.PwsRecordList;
import org.jpws.pwslib.exception.ApplicationFailureException;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.persist.ApplicationAdapter;

public class PwsFile
extends PwsRecordList
implements Cloneable {
    private static final int SECURITY_ITERATIONS_MINIMUM = 2048;
    private static final int SECURITY_ITERATIONS_MAXIMUM = 0x400000;
    private ApplicationAdapter application;
    private String filePath;
    private PwsPassphrase ps;
    private int fileVersion = 3;
    private int sourceFormat;
    private int securityLoops = 2048;
    private boolean checksumOK = true;
    private HeaderFieldList headerFields = new PFHeaderFieldList();
    private boolean preserveOld;

    public PwsFile() {
        this.initBasic();
        Log.log(2, "(PwsFile) new standard PwsFile: ID = " + this.fileID);
    }

    public PwsFile(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        super(defaultRecordWrapperArray);
        this.initBasic();
        Log.log(2, "(PwsFile) new PwsFile (with record set): ID = " + this.fileID);
    }

    public PwsFile(ApplicationAdapter applicationAdapter, String string, PwsPassphrase pwsPassphrase) {
        this.initFull(applicationAdapter, string, pwsPassphrase);
    }

    public PwsFile(String string, PwsPassphrase pwsPassphrase) {
        this.initBasic();
        this.initFull(this.application, string, pwsPassphrase);
    }

    private void initBasic() {
        this.application = Global.getStandardApplication();
        if (this.application == null) {
            throw new IllegalStateException("no standard application available");
        }
        this.headerFields.setField(new PwsRawField(1, this.getUUID().getBytes()));
    }

    private void initFull(ApplicationAdapter applicationAdapter, String string, PwsPassphrase pwsPassphrase) {
        if (applicationAdapter == null) {
            throw new IllegalArgumentException("application missing");
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("filepath missing");
        }
        if (pwsPassphrase == null) {
            throw new IllegalArgumentException("passphrase missing");
        }
        this.application = applicationAdapter;
        this.filePath = string;
        this.setPassphrase(pwsPassphrase);
        this.headerFields.setField(new PwsRawField(1, this.getUUID().getBytes()));
        Log.log(2, "(PwsFile) new PwsFile: ID = " + this.fileID + ", external: " + this.extFileRef(this.application, this.filePath));
    }

    public Object clone() {
        PwsFile pwsFile = (PwsFile)super.clone();
        if (pwsFile == null) {
            return null;
        }
        pwsFile.headerFields = (HeaderFieldList)this.headerFields.clone();
        pwsFile.ps = (PwsPassphrase)this.ps.clone();
        Log.log(2, "(PwsFile) new PwsFile (clone of " + this.idString + "): ID = " + pwsFile.idString);
        return pwsFile;
    }

    public Object copy() {
        PwsFile pwsFile = (PwsFile)this.clone();
        try {
            pwsFile.clear();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                pwsFile.addReadRecord((PwsRecord)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("list copy error: " + exception.getMessage());
        }
        Log.log(2, "(PwsFile) create copy of " + this.idString + ": ID = " + pwsFile.idString);
        return pwsFile;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final String getFileName() {
        return this.filePath == null ? null : new File(this.filePath).getName();
    }

    public final int getFormatVersion() {
        return this.fileVersion;
    }

    public String getCharset() {
        return this.fileVersion > 2 || this.fileVersion == 2 & this.getUserOptions().indexOf("B 24 1") > -1 ? "Utf-8" : Global.getDefaultCharset();
    }

    public synchronized void setFormatVersion(int n) {
        if (n < 1 | n > 3) {
            n = 3;
        }
        if (n != this.fileVersion) {
            int n2 = this.fileVersion;
            this.fileVersion = n;
            if (n2 < this.fileVersion) {
                this.clearUnknownFields();
            }
            if (n == 3 && this.headerFields.getField(1) == null) {
                this.headerFields.setField(new PwsRawField(1, this.getUUID().getBytes()));
            }
            this.contentModified();
        }
    }

    public final PwsPassphrase getPassphrase() {
        return this.ps == null ? null : (PwsPassphrase)this.ps.clone();
    }

    public final ApplicationAdapter getApplication() {
        return this.application;
    }

    public ContextFile getContextFile() {
        return this.hasResource() ? new ContextFile(this.getApplication(), this.getFilePath()) : null;
    }

    public long lastModified() throws IOException {
        return this.hasResource() ? this.application.getModifiedTime(this.filePath) : 0L;
    }

    public long getUnknownFieldSize() {
        return super.getUnknownFieldSize(this.fileVersion) + this.headerFields.getUnknownFieldSize(this.fileVersion);
    }

    public int getUnknownFieldCount() {
        return super.getUnknownFieldCount() + this.headerFields.getUnknownFieldCount();
    }

    public void clearUnknownFields() {
        super.clearUnknownFields();
        int n = this.headerFields.size();
        this.headerFields.clearUnknownFields();
        if (this.headerFields.size() != n) {
            this.contentModified();
        }
    }

    public long getBlockedDataSize(int n) {
        String string = this.getCharset();
        long l = super.getBlockedDataSize(n, string);
        switch (n) {
            case 1: {
                l += 56L;
                break;
            }
            case 2: {
                l += 152L;
                try {
                    l += (long)PwsRawField.pwsFieldBlockSize(this.getUserOptions().getBytes(string).length, n);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 3: {
                l += this.headerFields.blockedDataSize(n);
                l += 200L;
            }
        }
        return l;
    }

    public synchronized void save() throws IOException, ApplicationFailureException {
        if (this.isModified()) {
            String string;
            if (this.application == null | this.filePath == null | this.ps == null) {
                throw new IllegalStateException("persistent state parameters not set");
            }
            if (this.sourceFormat != 0 & this.fileVersion != this.sourceFormat | this.preserveOld) {
                try {
                    string = this.filePath + ".old";
                    Log.log(5, "(PwsFile) renaming previous file to : " + string);
                    if (this.application.renameFile(this.filePath, string)) {
                        Log.debug(2, "renamed " + this.filePath + " to: " + string);
                    } else {
                        Log.error(2, "unable to rename file " + this.filePath + ", target: " + string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = this.idString + this.extFileRef(this.application, this.filePath);
            Log.log(4, "(PwsFile) saving file to" + string);
            PwsFileFactory.saveFile(this.iterator(), this.application, this.filePath, this.ps, this.headerFields, this.securityLoops, this.fileVersion);
            this.resetModified();
            Log.log(4, "(PwsFile) file save finished (before event dispatch)");
            this.fireFileEvent(7, null);
            Log.debug(2, "file saved to" + string);
        }
    }

    public synchronized UUID saveCopy(ApplicationAdapter applicationAdapter, String string) throws IOException, ApplicationFailureException {
        return this.saveCopy(applicationAdapter, string, null, 0, false);
    }

    public synchronized UUID saveCopy(ApplicationAdapter applicationAdapter, String string, PwsPassphrase pwsPassphrase) throws IOException, ApplicationFailureException {
        return this.saveCopy(applicationAdapter, string, pwsPassphrase, 0, false);
    }

    public synchronized UUID saveCopy(ApplicationAdapter applicationAdapter, String string, PwsPassphrase pwsPassphrase, int n, boolean bl) throws IOException, ApplicationFailureException {
        if (applicationAdapter == null) {
            applicationAdapter = this.application;
        }
        if (pwsPassphrase == null) {
            pwsPassphrase = this.ps;
        }
        if (n == 0) {
            n = this.fileVersion;
        }
        HeaderFieldList headerFieldList = new HeaderFieldList(this.headerFields);
        if (n == 3 & !bl) {
            headerFieldList.removeField(1);
        }
        Log.log(2, "(PwsFile) saving a file copy to" + this.idString + this.extFileRef(applicationAdapter, string));
        UUID uUID = PwsFileFactory.saveFile(this.iterator(), applicationAdapter, string, pwsPassphrase, headerFieldList, this.securityLoops, n);
        String string2 = headerFieldList.contains(1) ? Util.bytesToHex(headerFieldList.getField(1).getData()) : "void";
        Log.log(2, "(PwsFile) copy done, target UUDI = " + string2);
        return uUID;
    }

    protected String extFileRef(ApplicationAdapter applicationAdapter, String string) {
        return "\"" + applicationAdapter.getName() + "\" -> " + string;
    }

    public synchronized void setFilePath(String string) {
        if (string != null && string.equals("")) {
            throw new IllegalArgumentException("empty filename");
        }
        this.filePath = string;
        this.setModified();
        Log.debug(2, "file path modified to" + this.idString + this.filePath);
        this.fireFileEvent(5, null);
    }

    public synchronized void setApplication(ApplicationAdapter applicationAdapter) {
        if (applicationAdapter == null) {
            throw new NullPointerException();
        }
        this.application = applicationAdapter;
        this.setModified();
        Log.debug(2, "file IO-context modified to: " + applicationAdapter.getName());
        this.fireFileEvent(5, null);
    }

    public String getUserOptions() {
        String string;
        PwsRawField pwsRawField = this.headerFields.getField(64);
        String string2 = string = pwsRawField == null ? "" : pwsRawField.getString("utf-8");
        if (Log.getLogLevel() > 6) {
            Log.log(7, "(PwsFile) returning user options = \"" + string + "\"");
        }
        return string;
    }

    public synchronized void setUserOptions(String string) {
        if (string == null) {
            string = "";
        }
        Log.log(7, "(PwsFile) setting user options = \"" + string + "\"");
        if (!string.equals(this.getUserOptions())) {
            this.setModified();
            try {
                this.headerFields.setField(new PwsRawField(64, string.getBytes("utf-8")));
                this.contentModified();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public synchronized void setPassphrase(PwsPassphrase pwsPassphrase) {
        this.ps = pwsPassphrase == null ? null : (PwsPassphrase)pwsPassphrase.clone();
        this.setModified();
        Log.debug(2, "file passphrase modified to" + this.idString + this.ps);
        this.fireFileEvent(6, null);
    }

    void setPreserveOld(boolean bl) {
        this.preserveOld = bl;
    }

    public boolean hasResource() {
        return this.application != null & this.filePath != null;
    }

    public boolean equalResource(PwsFile pwsFile) {
        if (pwsFile == null) {
            return false;
        }
        return !this.hasResource() && !pwsFile.hasResource() || this.hasResource() && pwsFile.hasResource() && this.application.equals(pwsFile.application) && this.filePath.equals(pwsFile.filePath);
    }

    public int getSourceFormat() {
        return this.sourceFormat;
    }

    void setSourceFormat(int n) {
        this.sourceFormat = n;
        this.fileVersion = n;
    }

    public HeaderFieldList getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(HeaderFieldList headerFieldList) {
        if (headerFieldList == null) {
            return;
        }
        if (Log.getDebugLevel() > 6) {
            Log.debug(7, "(PwsFile) setHeaderFields(): ");
        }
        boolean bl = this.eventPause;
        this.eventPause = true;
        this.headerFields.clear();
        Iterator iterator = headerFieldList.iterator();
        while (iterator.hasNext()) {
            PwsRawField pwsRawField = (PwsRawField)iterator.next();
            this.headerFields.setField(pwsRawField);
            if (Log.getDebugLevel() <= 6) continue;
            Log.debug(7, "    id=" + pwsRawField.type + "  data=" + Util.bytesToHex(pwsRawField.getData()));
        }
        this.eventPause = bl;
        this.contentModified();
    }

    protected void setChecksumResult(boolean bl) {
        this.checksumOK = bl;
    }

    public boolean isChecksumVerified() {
        return this.checksumOK;
    }

    public void setSecurityLoops(int n) {
        int n2 = this.securityLoops;
        this.securityLoops = Math.max(2048, Math.min(0x400000, n));
        if (this.securityLoops != n2) {
            this.contentModified();
        }
    }

    public int getSecurityLoops() {
        return this.securityLoops;
    }

    public byte[] getSignature() {
        SHA256 sHA256 = new SHA256();
        sHA256.update(super.getSignature());
        Iterator iterator = this.headerFields.iterator();
        while (iterator.hasNext()) {
            sHA256.update(((PwsRawField)iterator.next()).data);
        }
        return sHA256.digest();
    }

    private class PFHeaderFieldList
    extends HeaderFieldList {
        private PFHeaderFieldList() {
        }

        public void clearUnknownFields() {
            int n = super.getUnknownFieldCount();
            super.clearUnknownFields();
            if (n > 0) {
                PwsFile.this.contentModified();
            }
        }

        public PwsRawField setField(PwsRawField pwsRawField) {
            PwsRawField pwsRawField2 = super.setField(pwsRawField);
            if (!pwsRawField.equals(pwsRawField2)) {
                PwsFile.this.contentModified();
            }
            return pwsRawField2;
        }

        public void clear() {
            int n = super.size();
            super.clear();
            if (n > 0) {
                PwsFile.this.contentModified();
            }
        }

        public PwsRawField removeField(int n) {
            PwsRawField pwsRawField = super.removeField(n);
            if (pwsRawField != null) {
                PwsFile.this.contentModified();
            }
            return pwsRawField;
        }
    }
}

