/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.Util;

public final class PwsPassphrase
implements Cloneable {
    public static final int BLOCKSIZE = 4;
    private static final byte[] NULLVALUE = new byte[0];
    private PwsCipher cipher;
    private byte[] sbuf;
    private int length;

    public PwsPassphrase() {
        this.cipher = Global.getStandardCipher();
        this.sbuf = NULLVALUE;
    }

    public PwsPassphrase(PwsCipher pwsCipher) {
        this.cipher = pwsCipher;
        this.sbuf = NULLVALUE;
    }

    public PwsPassphrase(char[] cArray) {
        this.cipher = Global.getStandardCipher();
        this.setValue(cArray);
    }

    public PwsPassphrase(String string) {
        this.cipher = Global.getStandardCipher();
        this.setValue(string);
    }

    public PwsPassphrase(byte[] byArray, String string) {
        this.cipher = Global.getStandardCipher();
        this.setBytes(byArray, string);
    }

    public void setBytes(byte[] byArray, String string) {
        if (string == null) {
            string = Global.getDefaultCharset();
        }
        CharBuffer charBuffer = Charset.forName(string).decode(ByteBuffer.wrap(byArray));
        this.setValue(charBuffer.array(), charBuffer.position(), charBuffer.remaining());
        Util.destroyChars(charBuffer.array());
    }

    public Object clone() {
        try {
            PwsPassphrase pwsPassphrase = (PwsPassphrase)super.clone();
            pwsPassphrase.sbuf = (byte[])this.sbuf.clone();
            return pwsPassphrase;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void clear() {
        this.length = 0;
        this.sbuf = NULLVALUE;
    }

    public void setValue(PwsPassphrase pwsPassphrase) {
        if (pwsPassphrase == null) {
            this.clear();
        } else {
            char[] cArray = pwsPassphrase.getValue();
            this.setValue(cArray);
            Util.destroyChars(cArray);
        }
    }

    public void setValue(String string) {
        if (string == null) {
            this.clear();
        } else {
            char[] cArray = string.toCharArray();
            this.setValue(cArray);
            Util.destroyChars(cArray);
        }
    }

    public void setValue(char[] cArray) {
        if (cArray == null) {
            this.clear();
        } else {
            this.setValue(cArray, 0, cArray.length);
        }
    }

    public void setValue(char[] cArray, int n, int n2) {
        if (cArray == null) {
            this.clear();
            return;
        }
        if (n2 < 0 | n < 0 | n + n2 > cArray.length) {
            throw new IllegalArgumentException("length out of range");
        }
        int n3 = n2 / 4;
        if (n2 % 4 > 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3 * 4 * 2];
        this.length = n2;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            byArray[i * 2] = (byte)c;
            byArray[i * 2 + 1] = (byte)(c >>> 8);
        }
        this.sbuf = this.cipher.encrypt(byArray);
        Util.destroyBytes(byArray);
    }

    protected void setEncrypted(byte[] byArray, int n, PwsCipher pwsCipher) {
        if (byArray.length % 8 > 0) {
            throw new IllegalArgumentException("illegal buffer block length");
        }
        if (pwsCipher == null) {
            throw new NullPointerException("cipher");
        }
        if (n < 0 | n > byArray.length / 2) {
            throw new IllegalArgumentException("length out of range");
        }
        this.sbuf = (byte[])byArray.clone();
        this.length = n;
        this.cipher = pwsCipher;
    }

    public byte[] getBytes(String string) {
        char[] cArray = this.getValue();
        if (string == null) {
            string = Global.getDefaultCharset();
        }
        ByteBuffer byteBuffer = Charset.forName(string).encode(CharBuffer.wrap(cArray));
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        Util.destroyChars(cArray);
        Util.destroyBytes(byteBuffer.array());
        return byArray;
    }

    public char[] getValue() {
        byte[] byArray = this.getValueBuffer();
        char[] cArray = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            int n = byArray[i * 2] & 0xFF | (byArray[i * 2 + 1] & 0xFF) << 8;
            cArray[i] = (char)n;
        }
        Util.destroyBytes(byArray);
        return cArray;
    }

    protected byte[] getValueBuffer() {
        byte[] byArray = this.cipher.decrypt(this.sbuf);
        byte[] byArray2 = new byte[this.length * 2];
        System.arraycopy(byArray, 0, byArray2, 0, this.length * 2);
        Util.destroyBytes(byArray);
        return byArray2;
    }

    public byte[] getEncryptedBlock(PwsCipher pwsCipher) {
        byte[] byArray = (byte[])this.sbuf.clone();
        if (pwsCipher != null && !pwsCipher.equals(this.cipher)) {
            byte[] byArray2 = this.cipher.decrypt(byArray);
            byArray = pwsCipher.encrypt(byArray2);
            Util.destroyBytes(byArray2);
        }
        return byArray;
    }

    public int getLength() {
        return this.length;
    }

    public StringBuffer getStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = this.getValue();
        stringBuffer.append(cArray);
        Util.destroyChars(cArray);
        return stringBuffer;
    }

    public String getString() {
        char[] cArray = this.getValue();
        String string = new String(cArray);
        Util.destroyChars(cArray);
        return string;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        byte[] byArray = ((PwsPassphrase)object).getValueBuffer();
        byte[] byArray2 = this.getValueBuffer();
        boolean bl = Util.equalArrays(byArray, byArray2);
        Util.destroyBytes(byArray);
        Util.destroyBytes(byArray2);
        return bl;
    }

    public int hashCode() {
        byte[] byArray = this.getValueBuffer();
        int n = Util.arrayHashcode(byArray);
        Util.destroyBytes(byArray);
        return n;
    }

    public String toString() {
        return Util.bytesToHex(this.sbuf, 0, this.length * 2);
    }
}

