/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

public class PwsPassphrasePolicy
implements Cloneable {
    public static final int MAXKEYLENGTH = 256;
    public boolean lowercaseChars = true;
    public boolean uppercaseChars = true;
    public boolean digitChars = true;
    public boolean symbolChars = false;
    public boolean easyview = false;
    public int length = 8;

    public PwsPassphrasePolicy() {
    }

    public PwsPassphrasePolicy(int n) {
        if (n > 0) {
            this.setFromInt(n);
        }
    }

    public boolean isValid() {
        int n = 0;
        if (this.lowercaseChars) {
            ++n;
        }
        if (this.uppercaseChars) {
            ++n;
        }
        if (this.digitChars) {
            ++n;
        }
        if (this.symbolChars) {
            ++n;
        }
        return n > 0 && this.length >= n && this.length <= 256;
    }

    public int getIntForm() {
        int n = this.length;
        int n2 = 0;
        if (this.lowercaseChars) {
            n2 |= 1;
        }
        if (this.uppercaseChars) {
            n2 |= 2;
        }
        if (this.digitChars) {
            n2 |= 4;
        }
        if (this.symbolChars) {
            n2 |= 8;
        }
        if (this.easyview) {
            n2 |= 0x10;
        }
        return n |= n2 << 16;
    }

    public void setFromInt(int n) {
        this.length = n & 0xFFFF;
        int n2 = n >>> 16 & 0xFFFF;
        this.lowercaseChars = (n2 & 1) == 1;
        this.uppercaseChars = (n2 & 2) == 2;
        this.digitChars = (n2 & 4) == 4;
        this.symbolChars = (n2 & 8) == 8;
        this.easyview = (n2 & 0x10) == 16;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PwsPassphrasePolicy{ Length=");
        stringBuffer.append(this.length);
        stringBuffer.append(", Uppercase=");
        stringBuffer.append(this.uppercaseChars);
        stringBuffer.append(", Lowercase=");
        stringBuffer.append(this.lowercaseChars);
        stringBuffer.append(", Digits=");
        stringBuffer.append(this.digitChars);
        stringBuffer.append(", Symbols=");
        stringBuffer.append(this.symbolChars);
        stringBuffer.append(", Easyview=");
        stringBuffer.append(this.easyview);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return object != null && ((PwsPassphrasePolicy)object).getIntForm() == this.getIntForm();
    }

    public int hashCode() {
        return this.getIntForm();
    }
}

