/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.IllegalCharsetNameException;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.data.FieldHeader;
import org.jpws.pwslib.data.PwsBlockInputStream;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.PwsChecksum;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.persist.ByteArrayOutputStreamPws;

public class PwsRawField
implements Cloneable {
    int type;
    int length;
    byte[] data;
    private PwsCipher cipher;
    private OutputStream output;

    public PwsRawField(PwsBlockInputStream pwsBlockInputStream, int n) throws IOException {
        this.data = new byte[0];
        this.readStream(pwsBlockInputStream, n);
    }

    public PwsRawField(int n, byte[] byArray) {
        int n2 = byArray == null ? 0 : byArray.length;
        this.init(n, n2, byArray);
    }

    public static PwsRawField makeTextField(int n, String string) {
        byte[] byArray = null;
        String string2 = "utf-8";
        if (string != null) {
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalCharsetNameException(string2);
            }
        }
        return new PwsRawField(n, byArray);
    }

    public static PwsRawField makeTimeField(int n, long l, int n2) {
        if (n2 < 4) {
            throw new IllegalArgumentException("illegal length parameter".concat(String.valueOf(n2)));
        }
        l /= 1000L;
        byte[] byArray = new byte[n2];
        if (n2 < 8) {
            Util.writeIntLittle((int)l, byArray, 0);
        } else {
            Util.writeLongLittle(l, byArray, 0);
        }
        return new PwsRawField(n, byArray);
    }

    public PwsRawField(int n, int n2, byte[] byArray) {
        this.init(n, n2, byArray);
    }

    private void init(int n, int n2, byte[] byArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("illegal field length : " + n2);
        }
        if ((n & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("illegal type value : " + n);
        }
        this.type = n;
        this.length = n2;
        this.data = byArray != null ? Util.arraycopy(byArray, n2) : new byte[]{};
    }

    public Object clone() {
        try {
            PwsRawField pwsRawField = (PwsRawField)super.clone();
            pwsRawField.data = (byte[])this.data.clone();
            return pwsRawField;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        PwsRawField pwsRawField = (PwsRawField)object;
        return pwsRawField.type == this.type && (pwsRawField.data == this.data || pwsRawField.data != null && this.data != null && Util.equalArrays(pwsRawField.data, this.data));
    }

    public int hashCode() {
        int n = 0;
        if (this.data != null) {
            n = Util.arrayHashcode(this.data);
        }
        return n ^= this.type << this.length % 8;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        if (this.data == null) {
            return new byte[this.length];
        }
        return Util.arraycopy(this.data, this.length);
    }

    public PwsPassphrase getPassphrase(String string) {
        byte[] byArray = this.getData();
        PwsPassphrase pwsPassphrase = new PwsPassphrase(byArray, string);
        Util.destroyBytes(byArray);
        return pwsPassphrase;
    }

    public int getBlockedSize(int n) {
        return PwsRawField.pwsFieldBlockSize(this.length, n);
    }

    private byte[] getBlockedDataIntern(int n, int n2, int n3) {
        int n4;
        int n5;
        if (this.data == null | (n5 = (n4 = PwsRawField.pwsFieldBlockCount(this.length, n3) - 1) * n) == 0) {
            return null;
        }
        byte[] byArray = Util.arraycopy(this.data, n2, n5);
        int n6 = this.data.length - n2;
        byte[] byArray2 = Util.getCryptoRand().nextBytes(n5 - n6);
        System.arraycopy(byArray2, 0, byArray, n6, byArray2.length);
        return byArray;
    }

    public String getString(String string) {
        String string2;
        if (this.data == null | this.length == 0) {
            return "";
        }
        if (string == null) {
            string = Global.getDefaultCharset();
        }
        try {
            string2 = new String(this.data, 0, this.length, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "** enc error **";
        }
        return string2;
    }

    public int getBlockCount(int n) {
        return PwsRawField.pwsFieldBlockCount(this.length, n);
    }

    public static int pwsFieldBlockCount(int n, int n2) {
        int n3;
        int n4;
        if (n2 == 3) {
            n4 = 16;
            n3 = 11;
        } else {
            n4 = 8;
            n3 = 0;
        }
        int n5 = 1;
        int n6 = Math.max(0, n - n3);
        n5 += n6 / n4;
        if (n6 % n4 > 0 || n2 < 3 & n6 == 0) {
            ++n5;
        }
        return n5;
    }

    public static int pwsFieldBlockSize(int n, int n2) {
        int n3 = n2 == 3 ? 16 : 8;
        return n3 * PwsRawField.pwsFieldBlockCount(n, n2);
    }

    public void writeEncrypted(OutputStream outputStream, PwsCipher pwsCipher, int n) throws IOException {
        this.writeEncrypted(outputStream, pwsCipher, n, null);
    }

    public void writeEncrypted(OutputStream outputStream, PwsCipher pwsCipher, int n, PwsChecksum pwsChecksum) throws IOException {
        int n2;
        if (outputStream == null | pwsCipher == null) {
            throw new NullPointerException();
        }
        this.output = outputStream;
        this.cipher = pwsCipher;
        int n3 = pwsCipher.getBlockSize();
        int n4 = n3 - 5;
        byte[] byArray = new byte[n3];
        long l = (long)this.length & 0xFFFFFFFFL | ((long)this.type & 0xFFL) << 32;
        Util.writeLongLittle(l, byArray, 0);
        if (n == 3) {
            n2 = Math.min(n4, this.length);
            System.arraycopy(this.data, 0, byArray, 5, n2);
        } else {
            n2 = 0;
        }
        this.writeBlocksEncrypted(byArray);
        byte[] byArray2 = this.getBlockedDataIntern(n3, n2, n);
        if (byArray2 != null) {
            this.writeBlocksEncrypted(byArray2);
        }
        Util.destroyBytes(byArray2);
        if (pwsChecksum != null) {
            pwsChecksum.update(this.data);
        }
    }

    private void readStream(PwsBlockInputStream pwsBlockInputStream, int n) throws IOException {
        byte[] byArray = pwsBlockInputStream.readBlock();
        if (byArray == null) {
            throw new EOFException();
        }
        FieldHeader fieldHeader = new FieldHeader(byArray, n);
        ByteArrayOutputStreamPws byteArrayOutputStreamPws = new ByteArrayOutputStreamPws();
        if (fieldHeader.data != null) {
            byteArrayOutputStreamPws.write(fieldHeader.data);
        }
        if ((byArray = pwsBlockInputStream.readBlocks(fieldHeader.blocks)) == null) {
            throw new EOFException();
        }
        byteArrayOutputStreamPws.write(byArray, 0, fieldHeader.remLength);
        Util.destroyBytes(byArray);
        this.data = byteArrayOutputStreamPws.toByteArray();
        this.length = fieldHeader.length;
        this.type = fieldHeader.type;
        byteArrayOutputStreamPws.clear();
        fieldHeader.clear();
    }

    private void writeBlocksEncrypted(byte[] byArray) throws IOException {
        byte[] byArray2 = this.cipher.encrypt(byArray);
        this.output.write(byArray2);
    }

    public void destroy() {
        this.type = 0;
        this.length = 0;
        Util.destroyBytes(this.data);
        this.data = null;
    }
}

