/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Iterator;
import java.util.zip.CRC32;
import org.jpws.pwslib.crypto.SHA256;
import org.jpws.pwslib.data.PwsFileFactory;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsPassphrasePolicy;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.data.RawFieldList;
import org.jpws.pwslib.exception.InvalidPassphrasePolicy;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.global.Util;

public class PwsRecord
implements Cloneable {
    public static final int IMPORTED = 1;
    public static final int IMPORTED_CONFLICT = 2;
    private RawFieldList otherValues;
    private UUID recordID;
    private String group;
    private String title;
    private PwsPassphrase username;
    private PwsPassphrase notes;
    private PwsPassphrase password;
    private PwsPassphrasePolicy passPolicy;
    private PwsPassphrase history;
    private PwsPassphrase url;
    private String autotype;
    private long createTime;
    private long passLifeTime;
    private long passModTime;
    private long accessTime;
    private long modifyTime;
    private int importStatus;
    private boolean initializing;

    public PwsRecord() {
        this.recordID = new UUID();
        this.modifyTime = this.createTime = System.currentTimeMillis();
        Log.log(4, "(PwsRecord) new PwsRecord: " + this.toString());
    }

    public PwsRecord(long l) {
        this.recordID = new UUID();
        this.createTime = l;
        this.modifyTime = l;
        Log.log(4, "(PwsRecord) new PwsRecord: time == " + l + ", " + this.toString());
    }

    public PwsRecord(UUID uUID) {
        if (uUID == null) {
            throw new NullPointerException();
        }
        this.recordID = uUID;
        this.modifyTime = this.createTime = System.currentTimeMillis();
        Log.log(4, "(PwsRecord) new PwsRecord (param): " + this.toString());
    }

    public Object clone() {
        try {
            PwsRecord pwsRecord = (PwsRecord)super.clone();
            pwsRecord.password = this.getPassword();
            pwsRecord.passPolicy = this.getPassPolicy();
            pwsRecord.username = this.getUsernamePws();
            pwsRecord.notes = this.getNotesPws();
            pwsRecord.url = this.getUrlPws();
            pwsRecord.history = this.getHistoryPws();
            pwsRecord.otherValues = null;
            Iterator iterator = this.getUnknownFields();
            while (iterator != null && iterator.hasNext()) {
                PwsRawField pwsRawField = (PwsRawField)iterator.next();
                pwsRecord.addUnknownField(pwsRawField.type, pwsRawField.getData());
            }
            Log.log(8, "(PwsRecord) record cloned : " + pwsRecord.toString());
            return pwsRecord;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void clear() {
        this.setTitle(null);
        this.setUsername((PwsPassphrase)null);
        this.setGroup(null);
        this.setNotes((PwsPassphrase)null);
        this.setPassword(null);
        try {
            this.setPassPolicy(null);
        }
        catch (InvalidPassphrasePolicy invalidPassphrasePolicy) {
            // empty catch block
        }
        this.setAutotype(null);
        this.setHistory((PwsPassphrase)null);
        this.setUrl((PwsPassphrase)null);
        this.otherValues = null;
        this.passLifeTime = 0L;
        this.passModTime = 0L;
        this.accessTime = 0L;
        this.modified();
    }

    private void modified() {
        if (!this.initializing) {
            this.modifyTime = System.currentTimeMillis();
        }
    }

    public boolean isValid() {
        return this.getRecordID() != null && this.getPassword() != null && this.getTitle() != null;
    }

    public String getInvalidText() {
        if (this.getRecordID() == null) {
            return "UUID missing";
        }
        if (this.getTitle() == null) {
            return "title missing";
        }
        if (this.getPassword() == null) {
            return "password missing";
        }
        return "";
    }

    public boolean hasExpired() {
        return this.willExpire(System.currentTimeMillis());
    }

    public boolean willExpire(long l) {
        long l2 = this.getPassLifeTime();
        return l2 > 0L && l >= l2;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long l) {
        this.accessTime = l = l / 1000L * 1000L;
        if (Log.getDebugLevel() > 4) {
            Log.debug(5, "(PwsRecord) set ACCESSTIME value = " + l + ", " + this);
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getModifiedTime() {
        return this.modifyTime;
    }

    public void setCreateTime(long l) {
        l = l / 1000L * 1000L;
        this.controlValue(this.createTime, l, "CREATETIME");
        this.createTime = l;
    }

    public void setModifyTime(long l) {
        l = l / 1000L * 1000L;
        this.controlValue(this.modifyTime, l, "MODIFYTIME");
        this.modifyTime = l;
    }

    public long getPassLifeTime() {
        return this.passLifeTime;
    }

    public void setPassLifeTime(long l) {
        l = l / 1000L * 1000L;
        this.controlValue(this.passLifeTime, l, "PASSLIFETIME");
        this.passLifeTime = l;
    }

    public long getPassModTime() {
        return this.passModTime;
    }

    public void setPassModTime(long l) {
        l = l / 1000L * 1000L;
        this.controlValue(this.passLifeTime, l, "PASSMODTIME");
        this.passModTime = l;
    }

    public PwsPassphrasePolicy getPassPolicy() {
        return this.passPolicy == null ? null : (PwsPassphrasePolicy)this.passPolicy.clone();
    }

    public void setPassPolicy(PwsPassphrasePolicy pwsPassphrasePolicy) throws InvalidPassphrasePolicy {
        if (pwsPassphrasePolicy != null && !pwsPassphrasePolicy.isValid()) {
            throw new InvalidPassphrasePolicy();
        }
        this.controlValue(this.passPolicy, pwsPassphrasePolicy, "PASSPOLICY");
        this.passPolicy = pwsPassphrasePolicy == null ? null : (PwsPassphrasePolicy)pwsPassphrasePolicy.clone();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        if (string != null) {
            string = Util.substituteText(string, "..", ".");
            boolean bl = false;
            while (!(string.equals("") | bl)) {
                bl = true;
                if ((string = string.trim()).startsWith(".")) {
                    string = string.substring(1);
                    bl = false;
                }
                if (!string.endsWith(".")) continue;
                string = string.substring(0, string.length() - 1);
                bl = false;
            }
        }
        String string2 = this.group;
        this.group = this.transformedStringParam(string);
        this.controlValue(string2, this.group, "GROUP");
    }

    private void controlValue(Object object, Object object2, String string) {
        if (!this.equalVal(object, object2)) {
            this.modified();
            if (Log.getDebugLevel() > 4) {
                Log.debug(5, "(PwsRecord) set " + string + " value = \"" + object2 + "\", " + this);
            }
        }
    }

    private void controlValue(long l, long l2, String string) {
        if (l != l2) {
            this.modified();
            if (Log.getDebugLevel() > 4) {
                Log.debug(5, "(PwsRecord) set " + string + " value = " + l2 + ", " + this);
            }
        }
    }

    private boolean equalVal(Object object, Object object2) {
        return object == null & object2 == null || object != null && object2 != null && object.equals(object2);
    }

    public String getNotes() {
        return this.notes == null ? null : this.notes.getString();
    }

    public PwsPassphrase getNotesPws() {
        return this.notes == null ? null : (PwsPassphrase)this.notes.clone();
    }

    public void setNotes(String string) {
        this.setNotes((string = this.transformedStringParam(string)) == null ? null : new PwsPassphrase(string));
    }

    public void setNotes(PwsPassphrase pwsPassphrase) {
        if (this.voidPassphrase(pwsPassphrase)) {
            pwsPassphrase = null;
        }
        this.controlValue(this.notes, pwsPassphrase, "NOTES");
        this.notes = pwsPassphrase == null ? null : (PwsPassphrase)pwsPassphrase.clone();
    }

    private boolean voidPassphrase(PwsPassphrase pwsPassphrase) {
        return pwsPassphrase == null || pwsPassphrase.getLength() == 0;
    }

    public PwsPassphrase getPassword() {
        return this.password == null ? null : (PwsPassphrase)this.password.clone();
    }

    public void setPassword(PwsPassphrase pwsPassphrase) {
        if (this.voidPassphrase(pwsPassphrase)) {
            pwsPassphrase = null;
        }
        this.controlValue(this.password, pwsPassphrase, "PASSWORD");
        this.password = pwsPassphrase == null ? null : (PwsPassphrase)pwsPassphrase.clone();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = this.transformedStringParam(string);
        this.controlValue(string2, this.title, "TITLE");
    }

    public String getUsername() {
        return this.username == null ? null : this.username.getString();
    }

    public PwsPassphrase getUsernamePws() {
        return this.username == null ? null : (PwsPassphrase)this.username.clone();
    }

    public void setUsername(String string) {
        this.setUsername((string = this.transformedStringParam(string)) == null ? null : new PwsPassphrase(string));
    }

    public void setUsername(PwsPassphrase pwsPassphrase) {
        if (this.voidPassphrase(pwsPassphrase)) {
            pwsPassphrase = null;
        }
        this.controlValue(this.username, pwsPassphrase, "USERNAME");
        this.username = pwsPassphrase == null ? null : (PwsPassphrase)pwsPassphrase.clone();
    }

    public void passwordUpdated() {
        long l = System.currentTimeMillis();
        this.setPassModTime(l);
        this.setAccessTime(l);
    }

    protected void addUnknownField(int n, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (this.otherValues == null) {
            this.otherValues = new RawFieldList();
        }
        this.otherValues.setField(new PwsRawField(n, byArray));
    }

    public void setExtraField(int n, byte[] byArray, int n2) {
        if (PwsFileFactory.isCanonicalField(n, n2)) {
            throw new IllegalArgumentException("canonical field type");
        }
        if (this.otherValues == null) {
            this.otherValues = new RawFieldList();
        }
        if (byArray == null) {
            if (this.otherValues.removeField(n) != null) {
                this.modified();
            }
        } else {
            this.otherValues.setField(new PwsRawField(n, byArray));
            this.modified();
        }
    }

    public Iterator getUnknownFields() {
        return this.otherValues == null || this.otherValues.size() == 0 ? null : this.otherValues.iterator();
    }

    public int getUnknownFieldCount() {
        return this.otherValues == null ? 0 : this.otherValues.size();
    }

    public long getBlockedDataSize(int n, String string) {
        long l = 0L;
        switch (n) {
            case 3: {
                l = this.fieldBlockSizeUpdate(l, this.url, n, string);
                l = this.fieldBlockSizeUpdate(l, this.autotype, n, string);
                l = this.fieldBlockSizeUpdate(l, this.history, n, string);
            }
            case 2: {
                l = this.fieldBlockSizeUpdate(l, this.group, n, string);
                l += (long)PwsRawField.pwsFieldBlockSize(16, n);
                if (this.passPolicy != null) {
                    l += (long)PwsRawField.pwsFieldBlockSize(4, n);
                }
                if (this.accessTime != 0L) {
                    l += (long)PwsRawField.pwsFieldBlockSize(8, n);
                }
                if (this.createTime != 0L) {
                    l += (long)PwsRawField.pwsFieldBlockSize(8, n);
                }
                if (this.modifyTime != 0L) {
                    l += (long)PwsRawField.pwsFieldBlockSize(8, n);
                }
                if (this.passLifeTime != 0L) {
                    l += (long)PwsRawField.pwsFieldBlockSize(8, n);
                }
                if (this.passModTime != 0L) {
                    l += (long)PwsRawField.pwsFieldBlockSize(8, n);
                }
            }
            case 1: {
                l = this.fieldBlockSizeUpdate(l, this.title, n, string);
                l = this.fieldBlockSizeUpdate(l, this.username, n, string);
                l = this.fieldBlockSizeUpdate(l, this.notes, n, string);
                l = this.fieldBlockSizeUpdate(l, this.password, n, string);
            }
        }
        if (this.otherValues != null) {
            l += this.otherValues.blockedDataSize(n);
        }
        return l += n == 1 ? 0L : 16L;
    }

    private long fieldBlockSizeUpdate(long l, Object object, int n, String string) {
        if (object != null) {
            byte[] byArray;
            if (object instanceof String) {
                try {
                    byArray = ((String)object).getBytes(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalCharsetNameException(string);
                }
            } else if (object instanceof PwsPassphrase) {
                byArray = ((PwsPassphrase)object).getBytes(string);
            } else {
                throw new IllegalStateException("illegal parameter type FIELD");
            }
            l += (long)PwsRawField.pwsFieldBlockSize(byArray.length, n);
            Util.destroyBytes(byArray);
        } else if (n < 3) {
            l += 16L;
        }
        return l;
    }

    public long getUnknownFieldSize(int n) {
        return this.otherValues == null ? 0L : this.otherValues.dataSize(n);
    }

    public void clearExtraFields() {
        if (this.otherValues != null) {
            this.otherValues.clear();
        }
    }

    public byte[] getExtraField(int n) {
        PwsRawField pwsRawField;
        if (this.otherValues != null && (pwsRawField = this.otherValues.getField(n)) != null) {
            return pwsRawField.getData();
        }
        return null;
    }

    private String transformedStringParam(String string) {
        if (string != null && (string = string.trim()).equals("")) {
            string = null;
        }
        return string;
    }

    public void setInitialize(boolean bl) {
        this.initializing = bl;
    }

    public UUID getRecordID() {
        return this.recordID;
    }

    public void setRecordID(UUID uUID) {
        if (uUID == null) {
            throw new NullPointerException();
        }
        UUID uUID2 = this.recordID;
        this.recordID = uUID;
        Log.log(4, "(PwsRecord) set record-ID to: " + this.recordID + ", " + uUID2);
    }

    public int getImportStatus() {
        return this.importStatus;
    }

    public void setImportStatus(int n) {
        this.importStatus = n;
    }

    public boolean equals(Object object) {
        return object != null && ((PwsRecord)object).recordID.equals(this.recordID);
    }

    public int hashCode() {
        return this.recordID.hashCode();
    }

    public String toString() {
        return this.recordID.toString();
    }

    public int getCRC() {
        CRC32 cRC32 = new CRC32();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Iterator iterator;
            dataOutputStream.write(this.recordID.getBytes());
            if (this.password != null) {
                dataOutputStream.writeInt(this.password.hashCode());
            }
            if (this.passPolicy != null) {
                dataOutputStream.writeInt(this.passPolicy.getIntForm());
            }
            dataOutputStream.writeLong(this.accessTime);
            dataOutputStream.writeLong(this.createTime);
            dataOutputStream.writeLong(this.modifyTime);
            dataOutputStream.writeLong(this.passLifeTime);
            dataOutputStream.writeLong(this.passModTime);
            if (this.title != null) {
                dataOutputStream.writeChars(this.title);
            }
            if (this.group != null) {
                dataOutputStream.writeChars(this.group);
            }
            if (this.username != null) {
                dataOutputStream.writeInt(this.username.hashCode());
            }
            if (this.notes != null) {
                dataOutputStream.writeInt(this.notes.hashCode());
            }
            if (this.history != null) {
                dataOutputStream.writeInt(this.history.hashCode());
            }
            if (this.url != null) {
                dataOutputStream.writeInt(this.url.hashCode());
            }
            if (this.autotype != null) {
                dataOutputStream.writeChars(this.autotype);
            }
            if ((iterator = this.getUnknownFields()) != null) {
                while (iterator.hasNext()) {
                    PwsRawField pwsRawField = (PwsRawField)iterator.next();
                    dataOutputStream.write(pwsRawField.type);
                    dataOutputStream.write(pwsRawField.data);
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("*** ERROR in PwsRecord CRC : " + iOException);
            return -1;
        }
        cRC32.update(byteArrayOutputStream.toByteArray());
        return (int)cRC32.getValue();
    }

    public byte[] getSignature() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SHA256 sHA256 = new SHA256();
        try {
            Iterator iterator;
            dataOutputStream.write(this.recordID.getBytes());
            if (this.password != null) {
                dataOutputStream.writeInt(this.password.hashCode());
            }
            if (this.passPolicy != null) {
                dataOutputStream.writeInt(this.passPolicy.getIntForm());
            }
            dataOutputStream.writeLong(this.accessTime);
            dataOutputStream.writeLong(this.createTime);
            dataOutputStream.writeLong(this.modifyTime);
            dataOutputStream.writeLong(this.passLifeTime);
            dataOutputStream.writeLong(this.passModTime);
            if (this.title != null) {
                dataOutputStream.writeChars(this.title);
            }
            if (this.group != null) {
                dataOutputStream.writeChars(this.group);
            }
            if (this.username != null) {
                dataOutputStream.writeInt(this.username.hashCode());
            }
            if (this.notes != null) {
                dataOutputStream.writeInt(this.notes.hashCode());
            }
            if ((iterator = this.getUnknownFields()) != null) {
                while (iterator.hasNext()) {
                    PwsRawField pwsRawField = (PwsRawField)iterator.next();
                    dataOutputStream.write(pwsRawField.type);
                    dataOutputStream.write(pwsRawField.data);
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("*** ERROR in creating PwsRecord Signature : " + iOException);
            return null;
        }
        sHA256.update(byteArrayOutputStream.toByteArray());
        return sHA256.digest();
    }

    public String getAutotype() {
        return this.autotype;
    }

    public void setAutotype(String string) {
        String string2 = this.autotype;
        this.autotype = this.transformedStringParam(string);
        this.controlValue(string2, this.autotype, "AUTOTYPE");
    }

    public PwsPassphrase getHistoryPws() {
        return this.history == null ? null : (PwsPassphrase)this.history.clone();
    }

    public String getHistory() {
        return this.history == null ? null : this.history.getString();
    }

    public void setHistory(String string) {
        this.setHistory((string = this.transformedStringParam(string)) == null ? null : new PwsPassphrase(string));
    }

    public void setHistory(PwsPassphrase pwsPassphrase) {
        if (this.voidPassphrase(pwsPassphrase)) {
            pwsPassphrase = null;
        }
        this.controlValue(this.history, pwsPassphrase, "HISTORY");
        this.history = pwsPassphrase == null ? null : (PwsPassphrase)pwsPassphrase.clone();
    }

    public PwsPassphrase getUrlPws() {
        return this.url == null ? null : (PwsPassphrase)this.url.clone();
    }

    public String getUrl() {
        return this.url == null ? null : this.url.getString();
    }

    public void setUrl(String string) {
        this.setUrl((string = this.transformedStringParam(string)) == null ? null : new PwsPassphrase(string));
    }

    public void setUrl(PwsPassphrase pwsPassphrase) {
        if (this.voidPassphrase(pwsPassphrase)) {
            pwsPassphrase = null;
        }
        this.controlValue(this.url, pwsPassphrase, "URLFIELD");
        this.url = pwsPassphrase == null ? null : (PwsPassphrase)pwsPassphrase.clone();
    }
}

