/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.util.HashMap;
import java.util.Iterator;
import org.jpws.pwslib.data.PwsRawField;

public class RawFieldList
implements Cloneable {
    private HashMap fields;

    public RawFieldList() {
        this.fields = new HashMap();
    }

    public RawFieldList(RawFieldList rawFieldList) {
        this.fields = new HashMap(rawFieldList.fields);
    }

    public Object clone() {
        try {
            RawFieldList rawFieldList = (RawFieldList)super.clone();
            rawFieldList.fields = (HashMap)this.fields.clone();
            return rawFieldList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public PwsRawField getField(int n) {
        Integer n2 = new Integer(n);
        PwsRawField pwsRawField = (PwsRawField)this.fields.get(n2);
        return pwsRawField == null ? null : (PwsRawField)pwsRawField.clone();
    }

    public PwsRawField setField(PwsRawField pwsRawField) {
        if (pwsRawField == null) {
            throw new NullPointerException();
        }
        Integer n = new Integer(pwsRawField.type);
        return this.fields.put(n, pwsRawField);
    }

    public PwsRawField removeField(int n) {
        return (PwsRawField)this.fields.remove(new Integer(n));
    }

    public Iterator iterator() {
        return this.fields.values().iterator();
    }

    public int size() {
        return this.fields.size();
    }

    public long blockedDataSize(int n) {
        Iterator iterator = this.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            l += (long)((PwsRawField)iterator.next()).getBlockedSize(n);
        }
        return l;
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean contains(int n) {
        return this.fields.containsKey(new Integer(n));
    }

    public long dataSize(int n) {
        Iterator iterator = this.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            l += (long)((PwsRawField)iterator.next()).getBlockedSize(n);
        }
        return l;
    }

    public String getStringValue(int n) {
        String string = "";
        PwsRawField pwsRawField = this.getField(n);
        if (pwsRawField != null) {
            string = pwsRawField.getString("utf-8");
        }
        return string;
    }
}

