/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.global;

import org.jpws.pwslib.data.PwsPassphrasePolicy;
import org.jpws.pwslib.exception.InvalidPassphrasePolicy;
import org.jpws.pwslib.global.Util;

public class PassphraseUtils {
    public static final char[] LOWERCASE_CHARS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] UPPERCASE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] DIGIT_CHARS = "1234567890".toCharArray();
    public static final char[] SYMBOL_CHARS = "+-=_@#$%^&;:,.<>/~\\[](){}?!|".toCharArray();
    public static final char[] EASYVISION_LC_CHARS = "abcdefghijkmnopqrstuvwxyz".toCharArray();
    public static final char[] EASYVISION_UC_CHARS = "ABCDEFGHJKLMNPQRTUVWXY".toCharArray();
    public static final char[] EASYVISION_DIGIT_CHARS = "346789".toCharArray();
    public static final char[] EASYVISION_SYMBOL_CHARS = "+-=_@#$%^&<>/~\\?".toCharArray();
    public static final int MIN_PASSWORD_LEN = 4;

    private PassphraseUtils() {
    }

    public static char[] makePassword(PwsPassphrasePolicy pwsPassphrasePolicy) throws InvalidPassphrasePolicy {
        boolean[] blArray;
        int n;
        if (!pwsPassphrasePolicy.isValid()) {
            throw new InvalidPassphrasePolicy();
        }
        StringBuffer stringBuffer = new StringBuffer(pwsPassphrasePolicy.length);
        int n2 = 0;
        if (pwsPassphrasePolicy.digitChars) {
            ++n2;
        }
        if (pwsPassphrasePolicy.lowercaseChars) {
            ++n2;
        }
        if (pwsPassphrasePolicy.uppercaseChars) {
            ++n2;
        }
        if (pwsPassphrasePolicy.symbolChars) {
            ++n2;
        }
        char[][] cArrayArray = new char[n2][];
        boolean[] blArray2 = new boolean[4];
        for (n = 0; n < n2; ++n) {
            blArray2[n] = true;
        }
        if (pwsPassphrasePolicy.easyview) {
            n = 0;
            if (pwsPassphrasePolicy.digitChars) {
                cArrayArray[n++] = EASYVISION_DIGIT_CHARS;
            }
            if (pwsPassphrasePolicy.lowercaseChars) {
                cArrayArray[n++] = EASYVISION_LC_CHARS;
            }
            if (pwsPassphrasePolicy.uppercaseChars) {
                cArrayArray[n++] = EASYVISION_UC_CHARS;
            }
            if (pwsPassphrasePolicy.symbolChars) {
                cArrayArray[n++] = EASYVISION_SYMBOL_CHARS;
            }
        } else {
            n = 0;
            if (pwsPassphrasePolicy.digitChars) {
                cArrayArray[n++] = DIGIT_CHARS;
            }
            if (pwsPassphrasePolicy.lowercaseChars) {
                cArrayArray[n++] = LOWERCASE_CHARS;
            }
            if (pwsPassphrasePolicy.uppercaseChars) {
                cArrayArray[n++] = UPPERCASE_CHARS;
            }
            if (pwsPassphrasePolicy.symbolChars) {
                cArrayArray[n++] = SYMBOL_CHARS;
            }
        }
        do {
            stringBuffer.delete(0, stringBuffer.length());
            blArray = (boolean[])blArray2.clone();
            for (n = 0; n < pwsPassphrasePolicy.length; ++n) {
                int n3 = Util.getCryptoRand().nextInt(n2);
                blArray[n3] = false;
                stringBuffer.append(cArrayArray[n3][Util.getCryptoRand().nextInt(cArrayArray[n3].length)]);
            }
        } while (blArray[0] || blArray[1] || blArray[2] || blArray[3]);
        char[] cArray = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        for (n = 0; n < stringBuffer.length(); ++n) {
            stringBuffer.setCharAt(n, '\u0000');
        }
        return cArray;
    }

    public static boolean isWeakPassword(char[] cArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (cArray.length < 4) {
            return true;
        }
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isDigit(c)) {
                bl3 = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                bl = true;
                continue;
            }
            if (Character.isLowerCase(c)) {
                bl2 = true;
                continue;
            }
            bl4 = true;
        }
        return !bl || !bl2 || !bl3 && !bl4;
    }
}

