/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.jpws.front.Global;
import org.jpws.front.util.ResourceLoader;

public class FileOpenDialog
extends JFileChooser {
    public static final int PWSFILE_FILTER = 1;
    public static final int BACKUP_FILTER = 2;
    public static final int EXECUTABLE_FILTER = 4;
    public static final int CSV_FILTER = 8;
    private JDialog dialog;

    public FileOpenDialog(int n) {
        this.setOptions(n);
    }

    public FileOpenDialog(int n, File file) {
        super(file);
        this.setOptions(n);
    }

    public FileOpenDialog(int n, String string) {
        super(string);
        this.setOptions(n);
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        this.dialog = super.createDialog(component);
        return this.dialog;
    }

    public void dispose() {
        this.dialog.dispose();
    }

    private void setOptions(int n) {
        FileFilter fileFilter;
        this.setMultiSelectionEnabled(false);
        PwsFileFilter pwsFileFilter = null;
        if ((n & 1) == 1) {
            fileFilter = new PwsFileFilter();
            this.addChoosableFileFilter(fileFilter);
            if (pwsFileFilter == null) {
                pwsFileFilter = fileFilter;
            }
        }
        if ((n & 2) == 2) {
            fileFilter = new BackupFileFilter();
            this.addChoosableFileFilter(fileFilter);
            if (pwsFileFilter == null) {
                pwsFileFilter = fileFilter;
            }
        }
        if ((n & 8) == 8) {
            fileFilter = new CSVFileFilter();
            this.addChoosableFileFilter(fileFilter);
            if (pwsFileFilter == null) {
                pwsFileFilter = fileFilter;
            }
        }
        if ((n & 4) == 4) {
            fileFilter = new ExecutableFileFilter();
            this.addChoosableFileFilter(fileFilter);
            if (pwsFileFilter == null) {
                pwsFileFilter = fileFilter;
            }
        }
        if (pwsFileFilter != null) {
            this.setFileFilter(pwsFileFilter);
        }
    }

    static class CSVFileFilter
    extends FileFilter {
        CSVFileFilter() {
        }

        public boolean accept(File file) {
            String string;
            if (file.isDirectory()) {
                return true;
            }
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            return n >= 0 && (string = string2.substring(n)).equalsIgnoreCase(".csv");
        }

        public String getDescription() {
            return ResourceLoader.getDisplay("filechooser.filter.csv");
        }
    }

    static class ExecutableFileFilter
    extends FileFilter {
        ExecutableFileFilter() {
        }

        public boolean accept(File file) {
            String string;
            if (!Global.isWindows() || file.isDirectory()) {
                return true;
            }
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            return n >= 0 && ((string = string2.substring(n)).equalsIgnoreCase(".exe") || string.equalsIgnoreCase(".com"));
        }

        public String getDescription() {
            return ResourceLoader.getDisplay("filechooser.filter.executable");
        }
    }

    static class BackupFileFilter
    extends FileFilter {
        BackupFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                String string2 = string.substring(n);
                if (Global.isWindows()) {
                    string2 = string2.toLowerCase();
                }
                if (string2.equals(".bak") || string2.equals(".sec") || string2.equals(".old")) {
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return ResourceLoader.getDisplay("filechooser.filter.backup");
        }
    }

    static class PwsFileFilter
    extends FileFilter {
        PwsFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                String string2 = string.substring(n);
                if (Global.isWindows()) {
                    string2 = string2.toLowerCase();
                }
                if (string2.equals(".dat") || string2.equals(".psafe3")) {
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return ResourceLoader.getDisplay("filechooser.filter.native");
        }
    }
}

