/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jpws.data.Options;
import org.jpws.data.PwsFileSocket;
import org.jpws.front.ActionHandler;
import org.jpws.front.AddDialog;
import org.jpws.front.DisplayManager;
import org.jpws.front.FindTextDialog;
import org.jpws.front.GUIService;
import org.jpws.front.JPWSIdleFrame;
import org.jpws.front.MenuHandler;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.PwsafeJ;
import org.jpws.front.Reporter;
import org.jpws.front.Service;
import org.jpws.front.StatusBar;
import org.jpws.front.ToolbarHandler;
import org.jpws.front.UndoManager;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.TimePulseListener;
import org.jpws.front.util.TimeSlicer;
import org.jpws.front.util.Util;
import org.jpws.pwslib.crypto.CryptoRandom;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsPassphrasePolicy;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.persist.AbstractFTPAdapter;
import org.jpws.pwslib.persist.ApplicationAdapter;
import org.jpws.pwslib.persist.DefaultFilesystemAdapter;
import org.jpws.pwslib.persist.DefaultUrlAdapter;

public final class Global {
    public static final String APPLICATION_TITLE = "JPasswords - JPWS 0.5.0";
    public static final long BUILDVERSION = 500000L;
    public static final int DEBUG_LEVEL = 0;
    public static final long DAY = 86400000L;
    public static final long HOUR = 3600000L;
    public static final long MINUTE = 60000L;
    public static final String OS = System.getProperty("os.name", "").toLowerCase();
    private static final String UNIX_OPTIONFILENAME = ".jpws.ini";
    private static final String WINDOWS_OPTIONFILENAME = "jpws.ini";
    public static final String OPTIONFILENAME = Global.isUnixDerivate() ? ".jpws.ini" : "jpws.ini";
    public static final String DEFAULT_FILEEXTENTION = ".dat";
    public static final String DEFAULT_PWSFILEEXTENTION = ".psafe3";
    public static final String DEFAULT_BACKUPEXTENTION = ".bak";
    public static final int BASIC_SECURITY_LOOPS = 2048;
    public static final int RECENTFIND_LIST_LENGTH = 16;
    public static final long DEFAULT_MAXIDLE = 300000L;
    public static final long DEFAULT_MAXCLIPBOARD = 30000L;
    public static final long DEFAULT_EXPIRESCOPE = 2592000000L;
    public static final int DEFAULT_MAXUNDO = 25;
    public static final int FILEVERSION_1 = 1;
    public static final int FILEVERSION_2 = 2;
    public static final int FILEVERSION_3 = 3;
    public static final int FILEVERSION_LATEST = 3;
    public static final Object IDLE_LOCK = new Object();
    public static Locale locale;
    public static String[] commandlineArgs;
    public static Clipboard clipboard;
    public static ActionListener mainActionListener;
    public static PwsafeJ mainFrame;
    public static JPWSIdleFrame idleFrame;
    public static File currentDir;
    public static File backDir;
    public static File exchangeDir;
    public static File programDir;
    public static File portableDir;
    public static UndoManager undoManager;
    public static RecentList recentFiles;
    public static RecentList recentFinds;
    public static PwsPassphrasePolicy passphrasePolicy;
    public static FileMemory exportFileMem;
    private static ApplicationAdapter urlAdapter;
    private static ApplicationAdapter ftpAdapter;
    private static ApplicationAdapter fileAdapter;
    private static PwsFileContainer theFile;
    private static ServiceDemon serviceDemon;
    private static ShutdownThread shutdownThread;
    private static TimeSlicer blinkPulse;
    private static Hashtable criticalMap;
    private static String startupFilepath;
    private static long maxClipboardTime;
    private static long maxIdleTime;
    private static long clipboardTime;
    private static boolean hasClipboardTransfer;
    private static boolean isWindows;
    private static boolean isPortable;
    private static boolean optionsRead;
    private static boolean isShutdown;
    private static Hashtable activeDialogs;

    public static void autorun() {
        String string;
        String string2;
        long l = System.currentTimeMillis();
        long l2 = (long)Options.getIntOption("lastAccessTime") * 1000L;
        if (l2 > 0L) {
            string2 = ResourceLoader.getDisplay("msg.welcome") + " " + new Date(l2).toLocaleString();
            Global.setStatusText(string2);
        }
        if (Options.wasReset) {
            GUIService.warningMessage(null, null, "msg.warning.optionsreset");
        }
        if (!(string = Options.getOption("emergency")).equals("")) {
            if (new File(string).isFile()) {
                string2 = ResourceLoader.getDisplay("msg.emergency");
                string2 = Util.substituteText(string2, "$file", string);
                GUIService.warningMessage(null, "dlg.emergency", string2);
            } else {
                Options.setOption("emergency", null);
            }
        }
        if (startupFilepath != null) {
            ActionHandler.openFileToShelf(startupFilepath);
        } else if (Options.isOptionSet("reopenFile")) {
            ActionHandler.reopenFileFromRecents();
        }
        long l3 = Options.getLongOption("lastNewsTime");
        long l4 = Options.getLongOption("buildWarnTime");
        if (Options.isOptionSet("checkProjectNews") && l - l3 > 259200000L | l > l4) {
            Runnable runnable = new Runnable(){

                public void run() {
                    Service.controlProjectNews(false);
                }
            };
            ActionHandler.startTaskDelayed(runnable, 60000L);
        }
    }

    private static String getProgramPath() {
        String string = System.getProperty("java.class.path");
        if (string != null) {
            int n = string.indexOf(59);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if (string.toLowerCase().endsWith(".jar")) {
                string = Util.pathNameOfPath(string);
            }
        }
        if (string == null || string.length() == 0) {
            string = System.getProperty("user.dir");
        }
        return string;
    }

    private static File getPortableInitFile() {
        File file = new File(programDir, WINDOWS_OPTIONFILENAME);
        if (file.exists()) {
            return file;
        }
        file = new File(programDir, UNIX_OPTIONFILENAME);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getLocaleString() {
        String string = Locale.getDefault().getDisplayLanguage(Locale.ENGLISH) + ", " + Locale.getDefault().getDisplayCountry(Locale.ENGLISH);
        return string;
    }

    public static void init(String[] stringArray) {
        String string;
        System.out.println("# JPWS-F INITIAL SEQUENCE ...");
        System.err.println("# JPWS-F start, " + System.currentTimeMillis() / 1000L);
        Global.controlJavaVersion();
        commandlineArgs = stringArray;
        isWindows = OS.indexOf("windows") > -1;
        programDir = new File(Global.getProgramPath());
        System.out.println("# Program Path = ".concat(programDir.getAbsolutePath()));
        Reporter.init();
        File file = null;
        if (Global.hasCLArgument("/o:")) {
            file = new File(Global.extractCLArgument("/o"));
        }
        if (!Global.hasCLArgument("/n") && (file == null && (file = Global.getPortableInitFile()) != null || Global.hasCLArgument("/p"))) {
            if (file == null) {
                file = new File(programDir, OPTIONFILENAME);
            }
            try {
                portableDir = file.getCanonicalFile().getParentFile();
                if (portableDir == null) {
                    portableDir = programDir;
                }
            }
            catch (IOException iOException) {
                portableDir = programDir;
            }
            isPortable = true;
            System.out.println("# PORTABLE modus detected: " + portableDir.getAbsolutePath());
        }
        Global.readOptions(file);
        clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (!(stringArray.length <= 0 || (string = stringArray[0]).equals("/p") || string.length() >= 3 && string.charAt(2) == ':')) {
            startupFilepath = string;
        }
        if ((string = Global.extractCLArgument("/l")).equals("")) {
            string = Options.getOption("locale");
        }
        locale = string.equalsIgnoreCase("en") ? new Locale("", "") : (!string.equals("") ? new Locale(string, "") : Locale.getDefault());
        Locale.setDefault(locale);
        System.out.println("# Locale: " + Global.getLocaleString());
        System.out.println("# TimeZone: " + TimeZone.getDefault().getDisplayName());
        ResourceLoader.addResourcePath("org/jpws/front/resource/");
        ResourceLoader.addResourcePath("");
        ResourceLoader.init(null);
        try {
            org.jpws.pwslib.global.Global.init();
            org.jpws.pwslib.global.Global.setDisplayUsernames(Options.isOptionSet("treeUsername"));
            org.jpws.pwslib.global.Global.setProgramName(APPLICATION_TITLE);
            Log.setDebugLevel(0);
            Log.setLogLevel(0);
            org.jpws.pwslib.global.Util.setCryptoRandom(new OptimalRandom());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Global.exit("# *** ERROR: Cannot initialize library!", true);
        }
        Global.swingInit();
        ActionHandler.init();
        mainActionListener = ActionHandler.getMainActionListener();
        MenuHandler.init();
        ToolbarHandler.init();
        DisplayManager.init();
        recentFiles.setMenuFinalItem(MenuHandler.makeItem("menu.file.deleterecents", true));
        serviceDemon = new ServiceDemon();
        serviceDemon.start();
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        System.out.println("# JPWS-F System initialized");
    }

    private static void swingInit() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        String string = Options.getOption("lookAndFeel");
        boolean bl = true;
        try {
            UIManager.setLookAndFeel(string);
            bl = false;
        }
        catch (Exception exception) {
            System.out.println("*** unable to initialize LOOK-AND-FEEL: " + string);
            System.out.println(exception);
        }
        if (bl && Global.isPortable()) {
            RecentList recentList = Options.getOptionHistory("lookAndFeel");
            Iterator iterator = recentList.iterator();
            while (iterator.hasNext()) {
                try {
                    string = (String)iterator.next();
                    UIManager.setLookAndFeel(string);
                    bl = false;
                    break;
                }
                catch (Exception exception) {
                    System.out.println("*** unable to initialize LOOK-AND-FEEL: " + string);
                    System.out.println(exception);
                }
            }
        }
        if (bl) {
            string = UIManager.getCrossPlatformLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (Exception exception) {
                string = UIManager.getSystemLookAndFeelClassName();
                try {
                    UIManager.setLookAndFeel(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            Options.setOption("lookAndFeel", string);
        }
        Keymap keymap = JTextComponent.getKeymap("default");
        TextAction textAction = new DefaultEditorKit.CopyAction();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, 2);
        keymap.addActionForKeyStroke(keyStroke, textAction);
        textAction = new DefaultEditorKit.CutAction();
        keyStroke = KeyStroke.getKeyStroke(127, 1);
        keymap.addActionForKeyStroke(keyStroke, textAction);
        textAction = new DefaultEditorKit.PasteAction();
        keyStroke = KeyStroke.getKeyStroke(155, 1);
        keymap.addActionForKeyStroke(keyStroke, textAction);
    }

    public static void exit() {
        Global.exit(false);
    }

    public static void exit(boolean bl) {
        PwsFileContainer pwsFileContainer;
        boolean bl2 = true;
        if (bl && (pwsFileContainer = Global.getSelectedFile()) != null) {
            bl2 = pwsFileContainer.emergencySave();
        }
        if (bl2) {
            new ServiceAction(4).start();
        }
    }

    public static void exit(String string, boolean bl) {
        if (bl) {
            System.out.println();
            System.out.println("# JPWS-F fatal error condition");
        }
        System.err.println(string);
        Global.exit(false);
    }

    private static void controlJavaVersion() {
        String string = System.getProperty("java.version");
        try {
            int n;
            int n2;
            String[] stringArray;
            int n3;
            int n4 = string.indexOf(95);
            if (n4 > 0) {
                string = string.substring(0, n4);
            }
            if ((n4 = (n3 = Integer.parseInt((stringArray = string.split("[.]"))[0]) * 10000) + (n2 = Integer.parseInt(stringArray[1]) * 100) + (n = Integer.parseInt(stringArray[2]))) < 10402) {
                System.err.println("*** !! INCOMPATIBLE JAVA VIRTUAL MACHINE !!");
                System.err.println("*** Your system reports version: " + string);
                System.err.println("*** JPWS requires minimum: 1.4.2");
                System.exit(1);
            }
            System.out.println("# Java VM " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int indexCLArgument(String string) {
        for (int i = 0; i < commandlineArgs.length; ++i) {
            if (!commandlineArgs[i].toLowerCase().startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasCLArgument(String string) {
        return Global.indexCLArgument(string) > -1;
    }

    public static String extractCLArgument(String string) {
        try {
            int n = Global.indexCLArgument(string + ":");
            return commandlineArgs[n].substring(string.length() + 1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static long getClipboardTime() {
        return hasClipboardTransfer ? System.currentTimeMillis() - clipboardTime : 0L;
    }

    public static PwsFileContainer getSelectedFile() {
        return theFile;
    }

    public static boolean hasSelectedFile() {
        return theFile != null;
    }

    public static boolean hasOpenFiles() {
        return Global.hasSelectedFile();
    }

    public static boolean hasClipboardTransfer() {
        return hasClipboardTransfer;
    }

    public static boolean isOpenFile(String string) {
        if (theFile == null) {
            return false;
        }
        String string2 = theFile.getFilePath();
        return string2 != null && string.equals(string2);
    }

    public static synchronized void setSelectedFile(PwsFileContainer pwsFileContainer) {
        boolean bl = false;
        if (pwsFileContainer == theFile) {
            return;
        }
        if (theFile != null) {
            bl = Global.theFile.fileInfoDlg != null;
            theFile.setOperationMode(0);
            MenuHandler.unregisterFile(theFile);
            ToolbarHandler.unregisterFile(theFile);
        }
        theFile = pwsFileContainer;
        if (pwsFileContainer != null) {
            try {
                theFile.setOperationMode(2);
                MenuHandler.registerFile(theFile);
                ToolbarHandler.registerFile(theFile);
                mainFrame.setScreenView(theFile.getView());
                if (bl) {
                    theFile.showFileInfo();
                }
            }
            catch (Exception exception) {}
        } else {
            mainFrame.resetDisplay();
            FindTextDialog.resetIndex();
        }
        ActionHandler.resetIdleTime();
    }

    public static PwsRecord getSelectedRecord() {
        PwsFileContainer pwsFileContainer = Global.getSelectedFile();
        if (pwsFileContainer != null) {
            return pwsFileContainer.getSelectedRecord();
        }
        return null;
    }

    public static String getSelectedGroupName() {
        PwsFileContainer pwsFileContainer = Global.getSelectedFile();
        if (pwsFileContainer != null) {
            return pwsFileContainer.getSelectedGroupName();
        }
        return null;
    }

    public static StatusBar getStatusBar() {
        return mainFrame == null ? null : mainFrame.getStatusBar();
    }

    public static synchronized void setStatusText(String string) {
        if (mainFrame != null) {
            mainFrame.getStatusBar().setMessage(string);
        }
    }

    public static synchronized void setClipboardText(String string) {
        if (string != null && string.equals("")) {
            string = null;
        }
        clipboard.setContents(new StringSelection(string), null);
        clipboardTime = System.currentTimeMillis();
        hasClipboardTransfer = string != null;
        ActionHandler.clipboardUpdated();
    }

    public static void setDialogActive(String string, boolean bl) {
        if (bl) {
            activeDialogs.put(string, string);
        } else {
            activeDialogs.remove(string);
        }
    }

    public static boolean isDialogActive(String string) {
        return activeDialogs.containsKey(string);
    }

    public static synchronized String getClipboardText() {
        try {
            return (String)clipboard.getContents(null).getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void startBrowser(URL uRL) {
        new ServiceAction(5, uRL).start();
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    private static void readOptions(File file) {
        Options.init(file);
        Global.setMaxIdleTime(Options.getIntOption("maxIdleTime"));
        Global.setMaxClipboardTime(Options.getIntOption("clipboardTime"));
        currentDir = new File(Options.getOption("curdir"));
        backDir = new File(Options.getOption("backdir"));
        exchangeDir = new File(Options.getOption("exchangedir"));
        recentFiles = new RecentList("load.recent", Global.isPortable() ? 20 : 8, 8);
        recentFiles.setContent(Options.getOption("recentPaths"));
        recentFinds = new RecentList(16);
        recentFinds.setContent(Options.getOption("recentFindsContent"));
        int n = Options.getIntOption("policy");
        passphrasePolicy = new PwsPassphrasePolicy(n);
        optionsRead = true;
        if (Global.isPortable()) {
            Iterator iterator;
            RecentList recentList;
            String string = Options.getOption("recentPortableDir");
            String string2 = Util.normalizedPath(portableDir.getAbsolutePath(), true);
            Log.debug(3, "-- old Portable Root: ".concat(string));
            Log.debug(3, "-- new Portable Root: ".concat(string2));
            if (!(string.equals("") | string.equals(string2))) {
                recentList = (RecentList)recentFiles.clone();
                iterator = recentList.iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next().toString();
                    if (!string3.startsWith(string)) continue;
                    String string4 = Util.substituteTextS(string3, string, string2);
                    recentFiles.replaceRecent(string3, string4);
                    Log.debug(3, "-- modified RECENT entry: " + string3 + " --> " + string4);
                }
            }
            currentDir = Global.correctedDirectory(currentDir, string, string2);
            backDir = Global.correctedDirectory(backDir, string, string2);
            exchangeDir = Global.correctedDirectory(exchangeDir, string, string2);
            String string5 = Options.getOption("browserApplication");
            if (string5.length() != 0 && !new File(string5).isFile()) {
                recentList = Options.getOptionHistory("browserApplication");
                iterator = recentList.iterator();
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    if (!new File(string6).isFile()) continue;
                    Options.setOption("browserApplication", string6);
                    break;
                }
            }
        } else if (!exchangeDir.exists()) {
            exchangeDir = currentDir;
        }
    }

    private static File correctedDirectory(File file, String string, String string2) {
        if (!Global.isPortable()) {
            return file;
        }
        File file2 = file;
        String string3 = Util.normalizedPath(file.getPath(), true);
        if (!string.equals(string2) && string3.startsWith(string)) {
            string3 = Util.substituteTextS(string3, string, string2);
            file2 = new File(string3);
        }
        if (!file2.exists()) {
            file2 = portableDir;
        }
        if (!file.equals(file2)) {
            Log.debug(3, "-- modified standard directory: from " + file.getPath() + " to " + file2.getPath());
        }
        return file2;
    }

    public static void setMaxIdleTime(long l) {
        maxIdleTime = Math.max(60000L, l);
    }

    public static void setMaxClipboardTime(long l) {
        maxClipboardTime = Math.max(10000L, l);
    }

    private static void writeOptions() {
        if (!optionsRead) {
            return;
        }
        if (!Options.isOptionSet("useRecentList")) {
            recentFiles.clear();
            Options.setOption("connector.URL.recent", null);
        }
        Options.setOption("curdir", currentDir.getAbsolutePath());
        Options.setOption("backdir", backDir.getAbsolutePath());
        Options.setOption("exchangedir", exchangeDir.getAbsolutePath());
        Options.setOption("recentPaths", recentFiles.getStringContent());
        Options.setOption("recentFindsContent", recentFinds.getStringContent());
        Options.setIntOption("viewtype", MenuHandler.getViewSelection());
        Options.setIntOption("policy", passphrasePolicy.getIntForm());
        Options.save();
    }

    static synchronized void switchIdleState(boolean bl) {
        Global.startServiceAction(bl ? 1 : 2);
    }

    static boolean isIdleState() {
        return mainFrame == null ? false : mainFrame.getIdleState();
    }

    public static Frame getActiveFrame() {
        return Global.isIdleState() ? idleFrame : mainFrame;
    }

    public static void pushRecent(PwsFileSocket pwsFileSocket) {
        if (Options.isOptionSet("useRecentList")) {
            String string = pwsFileSocket.getFilePath().replaceAll("\\\\", "/");
            recentFiles.pushRecent(string);
        }
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isPortable() {
        return isPortable;
    }

    public static ApplicationAdapter getAdapter(URL uRL) {
        String string = uRL.getProtocol();
        return string.equalsIgnoreCase("file") ? fileAdapter : (string.equalsIgnoreCase("ftp") ? ftpAdapter : urlAdapter);
    }

    public static ApplicationAdapter getLocalFileAdapter() {
        return fileAdapter;
    }

    public static String getFilePath(URL uRL) {
        String string;
        String string2 = uRL.getProtocol();
        String string3 = string = string2.equalsIgnoreCase("file") ? uRL.getPath() : uRL.toExternalForm();
        if (isWindows && string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    public static void delay(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean requestCriticalPhase(URL uRL) {
        String string;
        String string2 = string = uRL == null ? "null" : uRL.toExternalForm();
        if (criticalMap.containsKey(string)) {
            return false;
        }
        criticalMap.put(string, string);
        StatusBar statusBar = Global.getStatusBar();
        if (statusBar != null && !isShutdown) {
            statusBar.setActivity(1);
        }
        return true;
    }

    public static boolean isCriticalPhase(URL uRL) {
        return criticalMap.containsKey(uRL == null ? "null" : uRL.toExternalForm());
    }

    public static void endCriticalPhase(URL uRL) {
        StatusBar statusBar;
        criticalMap.remove(uRL == null ? "null" : uRL.toExternalForm());
        if (criticalMap.size() == 0 && (statusBar = Global.getStatusBar()) != null && !isShutdown) {
            statusBar.setActivity(0);
        }
    }

    private Global() {
    }

    private static void startServiceAction(int n) {
        new ServiceAction(n).start();
    }

    public static void addTimePulseListener(TimePulseListener timePulseListener) {
        blinkPulse.addTimePulseListener(timePulseListener);
    }

    public static void removeTimePulseListener(TimePulseListener timePulseListener) {
        blinkPulse.removeTimePulseListener(timePulseListener);
    }

    public static String getDefaultCharset() {
        return org.jpws.pwslib.global.Global.getDefaultCharset();
    }

    public static boolean isUnixDerivate() {
        return OS.indexOf("linux") > -1 || OS.indexOf("unix") > -1;
    }

    public static HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){
            private Stack stack = new Stack();

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                    if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)jEditorPane.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                    } else {
                        ActionHandler.resetIdleTime();
                        try {
                            URL uRL = hyperlinkEvent.getURL();
                            if (uRL.getProtocol().equals("file") || uRL.getProtocol().equals("jar")) {
                                if (uRL.getRef() == null) {
                                    int n;
                                    String string = uRL.getPath();
                                    String string2 = string.substring(n = string.lastIndexOf(47) + 1);
                                    if (string2.equals("$RETURN")) {
                                        if (!this.stack.isEmpty()) {
                                            uRL = (URL)this.stack.pop();
                                        }
                                    } else {
                                        String string3 = ResourceLoader.getCommand("html.file." + string2);
                                        string = string.substring(0, n) + string3;
                                        uRL = new URL(uRL.getProtocol(), uRL.getHost(), string);
                                    }
                                }
                                if (uRL != null) {
                                    this.stack.push(jEditorPane.getPage());
                                    jEditorPane.setPage(uRL);
                                }
                            } else {
                                Global.startBrowser(uRL);
                            }
                        }
                        catch (IOException iOException) {
                            System.out.println("*** About Dialog: IOError: " + iOException);
                        }
                    }
                }
            }
        };
    }

    static {
        undoManager = new UndoManager();
        exportFileMem = new FileMemory(5);
        urlAdapter = new DefaultUrlAdapter();
        ftpAdapter = new FTPAdapter();
        fileAdapter = new DefaultFilesystemAdapter();
        shutdownThread = new ShutdownThread();
        blinkPulse = new TimeSlicer(6, 3);
        criticalMap = new Hashtable();
        activeDialogs = new Hashtable();
    }

    public static class FileMemory {
        private RecentList rlist;

        public FileMemory(int n) {
            this.rlist = new RecentList(n);
        }

        public void pushFile(PwsFile pwsFile) {
            this.pushFile(pwsFile, null);
        }

        public void pushFile(PwsFile pwsFile, String string) {
            FRec fRec = new FRec(pwsFile);
            if (string != null) {
                fRec.setName(string);
            }
            this.rlist.pushRecent(fRec);
        }

        public FRec getRecord(String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FRec fRec = (FRec)iterator.next();
                if (!fRec.filepath.equals(string)) continue;
                return fRec;
            }
            return null;
        }

        public PwsPassphrase getPassphrase(String string) {
            FRec fRec = this.getRecord(string);
            return fRec == null ? null : fRec.passphrase;
        }

        public void clear() {
            this.rlist.clear();
        }

        public int size() {
            return this.rlist.getSize();
        }

        public Iterator iterator() {
            return this.rlist.iterator();
        }

        public PwsFile openFile(String string) {
            if (string == null) {
                throw new NullPointerException("filepath");
            }
            FRec fRec = this.getRecord(string);
            if (fRec == null) {
                return null;
            }
            try {
                PwsFile pwsFile = ActionHandler.passTryOpen(Util.makeFileURL(fRec.filepath), fRec.passphrase);
                if (pwsFile == null) {
                    return null;
                }
                fRec.passphrase = pwsFile.getPassphrase();
                return pwsFile;
            }
            catch (IOException iOException) {
                GUIService.failureMessage(null, iOException);
                return null;
            }
        }

        public static class FRec {
            String filepath;
            String name;
            ApplicationAdapter adapter;
            PwsPassphrase passphrase;

            public FRec(PwsFile pwsFile) {
                if (pwsFile.getPassphrase() == null) {
                    throw new IllegalArgumentException("no passphrase defined");
                }
                if (!pwsFile.hasResource()) {
                    throw new IllegalArgumentException("no persistent state");
                }
                this.filepath = pwsFile.getFilePath();
                this.adapter = pwsFile.getApplication();
                this.passphrase = pwsFile.getPassphrase();
                this.name = Util.fileNameOfPath(this.filepath);
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                FRec fRec = (FRec)object;
                return fRec.filepath.equals(this.filepath) && fRec.adapter.equals(this.adapter);
            }

            public int hashCode() {
                return this.filepath.hashCode() ^ this.adapter.hashCode();
            }

            public String toString() {
                return this.name;
            }

            public void setName(String string) {
                this.name = string;
            }
        }
    }

    private static class OptimalRandom
    extends CryptoRandom {
        private OptimalRandom() {
        }

        public byte[] getUserSeed() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                PwsFileContainer pwsFileContainer;
                Dimension dimension;
                long l;
                Point point;
                dataOutputStream.write(Options.randomSeed);
                dataOutputStream.writeInt(this.hashCode());
                Frame frame = Global.getActiveFrame();
                if (frame != null) {
                    point = frame.getLocation();
                    l = (long)point.x << 32 | (long)point.y;
                    dataOutputStream.writeLong(l);
                    dimension = frame.getSize();
                    l = (long)dimension.width << 32 | (long)dimension.height;
                    dataOutputStream.writeLong(l);
                    dataOutputStream.writeInt(frame.hashCode());
                }
                if ((pwsFileContainer = Global.getSelectedFile()) != null) {
                    dataOutputStream.write(pwsFileContainer.getRandomValue());
                    dataOutputStream.writeInt(pwsFileContainer.hashCode());
                    AddDialog addDialog = pwsFileContainer.getEditDialog();
                    if (addDialog != null) {
                        dataOutputStream.writeInt(addDialog.hashCode());
                        point = addDialog.getLocation();
                        l = (long)point.x << 32 | (long)point.y;
                        dataOutputStream.writeLong(l);
                        dimension = addDialog.getSize();
                        l = (long)dimension.width << 32 | (long)dimension.height;
                        dataOutputStream.writeLong(l);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("*** ERROR in random user seed collector: " + exception);
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static class FTPAdapter
    extends AbstractFTPAdapter {
        public String getUserLogin(String string) {
            String string2 = ResourceLoader.getDisplay("dlg.connect.ftplogin");
            String string3 = ResourceLoader.getDisplay("msg.connect.ftplogin.request");
            string3 = Util.substituteText(string3, "$domain", string);
            return JOptionPane.showInputDialog(mainFrame, string3, string2, 3);
        }
    }

    private static class ShutdownThread
    extends Thread {
        boolean isInternal;

        public ShutdownThread() {
            super("JPWS Shutdown Thread");
        }

        public void run() {
            PwsFileContainer pwsFileContainer;
            PrintStream printStream = Reporter.getPrintStream(1);
            String string = !this.isInternal ? "# *** SYSTEM SHUTDOWN HOOK operating now ***" : "# *** JPWS-F SHUTDOWN INITIATED";
            System.out.println();
            System.out.println(string);
            printStream.println(string);
            isShutdown = true;
            if (serviceDemon != null) {
                serviceDemon.terminate();
            }
            if (!this.isInternal && (pwsFileContainer = Global.getSelectedFile()) != null) {
                pwsFileContainer.emergencySave();
            }
            if (optionsRead) {
                if (mainFrame != null) {
                    Options.setBounds("mainframe", mainFrame.getBounds());
                }
                Options.setIntOption("lastAccessTime", (int)(System.currentTimeMillis() / 1000L));
                if (portableDir != null) {
                    Options.setOption("recentPortableDir", Util.normalizedPath(portableDir.getAbsolutePath(), true));
                }
                Global.writeOptions();
                string = "# options saved";
                System.out.println(string);
                printStream.println(string);
            }
            if (hasClipboardTransfer && Options.isOptionSet("clearClipboard")) {
                Global.setClipboardText(null);
                string = "# System clipboard cleared";
                System.out.println(string);
                printStream.println(string);
            }
            if (this.isInternal) {
                if (idleFrame != null) {
                    System.out.println("# disposing IDLE FRAME");
                    idleFrame.dispose();
                    idleFrame = null;
                }
                if (mainFrame != null) {
                    System.out.println("# exiting MAIN FRAME");
                    mainFrame.exit();
                    mainFrame = null;
                }
            }
            System.out.println("# JPWS-F TERMINATED, " + System.currentTimeMillis() / 1000L);
            printStream.println("# JPWS-F TERMINATED ");
            Reporter.exit();
        }
    }

    private static class ServiceDemon
    extends Thread {
        private static final long SLEEPTIME = 1000L;
        private static final long AUTOSAFETIME = 10000L;

        ServiceDemon() {
            super("JPWS Service Demon");
            this.setDaemon(true);
        }

        public synchronized void run() {
            int n = 0;
            block4: while (true) {
                try {
                    while (true) {
                        boolean bl;
                        long l = ActionHandler.getIdleTime();
                        PwsFileContainer pwsFileContainer = Global.getSelectedFile();
                        boolean bl2 = bl = pwsFileContainer != null;
                        if (!Global.isIdleState() && l > maxIdleTime && Options.isOptionSet("lockIdleState")) {
                            Global.startServiceAction(1);
                        }
                        if (hasClipboardTransfer && Global.getClipboardTime() > maxClipboardTime && Options.isOptionSet("clearClipboard")) {
                            Global.startServiceAction(3);
                        }
                        if (bl && l > 10000L && pwsFileContainer.isModified() && Options.isOptionSet("autoflush") && pwsFileContainer.canWrite()) {
                            pwsFileContainer.saveFile(false);
                        }
                        if (n++ % 60 == 0) {
                            for (int i = 0; i < 3; ++i) {
                                System.gc();
                            }
                        }
                        if (Options.isOptionSet("monitorSystem")) {
                            Global.setStatusText("Idle Time: " + l / 1000L + "   Clipboard Time: " + Global.getClipboardTime() / 1000L + "   Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "/" + Runtime.getRuntime().totalMemory() / 1000L);
                        }
                        this.notifyAll();
                        try {
                            this.wait(1000L);
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    GUIService.failureMessage("Service-Demon", exception);
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public synchronized void terminate() {
            this.stop();
            System.out.println("# Service Demon terminated");
        }

        public synchronized void pause() {
            this.suspend();
        }
    }

    private static class ServiceAction
    extends Thread {
        static final int SWITCH_TO_IDLE = 1;
        static final int SWITCH_TO_ACTIVE = 2;
        static final int CLEAR_CLIPBOARD = 3;
        static final int EXIT = 4;
        static final int START_BROWSER = 5;
        private int opcode;
        private Object arg;

        public ServiceAction(int n) {
            this(n, null);
        }

        public ServiceAction(int n, Object object) {
            super("ServiceAction " + n);
            this.opcode = n;
            this.arg = object;
        }

        public void run() {
            switch (this.opcode) {
                case 1: {
                    ServiceAction.switchIdleState(true);
                    break;
                }
                case 2: {
                    ServiceAction.switchIdleState(false);
                    break;
                }
                case 3: {
                    Global.setClipboardText(null);
                    GUIService.statusConfirm("msg.confirm.clearclip");
                    break;
                }
                case 4: {
                    ServiceAction.exitAction();
                    break;
                }
                case 5: {
                    ServiceAction.startBrowser((URL)this.arg);
                }
            }
        }

        private static void exitAction() {
            System.out.println("# JPWS-F exit");
            if (serviceDemon != null) {
                serviceDemon.pause();
            }
            if (theFile != null && !theFile.close()) {
                System.out.println("# JPWS-F exit interrupted");
                if (serviceDemon != null) {
                    serviceDemon.resume();
                }
                return;
            }
            try {
                shutdownThread.isInternal = true;
                shutdownThread.start();
                try {
                    shutdownThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                System.out.println("# JPWS-F EXIT IllegalThreadState on Shutdown");
                return;
            }
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
            System.exit(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void switchIdleState(boolean bl) {
            Object object = IDLE_LOCK;
            synchronized (object) {
                if (mainFrame != null & Global.hasOpenFiles()) {
                    ActionHandler.resetIdleTime();
                    if (bl) {
                        if (idleFrame == null) {
                            idleFrame = new JPWSIdleFrame();
                        }
                        idleFrame.show();
                        idleFrame.setExtendedState(1);
                    } else if (idleFrame != null) {
                        idleFrame.dispose();
                    }
                    mainFrame.setIdleState(bl);
                    for (int i = 0; i < 3; ++i) {
                        System.gc();
                    }
                }
            }
        }

        public static void startBrowser(URL uRL) {
            boolean bl;
            String string = Options.getOption("browserApplication");
            int n = 0;
            boolean bl2 = bl = string.equals("") || new File(string).isFile();
            if (!bl) {
                GUIService.failureMessage("prefmsg.browser", null);
            }
            do {
                ActionHandler.resetIdleTime();
                if (string.equals("") | !bl) {
                    n = GUIService.editBrowserOption();
                    string = Options.getOption("browserApplication");
                }
                bl = false;
                if (!(!string.equals("") & n == 0)) continue;
                try {
                    Runtime.getRuntime().exec(string + " " + uRL.toExternalForm());
                    bl = true;
                }
                catch (IOException iOException) {
                    System.out.println("*** ERROR external browser start: " + iOException);
                }
            } while (n != 1 & n != -1 & !bl);
        }
    }
}

