/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jpws.data.Options;
import org.jpws.data.PersistentOptions;
import org.jpws.front.ActionHandler;
import org.jpws.front.FileOpenDialog;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.Service;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.ButtonBarListener;
import org.jpws.front.util.ReporterWindow;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.TooltipComboBoxRenderer;
import org.jpws.front.util.Util;

public class ImportCSVDialog
extends ButtonBarDialog
implements ButtonBarListener,
ActionListener {
    private PwsFileContainer container;
    private List groups;
    private PersistentOptions fileOptions;
    private Object lock = new Object();
    private JComboBox formatCombo;
    private JComboBox charsetCombo;
    private JComboBox groupCombo;
    private JButton fileButton;
    private JLabel filepathLabel;
    private String rootChoice;
    private ReporterWindow reporter;
    private PrintWriter errorLog;
    private File inFile;
    private boolean isNewFile;

    public ImportCSVDialog(PwsFileContainer pwsFileContainer) {
        super((Frame)Global.mainFrame, 4, pwsFileContainer != null);
        File file;
        this.container = pwsFileContainer;
        this.isNewFile = pwsFileContainer == null;
        String string = Options.getOption("importfile.recent");
        if (string.length() != 0 && (file = new File(string)).isFile()) {
            this.inFile = file;
        }
        this.init();
    }

    private void init() {
        this.fileOptions = this.isNewFile ? Options.getOptions() : this.container.getOptions();
        this.setTitle(ResourceLoader.getDisplay("dlg.import.csv"));
        if (this.isNewFile) {
            this.moveRelatedTo(Global.mainFrame);
        } else {
            this.groups = this.container.getGroupList();
        }
        this.setButtonBarListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setBarGap(2);
        this.filepathLabel = new JLabel(this.inFile != null ? this.inFile.getPath() : "");
        this.filepathLabel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.filepathLabel.setForeground(Color.green);
        this.filepathLabel.setBackground(Color.gray);
        this.filepathLabel.setOpaque(true);
        jPanel.add((Component)this.filepathLabel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        GridLayout gridLayout = new GridLayout(5, 1, 0, 10);
        jPanel3.setLayout(gridLayout);
        JPanel jPanel4 = new JPanel(new GridLayout(5, 1, 0, 10));
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)jPanel4, "Center");
        JLabel jLabel = new JLabel(ResourceLoader.getDisplay("label.destination"));
        jPanel3.add(jLabel);
        jLabel = new JLabel(ResourceLoader.getDisplay(this.isNewFile ? "label.newfile" : "label.merge"));
        jPanel4.add(jLabel);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.targetgroup"));
        jPanel3.add(jLabel);
        this.groupCombo = this.groups == null ? new JComboBox() : new JComboBox<Object>(this.groups.toArray());
        this.groupCombo.setEditable(true);
        jPanel4.add(this.groupCombo);
        this.rootChoice = ResourceLoader.getCommand("combo.select.root");
        this.groupCombo.insertItemAt(this.rootChoice, 0);
        String string = this.fileOptions.getOption("import.targetgroup");
        if (string.length() == 0) {
            string = this.rootChoice;
        } else if (this.isNewFile) {
            this.groupCombo.insertItemAt(string, 1);
        }
        this.groupCombo.setSelectedItem(string);
        int n = this.groupCombo.getPreferredSize().width;
        if (n > 400) {
            this.groupCombo.setPrototypeDisplayValue("DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD");
            this.groupCombo.setRenderer(new TooltipComboBoxRenderer());
        }
        jLabel = new JLabel(ResourceLoader.getDisplay("label.fileformat"));
        jPanel3.add(jLabel);
        this.formatCombo = new JComboBox<String>(new String[]{ResourceLoader.getDisplay("label.database"), ResourceLoader.getDisplay("label.spreadsheet")});
        int n2 = Options.getIntOption("import.format");
        if (n2 < 0 | n2 > 1) {
            n2 = 0;
        }
        this.formatCombo.setSelectedIndex(n2);
        jPanel4.add(this.formatCombo);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.charset"));
        jPanel3.add(jLabel);
        this.charsetCombo = GUIService.getListedCharsetsCombo();
        string = Options.getOption("import.charset");
        if (string.equals("")) {
            string = Global.getDefaultCharset();
        }
        this.charsetCombo.setSelectedItem(Charset.forName(string));
        jPanel4.add(this.charsetCombo);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.inputfile"));
        jPanel3.add(jLabel);
        this.fileButton = new JButton(ResourceLoader.getDisplay("button.browse"));
        this.fileButton.addActionListener(this);
        jPanel4.add(this.fileButton);
        this.setDialogPanel(jPanel);
        string = ResourceLoader.getDisplay("dlg.import.errorlog");
        this.reporter = new ReporterWindow((Dialog)this, string);
        this.errorLog = new PrintWriter(this.reporter.getWriter());
    }

    public void dispose() {
        super.dispose();
        this.fileButton.removeActionListener(this);
        if (this.isNewFile) {
            Global.setDialogActive("ImportCSVDialog.NewFile", false);
        }
    }

    public void setEditFieldsEnabled(boolean bl) {
        this.fileButton.setEnabled(bl);
        this.charsetCombo.setEnabled(bl);
        this.formatCombo.setEnabled(bl);
        this.groupCombo.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileButton) {
            File file;
            FileOpenDialog fileOpenDialog = new FileOpenDialog(8);
            fileOpenDialog.setDialogTitle(ResourceLoader.getDisplay("dlg.import.csv.inputfile"));
            if (this.inFile != null) {
                fileOpenDialog.setSelectedFile(this.inFile);
            } else {
                fileOpenDialog.setCurrentDirectory(Global.exchangeDir);
            }
            if (fileOpenDialog.showOpenDialog(this) == 0 && (file = fileOpenDialog.getSelectedFile()) != null) {
                this.inFile = file;
                this.filepathLabel.setText(file.getPath());
                Global.exchangeDir = fileOpenDialog.getCurrentDirectory();
                this.pack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelButtonPerformed() {
        Object object = this.lock;
        synchronized (object) {
            this.dispose();
        }
    }

    public void helpButtonPerformed() {
        GUIService.startHelpDialog(this, "dlg.help.csvimport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean okButtonPerformed() {
        var9_1 = new Util.BufferInt();
        var4_2 = null;
        var11_3 = 0;
        var13_4 = this.lock;
        synchronized (var13_4) {
            block28: {
                try {
                    block27: {
                        block33: {
                            block31: {
                                block32: {
                                    block29: {
                                        block30: {
                                            if (this.inFile == null) {
                                                GUIService.infoMessage(this, null, "msg.nofilespecified");
                                                var14_5 = false;
                                                var16_11 = null;
                                                this.setEditFieldsEnabled(true);
                                                try {
                                                    if (var4_2 == null) return var14_5;
                                                    var4_2.close();
                                                }
                                                catch (IOException var17_19) {
                                                    // empty catch block
                                                }
                                                return var14_5;
                                            }
                                            if (this.inFile.exists()) break block29;
                                            var6_27 = ResourceLoader.getDisplay("msg.filenotfound");
                                            var6_27 = Util.substituteText(var6_27, "$path", this.inFile.getAbsolutePath());
                                            GUIService.infoMessage(this, null, var6_27);
                                            var14_6 = false;
                                            var16_12 = null;
                                            this.setEditFieldsEnabled(true);
                                            ** try [egrp 4[TRYBLOCK] [16 : 664->677)] { 
lbl31:
                                            // 1 sources

                                            if (var4_2 == null) return var14_6;
                                            var4_2.close();
                                            break block30;
lbl34:
                                            // 1 sources

                                            catch (IOException var17_20) {
                                                // empty catch block
                                            }
                                        }
                                        return var14_6;
                                    }
                                    var8_31 = (String)this.groupCombo.getSelectedItem();
                                    if (var8_31 != null && var8_31.equals(this.rootChoice)) {
                                        var8_31 = null;
                                    }
                                    var4_2 = new FileInputStream(this.inFile);
                                    var10_32 = this.formatCombo.getSelectedIndex() == 0 ? 0 : 1;
                                    var5_33 = (Charset)this.charsetCombo.getSelectedItem();
                                    if (var5_33 == null) {
                                        var5_33 = Charset.forName(Global.getDefaultCharset());
                                    }
                                    this.reporter.clearText();
                                    var2_34 = Service.csvImportRecords(var4_2, var5_33, var10_32, var9_1, this.errorLog);
                                    var4_2.close();
                                    var6_28 = (String)this.groupCombo.getSelectedItem();
                                    if (var6_28.equals(this.rootChoice)) {
                                        var6_28 = "";
                                    }
                                    this.fileOptions.setOption("import.targetgroup", var6_28);
                                    Options.setOption("importfile.recent", this.inFile.getAbsolutePath());
                                    Options.setOption("import.charset", var5_33.name());
                                    Options.setIntOption("import.format", this.formatCombo.getSelectedIndex());
                                    if (var2_34.getRecordCount() != 0) break block31;
                                    GUIService.infoMessage(this, null, ResourceLoader.getDisplay("msg.import.empty"));
                                    var14_7 = false;
                                    var16_13 = null;
                                    this.setEditFieldsEnabled(true);
                                    ** try [egrp 4[TRYBLOCK] [16 : 664->677)] { 
lbl64:
                                    // 1 sources

                                    if (var4_2 == null) return var14_7;
                                    var4_2.close();
                                    break block32;
lbl67:
                                    // 1 sources

                                    catch (IOException var17_21) {
                                        // empty catch block
                                    }
                                }
                                return var14_7;
                            }
                            this.setEditFieldsEnabled(false);
                            if (this.isNewFile) {
                                var1_35 = ActionHandler.newFileToShelf(var2_34);
                                var12_36 = var1_35 != null;
                                if (var12_36 & var8_31 != null) {
                                    var3_37 = var2_34.toRecordWrappers(null);
                                    var1_35.moveEntries(var3_37, var8_31, true);
                                }
                                if (var12_36) {
                                    this.container = var1_35;
                                    var11_3 = var1_35.getRecordCount();
                                }
                            } else {
                                var14_8 = this.container.getRecordCount();
                                var12_36 = this.container.mergeDatabase(this, var2_34, this.inFile.getName(), var8_31) != null;
                                var11_3 = this.container.getRecordCount() - var14_8;
                            }
                            this.setEditFieldsEnabled(true);
                            if (!(var12_36 & (this.isNewFile | var9_1.value > 0))) break block27;
                            var7_38 = "";
                            if (var9_1.value > 0) {
                                var7_38 = ResourceLoader.getDisplay("msg.confirm.import.omitted");
                                var7_38 = Util.substituteText(var7_38, "$omits", String.valueOf(var9_1.value));
                            }
                            var6_28 = ResourceLoader.getDisplay("msg.confirm.import");
                            var6_28 = Util.substituteText(var6_28, "$file", this.inFile.getAbsolutePath());
                            var6_28 = Util.substituteText(var6_28, "$recs", String.valueOf(var11_3));
                            var6_28 = Util.substituteText(var6_28, "$omitinfo", var7_38);
                            GUIService.infoMessage(this, null, var6_28);
                            var14_8 = 1;
                            var16_14 = null;
                            this.setEditFieldsEnabled(true);
                            ** try [egrp 4[TRYBLOCK] [16 : 664->677)] { 
lbl102:
                            // 1 sources

                            if (var4_2 == null) return (boolean)var14_8;
                            var4_2.close();
                            break block33;
lbl105:
                            // 1 sources

                            catch (IOException var17_22) {
                                // empty catch block
                            }
                        }
                        return (boolean)var14_8;
                    }
                    var16_15 = null;
                    this.setEditFieldsEnabled(true);
                    try {}
                    catch (IOException var17_23) {}
                    if (var4_2 == null) return false;
                    var4_2.close();
                    break block28;
                    catch (StreamCorruptedException var14_9) {
                        var6_29 = ResourceLoader.getDisplay("msg.import.error.format");
                        var6_29 = Util.substituteText(var6_29, "$exc", var14_9.getMessage());
                        GUIService.infoMessage(this, "dlg.operfailure", var6_29);
                        var16_16 = null;
                        this.setEditFieldsEnabled(true);
                        try {}
                        catch (IOException var17_24) {}
                        if (var4_2 == null) return false;
                        var4_2.close();
                        break block28;
                    }
                    catch (Exception var14_10) {
                        var14_10.printStackTrace();
                        var6_30 = ResourceLoader.getDisplay("msg.import.error");
                        GUIService.failureMessage(var6_30, var14_10);
                        var16_17 = null;
                        this.setEditFieldsEnabled(true);
                        try {}
                        catch (IOException var17_25) {}
                        if (var4_2 == null) return false;
                        var4_2.close();
                    }
                }
                catch (Throwable var15_39) {
                    var16_18 = null;
                    this.setEditFieldsEnabled(true);
                    ** try [egrp 4[TRYBLOCK] [16 : 664->677)] { 
lbl149:
                    // 1 sources

                    if (var4_2 == null) throw var15_39;
                    var4_2.close();
                    throw var15_39;
lbl152:
                    // 1 sources

                    catch (IOException var17_26) {
                        // empty catch block
                    }
                    throw var15_39;
                }
            }
            return false;
        }
    }

    public boolean extraButtonPerformed(Object object) {
        return true;
    }
}

