/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Color;
import java.awt.Font;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jpws.data.Options;
import org.jpws.data.PwsFileSocket;
import org.jpws.front.ActionHandler;
import org.jpws.front.Global;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.ContextFile;

public class MenuHandler {
    public static final int FILTER_SHOWALL = 0;
    public static final int FILTER_SHOW_EXIRING = 1;
    public static final int FILTER_SHOW_IMPORTED = 2;
    public static final int FILTER_SHOW_MODIFIED = 3;
    private static JMenuBar menuBar;
    private static JMenu recordMenu;
    private static JMenu recentMenu;
    private static JMenu revertMenu;
    private static JMenu lastEditedMenu;
    private static JMenu lastUsedMenu;
    private static JMenu filterMenu;
    private static JMenu exportMenu;
    private static MListener mListener;
    private static JMenuItem editAdd;
    private static JMenuItem editEdit;
    private static JMenuItem editDelete;
    private static JMenuItem editFind;
    private static JMenuItem editCopyUser;
    private static JMenuItem editCopyPass;
    private static JMenuItem editUndo;
    private static JMenuItem editRedo;
    private static JSeparator editUndoSeparator;
    private static JMenuItem editSelectAll;
    private static JMenuItem fileClose;
    private static JMenuItem fileConvert;
    private static JMenuItem fileSave;
    private static JMenuItem fileSaveAs;
    private static JMenuItem fileSaveCopy;
    private static JMenuItem clearClip;
    private static JMenuItem viewTable;
    private static JMenuItem viewTree;
    private static JMenuItem manageChangePw;
    private static JMenuItem managePolicy;
    private static JMenuItem manageBackup;
    private static JMenuItem manageRestore;
    private static JMenuItem manageMergefile;
    private static JMenuItem manageExportFileCSV;
    private static JMenuItem manageImportFileCSV;
    private static JMenuItem fileInfo;
    private static JCheckBoxMenuItem monitorCheck;
    private static JRadioButtonMenuItem filterAll;
    private static JRadioButtonMenuItem filterExpiry;
    private static JRadioButtonMenuItem filterModify;
    private static JRadioButtonMenuItem filterImport;

    private MenuHandler() {
    }

    public static void init() {
        menuBar = new JMenuBar();
        menuBar.add(MenuHandler.buildFileMenu());
        menuBar.add(MenuHandler.buildEditMenu());
        menuBar.add(MenuHandler.buildViewMenu());
        menuBar.add(MenuHandler.buildManageMenu());
        menuBar.add(MenuHandler.buildHelpMenu());
        ActionHandler.clipboardUpdated();
    }

    private static JMenu buildEditMenu() {
        JMenu jMenu = new JMenu(ResourceLoader.getCommand("menu.edit"));
        jMenu.addMenuListener(mListener);
        editUndo = MenuHandler.makeItem("menu.edit.undo", true);
        jMenu.add(editUndo);
        editRedo = MenuHandler.makeItem("menu.edit.redo", true);
        jMenu.add(editRedo);
        editUndoSeparator = new JSeparator();
        jMenu.add(editUndoSeparator);
        MenuHandler.undoUpdated();
        recordMenu = MenuHandler.buildRecordMenu();
        jMenu.add(recordMenu);
        lastUsedMenu = new JMenu(ResourceLoader.getCommand("menu.edit.lastused"));
        lastUsedMenu.addMenuListener(mListener);
        lastUsedMenu.setVisible(Options.isOptionSet("storeMinorChanges"));
        lastUsedMenu.setEnabled(false);
        jMenu.add(lastUsedMenu);
        lastEditedMenu = new JMenu(ResourceLoader.getCommand("menu.edit.lastedited"));
        lastEditedMenu.addMenuListener(mListener);
        lastEditedMenu.setVisible(Options.isOptionSet("storeMinorChanges"));
        lastEditedMenu.setEnabled(false);
        jMenu.add(lastEditedMenu);
        jMenu.addSeparator();
        editCopyPass = MenuHandler.makeItem("menu.edit.copypass", false);
        editCopyPass.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenu.add(editCopyPass);
        editCopyUser = MenuHandler.makeItem("menu.edit.copyuser", false);
        editCopyUser.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenu.add(editCopyUser);
        clearClip = new JMenuItem(ActionHandler.getClearClipAction());
        clearClip.setIcon(null);
        jMenu.add(clearClip);
        jMenu.addSeparator();
        editFind = MenuHandler.makeItem("menu.edit.find", false);
        editFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenu.add(editFind);
        editSelectAll = MenuHandler.makeItem("menu.edit.selectall", false);
        editSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenu.add(editSelectAll);
        exportMenu = new ExportMenu();
        exportMenu.setEnabled(false);
        jMenu.add(exportMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem = MenuHandler.makeItem("menu.edit.options", true);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenuItem makeItem(String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(ResourceLoader.getCommand(string));
        jMenuItem.setActionCommand(string);
        jMenuItem.setEnabled(bl);
        jMenuItem.addActionListener(Global.mainActionListener);
        return jMenuItem;
    }

    private static JRadioButtonMenuItem makeRadioItem(String string, ButtonGroup buttonGroup, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(ResourceLoader.getCommand(string));
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setActionCommand(string);
        jRadioButtonMenuItem.setEnabled(bl);
        jRadioButtonMenuItem.addActionListener(Global.mainActionListener);
        return jRadioButtonMenuItem;
    }

    private static JMenu buildRecordMenu() {
        JMenu jMenu = new JMenu(ResourceLoader.getCommand("menu.edit.psw"));
        jMenu.addMenuListener(mListener);
        jMenu.setEnabled(false);
        editAdd = MenuHandler.makeItem("menu.edit.psw.add", false);
        jMenu.add(editAdd);
        editEdit = MenuHandler.makeItem("menu.edit.psw.edit", false);
        jMenu.add(editEdit);
        editDelete = MenuHandler.makeItem("menu.edit.psw.delete", false);
        jMenu.add(editDelete);
        return jMenu;
    }

    private static JMenu buildFileMenu() {
        JMenu jMenu = new JMenu(ResourceLoader.getCommand("menu.file"));
        jMenu.addMenuListener(mListener);
        JMenuItem jMenuItem = MenuHandler.makeItem("menu.file.new", true);
        jMenu.add(jMenuItem);
        jMenuItem = MenuHandler.makeItem("menu.file.open", true);
        jMenu.add(jMenuItem);
        fileClose = MenuHandler.makeItem("menu.file.close", false);
        jMenu.add(fileClose);
        jMenu.addSeparator();
        recentMenu = new JMenu(ResourceLoader.getCommand("menu.file.openrecent"));
        recentMenu.addMenuListener(Global.recentFiles);
        recentMenu.addMenuListener(mListener);
        recentMenu.setVisible(Options.isOptionSet("useRecentList"));
        jMenu.add(recentMenu);
        jMenuItem = MenuHandler.makeItem("menu.file.openurl", true);
        jMenu.add(jMenuItem);
        jMenuItem = MenuHandler.makeItem("menu.file.import", true);
        jMenu.add(jMenuItem);
        fileConvert = MenuHandler.makeItem("menu.file.convert", true);
        fileConvert.setVisible(false);
        jMenu.add(fileConvert);
        revertMenu = new OldStateMenu();
        jMenu.add(revertMenu);
        jMenu.addSeparator();
        fileSave = MenuHandler.makeItem("menu.file.save", false);
        jMenu.add(fileSave);
        fileSaveAs = MenuHandler.makeItem("menu.file.saveas", false);
        jMenu.add(fileSaveAs);
        fileSaveCopy = MenuHandler.makeItem("menu.file.savecopy", false);
        jMenu.add(fileSaveCopy);
        jMenu.addSeparator();
        jMenuItem = MenuHandler.makeItem("menu.file.exit", true);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private static JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu(ResourceLoader.getCommand("menu.help"));
        jMenu.addMenuListener(mListener);
        JMenuItem jMenuItem = MenuHandler.makeItem("menu.help.support", true);
        jMenuItem.setIcon(ResourceLoader.getImageIcon("webicon"));
        jMenuItem.setHorizontalTextPosition(10);
        jMenu.add(jMenuItem);
        jMenuItem = MenuHandler.makeItem("menu.help.checknews", true);
        jMenu.add(jMenuItem);
        jMenuItem = MenuHandler.makeItem("menu.help.wipefile", true);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        fileInfo = MenuHandler.makeItem("menu.help.fileinfo", false);
        fileInfo.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenu.add(fileInfo);
        jMenuItem = MenuHandler.makeItem("menu.help.system", true);
        jMenu.add(jMenuItem);
        monitorCheck = new JCheckBoxMenuItem(ResourceLoader.getCommand("menu.help.monitor"));
        monitorCheck.setSelected(Options.isOptionSet("monitorSystem"));
        monitorCheck.setActionCommand("menu.help.monitor");
        monitorCheck.addActionListener(Global.mainActionListener);
        jMenu.add(monitorCheck);
        jMenu.addSeparator();
        jMenuItem = MenuHandler.makeItem("menu.help.about", true);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private static JMenu buildManageMenu() {
        JMenu jMenu = new JMenu(ResourceLoader.getCommand("menu.manage"));
        jMenu.addMenuListener(mListener);
        manageChangePw = MenuHandler.makeItem("menu.manage.changepass", false);
        jMenu.add(manageChangePw);
        managePolicy = MenuHandler.makeItem("menu.manage.policy", true);
        jMenu.add(managePolicy);
        jMenu.addSeparator();
        manageMergefile = MenuHandler.makeItem("menu.manage.mergefile", false);
        jMenu.add(manageMergefile);
        manageImportFileCSV = MenuHandler.makeItem("menu.manage.importfile.csv", false);
        jMenu.add(manageImportFileCSV);
        manageExportFileCSV = MenuHandler.makeItem("menu.manage.exportfile.csv", false);
        jMenu.add(manageExportFileCSV);
        jMenu.addSeparator();
        manageBackup = MenuHandler.makeItem("menu.manage.backup", false);
        jMenu.add(manageBackup);
        manageRestore = MenuHandler.makeItem("menu.manage.restore", false);
        jMenu.add(manageRestore);
        return jMenu;
    }

    private static JMenu buildViewMenu() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = new JMenu(ResourceLoader.getCommand("menu.view"));
        jMenu.addMenuListener(mListener);
        JMenuItem jMenuItem = new JRadioButtonMenuItem(ResourceLoader.getCommand("menu.view.list"));
        jMenuItem.setActionCommand("menu.view.list");
        jMenuItem.addActionListener(Global.mainActionListener);
        jMenuItem.setEnabled(false);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        viewTable = jMenuItem;
        jMenuItem = new JRadioButtonMenuItem(ResourceLoader.getCommand("menu.view.tree"));
        jMenuItem.setActionCommand("menu.view.tree");
        jMenuItem.addActionListener(Global.mainActionListener);
        jMenuItem.setEnabled(false);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        viewTree = jMenuItem;
        jMenu.addSeparator();
        filterMenu = MenuHandler.buildFilterMenu();
        jMenu.add(filterMenu);
        jMenu.addSeparator();
        jMenuItem = MenuHandler.makeItem("menu.view.idle", true);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenu.add(jMenuItem);
        MenuHandler.setViewSelection(Options.getIntOption("viewtype"));
        return jMenu;
    }

    private static JMenu buildFilterMenu() {
        JMenu jMenu = new JMenu(ResourceLoader.getCommand("menu.view.filter"));
        jMenu.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        filterAll = MenuHandler.makeRadioItem("menu.view.filter.all", buttonGroup, true);
        filterAll.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        filterAll.setSelected(true);
        jMenu.add(filterAll);
        jMenu.addSeparator();
        filterExpiry = MenuHandler.makeRadioItem("menu.view.filter.expiry", buttonGroup, true);
        filterExpiry.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenu.add(filterExpiry);
        filterImport = MenuHandler.makeRadioItem("menu.view.filter.import", buttonGroup, true);
        jMenu.add(filterImport);
        filterModify = MenuHandler.makeRadioItem("menu.view.filter.modify", buttonGroup, true);
        filterModify.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        jMenu.add(filterModify);
        return jMenu;
    }

    public static void setFilterSelection(int n) {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        switch (n) {
            case 0: {
                jRadioButtonMenuItem = filterAll;
                break;
            }
            case 1: {
                jRadioButtonMenuItem = filterExpiry;
                break;
            }
            case 2: {
                jRadioButtonMenuItem = filterImport;
                break;
            }
            case 3: {
                jRadioButtonMenuItem = filterModify;
                break;
            }
            default: {
                jRadioButtonMenuItem = null;
            }
        }
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    private static void setViewSelection(int n) {
        if (n == 0) {
            return;
        }
        (n == 2 ? viewTable : viewTree).setSelected(true);
    }

    public static void setRecentMenuVisible(boolean bl) {
        recentMenu.setVisible(bl);
    }

    public static void setEntryListsVisible(boolean bl) {
        lastUsedMenu.setVisible(bl);
        lastEditedMenu.setVisible(bl);
    }

    public static void undoUpdated() {
        String string;
        boolean bl = Global.undoManager.canUndo();
        boolean bl2 = Global.undoManager.canRedo();
        if (bl) {
            string = Global.undoManager.getUndoPresentationName();
            editUndo.setText(string);
        }
        editUndo.setVisible(bl);
        if (bl2) {
            string = Global.undoManager.getRedoPresentationName();
            editRedo.setText(string);
        }
        editRedo.setVisible(bl2);
        editUndoSeparator.setVisible(bl | bl2);
    }

    public static void fileUpdated(PwsFileContainer pwsFileContainer) {
        boolean bl = pwsFileContainer.isModified();
        fileSave.setEnabled(bl);
        revertMenu.setEnabled(bl && pwsFileContainer.hasPersistentFile() || pwsFileContainer.getAutoBackups().size() != 0);
        fileConvert.setVisible(pwsFileContainer.getFileFormat() != 3);
        lastEditedMenu.setEnabled(pwsFileContainer.getLastEditedList().getSize() != 0);
        lastUsedMenu.setEnabled(pwsFileContainer.getLastUsedList().getSize() != 0);
    }

    private static void fileMounted(PwsFileContainer pwsFileContainer) {
        if (pwsFileContainer == null) {
            return;
        }
        boolean bl = pwsFileContainer.getOperationMode() == 2;
        boolean bl2 = pwsFileContainer.isModified();
        editAdd.setEnabled(bl);
        editFind.setEnabled(bl);
        manageChangePw.setEnabled(bl);
        manageBackup.setEnabled(bl);
        manageRestore.setEnabled(bl);
        manageMergefile.setEnabled(bl);
        manageExportFileCSV.setEnabled(bl);
        manageImportFileCSV.setEnabled(bl);
        recordMenu.setEnabled(bl);
        fileClose.setEnabled(bl);
        fileSave.setEnabled(bl & bl2);
        revertMenu.setEnabled(bl && (bl2 && pwsFileContainer.hasPersistentFile() || pwsFileContainer.getAutoBackups().size() != 0));
        fileConvert.setVisible(bl && pwsFileContainer.getFileFormat() != 3);
        fileSaveAs.setEnabled(bl);
        fileSaveCopy.setEnabled(bl);
        viewTable.setEnabled(bl);
        viewTree.setEnabled(bl);
        filterMenu.setEnabled(bl);
        editSelectAll.setEnabled(bl);
        lastEditedMenu.setEnabled(bl && pwsFileContainer.getLastEditedList().getSize() != 0);
        lastUsedMenu.setEnabled(bl && pwsFileContainer.getLastUsedList().getSize() != 0);
        fileInfo.setEnabled(bl);
        RecentList recentList = pwsFileContainer.getLastUsedList();
        if (bl) {
            lastUsedMenu.addMenuListener(recentList);
        } else {
            lastUsedMenu.removeAll();
            lastUsedMenu.removeMenuListener(recentList);
        }
        recentList = pwsFileContainer.getLastEditedList();
        if (bl) {
            lastEditedMenu.addMenuListener(recentList);
        } else {
            lastEditedMenu.removeAll();
            lastEditedMenu.removeMenuListener(recentList);
        }
        if (!bl) {
            Global.undoManager.clear();
        }
        if (!bl) {
            MenuHandler.rowSelected(pwsFileContainer);
        }
    }

    private static void rowSelected(PwsFileContainer pwsFileContainer) {
        int n = pwsFileContainer.getSelectionStatus();
        boolean bl = n == 2;
        boolean bl2 = n != 0;
        editEdit.setEnabled(bl);
        editDelete.setEnabled(bl);
        editCopyUser.setEnabled(bl);
        editCopyPass.setEnabled(bl);
        exportMenu.setEnabled(bl2);
    }

    public static boolean isMonitorSelected() {
        return monitorCheck.isSelected();
    }

    public static JMenuBar getMenuBar() {
        return menuBar;
    }

    private static void setMenuElementFont(MenuElement menuElement, Font font) {
        if (menuElement == null) {
            return;
        }
        menuElement.getComponent().setFont(font);
        MenuElement[] menuElementArray = menuElement.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            MenuHandler.setMenuElementFont(menuElementArray[i], font);
        }
    }

    public static void setMenuFont(Font font) {
        if (font == null) {
            return;
        }
        UIManager.put("Menu.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("MenuBar.font", font);
        MenuHandler.setMenuElementFont(menuBar, font);
    }

    public static int getViewSelection() {
        return viewTable.isSelected() ? 2 : 1;
    }

    public static ChangeListener getChangeListener() {
        return mListener;
    }

    public static void registerFile(PwsFileContainer pwsFileContainer) {
        if (pwsFileContainer != null) {
            pwsFileContainer.addChangeListener(mListener);
        }
    }

    public static void unregisterFile(PwsFileContainer pwsFileContainer) {
        if (pwsFileContainer != null) {
            pwsFileContainer.removeChangeListener(mListener);
        }
    }

    public static JPopupMenu getListviewContextMenu(PwsFileContainer pwsFileContainer) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = MenuHandler.makeItem("menu.edit.copypass", true);
        JMenuItem jMenuItem2 = MenuHandler.makeItem("menu.edit.copyuser", true);
        JMenuItem jMenuItem3 = MenuHandler.makeItem("menu.edit.delete.record", true);
        JMenuItem jMenuItem4 = MenuHandler.makeItem("menu.edit.delete.group", true);
        JMenuItem jMenuItem5 = MenuHandler.makeItem("menu.edit.expandbranch", true);
        JMenuItem jMenuItem6 = MenuHandler.makeItem("menu.edit.foldbranch", true);
        JMenuItem jMenuItem7 = MenuHandler.makeItem("menu.edit.selectall", true);
        JMenuItem jMenuItem8 = MenuHandler.makeItem("menu.edit.selectrecords", true);
        JMenuItem jMenuItem9 = MenuHandler.makeItem("menu.edit.foldall", true);
        JMenuItem jMenuItem10 = MenuHandler.makeItem("menu.edit.duplicate", true);
        JMenuItem jMenuItem11 = MenuHandler.makeItem("menu.edit.duplicategroup", true);
        JMenuItem jMenuItem12 = MenuHandler.makeItem("menu.edit.rename.group", true);
        JMenuItem jMenuItem13 = MenuHandler.makeItem("menu.edit.starturl", true);
        ExportMenu exportMenu = new ExportMenu();
        JMenuItem jMenuItem14 = MenuHandler.makeItem("menu.edit.moveentries", true);
        if (pwsFileContainer.getViewType() == 1) {
            switch (pwsFileContainer.getSelectionStatus()) {
                case 0: {
                    jPopupMenu.add(jMenuItem7);
                    jPopupMenu.add(jMenuItem9);
                    break;
                }
                case 2: {
                    boolean bl;
                    boolean bl2 = bl = pwsFileContainer.getSelectedRecords().length == 1;
                    if (bl) {
                        jPopupMenu.add(jMenuItem);
                        jPopupMenu.add(jMenuItem2);
                        if (Util.extractURL(pwsFileContainer.getSelectedRecord().getUrl()) != null) {
                            jPopupMenu.add(jMenuItem13);
                        }
                    }
                    jPopupMenu.add(jMenuItem3);
                    jPopupMenu.add(jMenuItem10);
                    jPopupMenu.addSeparator();
                    if (bl) {
                        jPopupMenu.add(jMenuItem8);
                    }
                    jPopupMenu.add(jMenuItem7);
                    jPopupMenu.add(jMenuItem9);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem14);
                    jPopupMenu.add(exportMenu);
                    break;
                }
                case 1: {
                    jPopupMenu.add(jMenuItem5);
                    jPopupMenu.add(jMenuItem6);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem12);
                    jPopupMenu.add(jMenuItem4);
                    jPopupMenu.add(jMenuItem11);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem8);
                    jPopupMenu.add(jMenuItem7);
                    jPopupMenu.add(jMenuItem9);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem14);
                    jPopupMenu.add(exportMenu);
                }
            }
        } else {
            switch (pwsFileContainer.getSelectionStatus()) {
                case 0: {
                    jPopupMenu.add(jMenuItem7);
                    break;
                }
                case 2: {
                    boolean bl;
                    boolean bl3 = bl = pwsFileContainer.getSelectedRecords().length == 1;
                    if (bl) {
                        jPopupMenu.add(jMenuItem);
                        jPopupMenu.add(jMenuItem2);
                        if (Util.extractURL(pwsFileContainer.getSelectedRecord().getUrl()) != null) {
                            jPopupMenu.add(jMenuItem13);
                        }
                    }
                    jPopupMenu.add(jMenuItem3);
                    jPopupMenu.add(jMenuItem10);
                    jPopupMenu.addSeparator();
                    if (bl) {
                        jPopupMenu.add(jMenuItem8);
                    }
                    jPopupMenu.add(jMenuItem7);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem14);
                    jPopupMenu.add(exportMenu);
                }
            }
        }
        return jPopupMenu;
    }

    static {
        mListener = new MListener();
    }

    public static class OldStateMenu
    extends JMenu {
        public static final Color PRIMARYFILE_COLOR = new Color(0x8B008B);
        public static final String COMMAND_BASE = "menu.file.revert.";

        public OldStateMenu() {
            this.setText(ResourceLoader.getCommand("menu.file.revert"));
            this.setEnabled(false);
        }

        private String itemText(long l) {
            return new Date(l).toLocaleString();
        }

        protected void fireMenuSelected() {
            this.removeAll();
            PwsFileContainer pwsFileContainer = Global.getSelectedFile();
            if (pwsFileContainer != null) {
                JMenuItem jMenuItem;
                String string;
                List list = pwsFileContainer.getAutoBackups();
                if (pwsFileContainer.isModified() && pwsFileContainer.hasPersistentFile()) {
                    string = this.itemText(pwsFileContainer.getStoreTime());
                    jMenuItem = new JMenuItem(string);
                    jMenuItem.setForeground(PRIMARYFILE_COLOR);
                    jMenuItem.setActionCommand(COMMAND_BASE.concat(pwsFileContainer.getFilePath()));
                    jMenuItem.addActionListener(Global.mainActionListener);
                    this.add(jMenuItem);
                    if (list.size() != 0) {
                        this.addSeparator();
                    }
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = ((ContextFile)iterator.next()).getFilepath();
                    try {
                        long l = Util.timeFromSECPath(string2);
                        if (l == -1L) continue;
                        string = this.itemText(l);
                        jMenuItem = new JMenuItem(string);
                        jMenuItem.setActionCommand(COMMAND_BASE.concat(string2));
                        jMenuItem.addActionListener(Global.mainActionListener);
                        this.add(jMenuItem);
                    }
                    catch (Exception exception) {}
                }
                if (list.size() != 0) {
                    this.addSeparator();
                    jMenuItem = MenuHandler.makeItem("menu.file.erasebackups", true);
                    this.add(jMenuItem);
                }
            }
            super.fireMenuSelected();
        }
    }

    private static class MListener
    implements MenuListener,
    ChangeListener {
        private MListener() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            ActionHandler.resetIdleTime();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent instanceof PwsFileSocket.ChangeEvent && changeEvent.getSource() != null && changeEvent.getSource() instanceof PwsFileContainer) {
                PwsFileContainer pwsFileContainer = (PwsFileContainer)changeEvent.getSource();
                switch (((PwsFileSocket.ChangeEvent)changeEvent).getState()) {
                    case 1: {
                        MenuHandler.fileMounted(pwsFileContainer);
                        break;
                    }
                    case 2: {
                        MenuHandler.rowSelected(pwsFileContainer);
                        break;
                    }
                    case 3: {
                        Global.mainFrame.setTitleFile(pwsFileContainer);
                        MenuHandler.setViewSelection(pwsFileContainer.getViewType());
                        break;
                    }
                    case 5: {
                        MenuHandler.setFilterSelection(pwsFileContainer.getFilterStatus());
                        break;
                    }
                    case 4: {
                        Global.mainFrame.setTitleFile(pwsFileContainer);
                        MenuHandler.fileUpdated(pwsFileContainer);
                        break;
                    }
                    case 6: {
                        Global.mainFrame.setTitleFile(pwsFileContainer);
                        MenuHandler.fileUpdated(pwsFileContainer);
                    }
                }
            }
        }
    }

    public static class ExportMenu
    extends JMenu {
        public static final Color TARGETFILE_COLOR = new Color(0x8B008B);

        public ExportMenu() {
            this.setText(ResourceLoader.getCommand("menu.edit.export"));
        }

        protected void fireMenuSelected() {
            this.removeAll();
            this.add(MenuHandler.makeItem("menu.edit.export.file", true));
            this.add(MenuHandler.makeItem("menu.edit.export.csv", true));
            if (Global.exportFileMem.size() != 0) {
                this.addSeparator();
                Iterator iterator = Global.exportFileMem.iterator();
                while (iterator.hasNext()) {
                    Global.FileMemory.FRec fRec = (Global.FileMemory.FRec)iterator.next();
                    JMenuItem jMenuItem = new JMenuItem(fRec.name);
                    jMenuItem.setForeground(TARGETFILE_COLOR);
                    jMenuItem.setActionCommand("export.targetfile." + fRec.filepath);
                    jMenuItem.addActionListener(Global.mainActionListener);
                    this.add(jMenuItem);
                }
            }
            super.fireMenuSelected();
        }
    }
}

