/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jpws.front.DisplayManager;
import org.jpws.front.GUIService;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.ButtonBarListener;
import org.jpws.front.util.DefaultButtonBarListener;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.PwsPassphrasePolicy;

public class PolicyDialog
extends ButtonBarDialog {
    private PolicyDialogPanel dlgPanel;
    private PwsPassphrasePolicy editedPolicy;
    private ButtonBarListener externalListener;

    public PolicyDialog(Dialog dialog, PwsPassphrasePolicy pwsPassphrasePolicy, int n) throws HeadlessException {
        super(dialog, 3, true);
        this.init(dialog, pwsPassphrasePolicy, n);
    }

    public PolicyDialog(Frame frame, PwsPassphrasePolicy pwsPassphrasePolicy, int n) throws HeadlessException {
        super(frame, 3, true);
        this.init(frame, pwsPassphrasePolicy, n);
    }

    private void init(Component component, PwsPassphrasePolicy pwsPassphrasePolicy, int n) {
        String string = n == 1 ? "dlg.policy.local" : "dlg.policy.global";
        this.editedPolicy = (PwsPassphrasePolicy)pwsPassphrasePolicy.clone();
        this.setTitle(ResourceLoader.getDisplay(string));
        this.buildCentrePanel();
        this.buildButtonPanel();
        this.pack();
        Util.centreWithin(component, this);
    }

    public void dispose() {
        super.dispose();
        this.externalListener = null;
    }

    public void setButtonBarListener(ButtonBarListener buttonBarListener) {
        this.externalListener = buttonBarListener;
    }

    private void buildButtonPanel() {
        DefaultButtonBarListener defaultButtonBarListener = new DefaultButtonBarListener(){

            public boolean okButtonPerformed() {
                try {
                    PolicyDialog.this.dlgPanel.transferValues();
                }
                catch (NumberFormatException numberFormatException) {
                    GUIService.infoMessage(PolicyDialog.this, "dlg.badvalue", "msg.badpassinteger");
                    return false;
                }
                if (!PolicyDialog.this.editedPolicy.isValid()) {
                    GUIService.infoMessage(PolicyDialog.this, "dlg.operrejected", "msg.badpasspolicy");
                    return false;
                }
                if (PolicyDialog.this.externalListener != null) {
                    PolicyDialog.this.externalListener.okButtonPerformed();
                }
                PolicyDialog.this.dispose();
                return true;
            }

            public void cancelButtonPerformed() {
                if (PolicyDialog.this.externalListener != null) {
                    PolicyDialog.this.externalListener.cancelButtonPerformed();
                }
                PolicyDialog.this.dispose();
            }
        };
        super.setButtonBarListener(defaultButtonBarListener);
    }

    private void buildCentrePanel() {
        this.dlgPanel = new PolicyDialogPanel(this.editedPolicy);
        this.setDialogPanel(this.dlgPanel);
    }

    public PwsPassphrasePolicy getEditedPolicy() {
        return this.editedPolicy;
    }

    private class PolicyDialogPanel
    extends JPanel {
        private static final int ICONTEXTGAP = 12;
        private PwsPassphrasePolicy policy;
        private JTextField lengthFld;
        private JCheckBox lowerCaseChk;
        private JCheckBox upperCaseChk;
        private JCheckBox digitsChk;
        private JCheckBox symbolsChk;
        private JCheckBox easyReadChk;

        public PolicyDialogPanel(PwsPassphrasePolicy pwsPassphrasePolicy) {
            this.setLayout(new GridLayout(0, 1));
            this.setBorder(new EmptyBorder(16, 16, 8, 16));
            this.policy = pwsPassphrasePolicy;
            this.init();
        }

        private void init() {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            JLabel jLabel = new JLabel(ResourceLoader.getDisplay("chk.policy.lengthfield"));
            jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
            jLabel.setFont(DisplayManager.getFont("control"));
            jPanel.add(jLabel);
            this.lengthFld = new JTextField(2);
            this.lengthFld.setText(String.valueOf(this.policy.length));
            jPanel.add(this.lengthFld);
            this.add(jPanel);
            this.lowerCaseChk = new JCheckBox(ResourceLoader.getDisplay("chk.policy.lowercase"), this.policy.lowercaseChars);
            this.lowerCaseChk.setIconTextGap(12);
            this.upperCaseChk = new JCheckBox(ResourceLoader.getDisplay("chk.policy.uppercase"), this.policy.uppercaseChars);
            this.upperCaseChk.setIconTextGap(12);
            this.digitsChk = new JCheckBox(ResourceLoader.getDisplay("chk.policy.digits"), this.policy.digitChars);
            this.digitsChk.setIconTextGap(12);
            this.symbolsChk = new JCheckBox(ResourceLoader.getDisplay("chk.policy.symbols"), this.policy.symbolChars);
            this.symbolsChk.setIconTextGap(12);
            this.easyReadChk = new JCheckBox(ResourceLoader.getDisplay("chk.policy.easyread"), this.policy.easyview);
            this.easyReadChk.setIconTextGap(12);
            this.add(this.lowerCaseChk);
            this.add(this.upperCaseChk);
            this.add(this.digitsChk);
            this.add(this.symbolsChk);
            this.add(this.easyReadChk);
        }

        public void transferValues() throws NumberFormatException {
            int n;
            this.policy.length = n = Integer.parseInt(this.lengthFld.getText().trim());
            this.policy.lowercaseChars = this.lowerCaseChk.isSelected();
            this.policy.uppercaseChars = this.upperCaseChk.isSelected();
            this.policy.digitChars = this.digitsChk.isSelected();
            this.policy.symbolChars = this.symbolsChk.isSelected();
            this.policy.easyview = this.easyReadChk.isSelected();
        }
    }
}

