/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jpws.data.Options;
import org.jpws.front.ActionHandler;
import org.jpws.front.DisplayManager;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.MenuHandler;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.DefaultButtonBarListener;
import org.jpws.front.util.FontChooser;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.front.util.VerticalFlowLayout;

public class PreferencesDialog
extends ButtonBarDialog
implements Runnable {
    protected static final Border PANEL_BORDER = BorderFactory.createEmptyBorder(8, 8, 18, 8);
    protected static final int MAX_IDLE_MIN = 1440;
    protected static final int MAX_CLIPBOARD_SEC = 300;
    protected static final UIManager.LookAndFeelInfo[] LAFs = UIManager.getInstalledLookAndFeels();
    protected OptionPanel[] panelSet;
    protected OptionPanel activePanel;
    protected JTextField browserFld;
    protected Font textLabelFont;
    protected CardLayout cardLayout;
    protected JPanel dlgPanel;
    protected JList lister;
    protected X xListener;
    protected boolean okPressed;

    public PreferencesDialog(Dialog dialog, boolean bl) throws HeadlessException {
        super(dialog, 3, bl);
        this.init(dialog);
    }

    public PreferencesDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, 3, true);
        this.init(frame);
    }

    private void init(Component component) {
        this.xListener = new X();
        this.textLabelFont = DisplayManager.getFont("control");
        this.panelSet = new OptionPanel[6];
        this.panelSet[0] = new GeneralPanel();
        this.panelSet[1] = new SecurityPanel();
        this.panelSet[2] = new ReportsPanel();
        this.panelSet[3] = new ConfirmPanel();
        this.panelSet[4] = new DisplayPanel();
        this.panelSet[5] = new FontsPanel();
        String string = "dlg.preferences";
        this.setTitle(ResourceLoader.getDisplay(string));
        Global.mainFrame.addChildDialog(this);
        this.buildButtonPanel();
        this.buildTopPanel();
        this.buildCentrePanel();
        this.lister.setSelectedIndex(0);
    }

    public void dispose() {
        PwsFileContainer pwsFileContainer = Global.getSelectedFile();
        if (pwsFileContainer != null) {
            pwsFileContainer.digestOptions();
        }
        super.dispose();
        if (this.panelSet != null) {
            for (int i = 0; i < this.panelSet.length; ++i) {
                this.panelSet[i].destruct();
                this.panelSet[i] = null;
            }
        }
        this.panelSet = null;
        if (this.lister != null) {
            this.lister.removeListSelectionListener(this.xListener);
        }
        this.lister = null;
        this.xListener = null;
        this.activePanel = null;
        this.getContentPane().removeAll();
    }

    public void run() {
        this.show();
    }

    protected void runEndActivity(final OptionPanel optionPanel) {
        if (optionPanel != null) {
            Thread thread = ActionHandler.startTask(new Runnable(){

                public void run() {
                    optionPanel.endActivity();
                }
            });
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void buildButtonPanel() {
        DefaultButtonBarListener defaultButtonBarListener = new DefaultButtonBarListener(){

            public boolean okButtonPerformed() {
                if (PreferencesDialog.this.activePanel != null) {
                    if (!PreferencesDialog.this.activePanel.validated()) {
                        return false;
                    }
                    PreferencesDialog.this.runEndActivity(PreferencesDialog.this.activePanel);
                }
                PreferencesDialog.this.dispose();
                return true;
            }

            public void cancelButtonPerformed() {
                PreferencesDialog.this.runEndActivity(PreferencesDialog.this.activePanel);
                PreferencesDialog.this.dispose();
            }
        };
        this.setButtonBarListener(defaultButtonBarListener);
    }

    private void buildCentrePanel() {
        this.cardLayout = new CardLayout();
        this.dlgPanel = new JPanel(this.cardLayout);
        this.dlgPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4), BorderFactory.createEtchedBorder()));
        for (int i = 0; i < this.panelSet.length; ++i) {
            this.dlgPanel.add((Component)this.panelSet[i].getComponent(), String.valueOf(i));
        }
        this.lister = new JList<OptionPanel>(this.panelSet);
        this.lister.addListSelectionListener(this.xListener);
        this.lister.setCellRenderer(new ListCellView());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.lister, "Center");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0), BorderFactory.createEtchedBorder()));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)this.dlgPanel, "Center");
        this.setDialogPanel(jPanel2);
    }

    private void buildTopPanel() {
    }

    protected void errorMessage(String string) {
        GUIService.infoMessage(this, "dlg.badvalue", string);
    }

    protected JCheckBox makeCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(ResourceLoader.codeOrRealDisplay(string));
        jCheckBox.setIconTextGap(10);
        return jCheckBox;
    }

    protected JTextField makeNumField() {
        JTextField jTextField = new JTextField(3);
        jTextField.setHorizontalAlignment(4);
        jTextField.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        return jTextField;
    }

    protected int getFieldInt(JTextField jTextField) {
        int n = -1;
        try {
            n = Integer.parseInt(jTextField.getText());
        }
        catch (Exception exception) {
            this.errorMessage("prefmsg.numinputfault");
        }
        return n;
    }

    private class ReportsPanel
    implements OptionPanel {
        String title = ResourceLoader.getDisplay("prefpanel.reports");
        boolean validated;
        CheckListener itemListener;
        long oldExpireScope;
        JPanel container;
        JCheckBox reportExpiryChk;
        JCheckBox useMarkerBrowseChk;
        JCheckBox useMarkerOpenChk;
        JTextField aheadDaysFld;

        public ReportsPanel() {
            this.init();
        }

        private void init() {
            this.container = new JPanel(new BorderLayout());
            this.container.setBorder(PANEL_BORDER);
            this.itemListener = new CheckListener();
            Border border = BorderFactory.createEmptyBorder(0, 6, 0, 0);
            Font font = DisplayManager.getFont("control");
            VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(3);
            JPanel jPanel = new JPanel(verticalFlowLayout);
            jPanel.add(Box.createVerticalStrut(5));
            JLabel jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.expiry"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jPanel.add(jLabel);
            this.reportExpiryChk = PreferencesDialog.this.makeCheckBox("prefbox.reportexpiry");
            this.reportExpiryChk.addItemListener(this.itemListener);
            jPanel.add(this.reportExpiryChk);
            this.aheadDaysFld = PreferencesDialog.this.makeNumField();
            jLabel = new JLabel(ResourceLoader.getDisplay("preffield.lookahead"));
            jLabel.setBorder(border);
            jLabel.setFont(PreferencesDialog.this.textLabelFont);
            FlowLayout flowLayout = new FlowLayout(0, 0, 0);
            JPanel jPanel2 = new JPanel(flowLayout);
            jPanel2.add(this.aheadDaysFld);
            jPanel2.add(jLabel);
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(10));
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.indices"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jPanel.add(jLabel);
            flowLayout = new FlowLayout(0, 0, 0);
            jPanel2 = new JPanel(flowLayout);
            jLabel = new JLabel(ResourceLoader.getDisplay("preffield.usedentrymarkers"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            jPanel2.add(jLabel);
            this.useMarkerBrowseChk = PreferencesDialog.this.makeCheckBox("prefbox.usedonbrowseentry");
            jPanel2.add(this.useMarkerBrowseChk);
            this.useMarkerOpenChk = PreferencesDialog.this.makeCheckBox("prefbox.usedonopenentry");
            this.useMarkerOpenChk.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            jPanel2.add(this.useMarkerOpenChk);
            jPanel.add(jPanel2);
            this.container.add((Component)jPanel, "Center");
        }

        public void destruct() {
            this.reportExpiryChk.removeItemListener(this.itemListener);
            this.itemListener = null;
        }

        public String toString() {
            return this.title;
        }

        public JComponent getComponent() {
            return this.container;
        }

        public boolean validated() {
            int n = PreferencesDialog.this.getFieldInt(this.aheadDaysFld);
            if (n < 30) {
                PreferencesDialog.this.errorMessage("prefmsg.num.underflow");
                return false;
            }
            this.validated = true;
            return true;
        }

        public void startActivity() {
            this.validated = false;
            this.oldExpireScope = Options.getLongOption("expireScope");
            this.reportExpiryChk.setSelected(Options.isOptionSet("expiryCheck"));
            this.aheadDaysFld.setText(String.valueOf(this.oldExpireScope / 86400000L));
            this.useMarkerBrowseChk.setSelected(Options.isOptionSet("useEntryOnBrowse"));
            this.useMarkerOpenChk.setSelected(Options.isOptionSet("useEntryOnOpen"));
        }

        public void endActivity() {
            if (!this.validated) {
                return;
            }
            PwsFileContainer pwsFileContainer = Global.getSelectedFile();
            Options.setOption("expiryCheck", this.reportExpiryChk.isSelected());
            Options.setOption("useEntryOnBrowse", this.useMarkerBrowseChk.isSelected());
            Options.setOption("useEntryOnOpen", this.useMarkerOpenChk.isSelected());
            long l = (long)PreferencesDialog.this.getFieldInt(this.aheadDaysFld) * 86400000L;
            if (this.oldExpireScope != l) {
                Options.setLongOption("expireScope", l);
                if (pwsFileContainer != null) {
                    pwsFileContainer.setExpireScope(l);
                }
            }
        }

        private class CheckListener
        implements ItemListener {
            private CheckListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (itemEvent.getItem() == ReportsPanel.this.reportExpiryChk) {
                    ReportsPanel.this.aheadDaysFld.setEnabled(bl);
                    ReportsPanel.this.aheadDaysFld.setBackground(bl ? Color.white : Color.lightGray);
                }
            }
        }
    }

    private class FontsPanel
    implements OptionPanel,
    ActionListener {
        private JPanel container;
        private String title = ResourceLoader.getDisplay("prefpanel.fonts");
        private boolean validated;
        private JPanel bigPanel;
        private HashMap labelMap;
        private HashMap fontMap;
        private HashMap fontInitMap;

        public FontsPanel() {
            this.init();
        }

        private void init() {
            this.container = new JPanel(new BorderLayout());
            this.container.setBorder(PANEL_BORDER);
            this.labelMap = new HashMap();
            this.fontMap = new HashMap();
            String string = "Lorem ipsum Dolor sit Amet, Consectetur adipisicing Elit";
            this.labelMap.put("menu", new JLabel(string));
            this.labelMap.put("notes", new JLabel(string));
            this.labelMap.put("password", new JLabel(string));
            this.labelMap.put("data", new JLabel(string));
            this.labelMap.put("display", new JLabel(string));
            this.labelMap.put("control", new JLabel(string));
            this.labelMap.put("tooltip", new JLabel(string));
            this.bigPanel = new JPanel(new VerticalFlowLayout(5));
            this.bigPanel.add(this.getFontPanel("menu"));
            this.bigPanel.add(this.getFontPanel("tooltip"));
            this.bigPanel.add(this.getFontPanel("control"));
            this.bigPanel.add(this.getFontPanel("display"));
            this.bigPanel.add(this.getFontPanel("data"));
            this.bigPanel.add(this.getFontPanel("notes"));
            this.bigPanel.add(this.getFontPanel("password"));
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ResourceLoader.getDisplay("fontpanel.reset"));
            jButton.setBackground(new Color(16773077));
            jButton.setActionCommand("resetfonts");
            jButton.addActionListener(this);
            jButton.setToolTipText(ResourceLoader.getCommand("tooltip.prefs.font.reset"));
            jPanel.add(jButton);
            this.bigPanel.add(jPanel);
            this.container.add((Component)this.bigPanel, "Center");
        }

        private JPanel getFontPanel(String string) {
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton();
            Insets insets = jButton.getMargin();
            insets.left = 5;
            insets.right = 5;
            jButton.setText(ResourceLoader.getDisplay("fontname." + string));
            jButton.setToolTipText(ResourceLoader.getCommand("tooltip.prefs.font." + string));
            jButton.setMargin(insets);
            jButton.setActionCommand("performfont." + string);
            jButton.addActionListener(this);
            jButton.setPreferredSize(new Dimension(100, 26));
            jButton.setFocusPainted(false);
            jPanel.add(jButton);
            jPanel.add((JLabel)this.labelMap.get(string));
            return jPanel;
        }

        public void destruct() {
            this.bigPanel.removeAll();
        }

        public String toString() {
            return this.title;
        }

        public JComponent getComponent() {
            return this.container;
        }

        public boolean validated() {
            this.validated = true;
            return this.validated;
        }

        private void updatePanel() {
            this.updateFontPanel("menu");
            this.updateFontPanel("data");
            this.updateFontPanel("password");
            this.updateFontPanel("display");
            this.updateFontPanel("control");
            this.updateFontPanel("tooltip");
            this.updateFontPanel("notes");
        }

        private void updateFontPanel(String string) {
            Font font = (Font)this.fontMap.get(string);
            JLabel jLabel = (JLabel)this.labelMap.get(string);
            jLabel.setFont(font);
            jLabel.setToolTipText(DisplayManager.fontCode(font));
        }

        public void startActivity() {
            this.validated = false;
            this.fontMap.put("menu", DisplayManager.getFont("menu"));
            this.fontMap.put("data", DisplayManager.getFont("data"));
            this.fontMap.put("notes", DisplayManager.getFont("notes"));
            this.fontMap.put("password", DisplayManager.getFont("password"));
            this.fontMap.put("display", DisplayManager.getFont("display"));
            this.fontMap.put("control", DisplayManager.getFont("control"));
            this.fontMap.put("tooltip", DisplayManager.getFont("tooltip"));
            this.fontInitMap = (HashMap)this.fontMap.clone();
            this.updatePanel();
        }

        public void endActivity() {
            if (!this.validated) {
                return;
            }
            this.storeFont("menu");
            this.storeFont("data");
            this.storeFont("password");
            this.storeFont("notes");
            this.storeFont("display");
            this.storeFont("control");
            this.storeFont("tooltip");
        }

        private void storeFont(String string) {
            Font font;
            if (string == null) {
                return;
            }
            Font font2 = (Font)this.fontMap.get(string);
            if (!font2.equals(font = (Font)this.fontInitMap.get(string))) {
                DisplayManager.storeFont(string, font2);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("performfont.")) {
                String string2 = string.substring(12);
                String string3 = ResourceLoader.getDisplay("dlg.pref.choosefont");
                Font font = FontChooser.showDialog(Global.mainFrame, PreferencesDialog.this, string3 = Util.substituteText(string3, "$name", ResourceLoader.getDisplay("fontname." + string2)), (Font)this.fontMap.get(string2));
                if (font != null) {
                    this.fontMap.put(string2, font);
                    DisplayManager.setFont(string2, font);
                    this.updateFontPanel(string2);
                }
            } else if (string.startsWith("resetfonts")) {
                this.resetFont("menu");
                this.resetFont("data");
                this.resetFont("password");
                this.resetFont("notes");
                this.resetFont("display");
                this.resetFont("control");
                this.resetFont("tooltip");
            }
        }

        private void resetFont(String string) {
            Font font = DisplayManager.getDefaultFont(string);
            this.fontMap.put(string, font);
            DisplayManager.setFont(string, font);
            this.updateFontPanel(string);
        }
    }

    private class DisplayPanel
    implements OptionPanel {
        private String title = ResourceLoader.getDisplay("prefpanel.display");
        private boolean validated;
        private JPanel container;
        private JCheckBox usernameChk;
        private JCheckBox colorUseChk;
        private JCheckBox expandTreeChk;
        private JRadioButton treeViewRadio;
        private JRadioButton tableViewRadio;
        private JCheckBox fullNotesChk;
        private JCheckBox lineWrapChk;
        private JCheckBox activeHistoryChk;
        private JCheckBox logicalNamesChk;

        public DisplayPanel() {
            this.init();
        }

        private void init() {
            this.container = new JPanel(new BorderLayout());
            this.container.setBorder(PANEL_BORDER);
            Border border = BorderFactory.createEmptyBorder(0, 6, 0, 0);
            VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(3);
            JPanel jPanel = new JPanel(verticalFlowLayout);
            jPanel.add(Box.createVerticalStrut(5));
            JLabel jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.listscreen"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jPanel.add(jLabel);
            FlowLayout flowLayout = new FlowLayout(0, 0, 0);
            JPanel jPanel2 = new JPanel(flowLayout);
            jLabel = new JLabel(ResourceLoader.getDisplay("preffield.standardview"));
            jLabel.setFont(PreferencesDialog.this.textLabelFont);
            jPanel2.add(jLabel);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.treeViewRadio = new JRadioButton(ResourceLoader.getCommand("menu.view.tree"));
            buttonGroup.add(this.treeViewRadio);
            jPanel2.add(this.treeViewRadio);
            this.tableViewRadio = new JRadioButton(ResourceLoader.getCommand("menu.view.list"));
            buttonGroup.add(this.tableViewRadio);
            jPanel2.add(this.tableViewRadio);
            jPanel.add(jPanel2);
            this.usernameChk = PreferencesDialog.this.makeCheckBox("prefbox.username");
            jPanel.add(this.usernameChk);
            this.expandTreeChk = PreferencesDialog.this.makeCheckBox("prefbox.expandtree");
            jPanel.add(this.expandTreeChk);
            this.colorUseChk = PreferencesDialog.this.makeCheckBox("prefbox.uselistcolors");
            jPanel.add(this.colorUseChk);
            jPanel.add(Box.createVerticalStrut(5));
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.editor"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jPanel.add(jLabel);
            this.fullNotesChk = PreferencesDialog.this.makeCheckBox("prefbox.fullnotes");
            jPanel.add(this.fullNotesChk);
            this.lineWrapChk = PreferencesDialog.this.makeCheckBox("prefbox.linewrapping");
            jPanel.add(this.lineWrapChk);
            this.activeHistoryChk = PreferencesDialog.this.makeCheckBox("prefbox.activehistory");
            jPanel.add(this.activeHistoryChk);
            jPanel.add(Box.createVerticalStrut(5));
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.others"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jPanel.add(jLabel);
            this.logicalNamesChk = PreferencesDialog.this.makeCheckBox("prefbox.logicalnames");
            jPanel.add(this.logicalNamesChk);
            this.container.add((Component)jPanel, "Center");
        }

        public void destruct() {
        }

        public String toString() {
            return this.title;
        }

        public JComponent getComponent() {
            return this.container;
        }

        public boolean validated() {
            this.validated = true;
            return this.validated;
        }

        public void startActivity() {
            this.validated = false;
            this.usernameChk.setSelected(Options.isOptionSet("treeUsername"));
            this.colorUseChk.setSelected(Options.isOptionSet("useTableColors"));
            this.expandTreeChk.setSelected(Options.isOptionSet("autoExpandTree"));
            this.fullNotesChk.setSelected(Options.isOptionSet("editFullNotes"));
            this.lineWrapChk.setSelected(Options.isOptionSet("editLineWrap"));
            this.activeHistoryChk.setSelected(Options.isOptionSet("editActiveHistory"));
            this.logicalNamesChk.setSelected(Options.isOptionSet("logicalFilenames"));
            if (Options.getOption("defaultViewType").equals("table")) {
                this.tableViewRadio.setSelected(true);
            } else {
                this.treeViewRadio.setSelected(true);
            }
        }

        public void endActivity() {
            if (!this.validated) {
                return;
            }
            PwsFileContainer pwsFileContainer = Global.getSelectedFile();
            Options.setOption("treeUsername", this.usernameChk.isSelected());
            Options.setOption("useTableColors", this.colorUseChk.isSelected());
            Options.setOption("autoExpandTree", this.expandTreeChk.isSelected());
            Options.setOption("editFullNotes", this.fullNotesChk.isSelected());
            Options.setOption("editLineWrap", this.lineWrapChk.isSelected());
            Options.setOption("editActiveHistory", this.activeHistoryChk.isSelected());
            Options.setOption("logicalFilenames", this.logicalNamesChk.isSelected());
            Options.setOption("defaultViewType", this.tableViewRadio.isSelected() ? "table" : "tree");
            org.jpws.pwslib.global.Global.setDisplayUsernames(this.usernameChk.isSelected());
            if (pwsFileContainer != null) {
                Global.mainFrame.setTitleFile(pwsFileContainer);
                pwsFileContainer.getViewHandler().repaint();
            }
        }
    }

    private class SecurityPanel
    implements OptionPanel {
        String title = ResourceLoader.getDisplay("prefpanel.security");
        boolean validated;
        CheckListener itemListener;
        JPanel container;
        JCheckBox lockIdleChk;
        JCheckBox lockMinimizeChk;
        JCheckBox autoClearChk;
        JCheckBox autoBackupChk;
        JCheckBox passCheckChk;
        JCheckBox openPassChk;
        JTextField idleTimeFld;
        JTextField clipTimeFld;
        JSpinner autoSaveSpin;
        SpinnerNumberModel autoSaveModel;

        public SecurityPanel() {
            this.init();
        }

        private void init() {
            this.container = new JPanel(new BorderLayout());
            this.container.setBorder(PANEL_BORDER);
            this.itemListener = new CheckListener();
            Border border = BorderFactory.createEmptyBorder(0, 6, 0, 0);
            Font font = DisplayManager.getFont("control");
            VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(3);
            JPanel jPanel = new JPanel(verticalFlowLayout);
            jPanel.add(Box.createVerticalStrut(5));
            JLabel jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.security"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 8, 0));
            jPanel.add(jLabel);
            this.lockIdleChk = PreferencesDialog.this.makeCheckBox("prefbox.lockonidle");
            this.lockIdleChk.addItemListener(this.itemListener);
            this.idleTimeFld = PreferencesDialog.this.makeNumField();
            jLabel = new JLabel(ResourceLoader.getDisplay("units.min"));
            jLabel.setBorder(border);
            jLabel.setFont(font);
            FlowLayout flowLayout = new FlowLayout(0, 0, 0);
            JPanel jPanel2 = new JPanel(flowLayout);
            jPanel2.add(this.lockIdleChk);
            jPanel2.add(this.idleTimeFld);
            jPanel2.add(jLabel);
            jPanel.add(jPanel2);
            this.lockMinimizeChk = PreferencesDialog.this.makeCheckBox("prefbox.lockonminimize");
            jPanel.add(this.lockMinimizeChk);
            this.autoClearChk = PreferencesDialog.this.makeCheckBox("prefbox.autoclearclip");
            this.autoClearChk.addItemListener(this.itemListener);
            this.clipTimeFld = PreferencesDialog.this.makeNumField();
            jLabel = new JLabel(ResourceLoader.getDisplay("units.sec"));
            jLabel.setBorder(border);
            jLabel.setFont(font);
            flowLayout = new FlowLayout(0, 0, 0);
            jPanel2 = new JPanel(flowLayout);
            jPanel2.add(this.autoClearChk);
            jPanel2.add(this.clipTimeFld);
            jPanel2.add(jLabel);
            jPanel.add(jPanel2);
            int n = Options.getIntOption("autoBackupFiles");
            if (n < 1 | n > 99) {
                n = 3;
            }
            this.autoSaveModel = new SpinnerNumberModel(n, 1, 99, 1);
            this.autoSaveSpin = new JSpinner(this.autoSaveModel);
            jLabel = new JLabel(ResourceLoader.getDisplay("units.copies"));
            jLabel.setBorder(border);
            jLabel.setFont(font);
            flowLayout = new FlowLayout(0, 0, 0);
            jPanel2 = new JPanel(flowLayout);
            this.autoBackupChk = PreferencesDialog.this.makeCheckBox("prefbox.autobackup");
            this.autoBackupChk.addItemListener(this.itemListener);
            jPanel2.add(this.autoBackupChk);
            jPanel2.add(this.autoSaveSpin);
            jPanel2.add(jLabel);
            jPanel.add(jPanel2);
            this.passCheckChk = PreferencesDialog.this.makeCheckBox("prefbox.passcheckcopy");
            jPanel.add(this.passCheckChk);
            this.openPassChk = PreferencesDialog.this.makeCheckBox("prefbox.openpassword");
            jPanel.add(this.openPassChk);
            this.container.add((Component)jPanel, "Center");
        }

        public void destruct() {
            this.lockIdleChk.removeItemListener(this.itemListener);
            this.autoClearChk.removeItemListener(this.itemListener);
            this.autoBackupChk.removeItemListener(this.itemListener);
            this.itemListener = null;
        }

        public String toString() {
            return this.title;
        }

        public JComponent getComponent() {
            return this.container;
        }

        public boolean validated() {
            int n;
            int n2 = PreferencesDialog.this.getFieldInt(this.idleTimeFld);
            if (n2 < 1 | n2 > 1440 | (n = PreferencesDialog.this.getFieldInt(this.clipTimeFld)) < 1 | n > 300) {
                PreferencesDialog.this.errorMessage("prefmsg.timefield");
                return false;
            }
            this.validated = true;
            return this.validated;
        }

        public void startActivity() {
            this.validated = false;
            this.lockIdleChk.setSelected(Options.isOptionSet("lockIdleState"));
            this.lockMinimizeChk.setSelected(Options.isOptionSet("lockMinimize"));
            this.autoClearChk.setSelected(Options.isOptionSet("clearClipboard"));
            this.autoBackupChk.setSelected(Options.isOptionSet("autoBackup"));
            this.passCheckChk.setSelected(Options.isOptionSet("createFileCheck"));
            this.openPassChk.setSelected(Options.isOptionSet("openPassEdit"));
            this.idleTimeFld.setText(String.valueOf(Options.getIntOption("maxIdleTime") / 60000));
            this.idleTimeFld.setEnabled(this.lockIdleChk.isSelected());
            if (!this.lockIdleChk.isSelected()) {
                this.idleTimeFld.setBackground(Color.lightGray);
            }
            this.clipTimeFld.setText(String.valueOf(Options.getIntOption("clipboardTime") / 1000));
            this.clipTimeFld.setEnabled(this.autoClearChk.isSelected());
            if (!this.autoClearChk.isSelected()) {
                this.clipTimeFld.setBackground(Color.lightGray);
            }
            this.autoSaveModel.setValue(new Integer(Options.getIntOption("autoBackupFiles")));
        }

        public void endActivity() {
            if (!this.validated) {
                return;
            }
            Options.setOption("lockIdleState", this.lockIdleChk.isSelected());
            Options.setOption("lockMinimize", this.lockMinimizeChk.isSelected());
            Options.setOption("clearClipboard", this.autoClearChk.isSelected());
            Options.setOption("autoBackup", this.autoBackupChk.isSelected());
            Options.setOption("createFileCheck", this.passCheckChk.isSelected());
            Options.setOption("openPassEdit", this.openPassChk.isSelected());
            int n = PreferencesDialog.this.getFieldInt(this.idleTimeFld) * 60000;
            Options.setIntOption("maxIdleTime", n);
            Global.setMaxIdleTime(n);
            n = PreferencesDialog.this.getFieldInt(this.clipTimeFld) * 1000;
            Options.setIntOption("clipboardTime", n);
            Options.setIntOption("autoBackupFiles", (Integer)this.autoSaveModel.getValue());
            Global.setMaxClipboardTime(n);
        }

        private class CheckListener
        implements ItemListener {
            private CheckListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (itemEvent.getItem() == SecurityPanel.this.lockIdleChk) {
                    SecurityPanel.this.idleTimeFld.setEnabled(bl);
                    SecurityPanel.this.idleTimeFld.setBackground(bl ? Color.white : Color.lightGray);
                } else if (itemEvent.getItem() == SecurityPanel.this.autoClearChk) {
                    SecurityPanel.this.clipTimeFld.setEnabled(bl);
                    SecurityPanel.this.clipTimeFld.setBackground(bl ? Color.white : Color.lightGray);
                } else if (itemEvent.getItem() == SecurityPanel.this.autoBackupChk) {
                    SecurityPanel.this.autoSaveSpin.setEnabled(bl);
                    SecurityPanel.this.autoSaveSpin.setBackground(bl ? Color.white : Color.lightGray);
                }
            }
        }
    }

    private class ConfirmPanel
    implements OptionPanel {
        private String title = ResourceLoader.getDisplay("prefpanel.confirm");
        private boolean validated;
        private JPanel container;
        private JCheckBox deleteChk;
        private JCheckBox updateChk;
        private JCheckBox cancelChk;
        private JCheckBox copyClipChk;
        private JCheckBox saveFileChk;
        private JCheckBox backupChk;
        private JCheckBox revertChk;

        public ConfirmPanel() {
            this.init();
        }

        private void init() {
            this.container = new JPanel(new BorderLayout());
            this.container.setBorder(PANEL_BORDER);
            Border border = BorderFactory.createEmptyBorder(0, 3, 0, 0);
            Box box = Box.createVerticalBox();
            box.setBorder(border);
            box.add(Box.createVerticalStrut(5));
            JLabel jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.askconfirm"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 8, 0));
            box.add(jLabel);
            this.deleteChk = PreferencesDialog.this.makeCheckBox("prefbox.delentries");
            box.add(this.deleteChk);
            this.updateChk = PreferencesDialog.this.makeCheckBox("prefbox.updatepass");
            box.add(this.updateChk);
            this.cancelChk = PreferencesDialog.this.makeCheckBox("prefbox.cancelrec");
            box.add(this.cancelChk);
            this.container.add((Component)box, "North");
            box = Box.createVerticalBox();
            box.setBorder(border);
            box.add(Box.createVerticalStrut(25));
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.reportconfirm"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 8, 0));
            box.add(jLabel);
            this.copyClipChk = PreferencesDialog.this.makeCheckBox("prefbox.copyclip");
            box.add(this.copyClipChk);
            this.saveFileChk = PreferencesDialog.this.makeCheckBox("prefbox.savefile");
            box.add(this.saveFileChk);
            this.backupChk = PreferencesDialog.this.makeCheckBox("prefbox.backup");
            box.add(this.backupChk);
            this.revertChk = PreferencesDialog.this.makeCheckBox("prefbox.revert");
            box.add(this.revertChk);
            this.container.add((Component)box, "Center");
        }

        public void destruct() {
        }

        public String toString() {
            return this.title;
        }

        public JComponent getComponent() {
            return this.container;
        }

        public boolean validated() {
            this.validated = true;
            return this.validated;
        }

        public void startActivity() {
            this.validated = false;
            this.deleteChk.setSelected(Options.isOptionSet("confirmDeleteRecord"));
            this.updateChk.setSelected(Options.isOptionSet("confirmUpdatePass"));
            this.cancelChk.setSelected(Options.isOptionSet("confirmCancelRecord"));
            this.copyClipChk.setSelected(Options.isOptionSet("confirmCopyClipboard"));
            this.saveFileChk.setSelected(Options.isOptionSet("confirmSave"));
            this.backupChk.setSelected(Options.isOptionSet("confirmBackup"));
            this.revertChk.setSelected(Options.isOptionSet("confirmRevert"));
        }

        public void endActivity() {
            if (!this.validated) {
                return;
            }
            Options.setOption("confirmDeleteRecord", this.deleteChk.isSelected());
            Options.setOption("confirmUpdatePass", this.updateChk.isSelected());
            Options.setOption("confirmCancelRecord", this.cancelChk.isSelected());
            Options.setOption("confirmCopyClipboard", this.copyClipChk.isSelected());
            Options.setOption("confirmSave", this.saveFileChk.isSelected());
            Options.setOption("confirmBackup", this.backupChk.isSelected());
            Options.setOption("confirmRevert", this.revertChk.isSelected());
        }
    }

    private class GeneralPanel
    implements OptionPanel {
        private String title = ResourceLoader.getDisplay("prefpanel.general");
        private String browserStartVal;
        private boolean validated;
        private int initLAF;
        private int initLocale;
        private JButton browserButton;
        private JPanel container;
        private JComboBox localeCbo;
        private JComboBox lookAndFeelCbo;
        private JComboBox undoEntriesCbo;
        private JCheckBox reopenChk;
        private JCheckBox useRecentChk;
        private JCheckBox useUndoRedoChk;
        private JCheckBox autoFlushChk;
        private JCheckBox remScreenChk;
        private JCheckBox autoNewsChk;
        private JCheckBox storeMinorsChk;

        public GeneralPanel() {
            this.init();
        }

        private void init() {
            this.container = new JPanel(new BorderLayout());
            this.container.setBorder(PANEL_BORDER);
            FlowLayout flowLayout = new FlowLayout(0);
            JPanel jPanel = new JPanel(flowLayout);
            JLabel jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.browser"));
            jPanel.add(jLabel);
            PreferencesDialog.this.browserFld = new JTextField(25);
            jPanel.add(PreferencesDialog.this.browserFld);
            this.browserButton = new JButton(ResourceLoader.getDisplay("button.browse"));
            this.browserButton.setActionCommand("dialog.browseroption");
            this.browserButton.addActionListener(PreferencesDialog.this.xListener);
            jPanel.add(this.browserButton);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            this.container.add((Component)jPanel2, "North");
            flowLayout = new FlowLayout(0);
            jPanel = new JPanel(flowLayout);
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.locale"));
            jPanel.add(jLabel);
            this.localeCbo = new JComboBox();
            this.localeCbo.addItem(ResourceLoader.getDisplay("locale.en"));
            this.localeCbo.addItem(ResourceLoader.getDisplay("locale.de"));
            jPanel.add(this.localeCbo);
            jPanel2.add((Component)jPanel, "South");
            jPanel.add(Box.createHorizontalStrut(20));
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.lookandfeel"));
            jPanel.add(jLabel);
            this.lookAndFeelCbo = new JComboBox();
            for (int i = 0; i < LAFs.length; ++i) {
                this.lookAndFeelCbo.addItem(LAFs[i].getName());
            }
            jPanel.add(this.lookAndFeelCbo);
            VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(3);
            JPanel jPanel3 = new JPanel(verticalFlowLayout);
            jPanel3.add(Box.createVerticalStrut(25));
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.gui"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 8, 0));
            jPanel3.add(jLabel);
            this.autoFlushChk = PreferencesDialog.this.makeCheckBox("prefbox.autoflush");
            jPanel3.add(this.autoFlushChk);
            this.useRecentChk = PreferencesDialog.this.makeCheckBox("prefbox.userecent");
            jPanel3.add(this.useRecentChk);
            this.reopenChk = PreferencesDialog.this.makeCheckBox("prefbox.reopen");
            jPanel3.add(this.reopenChk);
            flowLayout = new FlowLayout(0, 0, 0);
            jPanel = new JPanel(flowLayout);
            this.useUndoRedoChk = PreferencesDialog.this.makeCheckBox("prefbox.useundoredo");
            jPanel.add(this.useUndoRedoChk);
            jPanel.add(Box.createHorizontalStrut(3));
            this.undoEntriesCbo = new JComboBox();
            this.undoEntriesCbo.addItem(ResourceLoader.getDisplay("value.dec.10"));
            this.undoEntriesCbo.addItem(ResourceLoader.getDisplay("value.dec.25"));
            this.undoEntriesCbo.addItem(ResourceLoader.getDisplay("value.dec.50"));
            jPanel.add(this.undoEntriesCbo);
            jPanel.add(Box.createHorizontalStrut(5));
            jLabel = new JLabel(ResourceLoader.getDisplay("preflabel.operations"));
            jLabel.setFont(DisplayManager.getFont("control"));
            jPanel.add(jLabel);
            jPanel3.add(jPanel);
            this.storeMinorsChk = PreferencesDialog.this.makeCheckBox("prefbox.storeminordata");
            jPanel3.add(this.storeMinorsChk);
            this.autoNewsChk = PreferencesDialog.this.makeCheckBox("prefbox.autonewscheck");
            jPanel3.add(this.autoNewsChk);
            this.remScreenChk = PreferencesDialog.this.makeCheckBox("prefbox.remscreen");
            jPanel3.add(this.remScreenChk);
            this.container.add((Component)jPanel3, "Center");
        }

        public void destruct() {
            this.browserButton.removeActionListener(PreferencesDialog.this.xListener);
        }

        public String toString() {
            return this.title;
        }

        public JComponent getComponent() {
            return this.container;
        }

        public boolean validated() {
            if (this.localeCbo.getSelectedIndex() != this.initLocale || this.lookAndFeelCbo.getSelectedIndex() != this.initLAF) {
                GUIService.infoMessage(PreferencesDialog.this, null, ResourceLoader.getDisplay("prefmsg.reloadprogram"));
            }
            this.validated = true;
            return this.validated;
        }

        public void startActivity() {
            this.validated = false;
            this.browserStartVal = Options.getOption("browserApplication");
            PreferencesDialog.this.browserFld.setText(this.browserStartVal);
            String string = Options.getOption("locale");
            int n = string.equals("de") ? 1 : (string.equals("fr") ? 2 : (string.equals("ru") ? 3 : 0));
            this.localeCbo.setSelectedIndex(n);
            this.initLocale = this.localeCbo.getSelectedIndex();
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            String string2 = string = lookAndFeel == null ? Options.getOption("lookAndFeel") : lookAndFeel.getClass().getName();
            if (string.length() != 0) {
                for (n = 0; n < LAFs.length; ++n) {
                    if (!LAFs[n].getClassName().equals(string)) continue;
                    this.lookAndFeelCbo.setSelectedIndex(n);
                }
            }
            this.initLAF = this.lookAndFeelCbo.getSelectedIndex();
            this.autoFlushChk.setSelected(Options.isOptionSet("autoflush"));
            this.reopenChk.setSelected(Options.isOptionSet("reopenFile"));
            this.useRecentChk.setSelected(Options.isOptionSet("useRecentList"));
            this.useUndoRedoChk.setSelected(Options.isOptionSet("useUndoRedo"));
            this.remScreenChk.setSelected(Options.isOptionSet("rememberScreen"));
            this.autoNewsChk.setSelected(Options.isOptionSet("checkProjectNews"));
            this.storeMinorsChk.setSelected(Options.isOptionSet("storeMinorChanges"));
            int n2 = 0;
            n = Options.getIntOption("maxUndoEntries");
            if (n == 25) {
                n2 = 1;
            } else if (n == 50) {
                n2 = 2;
            }
            this.undoEntriesCbo.setSelectedIndex(n2);
        }

        public void endActivity() {
            int n;
            if (!this.validated) {
                return;
            }
            String string = PreferencesDialog.this.browserFld.getText();
            if (!this.browserStartVal.equals(string)) {
                Options.setOption("browserApplication", this.browserStartVal);
                Options.setOption("browserApplication", string);
            }
            if ((n = this.localeCbo.getSelectedIndex()) != this.initLocale) {
                switch (n) {
                    case 1: {
                        string = "de";
                        break;
                    }
                    case 2: {
                        string = "fr";
                        break;
                    }
                    case 3: {
                        string = "ru";
                        break;
                    }
                    default: {
                        string = "en";
                    }
                }
                Options.setOption("locale", string);
            }
            if ((n = this.lookAndFeelCbo.getSelectedIndex()) > -1 && this.initLAF != n) {
                string = LAFs[n].getClassName();
                Options.setOption("lookAndFeel", string);
            }
            Options.setOption("autoflush", this.autoFlushChk.isSelected());
            Options.setOption("reopenFile", this.reopenChk.isSelected());
            Options.setOption("useRecentList", this.useRecentChk.isSelected());
            Options.setOption("useUndoRedo", this.useUndoRedoChk.isSelected());
            Options.setOption("rememberScreen", this.remScreenChk.isSelected());
            Options.setOption("checkProjectNews", this.autoNewsChk.isSelected());
            Options.setOption("storeMinorChanges", this.storeMinorsChk.isSelected());
            org.jpws.pwslib.global.Global.setDisplayUsernames(Options.isOptionSet("treeUsername"));
            MenuHandler.setRecentMenuVisible(this.useRecentChk.isSelected());
            MenuHandler.setEntryListsVisible(this.storeMinorsChk.isSelected());
            if (!this.useUndoRedoChk.isSelected()) {
                Global.undoManager.clear();
            } else {
                n = this.undoEntriesCbo.getSelectedIndex();
                int n2 = n == 0 ? 10 : (n == 1 ? 25 : 50);
                Options.setOption("maxUndoEntries", String.valueOf(n2));
                Global.undoManager.setLimit(n2);
            }
        }
    }

    private static class ListCellView
    implements ListCellRenderer {
        private static JLabel label;

        public ListCellView() {
            label = new JLabel();
            Font font = label.getFont();
            label.setFont(font.deriveFont(font.getSize2D() + 1.0f));
            label.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 8));
            label.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            label.setText(object.toString());
            if (bl) {
                label.setBackground(jList.getSelectionBackground());
                label.setForeground(jList.getSelectionForeground());
            } else {
                label.setBackground(jList.getBackground());
                label.setForeground(jList.getForeground());
            }
            label.setEnabled(jList.isEnabled());
            return label;
        }
    }

    private class X
    implements ListSelectionListener,
    ActionListener {
        private X() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            OptionPanel optionPanel;
            int n = PreferencesDialog.this.lister.getSelectedIndex();
            if (n > -1 & n < PreferencesDialog.this.panelSet.length && PreferencesDialog.this.activePanel != (optionPanel = PreferencesDialog.this.panelSet[n])) {
                if (PreferencesDialog.this.activePanel != null) {
                    if (!PreferencesDialog.this.activePanel.validated()) {
                        return;
                    }
                    PreferencesDialog.this.runEndActivity(PreferencesDialog.this.activePanel);
                }
                PreferencesDialog.this.cardLayout.show(PreferencesDialog.this.dlgPanel, String.valueOf(n));
                PreferencesDialog.this.activePanel = optionPanel;
                PreferencesDialog.this.activePanel.startActivity();
                ActionHandler.resetIdleTime();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("dialog.browseroption")) {
                GUIService.editBrowserOption();
                PreferencesDialog.this.browserFld.setText(Options.getOption("browserApplication"));
            }
        }
    }

    public static interface OptionPanel {
        public String toString();

        public JComponent getComponent();

        public void startActivity();

        public void endActivity();

        public boolean validated();

        public void destruct();
    }
}

