/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.jpws.data.Options;
import org.jpws.data.PersistentOptions;
import org.jpws.data.PwsFileSocket;
import org.jpws.front.ActionHandler;
import org.jpws.front.AddDialog;
import org.jpws.front.ContainerView;
import org.jpws.front.ExportCSVDialog;
import org.jpws.front.FileInfoDialog;
import org.jpws.front.FileOpenDialog;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.ImportCSVDialog;
import org.jpws.front.MenuHandler;
import org.jpws.front.Service;
import org.jpws.front.TableHandler;
import org.jpws.front.TreeHandler;
import org.jpws.front.UndoManager;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.DefaultButtonBarListener;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.front.util.VerticalFlowLayout;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsFileEvent;
import org.jpws.pwslib.data.PwsFileListener;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.data.PwsRecordList;
import org.jpws.pwslib.exception.DuplicateEntryException;
import org.jpws.pwslib.exception.NoSuchRecordException;
import org.jpws.pwslib.exception.PasswordSafeException;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.persist.ApplicationAdapter;

public class PwsFileContainer
extends PwsFileSocket
implements ActionListener {
    public static final int OPERATION_MODE = 1;
    public static final int SELECTION_STATUS = 2;
    public static final int DISPLAY_MODE = 3;
    public static final int MODIFY_STATUS = 4;
    public static final int FILTER_MODE = 5;
    public static final int MODIFY_EVENT = 6;
    public static final int TABLE_VIEW = 2;
    public static final int TREE_VIEW = 1;
    public static final int NO_VIEW = 0;
    public static final int NOTHING_SELECTED = 0;
    public static final int GROUP_SELECTED = 1;
    public static final int RECORD_SELECTED = 2;
    public static final int UNMOUNTED = 0;
    public static final int MOUNTED_PASSIVE = 1;
    public static final int MOUNTED_ACTIVE = 2;
    private static final int OP_SAVE = 1;
    private static final int OP_BACKUP = 2;
    private static final int OP_RESTORE = 3;
    private static final int OP_SAVEAS = 4;
    private static final int OP_SAVECOPY = 5;
    private static final int OP_REVERT = 6;
    private static final int OP_CONVERT = 7;
    private JPanel view;
    private JScrollPane scrollPane;
    private JLabel filterBar;
    private JPanel filterPanel;
    private int viewType;
    private int operationMode;
    private boolean isIOProgress;
    private AddDialog editDialog;
    FileInfoDialog fileInfoDlg;
    private int reportedViewType;
    private TreeHandler treeHandler;
    private TableHandler tableHandler;
    private ContainerView viewHandler;
    private FileListener fileListener;
    private RecentEntryList lastEditedEntries;
    private RecentEntryList lastUsedEntries;
    private ArrayList editListeners = new ArrayList();
    private byte[] random = new byte[0];
    private static final int SAVE_FILE = 0;
    private static final int SAVE_AS = 1;
    private static final int SAVE_COPY = 2;
    private static final int SAVE_BACKUP = 3;

    public PwsFileContainer(PwsFile pwsFile) {
        super(pwsFile);
        this.init();
    }

    public boolean addChangeListener(ChangeListener changeListener) {
        if (super.addChangeListener(changeListener)) {
            changeListener.stateChanged(new PwsFileSocket.ChangeEvent(this, 1));
            changeListener.stateChanged(new PwsFileSocket.ChangeEvent(this, 3));
            changeListener.stateChanged(new PwsFileSocket.ChangeEvent(this, 2));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        ArrayList arrayList = this.editListeners;
        synchronized (arrayList) {
            if (!this.editListeners.contains(undoableEditListener)) {
                this.editListeners.add(undoableEditListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        ArrayList arrayList = this.editListeners;
        synchronized (arrayList) {
            this.editListeners.remove(undoableEditListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEditEvent(UndoableEdit undoableEdit) {
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
        ArrayList arrayList = this.editListeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.editListeners.size(); ++i) {
                ((UndoableEditListener)this.editListeners.get(i)).undoableEditHappened(undoableEditEvent);
            }
        }
    }

    private Component window() {
        return Global.mainFrame;
    }

    private void loadFileOptions() {
        PersistentOptions persistentOptions = this.getOptions();
        this.lastEditedEntries.setContent(persistentOptions.getOption("lastEditedEntries"));
        this.lastEditedEntries.resetModified();
        this.lastUsedEntries.setContent(persistentOptions.getOption("lastUsedEntries"));
        this.lastUsedEntries.resetModified();
    }

    private void init() {
        this.view = new JPanel(new BorderLayout());
        this.filterPanel = new JPanel(new BorderLayout());
        this.lastEditedEntries = new RecentEntryList(6);
        this.lastUsedEntries = new RecentEntryList(6);
        this.loadFileOptions();
        this.filterBar = new JLabel();
        this.filterBar.setBackground(new Color(8388564));
        this.filterBar.setForeground(new Color(4286945));
        this.filterBar.setOpaque(true);
        JButton jButton = new JButton(ResourceLoader.getImageIcon("filtercancel"));
        jButton.setToolTipText(ResourceLoader.getCommand("tooltip.filter.cancel"));
        jButton.setBorder(null);
        jButton.setOpaque(false);
        jButton.setActionCommand("viewport.cancelfilter");
        jButton.addActionListener(ActionHandler.getMainActionListener());
        this.filterPanel.add((Component)jButton, "East");
        this.filterPanel.add((Component)this.filterBar, "Center");
        this.filterPanel.setBackground(this.filterBar.getBackground());
        this.filterPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 1, 5));
        this.filterPanel.setVisible(false);
        this.view.add((Component)this.filterPanel, "North");
        this.scrollPane = new JScrollPane();
        this.view.add((Component)this.scrollPane, "Center");
        String string = this.getOptions().getOption("viewType");
        if (string.length() == 0) {
            string = Options.getOption("defaultViewType");
        }
        this.setViewType(string.equals("table") ? 2 : 1);
        try {
            string = (String)this.lastUsedEntries.getFirst();
            PwsRecord pwsRecord = this.getRecord(new UUID(string));
            this.random = pwsRecord.getSignature();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exitDisplay() {
        if (this.viewType != 0) {
            if (this.editDialog != null) {
                this.editDialog.dispose();
                this.editDialog = null;
            }
            if (this.treeHandler != null) {
                this.treeHandler.destruct();
            }
            if (this.tableHandler != null) {
                this.tableHandler.destruct();
            }
            this.treeHandler = null;
            this.tableHandler = null;
            this.viewHandler = null;
            this.viewType = 0;
            this.getPwsFile().removeFileListener(this.fileListener);
            this.reportPropertyChange(3);
        }
    }

    private void initDisplay(int n) {
        String string;
        this.treeHandler = new TreeHandler(this);
        this.tableHandler = new TableHandler(this);
        this.viewType = n;
        this.viewHandler = this.viewType == 2 ? this.tableHandler : this.treeHandler;
        this.digestOptions();
        this.fileListener = new FileListener();
        this.getPwsFile().addFileListener(this.fileListener);
        this.setupDisplay(new int[0]);
        if (Options.isOptionSet("autoExpandTree")) {
            this.setExpandedBranch("", true);
        }
        if ((string = (String)this.lastUsedEntries.getFirst()) != null) {
            UUID uUID = new UUID(string);
            int n2 = this.getOrderedList().indexOf(new PwsRecord(uUID));
            this.viewHandler.setSelectedIndex(n2);
        }
        this.reportPropertyChange(2);
        this.reportPropertyChange(3);
    }

    public JPanel getView() {
        return this.view;
    }

    public byte[] getRandomValue() {
        return this.random;
    }

    public AddDialog getEditDialog() {
        return this.editDialog;
    }

    public void digestOptions() {
        boolean bl = Options.isOptionSet("useUndoRedo");
        if (this.treeHandler != null) {
            this.treeHandler.setDeleteKeyEnabled(bl);
        }
        if (this.tableHandler != null) {
            this.tableHandler.setDeleteKeyEnabled(bl);
        }
    }

    public void addEntry() {
        if (this.editDialog != null) {
            this.editDialog.show();
        } else {
            this.editDialog = new AddDialog((Frame)Global.mainFrame, this.getSelectedGroupName());
            this.editDialog.setExternalActions(this);
            Global.mainFrame.addChildDialog(this.editDialog);
            this.editDialog.show();
        }
    }

    public void editEntry(PwsRecord pwsRecord) {
        if (this.editDialog != null) {
            this.editDialog.show();
        } else {
            this.editDialog = new AddDialog((Frame)Global.mainFrame, (PwsRecord)pwsRecord.clone());
            this.editDialog.setExternalActions(this);
            Global.mainFrame.addChildDialog(this.editDialog);
            this.editDialog.show();
            if (Options.isOptionSet("useEntryOnOpen")) {
                this.recordUsed(pwsRecord);
            }
        }
    }

    public void updateRecord(PwsRecord pwsRecord) throws NoSuchRecordException {
        super.updateRecord(pwsRecord);
        this.setSelectedRecord(pwsRecord);
        Log.debug(5, "-- updating record: ".concat(pwsRecord.getRecordID().toString()));
    }

    public void updateUI() {
        if (this.treeHandler != null) {
            this.treeHandler.updateUI();
        }
        if (this.tableHandler != null) {
            this.tableHandler.updateUI();
        }
    }

    public void showFileInfo() {
        if (this.fileInfoDlg == null) {
            this.fileInfoDlg = new FileInfoDialog(this);
            Global.mainFrame.addChildDialog(this.fileInfoDlg);
        } else {
            this.fileInfoDlg.show();
        }
    }

    public void addRecord(PwsRecord pwsRecord) throws DuplicateEntryException {
        super.addRecord(pwsRecord);
        this.setSelectedRecord(pwsRecord);
    }

    public boolean emergencySave() {
        this.setEventPause(true);
        if (this.editDialog != null && this.editDialog.recordModified()) {
            PwsRecord pwsRecord = this.editDialog.getRecord();
            try {
                if (this.editDialog.isNewRecord()) {
                    this.addRecord(pwsRecord);
                } else {
                    this.updateRecord(pwsRecord);
                }
                if (this.editDialog.dataModified()) {
                    this.lastEditedEntries.pushRecent(pwsRecord);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.emergencySave();
    }

    protected void storeFileOptions() {
        PersistentOptions persistentOptions = this.getOptions();
        persistentOptions.setOption("lastEditedEntries", this.lastEditedEntries.getStringContent());
        persistentOptions.setOption("lastUsedEntries", this.lastUsedEntries.getStringContent());
        super.storeFileOptions();
    }

    private boolean saveCopyIntern(int n, boolean bl) {
        int n2;
        String string;
        String string2;
        String string3;
        boolean bl2;
        if (this.isCriticalPhase() | this.isIOProgressing()) {
            return false;
        }
        this.isIOProgress = true;
        boolean bl3 = n == 3;
        boolean bl4 = n == 1;
        boolean bl5 = n == 2;
        boolean bl6 = bl2 = n == 0;
        if (bl3) {
            string3 = "dlg.savebackup";
            string2 = "msg.confirm.backup";
            string = "confirmBackup";
            n2 = 2;
        } else if (bl2) {
            string3 = "dlg.savefile";
            string2 = "msg.confirm.savefile";
            string = "confirmSave";
            n2 = 1;
        } else if (bl4) {
            string3 = "dlg.saveas";
            string2 = "msg.confirm.saveas";
            string = "true";
            n2 = 4;
        } else if (bl5) {
            string3 = "dlg.savecopy";
            string2 = "msg.confirm.savecopy";
            string = "true";
            n2 = 5;
        } else {
            throw new IllegalArgumentException();
        }
        if (bl3 | bl2 || !Options.isOptionSet("createFileCheck") || GUIService.passwordControl(this)) {
            URL uRL;
            boolean bl7 = !this.hasPersistentFile();
            URL uRL2 = this.getUrl();
            String string4 = this.getFilePath();
            PwsPassphrase pwsPassphrase = this.getPassphrase();
            if (!Global.requestCriticalPhase(uRL2)) {
                this.isIOProgress = false;
                return false;
            }
            String string5 = bl7 ? (bl2 ? "" : "?") : Util.fileNameOfPath(string4);
            String string6 = ResourceLoader.getDisplay(string3) + string5;
            int n3 = bl3 ? 2 : 1;
            File file = null;
            if (bl3) {
                string5 = Util.fileNameOfPath(string4);
                int n4 = string5.lastIndexOf(".");
                if (n4 > -1) {
                    string5 = string5.substring(0, n4);
                }
                file = new File(Global.backDir, string5 + ".bak");
            }
            if ((uRL = bl2 & !bl7 ? uRL2 : GUIService.chooseSaveFilePath(this.window(), string6.trim(), n3, -1, file)) != null) {
                ApplicationAdapter applicationAdapter = Global.getAdapter(uRL);
                String string7 = Global.getFilePath(uRL);
                String string8 = Util.fileNameOfPath(string7);
                pwsPassphrase = null;
                if (!bl2 | bl7) {
                    try {
                        boolean bl8 = applicationAdapter.existsFile(string7);
                        if (bl8 && !GUIService.overwriteConfirm(this.window(), string7) || bl5 && GUIService.userConfirm(this.window(), "msg.ask.newpassword") && (pwsPassphrase = GUIService.enterNewPassphrase(string8)) == null) {
                            Global.endCriticalPhase(uRL2);
                            this.isIOProgress = false;
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        GUIService.failureMessage("IO Error", exception);
                        Global.endCriticalPhase(uRL2);
                        this.isIOProgress = false;
                        return false;
                    }
                }
                try {
                    if (bl4 | bl2 & bl7) {
                        super.saveAs(uRL, bl7);
                    } else if (bl2) {
                        Global.endCriticalPhase(uRL2);
                        super.saveFile();
                    } else {
                        super.saveCopy(uRL, pwsPassphrase, bl3);
                    }
                }
                catch (Exception exception) {
                    GUIService.failureMessage("msg.saveerror", exception);
                    Global.endCriticalPhase(uRL2);
                    this.isIOProgress = false;
                    return false;
                }
                if (bl) {
                    GUIService.statusConfirm(string2, string7);
                    if (string.equals("true") || Options.isOptionSet(string)) {
                        this.confirmOperation(n2, string7);
                    }
                }
            }
            Global.endCriticalPhase(uRL2);
        }
        this.isIOProgress = false;
        return true;
    }

    public void saveCopy(boolean bl) {
        this.saveCopyIntern(bl ? 3 : 2, true);
    }

    public void saveAs() {
        this.saveCopyIntern(1, true);
    }

    public boolean saveFile(boolean bl) {
        if (this.isCriticalPhase() | this.isIOProgressing()) {
            return false;
        }
        String string = this.getFilePath();
        if (string != null && !this.getApplication().canWrite(string)) {
            string = ResourceLoader.getDisplay("msg.url.writedenied");
            string = Util.substituteText(string, "$adapter", this.getApplication().getName());
            GUIService.infoMessage(this.window(), "dlg.operrejected", string);
            return false;
        }
        boolean bl2 = true;
        if (this.isModified()) {
            bl2 = this.saveCopyIntern(0, bl);
        }
        return bl2;
    }

    private void confirmOperation(int n, String string) {
        String string2;
        String string3 = ResourceLoader.getDisplay("confirm.fileaction");
        string3 = Util.substituteText(string3, "$target", string);
        switch (n) {
            case 2: {
                string2 = "confirm.backup";
                break;
            }
            case 3: {
                string2 = "confirm.restore";
                break;
            }
            case 1: {
                string2 = "confirm.save";
                break;
            }
            case 4: {
                string2 = "confirm.saveas";
                break;
            }
            case 5: {
                string2 = "confirm.savecopy";
                break;
            }
            case 6: {
                string2 = "confirm.revert";
                break;
            }
            case 7: {
                string2 = "confirm.convert";
                break;
            }
            default: {
                string2 = null;
            }
        }
        string3 = Util.substituteText(string3, "$action", ResourceLoader.getDisplay(string2));
        GUIService.infoMessage(this.window(), "confirm.operation", string3);
    }

    private PwsFile passTryOpen(URL uRL) {
        return ActionHandler.passTryOpen(uRL, this.getPassphrase());
    }

    private PwsPassphrase enterNewPassphrase() {
        return GUIService.enterNewPassphrase(this.getDatabaseName());
    }

    public void changePassphrase() {
        PwsPassphrase pwsPassphrase;
        if (this.isCriticalPhase() | this.isIOProgressing()) {
            return;
        }
        this.isIOProgress = true;
        PwsPassphrase pwsPassphrase2 = this.getPassphrase();
        if ((pwsPassphrase2 == null || GUIService.passwordControl(this)) && (pwsPassphrase = this.enterNewPassphrase()) != null) {
            this.setPassphrase(pwsPassphrase);
            UndoManager.ModifyPasswordEdit modifyPasswordEdit = new UndoManager.ModifyPasswordEdit(this, pwsPassphrase2, pwsPassphrase);
            this.fireEditEvent(modifyPasswordEdit);
            GUIService.statusConfirm("msg.confirm.passmodify");
        }
        this.isIOProgress = false;
    }

    public void deleteCommand() {
        int n = this.getSelectionStatus();
        if (n == 1) {
            this.deleteGroupDlg(this.getSelectedGroupName());
        } else if (n == 2) {
            this.deleteEntriesDlg(this.getSelectedRecords());
        }
    }

    public void deleteGroupDlg(String string) {
        int n;
        if (this.isIOProgressing() || (n = this.getGroupRecords(string).length) == 0) {
            return;
        }
        String string2 = ResourceLoader.getDisplay("msg.delete.group");
        string2 = Util.substituteText(string2, "$group", string);
        string2 = Util.substituteText(string2, "$count", String.valueOf(n));
        if (GUIService.userConfirm(this.window(), string2)) {
            DefaultRecordWrapper[] defaultRecordWrapperArray = this.deleteGroup(string);
            this.clearSelection();
            this.fireEditEvent(new UndoManager.DeleteRecordEdit(this, defaultRecordWrapperArray, string));
        }
        GUIService.statusConfirm("msg.confirm.deleterec");
    }

    public void deleteEntriesDlg(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        if (this.isIOProgressing()) {
            return;
        }
        if (defaultRecordWrapperArray != null & defaultRecordWrapperArray.length > 0) {
            String string;
            int n = defaultRecordWrapperArray.length;
            if (n == 1) {
                string = ResourceLoader.getDisplay("msg.ask.deleterec");
                string = Util.substituteText(string, "$name", defaultRecordWrapperArray[0].toString());
            } else {
                string = ResourceLoader.getDisplay("msg.ask.deletemultirec");
                string = Util.substituteText(string, "$amount", String.valueOf(n));
            }
            if (!Options.isOptionSet("confirmDeleteRecord") || GUIService.userConfirm(this.window(), string)) {
                this.deleteEntries(defaultRecordWrapperArray);
                this.clearSelection();
                this.fireEditEvent(new UndoManager.DeleteRecordEdit(this, defaultRecordWrapperArray, null));
                GUIService.statusConfirm("msg.confirm.deleterec");
            }
        }
    }

    public PwsRecordList mergeDatabase(Dialog dialog, PwsRecordList pwsRecordList, String string, String string2) {
        String string3;
        if (string == null) {
            throw new NullPointerException("source parameter missing");
        }
        JComboBox<String> jComboBox = new JComboBox<String>(ResourceLoader.getCommand("combo.mergeconflict").split(","));
        JCheckBox jCheckBox = new JCheckBox(ResourceLoader.getDisplay("chk.merge.copyold"));
        jCheckBox.setIconTextGap(10);
        jCheckBox.setSelected(Options.isOptionSet("merge.copycheck"));
        int n = pwsRecordList.getRecordCount();
        PwsFile pwsFile = this.getPwsFile();
        PwsRecordList pwsRecordList2 = (PwsRecordList)((PwsRecordList)pwsFile).clone();
        PwsRecordList pwsRecordList3 = pwsFile.cutSetRecordList(pwsRecordList);
        PwsRecordList pwsRecordList4 = new PwsRecordList();
        PwsRecordList pwsRecordList5 = new PwsRecordList();
        Iterator iterator = pwsRecordList3.iterator();
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            PwsRecord pwsRecord2 = pwsRecordList.getRecord(pwsRecord.getRecordID());
            try {
                if (Util.equalArrays(pwsRecord2.getSignature(), pwsRecord.getSignature())) {
                    pwsRecordList4.addRecord(pwsRecord);
                    continue;
                }
                pwsRecordList5.addRecord(pwsRecord2);
            }
            catch (DuplicateEntryException duplicateEntryException) {}
        }
        int n2 = pwsRecordList4.getRecordCount();
        int n3 = pwsRecordList5.getRecordCount();
        boolean bl = n3 > 0;
        pwsRecordList3 = null;
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont().deriveFont(0);
        jLabel.setFont(font);
        String string4 = ResourceLoader.getDisplay(bl ? "msg.merge.conflict" : "msg.merge.no_conflict");
        int n4 = n - n2 == 0 ? 2 : 3;
        ButtonBarDialog buttonBarDialog = dialog == null ? new ButtonBarDialog((Frame)Global.mainFrame, n4, true) : new ButtonBarDialog(dialog, n4, true);
        buttonBarDialog.setTitle(ResourceLoader.getDisplay("dlg.merge"));
        class OurActionListener
        implements ActionListener {
            int nrMerge;
            int nrSolved;
            private final /* synthetic */ int val$srcRecs;
            private final /* synthetic */ int val$nrIdentical;
            private final /* synthetic */ int val$nrConflict;
            private final /* synthetic */ PwsRecordList val$thisDb;
            private final /* synthetic */ PwsRecordList val$conflictList;
            private final /* synthetic */ String val$t2Basis;
            private final /* synthetic */ JLabel val$labelT2;
            private final /* synthetic */ JCheckBox val$copyCheck;
            private final /* synthetic */ JComboBox val$combo;

            public OurActionListener(int n, int n2, int n3, PwsRecordList pwsRecordList, PwsRecordList pwsRecordList2, String string, JLabel jLabel, JCheckBox jCheckBox, JComboBox jComboBox) {
                this.val$srcRecs = n;
                this.val$nrIdentical = n2;
                this.val$nrConflict = n3;
                this.val$thisDb = pwsRecordList;
                this.val$conflictList = pwsRecordList2;
                this.val$t2Basis = string;
                this.val$labelT2 = jLabel;
                this.val$copyCheck = jCheckBox;
                this.val$combo = jComboBox;
                this.nrMerge = this.val$srcRecs - this.val$nrIdentical - this.val$nrConflict;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = this.getChosenStrategyModus();
                PwsRecordList pwsRecordList = (PwsRecordList)this.val$thisDb.clone();
                PwsRecordList pwsRecordList2 = pwsRecordList.merge(this.val$conflictList, n);
                this.nrSolved = this.val$nrConflict - pwsRecordList2.getRecordCount();
                this.nrMerge = this.val$srcRecs - this.val$nrIdentical - this.val$nrConflict + this.nrSolved;
                this.refresh();
            }

            public void refresh() {
                String string = this.val$t2Basis;
                string = Util.substituteText(string, "$records", String.valueOf(this.nrMerge));
                string = Util.substituteText(string, "$overwrites", String.valueOf(this.nrSolved));
                string = Util.substituteText(string, "$remains", String.valueOf(this.val$nrConflict - this.nrSolved));
                this.val$labelT2.setText(string);
                this.val$copyCheck.setEnabled(this.nrSolved != 0);
            }

            public int getChosenStrategyModus() {
                int n;
                switch (this.val$combo.getSelectedIndex()) {
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 8;
                        break;
                    }
                    case 5: {
                        n = 16;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                return n;
            }
        }
        OurActionListener ourActionListener = new OurActionListener(n, n2, n3, pwsFile, pwsRecordList5, string4, jLabel, jCheckBox, jComboBox);
        String string5 = ResourceLoader.getDisplay("label.merge.source");
        string5 = Util.substituteText(string5, "$source", string);
        JLabel jLabel2 = new JLabel(string5);
        JLabel jLabel3 = new JLabel();
        if (n - n2 == 0) {
            string3 = ResourceLoader.getDisplay("msg.merge.nothing");
        } else if (n3 == 0 & n2 == 0) {
            string3 = ResourceLoader.getDisplay("msg.merge.everything");
            string3 = Util.substituteText(string3, "$records", String.valueOf(n));
        } else {
            string3 = ResourceLoader.getDisplay("msg.merge.subset");
            string3 = Util.substituteText(string3, "$srcrecs", String.valueOf(n));
            string3 = Util.substituteText(string3, "$identrecs", String.valueOf(n2));
            string3 = Util.substituteText(string3, "$confrecs", String.valueOf(n3));
            ourActionListener.refresh();
        }
        jLabel3.setText(string3);
        jComboBox.addActionListener(ourActionListener);
        JPanel jPanel = new JPanel(new BorderLayout(8, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JLabel jLabel4 = new JLabel(ResourceLoader.getDisplay("label.merge.strategy"));
        jPanel.add((Component)jLabel4, "West");
        jPanel.add(jComboBox, "Center");
        VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(5);
        JPanel jPanel2 = new JPanel(verticalFlowLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel2.add(jLabel);
        if (bl) {
            jPanel2.add(jPanel);
            jPanel2.add(jCheckBox);
        }
        class OurButtonBarListener
        extends DefaultButtonBarListener {
            PwsRecordList excludes;
            private final /* synthetic */ int val$srcRecs;
            private final /* synthetic */ int val$nrIdentical;
            private final /* synthetic */ OurActionListener val$selectListener;
            private final /* synthetic */ PwsRecordList val$list;
            private final /* synthetic */ PwsRecordList val$identList;
            private final /* synthetic */ PwsRecordList val$thisOld;
            private final /* synthetic */ String val$target;
            private final /* synthetic */ JCheckBox val$copyCheck;
            private final /* synthetic */ String val$source;
            private final /* synthetic */ ButtonBarDialog val$dialog;

            OurButtonBarListener(ButtonBarDialog buttonBarDialog, int n, int n2, OurActionListener ourActionListener, PwsRecordList pwsRecordList, PwsRecordList pwsRecordList2, PwsRecordList pwsRecordList3, String string, JCheckBox jCheckBox, String string2, ButtonBarDialog buttonBarDialog2) {
                super(buttonBarDialog);
                this.val$srcRecs = n;
                this.val$nrIdentical = n2;
                this.val$selectListener = ourActionListener;
                this.val$list = pwsRecordList;
                this.val$identList = pwsRecordList2;
                this.val$thisOld = pwsRecordList3;
                this.val$target = string;
                this.val$copyCheck = jCheckBox;
                this.val$source = string2;
                this.val$dialog = buttonBarDialog2;
            }

            public boolean okButtonPerformed() {
                if (this.val$srcRecs - this.val$nrIdentical > 0) {
                    String string;
                    int n = this.val$selectListener.getChosenStrategyModus();
                    PwsRecordList pwsRecordList = n != 16 ? this.val$list : ((PwsRecordList)this.val$list.clone()).removeRecordList(this.val$identList);
                    this.excludes = PwsFileContainer.this.mergeDatabase(pwsRecordList, n);
                    PwsRecordList pwsRecordList2 = ((PwsRecordList)pwsRecordList.clone()).removeRecordList(this.excludes);
                    DefaultRecordWrapper[] defaultRecordWrapperArray = this.val$thisOld.cutSetRecordList(pwsRecordList2).toRecordWrappers(null);
                    int n2 = pwsRecordList2.getRecordCount();
                    if (this.val$target != null) {
                        DefaultRecordWrapper[] defaultRecordWrapperArray2 = pwsRecordList2.toRecordWrappers(null);
                        PwsFileContainer.this.moveEntries(defaultRecordWrapperArray2, this.val$target, true);
                    }
                    DefaultRecordWrapper[] defaultRecordWrapperArray3 = null;
                    if (this.val$copyCheck.isSelected()) {
                        try {
                            defaultRecordWrapperArray3 = PwsFileSocket.duplicateRecords(defaultRecordWrapperArray);
                            PwsFileContainer.this.addRecordList(defaultRecordWrapperArray3);
                            PwsFileContainer.this.moveEntries(defaultRecordWrapperArray3, ResourceLoader.getDisplay("merge.replacement_group"), true);
                        }
                        catch (PasswordSafeException passwordSafeException) {
                            passwordSafeException.printStackTrace();
                            GUIService.failureMessage("Could not create replacement duplicates!", passwordSafeException);
                            defaultRecordWrapperArray3 = null;
                        }
                    }
                    if (n2 != 0) {
                        final DefaultRecordWrapper[] defaultRecordWrapperArray4 = PwsFileContainer.this.getImportedRecords(pwsRecordList2);
                        UndoManager.ModifyRecordEdit modifyRecordEdit = new UndoManager.ModifyRecordEdit(7, (PwsFileSocket)PwsFileContainer.this, defaultRecordWrapperArray, defaultRecordWrapperArray4, defaultRecordWrapperArray3, this.val$source);
                        PwsFileContainer.this.fireEditEvent(modifyRecordEdit);
                        SwingUtilities.invokeLater(new Runnable(){
                            {
                            }

                            public void run() {
                                PwsFileContainer.this.treeHandler.setExpanded("", true);
                                PwsFileContainer.this.viewHandler.setSelectedWrappers(defaultRecordWrapperArray4);
                                PwsFileContainer.this.viewHandler.scrollToVisible(PwsFileContainer.this.viewHandler.getFirstSelected());
                            }
                        });
                        string = ResourceLoader.getDisplay("msg.confirm.merge");
                        string = Util.substituteText(string, "$count", String.valueOf(n2));
                    } else {
                        string = ResourceLoader.getDisplay("msg.confirm.merge_nothing");
                    }
                    Global.setStatusText(string);
                    GUIService.infoMessage(this.val$dialog, "confirm.operation", string);
                }
                Options.setOption("merge.copycheck", this.val$copyCheck.isSelected());
                return super.okButtonPerformed();
            }
        }
        OurButtonBarListener ourButtonBarListener = new OurButtonBarListener(buttonBarDialog, n, n2, ourActionListener, pwsRecordList, pwsRecordList4, pwsRecordList2, string2, jCheckBox, string, buttonBarDialog);
        buttonBarDialog.setButtonBarListener(ourButtonBarListener);
        buttonBarDialog.setDialogPanel(jPanel2);
        if (buttonBarDialog.getWidth() < 250) {
            buttonBarDialog.setSize(new Dimension(300, buttonBarDialog.getHeight()));
        }
        buttonBarDialog.show();
        buttonBarDialog.joinButtonThreads();
        return ourButtonBarListener.excludes;
    }

    public void mergeDatabase() {
        URL uRL;
        PwsFile pwsFile = null;
        if (this.isCriticalPhase() | this.isIOProgressing()) {
            return;
        }
        this.isIOProgress = true;
        URL uRL2 = this.getUrl();
        int n = 3;
        FileOpenDialog fileOpenDialog = new FileOpenDialog(n, Global.currentDir);
        fileOpenDialog.setDialogTitle(ResourceLoader.getDisplay("dlg.mergefile"));
        if (fileOpenDialog.showOpenDialog(this.window()) != 0) {
            this.isIOProgress = false;
            return;
        }
        Global.exchangeDir = fileOpenDialog.getCurrentDirectory();
        File file = fileOpenDialog.getSelectedFile();
        try {
            uRL = Util.makeFileURL(file.getPath());
        }
        catch (Exception exception) {
            GUIService.failureMessage("msg.url.formerror", exception);
            this.isIOProgress = false;
            return;
        }
        pwsFile = this.passTryOpen(uRL);
        if (pwsFile == null || !Global.requestCriticalPhase(uRL2) || !Global.requestCriticalPhase(uRL)) {
            Global.endCriticalPhase(uRL2);
            this.isIOProgress = false;
            return;
        }
        this.mergeDatabase(null, pwsFile, pwsFile.getFileName(), null);
        Global.endCriticalPhase(uRL2);
        Global.endCriticalPhase(uRL);
        this.isIOProgress = false;
    }

    public void importFileCSV() {
        if (this.isCriticalPhase() | this.isIOProgressing()) {
            return;
        }
        ImportCSVDialog importCSVDialog = new ImportCSVDialog(this);
        Global.mainFrame.addChildDialog(importCSVDialog);
        importCSVDialog.setVisible(true);
    }

    public void exportFileCSV() {
        if (this.isCriticalPhase() | this.isIOProgressing()) {
            return;
        }
        Service.csvUserWarning();
        ExportCSVDialog exportCSVDialog = new ExportCSVDialog(this);
        Global.mainFrame.addChildDialog(exportCSVDialog);
        exportCSVDialog.setVisible(true);
    }

    public void exportSelectionCSV() {
        if (this.isCriticalPhase() | this.isIOProgressing()) {
            return;
        }
        DefaultRecordWrapper[] defaultRecordWrapperArray = this.getSelectedGroupRecords();
        if (defaultRecordWrapperArray == null) {
            defaultRecordWrapperArray = this.getSelectedRecords();
        }
        if (defaultRecordWrapperArray.length != 0) {
            Service.csvUserWarning();
            ExportCSVDialog exportCSVDialog = new ExportCSVDialog(this, defaultRecordWrapperArray);
            Global.mainFrame.addChildDialog(exportCSVDialog);
            exportCSVDialog.setVisible(true);
        }
    }

    public void exportSelectionFile(String string) {
        DefaultRecordWrapper[] defaultRecordWrapperArray = this.getSelectedGroupRecords();
        if (defaultRecordWrapperArray == null) {
            defaultRecordWrapperArray = this.getSelectedRecords();
        }
        if (defaultRecordWrapperArray.length != 0) {
            PwsFile pwsFile;
            if (string != null ? (pwsFile = Global.exportFileMem.openFile(string)) == null : (pwsFile = ActionHandler.openOrNewFile(Global.mainFrame, "dlg.export.openfile", Global.exchangeDir)) == null) {
                return;
            }
            String string2 = ResourceLoader.getDisplay("msg.export.autotarget");
            string2 = Util.substituteText(string2, "$count", String.valueOf(defaultRecordWrapperArray.length));
            string2 = Util.substituteText(string2, "$target", pwsFile.getFilePath());
            if (!GUIService.userConfirm(this.window(), string2)) {
                return;
            }
            PwsRecordList pwsRecordList = new PwsRecordList(defaultRecordWrapperArray);
            PwsRecordList pwsRecordList2 = pwsFile.merge(pwsRecordList, 0);
            try {
                pwsFile.save();
            }
            catch (Exception exception) {
                GUIService.failureMessage(null, exception);
                return;
            }
            Global.exportFileMem.pushFile(pwsFile);
            Global.exchangeDir = new File(Util.pathNameOfPath(pwsFile.getFilePath()));
            pwsRecordList.removeRecordList(pwsRecordList2);
            int n = pwsRecordList.getRecordCount();
            String string3 = n < defaultRecordWrapperArray.length ? "confirm.export.selection.2" : "confirm.export.selection";
            String string4 = n == 0 ? "dlg.operrejected" : "confirm.operation";
            string2 = ResourceLoader.getDisplay(string3);
            string2 = Util.substituteText(string2, "$target", pwsFile.getFilePath());
            string2 = Util.substituteText(string2, "$count", String.valueOf(n));
            string2 = Util.substituteText(string2, "$failed", String.valueOf(pwsRecordList2.getRecordCount()));
            string2 = Util.substituteText(string2, "$all", String.valueOf(defaultRecordWrapperArray.length));
            GUIService.infoMessage(this.window(), string4, string2);
        }
    }

    public boolean restoreBackup() {
        String string;
        PwsRecordList pwsRecordList = null;
        URL uRL = this.getUrl();
        if (this.isIOProgressing() || !Global.requestCriticalPhase(uRL)) {
            return false;
        }
        this.isIOProgress = true;
        FileOpenDialog fileOpenDialog = new FileOpenDialog(2, Global.backDir);
        String string2 = this.getFileName();
        if (this.hasPersistentFile()) {
            string = string2;
            int n = string.lastIndexOf(".");
            if (n > -1) {
                string = string.substring(0, n);
            }
            fileOpenDialog.setSelectedFile(new File(Global.backDir, string + ".bak"));
        }
        fileOpenDialog.setDialogTitle(ResourceLoader.getDisplay("dlg.restorebackup") + this.getDatabaseName());
        boolean bl = false;
        File file = null;
        if (fileOpenDialog.showOpenDialog(this.window()) == 0) {
            URL uRL2;
            Global.backDir = fileOpenDialog.getCurrentDirectory();
            file = fileOpenDialog.getSelectedFile();
            try {
                uRL2 = Util.makeFileURL(file.getPath());
                bl = true;
            }
            catch (Exception exception) {
                GUIService.failureMessage("msg.url.formerror", exception);
                uRL2 = null;
            }
            boolean bl2 = bl = bl && (pwsRecordList = this.passTryOpen(uRL2)) != null;
        }
        if (!bl) {
            Global.endCriticalPhase(uRL);
            this.isIOProgress = false;
            return false;
        }
        int n = 0;
        Iterator iterator = pwsRecordList.iterator();
        while (iterator.hasNext()) {
            if (!this.getPwsFile().contains((PwsRecord)iterator.next())) continue;
            ++n;
        }
        int n2 = pwsRecordList.getRecordCount();
        int n3 = 0;
        if (n2 > 0) {
            n3 = n * 100 / n2;
        }
        string = "<font color=\"red\">" + String.valueOf(n3) + " %</font>";
        String string3 = ResourceLoader.getDisplay("msg.ask.loadbackup");
        string3 = Util.substituteText(string3, "$value", string);
        bl = GUIService.userConfirm(this.window(), string3);
        if (bl) {
            try {
                UndoManager.FileEdit fileEdit = new UndoManager.FileEdit(1, this, (PwsFile)pwsRecordList, ((PwsFile)pwsRecordList).lastModified());
                this.substituteContent(pwsRecordList);
                this.fireEditEvent(fileEdit);
                GUIService.statusConfirm("msg.confirm.restore", file.getAbsolutePath());
                if (Options.isOptionSet("confirmBackup")) {
                    this.confirmOperation(3, file.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                GUIService.failureMessage("Substitute Content", exception);
                bl = false;
            }
        }
        Global.endCriticalPhase(uRL);
        this.isIOProgress = false;
        return bl;
    }

    public void substituteContent(PwsRecordList pwsRecordList) throws PasswordSafeException {
        PwsPassphrase pwsPassphrase = this.getPassphrase();
        super.substituteContent(pwsRecordList);
        this.loadFileOptions();
        this.fileUpdated();
        if (!pwsPassphrase.equals(this.getPassphrase())) {
            GUIService.warningMessage(this.window(), null, "msg.warning.accesspasschanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revert(String string) {
        String string2;
        long l;
        URL uRL;
        if (!this.hasPersistentFile() | this.isIOProgressing()) {
            return false;
        }
        boolean bl = string.equals(this.getFilePath());
        this.isIOProgress = true;
        try {
            uRL = Util.makeFileURL(string);
        }
        catch (IOException iOException) {
            GUIService.failureMessage("Bad File Path", iOException);
            return false;
        }
        PwsFile pwsFile = this.passTryOpen(uRL);
        if (pwsFile == null) {
            this.isIOProgress = false;
            return false;
        }
        String string3 = ResourceLoader.getDisplay("msg.ask.loadrevert");
        string3 = Util.substituteText(string3, "$name", this.getDatabaseName());
        try {
            l = Util.timeFromSECPath(string);
            if (l == -1L) {
                l = pwsFile.lastModified();
            }
            string2 = l == 0L ? "- ? -" : new Date(l).toLocaleString();
        }
        catch (IOException iOException) {
            l = 0L;
            string2 = "- ? -";
        }
        string3 = Util.substituteText(string3, "$time", string2);
        if (!GUIService.userConfirm(this.window(), string3)) {
            this.isIOProgress = false;
            return false;
        }
        try {
            UndoManager.FileEdit fileEdit = new UndoManager.FileEdit(0, this, pwsFile, l);
            this.substituteContent(pwsFile);
            if (bl) {
                this.resetModified();
            }
            this.lastSaveTime = System.currentTimeMillis();
            this.fireEditEvent(fileEdit);
            GUIService.statusConfirm("msg.confirm.revert");
            if (Options.isOptionSet("confirmRevert")) {
                this.confirmOperation(6, "");
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            GUIService.failureMessage("Substitute Content", exception);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            Global.endCriticalPhase(uRL);
            this.isIOProgress = false;
        }
    }

    public void eraseBackups() {
        String string = ResourceLoader.getDisplay("msg.ask.delete.backups");
        string = Util.substituteText(string, "$amount", String.valueOf(this.getAutoBackups().size()));
        string = Util.substituteText(string, "$name", this.getDatabaseName());
        if (GUIService.userConfirm(this.window(), string)) {
            super.eraseBackups();
            MenuHandler.fileUpdated(this);
        }
    }

    public void convert() {
        if (this.getFileFormat() == 3) {
            return;
        }
        String string = ResourceLoader.getDisplay("msg.convert.ask");
        string = Util.substituteText(string, "$file", this.getDatabaseName());
        string = Util.substituteText(string, "$oldformat", PwsFileContainer.getFileFormatText(this.getFileFormat()));
        if (GUIService.userConfirm(string = Util.substituteText(string, "$newformat", PwsFileContainer.getFileFormatText(3)))) {
            Global.delay(500L);
            this.setFileFormat(3);
            GUIService.statusConfirm("msg.confirm.convert");
            this.confirmOperation(7, "");
        }
    }

    public boolean isIOProgressing() {
        return this.isIOProgress;
    }

    public boolean close() {
        if (this.isOpen() & this.isModified()) {
            if (this.isCriticalPhase() | this.isIOProgressing()) {
                return false;
            }
            String string = ResourceLoader.getDisplay("msg.cansave");
            string = Util.substituteText(string, "$name", this.getDatabaseName());
            int n = GUIService.userConfirmOption(this.window(), string);
            if (n == 2) {
                return false;
            }
            if (n == 0 && !this.saveFile(true)) {
                return false;
            }
        }
        this.exitDisplay();
        this.operationMode = 0;
        this.fireChangeEvent(1);
        try {
            super.close(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public PwsRecord getSelectedRecord() {
        if (this.viewHandler == null) {
            return null;
        }
        int n = this.viewHandler.getFirstSelected();
        DefaultRecordWrapper defaultRecordWrapper = this.getOrderedList().getItemAt(n);
        if (defaultRecordWrapper != null) {
            return defaultRecordWrapper.getRecord();
        }
        return null;
    }

    public DefaultRecordWrapper[] getSelectedRecords() {
        DefaultRecordWrapper[] defaultRecordWrapperArray;
        if (this.viewHandler == null) {
            defaultRecordWrapperArray = new DefaultRecordWrapper[]{};
        } else {
            int[] nArray = this.viewHandler.getSelectedItems();
            defaultRecordWrapperArray = new DefaultRecordWrapper[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                defaultRecordWrapperArray[i] = this.getOrderedList().getItemAt(nArray[i]);
            }
        }
        return defaultRecordWrapperArray;
    }

    public String getSelectedGroupName() {
        if (this.viewHandler == null) {
            return null;
        }
        if (this.viewType == 1) {
            TreeHandler.PwsTreeNode pwsTreeNode = (TreeHandler.PwsTreeNode)this.treeHandler.getSelectedNode();
            if (pwsTreeNode == null) {
                return null;
            }
            Object object = pwsTreeNode.getUserObject();
            if (object instanceof DefaultRecordWrapper) {
                return ((DefaultRecordWrapper)object).getRecord().getGroup();
            }
            return pwsTreeNode.getPathName();
        }
        PwsRecord pwsRecord = this.getSelectedRecord();
        if (pwsRecord != null) {
            return pwsRecord.getGroup();
        }
        return null;
    }

    public DefaultRecordWrapper[] getSelectedGroupRecords() {
        if (this.getSelectionStatus() == 1) {
            return this.getGroupRecords(this.getSelectedGroupName());
        }
        return null;
    }

    public int getSelectionStatus() {
        if (this.viewHandler == null || !this.viewHandler.hasUserSelection()) {
            return 0;
        }
        return this.viewHandler.getFirstSelected() == -1 ? 1 : 2;
    }

    public int getViewType() {
        return this.viewType;
    }

    public String getTitle() {
        String string = null;
        if (Options.isOptionSet("logicalFilenames")) {
            string = this.getHeaderValue(9);
        }
        if (string == null) {
            string = this.getFilePath();
        }
        if (string == null) {
            string = ResourceLoader.getDisplay("ui.newtitle");
        }
        return string;
    }

    public void setViewType(int n) {
        if (n > -1 & n < 3 & n != this.viewType) {
            this.viewType = n;
            int[] nArray = null;
            if (this.viewHandler != null) {
                if (n == 0) {
                    this.exitDisplay();
                    return;
                }
            } else if (n != 0) {
                this.initDisplay(n);
            } else {
                return;
            }
            nArray = this.viewHandler.getSelectedItems();
            this.viewHandler = this.viewType == 0 ? null : (this.viewType == 1 ? this.treeHandler : this.tableHandler);
            this.getOptions().setOption("viewType", this.viewType == 2 ? "table" : "tree");
            this.setupDisplay(nArray);
            this.getViewHandler().getView().requestFocusInWindow();
            this.reportPropertyChange(2);
            this.reportPropertyChange(3);
        }
    }

    public void setSelectedRecord(PwsRecord pwsRecord) {
        if (this.viewHandler != null) {
            this.viewHandler.setSelectedIndex(this.getOrderedList().indexOf(pwsRecord));
        }
    }

    public void selectAll() {
        if (this.viewHandler != null) {
            this.viewHandler.setSelectAll();
        }
    }

    public void clearSelection() {
        if (this.viewHandler != null) {
            this.viewHandler.setSelectedIndex(-1);
        }
    }

    public void setExpandedBranch(String string, boolean bl) {
        this.treeHandler.setExpanded(string, bl);
    }

    private void setScreenView(Component component) {
        if (component == null) {
            component = new JPanel();
        }
        this.scrollPane.setViewportView(component);
        this.view.validate();
    }

    private void setEmptyView() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        String string = this.getFilterStatus() == 0 ? "info.emptyfile" : "info.emptyfilterview";
        JLabel jLabel = new JLabel(ResourceLoader.getDisplay(string));
        jPanel.add((Component)jLabel, "North");
        this.setScreenView(jPanel);
    }

    public void setupDisplay(int[] nArray) {
        if (this.getFilteredSize() == 0) {
            this.setEmptyView();
        } else {
            this.setScreenView(this.viewHandler.getView());
            if (nArray != null) {
                this.viewHandler.setSelectedItems(nArray);
            }
        }
        this.setFilterStatusIntern(this.getFilterStatus());
    }

    public boolean isModified() {
        return super.isModified() || this.lastUsedEntries.isModified();
    }

    public void resetModified() {
        this.lastUsedEntries.resetModified();
        super.resetModified();
    }

    protected void fileSaved() {
        super.fileSaved();
        Global.pushRecent(this);
    }

    public ContainerView getViewHandler() {
        return this.viewHandler;
    }

    public MouseAdapter getMouseAdapter() {
        return new ViewportMouseAdapter();
    }

    public RecentList getLastUsedList() {
        return this.lastUsedEntries;
    }

    public RecentList getLastEditedList() {
        return this.lastEditedEntries;
    }

    private void setFilterStatusIntern(int n) {
        String string;
        boolean bl = n != this.getFilterStatus();
        switch (n) {
            case 1: {
                string = "filter.modus1.text";
                break;
            }
            case 2: {
                string = "filter.modus2.text";
                break;
            }
            case 3: {
                string = "filter.modus3.text";
                break;
            }
            default: {
                n = 0;
                string = null;
            }
        }
        this.filterBar.setText(string == null ? null : ResourceLoader.getCommand(string));
        this.filterPanel.setVisible(string != null);
        DefaultRecordWrapper[] defaultRecordWrapperArray = null;
        if (bl) {
            defaultRecordWrapperArray = this.viewHandler == null ? null : this.viewHandler.getSelectedWrappers();
        }
        super.setFilterStatus(n);
        if (this.getFilteredSize() == 0) {
            this.setEmptyView();
        } else {
            this.setScreenView(this.viewHandler.getView());
        }
        if (n != 0 & this.getViewType() == 1) {
            this.treeHandler.setExpanded("", true);
        }
        if (this.viewHandler != null & bl) {
            this.viewHandler.setSelectedWrappers(defaultRecordWrapperArray);
        }
    }

    public void setFilterStatus(int n) {
        if (n == this.getFilterStatus()) {
            return;
        }
        this.setFilterStatusIntern(n);
    }

    public void setOperationMode(int n) {
        if (n < -1 | n > 2 | n == this.operationMode) {
            return;
        }
        switch (n) {
            case 2: {
                this.addUndoableEditListener(Global.undoManager);
                this.setupDisplay(null);
                break;
            }
            case 0: {
                this.removeUndoableEditListener(Global.undoManager);
                if (!this.isOpen()) break;
                this.close();
            }
        }
        this.operationMode = n;
        this.fireChangeEvent(1);
    }

    public int getOperationMode() {
        return this.operationMode;
    }

    public void showExpiredMessage(boolean bl) {
        long l = Options.getLongOption("expireScope");
        int n = this.getPwsFile().countExpired(System.currentTimeMillis());
        int n2 = this.getPwsFile().countExpired(System.currentTimeMillis() + l);
        String string = ResourceLoader.getDisplay("title.expirecheck");
        if (n2 > 0) {
            String string2 = "";
            String string3 = "";
            if (n > 0) {
                string3 = ResourceLoader.getDisplay("msg.expire.now");
                string3 = Util.substituteText(string3, "$expire", String.valueOf(n));
            }
            if (n2 - n > 0) {
                string2 = ResourceLoader.getDisplay("msg.expire.soon");
                string2 = Util.substituteText(string2, "$expire", String.valueOf(n2 - n));
                string2 = Util.substituteText(string2, "$scope", String.valueOf(l / 86400000L));
            }
            String string4 = "<html><font color=\"green\" size=\"+1\">" + this.getDatabaseName() + "</font><p> " + string3 + string2 + "<p> <p></html>";
            ButtonBarDialog buttonBarDialog = new ButtonBarDialog(Global.getActiveFrame(), 3, true);
            buttonBarDialog.setTitle(string);
            JLabel jLabel = new JLabel(string4);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            buttonBarDialog.getDialogPanel().add(jLabel);
            buttonBarDialog.getButtonBar().getOkButton().setText(ResourceLoader.getDisplay("button.show"));
            buttonBarDialog.getButtonBar().getCancelButton().setText(ResourceLoader.getDisplay("button.close"));
            buttonBarDialog.pack();
            Util.centreWithin(buttonBarDialog.getOwner(), buttonBarDialog);
            buttonBarDialog.show();
            if (buttonBarDialog.isOkPressed()) {
                this.setFilterStatus(1);
            }
        } else if (bl) {
            GUIService.infoMessage(this.window(), string, ResourceLoader.getDisplay("msg.noexpiredinfo"));
        }
    }

    public void renameGroupDlg(String string) {
        if (this.getPwsFile().getGrpRecordCount(string, true) > 0) {
            String string2 = string;
            int n = string.lastIndexOf(46);
            if (n > -1) {
                string2 = string.substring(n + 1);
            }
            String string3 = ResourceLoader.getDisplay("msg.renamegroup");
            string3 = Util.substituteText(string3, "$group", string);
            String string4 = GUIService.userInput(this.window(), ResourceLoader.getDisplay("dlg.input.groupname"), string3, string2);
            if (string4 != null) {
                DefaultRecordWrapper[] defaultRecordWrapperArray = this.getAbsoluteGroupRecords(string);
                DefaultRecordWrapper[] defaultRecordWrapperArray2 = this.renameGroup(string, string4);
                UndoManager.ModifyRecordEdit modifyRecordEdit = new UndoManager.ModifyRecordEdit(4, (PwsFileSocket)this, defaultRecordWrapperArray, defaultRecordWrapperArray2, string, string4);
                this.fireEditEvent(modifyRecordEdit);
            }
        }
    }

    public void addDuplicates(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        try {
            DefaultRecordWrapper[] defaultRecordWrapperArray2 = PwsFileContainer.duplicateRecords(defaultRecordWrapperArray);
            this.addRecordList(defaultRecordWrapperArray2);
            this.viewHandler.setSelectedWrappers(defaultRecordWrapperArray2);
            UndoManager.ModifyRecordEdit modifyRecordEdit = new UndoManager.ModifyRecordEdit(3, (PwsFileSocket)this, null, defaultRecordWrapperArray2);
            this.fireEditEvent(modifyRecordEdit);
        }
        catch (Exception exception) {
            GUIService.failureMessage("Duplicate or invalid Record", exception);
        }
    }

    public void duplicateGroup(String string) {
        PwsRecord[] pwsRecordArray = this.groupDuplicates(string);
        String string2 = this.getNewGroupName(string);
        for (int i = 0; i < pwsRecordArray.length; ++i) {
            PwsRecord pwsRecord = pwsRecordArray[i];
            String string3 = pwsRecord.getGroup().substring(string.length());
            pwsRecord.setGroup(string2 + string3);
        }
        DefaultRecordWrapper[] defaultRecordWrapperArray = DefaultRecordWrapper.makeWrappers(pwsRecordArray, null);
        try {
            this.addRecordList(defaultRecordWrapperArray);
            this.viewHandler.setSelectedWrappers(defaultRecordWrapperArray);
        }
        catch (Exception exception) {
            GUIService.failureMessage("Duplicate or invalid Record", exception);
        }
        UndoManager.ModifyRecordEdit modifyRecordEdit = new UndoManager.ModifyRecordEdit(6, (PwsFileSocket)this, null, defaultRecordWrapperArray, string, string2);
        this.fireEditEvent(modifyRecordEdit);
    }

    public void moveSelectedDlg() {
        String string;
        DefaultRecordWrapper[] defaultRecordWrapperArray;
        String string2;
        boolean bl;
        JCheckBox jCheckBox = null;
        boolean bl2 = bl = this.getSelectionStatus() == 1;
        if (bl) {
            string2 = this.getSelectedGroupName();
            defaultRecordWrapperArray = this.getGroupRecords(string2);
            string = ResourceLoader.getDisplay("msg.moveentrygroup");
        } else {
            string2 = "";
            defaultRecordWrapperArray = this.getSelectedRecords();
            string = ResourceLoader.getDisplay("msg.moveentryset");
        }
        DefaultRecordWrapper[] defaultRecordWrapperArray2 = Util.cloneRecordWrappers(defaultRecordWrapperArray);
        if (defaultRecordWrapperArray.length != 0) {
            Component[] componentArray;
            List list = this.getGroupList();
            string = Util.substituteText(string, "$count", String.valueOf(defaultRecordWrapperArray.length));
            JComboBox<Object> jComboBox = new JComboBox<Object>(list.toArray());
            jComboBox.setEditable(true);
            String string3 = ResourceLoader.getCommand("combo.select.group");
            jComboBox.insertItemAt(string3, 0);
            jComboBox.setSelectedIndex(0);
            if (!bl) {
                jCheckBox = new JCheckBox(ResourceLoader.getDisplay("dlg.input.keepgrouppaths"));
                componentArray = new Component[]{jComboBox, jCheckBox};
            } else {
                componentArray = new Component[]{jComboBox};
            }
            int n = GUIService.userCombiInput(null, "dlg.input.moveentries", string, componentArray);
            if (n == 0) {
                try {
                    final String string4 = (String)jComboBox.getSelectedItem();
                    if (!string4.equals(string3)) {
                        int n2;
                        this.clearSelection();
                        if (bl) {
                            this.moveGroup(string2, string4);
                            n2 = 5;
                        } else {
                            this.setExpandedBranch(string4, true);
                            this.moveEntries(defaultRecordWrapperArray, string4, jCheckBox.isSelected());
                            n2 = 2;
                        }
                        UndoManager.ModifyRecordEdit modifyRecordEdit = new UndoManager.ModifyRecordEdit(n2, (PwsFileSocket)this, defaultRecordWrapperArray2, defaultRecordWrapperArray, string2, string4);
                        this.fireEditEvent(modifyRecordEdit);
                        Runnable runnable = new Runnable(){

                            public void run() {
                                if (bl) {
                                    PwsFileContainer.this.setExpandedBranch(string4, true);
                                }
                                PwsFileContainer.this.viewHandler.setSelectedWrappers(defaultRecordWrapperArray);
                                PwsFileContainer.this.viewHandler.scrollToVisible(PwsFileContainer.this.getOrderedList().indexOf(defaultRecordWrapperArray[defaultRecordWrapperArray.length - 1]));
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (Exception exception) {
                    GUIService.warningMessage(null, null, exception.toString());
                }
            }
        }
    }

    public void selectRecords() {
        String string = this.getSelectedGroupName();
        if (string == null) {
            string = "";
        }
        this.viewHandler.setSelectedWrappers(this.getGroupRecords(string));
    }

    protected void reportPropertyChange(int n) {
        super.reportPropertyChange(n);
        switch (n) {
            case 1: {
                this.fireChangeEvent(1);
                break;
            }
            case 2: {
                this.fireChangeEvent(2);
                break;
            }
            case 3: {
                if (this.viewType != this.reportedViewType) {
                    this.fireChangeEvent(3);
                }
                this.reportedViewType = this.viewType;
            }
        }
    }

    public void recordUsed(PwsRecord pwsRecord) {
        if (!this.getPwsFile().contains(pwsRecord)) {
            return;
        }
        this.lastUsedEntries.pushRecent(pwsRecord);
        this.reportPropertyChange(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        PwsRecord pwsRecord;
        String string = actionEvent.getActionCommand();
        if (this.editDialog == null || (pwsRecord = this.editDialog.getRecord()) == null) {
            return;
        }
        try {
            if (string.equals("dialog.action.ok")) {
                if (actionEvent.getID() == 0) {
                    if (this.editDialog.recordModified()) {
                        this.updateRecord(pwsRecord);
                        this.random = pwsRecord.getSignature();
                        if (this.editDialog.dataModified()) {
                            UndoManager.ModifyRecordEdit modifyRecordEdit = new UndoManager.ModifyRecordEdit(0, (PwsFileSocket)this, this.editDialog.getInitRecord(), pwsRecord);
                            this.fireEditEvent(modifyRecordEdit);
                            this.lastEditedEntries.pushRecent(pwsRecord);
                            GUIService.statusConfirm("msg.confirm.modifyrec", pwsRecord.getTitle());
                            this.fileUpdated();
                        }
                    }
                } else if (actionEvent.getID() == 1) {
                    this.addRecord(pwsRecord);
                    UndoManager.ModifyRecordEdit modifyRecordEdit = new UndoManager.ModifyRecordEdit(1, (PwsFileSocket)this, null, pwsRecord);
                    this.fireEditEvent(modifyRecordEdit);
                    this.random = pwsRecord.getSignature();
                    this.lastEditedEntries.pushRecent(pwsRecord);
                    GUIService.statusConfirm("msg.confirm.newrec", pwsRecord.getTitle());
                    this.fileUpdated();
                }
            } else if (string.equals("dialog.action.cancel") && actionEvent.getID() == 0 && this.editDialog.recordModified() & !this.editDialog.dataModified()) {
                this.updateRecord(pwsRecord);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GUIService.failureMessage("dlg.operfailure", exception);
        }
        finally {
            this.editDialog = null;
            pwsRecord = null;
        }
    }

    public void setFont(Font font) {
        this.treeHandler.setFont(font);
        this.tableHandler.setFont(font);
    }

    private static class EventReporter
    implements ChangeListener {
        private EventReporter() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = ((PwsFileSocket.ChangeEvent)changeEvent).getState();
            PwsFileContainer pwsFileContainer = (PwsFileContainer)changeEvent.getSource();
            String string = "?";
            String string2 = "?";
            if (n == 5 | n == 4) {
                return;
            }
            if (n == 1) {
                int n2 = pwsFileContainer.getOperationMode();
                string = "OPERATION MODE";
                string2 = n2 == 0 ? "UNMOUNTED" : (n2 == 1 ? "MOUNTED_PASSIVE" : "MOUNTED_ACTIVE");
            } else if (n == 2) {
                int n3 = pwsFileContainer.getSelectionStatus();
                string = "SELECTION STATUS";
                string2 = n3 == 0 ? "NOTHING" : (n3 == 2 ? "RECORD" : "GROUP");
            } else if (n == 3) {
                int n4 = pwsFileContainer.getViewType();
                string = "DISPLAY MODE";
                string2 = n4 == 0 ? "NO VIEW" : (n4 == 2 ? "TABLE" : "TREE");
            }
            System.out.println("+++ New Container State: " + string + " == " + string2);
        }
    }

    private class RecentEntryList
    extends RecentList {
        public RecentEntryList(int n) {
            super("edit.recent", n);
        }

        public void setContent(String string) {
            this.clear();
            String[] stringArray = Util.CSV.decodeLine(string, 0, ';');
            for (int i = Math.min(stringArray.length, this.maxEntries); i > 0; --i) {
                try {
                    String string2 = stringArray[i - 1];
                    UUID uUID = new UUID(string2);
                    if (PwsFileContainer.this.getRecord(uUID) == null) continue;
                    this.pushRecent(string2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void pushRecent(PwsRecord pwsRecord) {
            super.pushRecent(pwsRecord.getRecordID().toHexString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateMenu(JMenu jMenu) {
            ArrayList arrayList = this.vlist;
            synchronized (arrayList) {
                Iterator iterator = this.iterator();
                jMenu.removeAll();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    if (string2.length() == 0) continue;
                    try {
                        UUID uUID = new UUID(string2);
                        string = PwsFileContainer.this.getRecord(uUID).getTitle();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.setActionCommand(this.command + string2);
                    jMenuItem.addActionListener(ActionHandler.getMainActionListener());
                    jMenu.add(jMenuItem);
                }
            }
        }
    }

    private class FileListener
    implements PwsFileListener {
        private FileListener() {
        }

        public void fileStateChanged(PwsFileEvent pwsFileEvent) {
            switch (pwsFileEvent.getType()) {
                case 8: {
                    PwsFileContainer.this.fireChangeEvent(4);
                    break;
                }
                case 5: {
                    PwsFileContainer.this.fireChangeEvent(3);
                    break;
                }
                case 1: {
                    if (!(PwsFileContainer.this.viewHandler != null & PwsFileContainer.this.getFilteredSize() == 1)) break;
                    PwsFileContainer.this.setScreenView(PwsFileContainer.this.viewHandler.getView());
                    break;
                }
                case 9: {
                    if (PwsFileContainer.this.getFilteredSize() == 0) {
                        PwsFileContainer.this.setEmptyView();
                        break;
                    }
                    if (PwsFileContainer.this.viewHandler == null) break;
                    PwsFileContainer.this.setScreenView(PwsFileContainer.this.viewHandler.getView());
                    break;
                }
                case 4: {
                    PwsFileContainer.this.setEmptyView();
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    if (PwsFileContainer.this.getFilteredSize() != 0) break;
                    PwsFileContainer.this.setEmptyView();
                    break;
                }
            }
        }
    }

    private class ViewportMouseAdapter
    extends MouseAdapter {
        private ViewportMouseAdapter() {
        }

        private void tryPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = MenuHandler.getListviewContextMenu(PwsFileContainer.this);
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            PwsRecord pwsRecord;
            ActionHandler.resetIdleTime();
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1 && (pwsRecord = PwsFileContainer.this.getSelectedRecord()) != null) {
                PwsFileContainer.this.editEntry(pwsRecord);
            }
        }
    }
}

