/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jpws.data.Options;
import org.jpws.front.Global;
import org.jpws.front.MenuHandler;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.StatusBar;
import org.jpws.front.ToolbarHandler;
import org.jpws.front.util.ShowDialogRunnable;
import org.jpws.front.util.Util;

public class PwsafeJ
extends JFrame {
    private ArrayList childWindows = new ArrayList();
    private WindowEar childListener = new WindowEar();
    private StatusBar statusBar;
    private JPanel centerPanel;
    private String winTitleTrunk = "JPasswords - JPWS 0.5.0";
    private boolean idleState;

    public static void main(String[] stringArray) {
        Global.init(stringArray);
        Global.mainFrame = new PwsafeJ();
        Global.autorun();
    }

    public PwsafeJ() throws HeadlessException {
        Rectangle rectangle;
        this.setTitle(this.winTitleTrunk);
        this.statusBar = new StatusBar();
        this.setJMenuBar(MenuHandler.getMenuBar());
        this.centerPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)ToolbarHandler.getToolBar(), "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setDefaultCloseOperation(0);
        this.pack();
        if (Options.isOptionSet("rememberScreen") && (rectangle = Options.getBounds("mainframe")) != null) {
            this.setBounds(rectangle);
        } else {
            this.setSize(new Dimension(480, 300));
            Point point = Util.centreWithin(new Rectangle(this.getToolkit().getScreenSize()), this.getSize());
            this.setLocation(point);
        }
        this.setVisible(true);
    }

    public void setScreenView(Component component) {
        if (component == null) {
            component = new ScreenPanel();
        }
        this.centerPanel.removeAll();
        this.centerPanel.add(component, "Center");
        this.validate();
    }

    public void setTitleFile(PwsFileContainer pwsFileContainer) {
        if (pwsFileContainer != null) {
            this.setTitle(this.winTitleTrunk + " - " + pwsFileContainer.getTitle());
            String string = pwsFileContainer.getCharset();
            String string2 = !string.equalsIgnoreCase("utf-8") ? pwsFileContainer.getFileFormatText() + " - " + string : pwsFileContainer.getFileFormatText();
            this.statusBar.setFormatCell(string2);
            this.statusBar.setRecordCounterCell(String.valueOf(pwsFileContainer.getRecordCount()));
        }
    }

    public void resetDisplay() {
        this.setTitle(this.winTitleTrunk);
        this.statusBar.setFormatCell(null);
        this.statusBar.setRecordCounterCell(null);
        this.setScreenView(null);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void exit() {
        Options.setBounds("mainframe", this.getBounds());
        this.statusBar.shutdown();
        this.setVisible(false);
        this.dispose();
    }

    public void iconify() {
        this.setExtendedState(1);
    }

    public boolean getIdleState() {
        return this.idleState;
    }

    public void setIdleState(boolean bl) {
        this.idleState = bl;
        this.setVisible(!bl);
        if (!bl && this.isShowing()) {
            this.setExtendedState(0);
            this.toFront();
        }
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        this.validate();
        PwsFileContainer pwsFileContainer = Global.getSelectedFile();
        if (pwsFileContainer != null) {
            pwsFileContainer.updateUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        ArrayList arrayList = this.childWindows;
        synchronized (arrayList) {
            ShowDialogRunnable.startDialogsLater(this.childWindows);
        }
        super.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildDialog(Dialog dialog) {
        ArrayList arrayList = this.childWindows;
        synchronized (arrayList) {
            if (dialog != null & !this.childWindows.contains(dialog)) {
                this.childWindows.add(dialog);
                dialog.addWindowListener(this.childListener);
            }
        }
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 202: {
                break;
            }
            case 201: {
                Global.exit();
                return;
            }
            case 203: {
                if (this.idleState || !Options.isOptionSet("lockMinimize")) break;
                Global.switchIdleState(true);
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private class ScreenPanel
    extends JPanel {
        private ScreenPanel() {
        }
    }

    private class WindowEar
    extends WindowAdapter {
        private WindowEar() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(WindowEvent windowEvent) {
            ArrayList arrayList = PwsafeJ.this.childWindows;
            synchronized (arrayList) {
                PwsafeJ.this.childWindows.remove(windowEvent.getWindow());
            }
        }
    }
}

