/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jpws.front.util.ResourceLoader;

public class StatusBar
extends JPanel {
    public static final int STATUSTEXTDELAY = 30000;
    public static final int ACTIVE = 1;
    public static final int PASSIVE = 0;
    private JPanel rightPanel;
    private JTextField textField = new JTextField();
    private JLabel activeLabel = new JLabel();
    private JLabel formatLabel = new JLabel();
    private JLabel reccountLabel = new JLabel();
    private Timer statusTimer;
    private TimerTask statusTextRemover;

    public StatusBar() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setFont(this.textField.getFont().deriveFont(0));
        this.add((Component)this.textField, "Center");
        this.textField.setEditable(false);
        this.statusTimer = new Timer(true);
        this.rightPanel = new JPanel(new BorderLayout());
        this.add((Component)this.rightPanel, "East");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)jPanel, "East");
        jPanel.add((Component)this.activeLabel, "East");
        this.activeLabel.setPreferredSize(new Dimension(22, 16));
        this.activeLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.gray), BorderFactory.createEmptyBorder(2, 3, 0, 0)));
        jPanel.add((Component)this.reccountLabel, "Center");
        this.reccountLabel.setVisible(false);
        this.reccountLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.gray), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        this.rightPanel.add((Component)this.formatLabel, "Center");
        this.formatLabel.setVisible(false);
        this.formatLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.gray), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
    }

    public void setMessage(String string) {
        if (this.statusTextRemover != null) {
            this.statusTextRemover.cancel();
        }
        this.statusTextRemover = new TimerTask(){

            public void run() {
                StatusBar.this.setTextConsolidated(null);
            }
        };
        this.statusTimer.schedule(this.statusTextRemover, 30000L);
        string = string == null ? "" : ResourceLoader.codeOrRealDisplay(string);
        this.setTextConsolidated(string);
    }

    private void setTextConsolidated(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                StatusBar.this.textField.setText(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setFormatCell(String string) {
        if (string == null) {
            this.formatLabel.setVisible(false);
        } else {
            this.formatLabel.setText(string);
            this.formatLabel.setVisible(true);
        }
    }

    public void setRecordCounterCell(String string) {
        if (string == null) {
            this.reccountLabel.setVisible(false);
        } else {
            this.reccountLabel.setText(string);
            this.reccountLabel.setVisible(true);
        }
    }

    public void setActivity(int n) {
        ImageIcon imageIcon = n == 1 ? ResourceLoader.getImageIcon("activity") : null;
        this.activeLabel.setIcon(imageIcon);
    }

    public void shutdown() {
        this.statusTimer.cancel();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (font != null & this.reccountLabel != null) {
            this.reccountLabel.setFont(font);
            this.formatLabel.setFont(font);
            this.textField.setFont(font);
        }
    }
}

