/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Component;
import java.awt.Font;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jpws.data.Options;
import org.jpws.front.ActionHandler;
import org.jpws.front.ContainerView;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.ResourceLoader;
import org.jpws.pwslib.order.Collatable;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.order.OrderedListEvent;
import org.jpws.pwslib.order.OrderedListListener;
import org.jpws.pwslib.order.OrderedRecordList;

public class TreeHandler
implements TreeSelectionListener,
ContainerView,
OrderedListListener {
    private JTree tree;
    private DefaultTreeModel treeModel;
    private PwsTreeNode rootNode;
    private PwsFileContainer owner;
    private OrderedRecordList sortList;
    private DefaultTreeCellRenderer renderer;

    public TreeHandler(PwsFileContainer pwsFileContainer) {
        this.owner = pwsFileContainer;
        this.init();
    }

    private void init() {
        this.sortList = this.owner.getOrderedList();
        this.sortList.addOrderedListListener(this);
        this.treeModel = new DefaultTreeModel(null);
        this.tree = new JTree(this.treeModel);
        this.renderer = new TreeCellRenderer();
        this.renderer.setLeafIcon(ResourceLoader.getImageIcon("treeleaf-pass"));
        this.tree.setCellRenderer(this.renderer);
        this.tree.setBorder(new EmptyBorder(3, 6, 3, 0));
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(this.owner.getMouseAdapter());
        this.tree.setExpandsSelectedPaths(true);
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(65, 2), "none");
        this.tree.getInputMap().put(KeyStroke.getKeyStroke(88, 2), "none");
        this.rootNode = this.createTree(this.sortList);
        this.treeModel.setRoot(this.rootNode);
    }

    public void destruct() {
        this.owner = null;
        this.rootNode = null;
        this.tree = null;
        this.treeModel = null;
        this.sortList = null;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public boolean hasUserSelection() {
        return this.getSelectedNode() != null;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    private PwsTreeNode findItemNode(int n) {
        if (n > -1 && n < this.owner.getOrderedList().size()) {
            DefaultRecordWrapper defaultRecordWrapper = this.owner.getOrderedList().getItemAt(n);
            return this.findItemNode(defaultRecordWrapper);
        }
        return null;
    }

    private PwsTreeNode findItemNode(DefaultRecordWrapper defaultRecordWrapper) {
        if (defaultRecordWrapper != null) {
            PwsTreeNode pwsTreeNode = (PwsTreeNode)this.treeModel.getRoot();
            Enumeration<TreeNode> enumeration = pwsTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                pwsTreeNode = (PwsTreeNode)enumeration.nextElement();
                Object object = pwsTreeNode.getUserObject();
                if (!(object instanceof DefaultRecordWrapper) || !((DefaultRecordWrapper)object).equals(defaultRecordWrapper)) continue;
                return pwsTreeNode;
            }
        }
        return null;
    }

    private PwsTreeNode findItemNode(String string) {
        return string == null ? null : this.ensureNode(this.rootNode, string, false);
    }

    private PwsTreeNode createTree(OrderedRecordList orderedRecordList) {
        PwsTreeNode pwsTreeNode = new PwsTreeNode("");
        String string = "";
        PwsTreeNode pwsTreeNode2 = pwsTreeNode;
        for (int i = 0; i < orderedRecordList.size(); ++i) {
            String string2 = string;
            DefaultRecordWrapper defaultRecordWrapper = orderedRecordList.getItemAt(i);
            string = defaultRecordWrapper.getGroup();
            if (!string.equals(string2)) {
                if (string.startsWith(string2 + ".")) {
                    String string3 = string.substring(string2.length() + 1);
                    pwsTreeNode2 = this.ensureNode(pwsTreeNode2, string3, true);
                } else {
                    pwsTreeNode2 = this.ensureNode(pwsTreeNode, string, true);
                }
            }
            pwsTreeNode2.add(new PwsTreeNode(defaultRecordWrapper));
        }
        return pwsTreeNode;
    }

    private void removeNode(PwsTreeNode pwsTreeNode) {
        if (pwsTreeNode == this.rootNode) {
            this.rootNode = null;
            this.treeModel.setRoot(null);
        } else if (pwsTreeNode != null) {
            PwsTreeNode pwsTreeNode2 = (PwsTreeNode)pwsTreeNode.getParent();
            pwsTreeNode2.removeChild(pwsTreeNode);
            if (pwsTreeNode2.getChildCount() == 0) {
                this.removeNode(pwsTreeNode2);
            }
        }
    }

    private PwsTreeNode ensureNode(PwsTreeNode pwsTreeNode, String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split("[.]");
        PwsTreeNode pwsTreeNode2 = pwsTreeNode;
        PwsTreeNode pwsTreeNode3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            pwsTreeNode3 = null;
            if (string2.equals("")) continue;
            Enumeration<TreeNode> enumeration = pwsTreeNode2.children();
            while (enumeration.hasMoreElements()) {
                pwsTreeNode3 = (PwsTreeNode)enumeration.nextElement();
                if (pwsTreeNode3.isDir && pwsTreeNode3.toString().equals(string2)) break;
                pwsTreeNode3 = null;
            }
            if (pwsTreeNode3 == null) {
                if (bl) {
                    pwsTreeNode3 = new PwsTreeNode(new DirectoryObject(string2));
                    pwsTreeNode2.insertDirectory(pwsTreeNode3);
                } else {
                    return null;
                }
            }
            pwsTreeNode2 = pwsTreeNode3;
        }
        return pwsTreeNode2;
    }

    public Component getView() {
        return this.tree;
    }

    public int getFirstSelected() {
        int[] nArray = this.getSelectedItems();
        return nArray.length == 0 ? -1 : nArray[0];
    }

    private int indexForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        if (defaultMutableTreeNode == null || !((object = defaultMutableTreeNode.getUserObject()) instanceof DefaultRecordWrapper)) {
            return -1;
        }
        return this.owner.getOrderedList().indexOf((DefaultRecordWrapper)object);
    }

    public int[] getSelectedItems() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        int[] nArray = treePathArray != null ? new int[treePathArray.length] : new int[]{};
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            int n2 = this.indexForNode(defaultMutableTreeNode);
            if (n2 <= -1) continue;
            nArray[n++] = n2;
        }
        if (n == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public void setSelectedIndex(int n) {
        int[] nArray = null;
        if (n > -1) {
            nArray = new int[]{n};
        }
        this.setSelectedItems(nArray);
    }

    public DefaultRecordWrapper[] getSelectedWrappers() {
        int[] nArray = this.getSelectedItems();
        DefaultRecordWrapper[] defaultRecordWrapperArray = new DefaultRecordWrapper[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            defaultRecordWrapperArray[i] = this.sortList.getItemAt(nArray[i]);
        }
        return defaultRecordWrapperArray;
    }

    public void setSelectedWrappers(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        int n = defaultRecordWrapperArray == null ? 0 : defaultRecordWrapperArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.sortList.indexOf(defaultRecordWrapperArray[i]);
        }
        this.setSelectedItems(nArray);
    }

    public void setExpanded(String string, boolean bl) {
        PwsTreeNode pwsTreeNode;
        if (string != null && (pwsTreeNode = this.findItemNode(string)) != null) {
            TreePath treePath = new TreePath(pwsTreeNode.getPath());
            if (bl) {
                this.tree.expandPath(treePath);
            }
            for (int i = 0; i < pwsTreeNode.dirCount; ++i) {
                DirectoryObject directoryObject = (DirectoryObject)((PwsTreeNode)pwsTreeNode.getChildAt(i)).getUserObject();
                String string2 = string + "." + directoryObject.name;
                this.setExpanded(string2, bl);
            }
            if (!bl) {
                this.tree.collapsePath(treePath);
            }
            if (pwsTreeNode == this.rootNode) {
                this.tree.expandPath(treePath);
                this.setSelectedIndex(-1);
            }
        }
    }

    private TreePath pathForIndex(int n) {
        PwsTreeNode pwsTreeNode = this.findItemNode(n);
        if (pwsTreeNode != null) {
            return new TreePath(pwsTreeNode.getPath());
        }
        return null;
    }

    public void setSelectedItems(int[] nArray) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        this.tree.clearSelection();
        if (nArray != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                TreePath treePath = this.pathForIndex(nArray[i]);
                if (treePath == null) continue;
                arrayList.add(treePath);
            }
            TreePath[] treePathArray = arrayList.toArray(new TreePath[0]);
            this.tree.setSelectionPaths(treePathArray);
            if (treePathArray.length > 0) {
                this.tree.scrollRowToVisible(this.tree.getSelectionRows()[0]);
            }
        }
    }

    public void setSelectAll() {
        int n = this.owner.getOrderedList().size();
        if (n > 0) {
            this.tree.clearSelection();
            for (int i = 0; i < n; ++i) {
                this.tree.addSelectionPath(this.pathForIndex(i));
            }
        }
    }

    public void scrollToVisible(int n) {
        this.tree.scrollRowToVisible(this.tree.getRowForPath(this.pathForIndex(n)));
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.isAddedPath()) {
            this.controlSelection(treeSelectionEvent);
        }
        this.owner.reportPropertyChange(2);
        ActionHandler.resetIdleTime();
    }

    private void controlSelection(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray;
        boolean bl;
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
        TreePath[] treePathArray2 = treeSelectionEvent.getPaths();
        if (this.tree.getSelectionCount() == 1) {
            return;
        }
        if (treePath == null) {
            treePath = treePathArray2[0];
        }
        boolean bl2 = bl = !((DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf();
        if (bl) {
            treePathArray = treePathArray2;
        } else {
            for (int i = 0; i < treePathArray2.length; ++i) {
                TreePath treePath2 = treePathArray2[i];
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
                if (defaultMutableTreeNode.isLeaf()) continue;
                arrayList.add(treePath2);
            }
            treePathArray = arrayList.toArray(new TreePath[arrayList.size()]);
        }
        this.tree.removeSelectionPaths(treePathArray);
    }

    public void orderedListPerformed(final OrderedListEvent orderedListEvent) {
        Runnable runnable = new Runnable(){
            PwsTreeNode node;
            PwsTreeNode parent;
            int eventType;

            public void run() {
                this.eventType = orderedListEvent.getType();
                if (this.eventType == 4) {
                    TreeHandler.this.rootNode = TreeHandler.this.createTree((OrderedRecordList)orderedListEvent.getSource());
                    TreeHandler.this.treeModel.setRoot(TreeHandler.this.rootNode);
                    TreeHandler.this.tree.validate();
                    if (Options.isOptionSet("autoExpandTree")) {
                        TreeHandler.this.setExpanded("", true);
                    }
                } else if (this.eventType == 3) {
                    TreeHandler.this.rootNode = null;
                    TreeHandler.this.treeModel.setRoot(null);
                    TreeHandler.this.tree.validate();
                } else if (this.eventType == 2) {
                    this.node = TreeHandler.this.findItemNode(orderedListEvent.getRecord());
                    TreeHandler.this.removeNode(this.node);
                } else if (this.eventType == 1) {
                    if (TreeHandler.this.rootNode == null) {
                        TreeHandler.this.rootNode = TreeHandler.this.createTree((OrderedRecordList)orderedListEvent.getSource());
                        TreeHandler.this.treeModel.setRoot(TreeHandler.this.rootNode);
                        TreeHandler.this.tree.validate();
                    } else {
                        DefaultRecordWrapper defaultRecordWrapper = orderedListEvent.getRecord();
                        this.parent = TreeHandler.this.ensureNode(TreeHandler.this.rootNode, defaultRecordWrapper.getRecord().getGroup(), true);
                        this.parent.insertLeaf(new PwsTreeNode(defaultRecordWrapper));
                    }
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void reconstruct() {
        this.sortList = this.owner.getOrderedList();
        this.sortList.addOrderedListListener(this);
        this.sortList.loadDatabase(this.owner.getPwsFile(), Options.getLongOption("expireScope"));
    }

    public void repaint() {
        PwsTreeNode pwsTreeNode = (PwsTreeNode)this.treeModel.getRoot();
        Enumeration<TreeNode> enumeration = pwsTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            this.treeModel.nodeChanged((PwsTreeNode)enumeration.nextElement());
        }
        this.tree.invalidate();
        this.tree.repaint();
    }

    public void updateUI() {
    }

    public void setFont(Font font) {
        this.renderer.setFont(font);
        this.tree.setFont(font);
    }

    public void setDeleteKeyEnabled(boolean bl) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        if (bl) {
            this.tree.getInputMap().put(keyStroke, "DELETE_RECS");
            this.tree.getActionMap().put("DELETE_RECS", ActionHandler.getAction("DELETE"));
        } else {
            this.tree.getInputMap().put(keyStroke, "DONOTHING");
        }
    }

    private class DirectoryObject
    implements Collatable {
        protected String name;
        protected CollationKey key;

        public DirectoryObject(String string) {
            this.name = string;
            this.key = Collator.getInstance().getCollationKey(string);
        }

        public CollationKey getCollationKey() {
            return this.key;
        }

        public String toString() {
            return this.name;
        }
    }

    private class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        public TreeCellRenderer() {
            Font font = UIManager.getFont("Tree.font");
            this.setFont(font);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            int n2;
            DefaultRecordWrapper defaultRecordWrapper;
            int n3;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object == null) {
                return this;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getUserObject() instanceof DefaultRecordWrapper && (n3 = (defaultRecordWrapper = (DefaultRecordWrapper)defaultMutableTreeNode.getUserObject()).getExpiry()) > 0 | (n2 = defaultRecordWrapper.getImportStatus()) > 0) {
                String string = "treeleaf-pass";
                if (n2 == 1) {
                    string = "treeleaf-pass-imported";
                } else if (n2 == 2) {
                    string = "treeleaf-pass-importedconflict";
                } else if (n3 == 1) {
                    string = "treeleaf-pass-expired";
                } else if (n3 == 2) {
                    string = "treeleaf-pass-expiresoon";
                }
                this.setIcon(ResourceLoader.getImageIcon(string));
            }
            return this;
        }
    }

    public class PwsTreeNode
    extends DefaultMutableTreeNode {
        boolean isDir;
        int dirCount;

        public PwsTreeNode(Object object) {
            super(object);
        }

        public void insertDirectory(PwsTreeNode pwsTreeNode) {
            PwsTreeNode pwsTreeNode2;
            int n;
            for (n = 0; n < this.dirCount && pwsTreeNode.compareTo(pwsTreeNode2 = (PwsTreeNode)this.getChildAt(n)) >= 0; ++n) {
            }
            TreeHandler.this.treeModel.insertNodeInto(pwsTreeNode, this, n);
            pwsTreeNode.isDir = true;
            ++this.dirCount;
        }

        public void insertLeaf(PwsTreeNode pwsTreeNode) {
            PwsTreeNode pwsTreeNode2;
            int n;
            if (!pwsTreeNode.isLeaf()) {
                throw new IllegalArgumentException();
            }
            for (n = this.dirCount; n < this.getChildCount() && pwsTreeNode.compareTo(pwsTreeNode2 = (PwsTreeNode)this.getChildAt(n)) >= 0; ++n) {
            }
            TreeHandler.this.treeModel.insertNodeInto(pwsTreeNode, this, n);
        }

        public void removeChild(PwsTreeNode pwsTreeNode) {
            int n = this.getIndex(pwsTreeNode);
            if (n == -1) {
                return;
            }
            if (n < this.dirCount) {
                --this.dirCount;
            }
            TreeHandler.this.treeModel.removeNodeFromParent(pwsTreeNode);
        }

        public String getPathName() {
            TreeNode[] treeNodeArray = this.getPath();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < treeNodeArray.length; ++i) {
                stringBuffer.append(treeNodeArray[i]);
                stringBuffer.append(".");
            }
            String string = stringBuffer.toString();
            return string.substring(1, string.length() - 1);
        }

        public int compareTo(PwsTreeNode pwsTreeNode) {
            return ((Collatable)this.getUserObject()).getCollationKey().compareTo(((Collatable)pwsTreeNode.getUserObject()).getCollationKey());
        }
    }
}

