/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ButtonBar
extends JPanel {
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 1;
    public static final int CENTRE = 2;
    public static final int CENTER = 2;
    public static final int HORIZONTAL = 3;
    public static final int VERTICAL = 4;
    private JPanel buttonPanel;

    public ButtonBar() {
        this(3, 2);
    }

    public ButtonBar(int n, int n2) {
        this(n, n2, new Insets(12, 0, 6, 0));
    }

    public ButtonBar(int n, int n2, Insets insets) {
        GridLayout gridLayout;
        if (n == 3) {
            gridLayout = new GridLayout(1, 0, 8, 0);
        } else if (n == 4) {
            gridLayout = new GridLayout(0, 1, 0, 4);
        } else {
            throw new IllegalArgumentException();
        }
        if (n2 != 0 && n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException();
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.buttonPanel = new JPanel(gridLayout);
        this.buttonPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (n2 == 2 || n2 == 1) {
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.spacerPanel(10, 10), gridBagConstraints);
        }
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.buttonPanel, gridBagConstraints);
        if (n2 == 2 || n2 == 0) {
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.spacerPanel(10, 10), gridBagConstraints);
        }
        super.setBorder(new EmptyBorder(insets));
        super.add(jPanel);
    }

    private JPanel spacerPanel(int n, int n2) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setPreferredSize(new Dimension(n, n2));
        return jPanel;
    }

    public Component add(Component component) {
        return this.buttonPanel.add(component);
    }

    public Component add(Component component, int n) {
        return this.buttonPanel.add(component, n);
    }

    public void remove(Component component) {
        this.buttonPanel.remove(component);
    }

    public void remove(int n) {
        this.buttonPanel.remove(n);
    }

    public void removeAll() {
        this.buttonPanel.removeAll();
    }

    public void setBackground(Color color) {
        Component[] componentArray;
        super.setBackground(color);
        if (this.buttonPanel != null && (componentArray = this.buttonPanel.getComponents()) != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setBackground(color);
            }
        }
    }
}

