/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jpws.data.PersistentOptions;
import org.jpws.front.Global;
import org.jpws.front.util.AutomoveAdapter;
import org.jpws.front.util.ButtonBarListener;
import org.jpws.front.util.DialogButtonBar;
import org.jpws.front.util.ShowDialogRunnable;
import org.jpws.front.util.Util;
import org.jpws.front.util.VerticalFlowLayout;

public class ButtonBarDialog
extends JDialog {
    protected ArrayList childWindows = new ArrayList();
    private AutomoveAdapter moveAdapter;
    private Component owner;
    private JPanel dlgPanel;
    private Component prevPanel;
    private VerticalFlowLayout flowLayout;
    private DialogButtonBar buttonbar;
    private String singletonName;

    public ButtonBarDialog() throws HeadlessException {
        super(Global.getActiveFrame());
        this.init(this.getOwner(), null, 3);
    }

    public ButtonBarDialog(Dialog dialog, int n, boolean bl) throws HeadlessException {
        super(dialog, bl);
        this.init(dialog, null, n);
    }

    public ButtonBarDialog(Dialog dialog, JPanel jPanel, int n, boolean bl) throws HeadlessException {
        super(dialog, bl);
        this.init(dialog, jPanel, n);
    }

    public ButtonBarDialog(Frame frame, int n, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.init(frame, null, n);
    }

    public ButtonBarDialog(Frame frame, JPanel jPanel, int n, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.init(frame, jPanel, n);
    }

    private void init(Component component, JPanel jPanel, int n) {
        this.setResizable(false);
        this.owner = component;
        if (component instanceof ButtonBarDialog) {
            ((ButtonBarDialog)component).childWindows.add(this);
        }
        this.buildCentrePanel(jPanel);
        this.buildButtonPanel(n);
        this.pack();
        Util.centreWithin(component, this);
    }

    public void dispose() {
        super.dispose();
        if (this.singletonName != null) {
            Global.setDialogActive(this.singletonName, false);
        }
        if (this.owner instanceof ButtonBarDialog) {
            ((ButtonBarDialog)this.owner).childWindows.remove(this);
        }
        if (this.buttonbar != null) {
            this.buttonbar.destruct();
        }
        if (this.moveAdapter != null) {
            this.moveAdapter.release();
        }
    }

    public void joinButtonThreads() {
        if (this.buttonbar != null) {
            this.buttonbar.joinButtonThreads();
        }
    }

    public void setButtonBarListener(ButtonBarListener buttonBarListener) {
        if (this.buttonbar != null) {
            this.buttonbar.setButtonBarListener(buttonBarListener);
        }
    }

    public DialogButtonBar getButtonBar() {
        return this.buttonbar;
    }

    public JPanel getDialogPanel() {
        return this.dlgPanel;
    }

    public void setDialogPanel(JPanel jPanel) {
        this.buildCentrePanel(jPanel);
        this.pack();
        Util.centreWithin(this.getOwner(), this);
    }

    public void setBarGap(int n) {
        ((BorderLayout)this.getContentPane().getLayout()).setVgap(n);
    }

    private void buildButtonPanel(int n) {
        if (n > 0) {
            this.setButtonBar(new DialogButtonBar(n));
        }
    }

    public void setButtonBar(DialogButtonBar dialogButtonBar) {
        if (this.buttonbar != null) {
            this.getContentPane().remove(this.buttonbar);
            this.buttonbar.destruct();
            this.buttonbar = null;
        }
        if (dialogButtonBar != null) {
            this.buttonbar = dialogButtonBar;
            this.getContentPane().add((Component)this.buttonbar, "South");
            this.getRootPane().setDefaultButton(this.buttonbar.getOkButton());
        }
        if (this.isShowing()) {
            this.validate();
        }
    }

    private void buildCentrePanel(JPanel jPanel) {
        this.flowLayout = new VerticalFlowLayout();
        if (jPanel != null) {
            this.dlgPanel = jPanel;
        } else {
            this.dlgPanel = new JPanel(this.flowLayout);
            this.dlgPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 0, 20));
        }
        if (this.prevPanel != null) {
            this.getContentPane().remove(this.prevPanel);
        }
        this.getContentPane().add((Component)this.dlgPanel, "Center");
        this.prevPanel = this.dlgPanel;
    }

    public void moveRelatedTo(Component component) {
        if (this.moveAdapter != null) {
            this.moveAdapter.release();
        }
        if (component != null) {
            this.moveAdapter = new AutomoveAdapter(component, this);
        }
    }

    public void storeBounds(PersistentOptions persistentOptions, String string, boolean bl) {
        Rectangle rectangle = this.getBounds();
        if (bl) {
            Rectangle rectangle2 = this.getParent().getBounds();
            rectangle.translate(-rectangle2.x, -rectangle2.y);
        }
        persistentOptions.setBounds(string, rectangle);
    }

    public boolean gainBounds(PersistentOptions persistentOptions, String string, boolean bl) {
        Rectangle rectangle = persistentOptions.getBounds(string);
        if (rectangle != null) {
            if (bl) {
                Rectangle rectangle2 = this.getParent().getBounds();
                rectangle.translate(rectangle2.x, rectangle2.y);
            }
            this.setBounds(rectangle);
            return true;
        }
        return false;
    }

    public void gainLocation(PersistentOptions persistentOptions, String string, boolean bl) {
        Rectangle rectangle = persistentOptions.getBounds(string);
        if (rectangle != null) {
            if (bl) {
                Rectangle rectangle2 = this.getParent().getBounds();
                rectangle.translate(rectangle2.x, rectangle2.y);
            }
            this.setLocation(rectangle.getLocation());
        }
    }

    public boolean isOkPressed() {
        return this.buttonbar == null ? false : this.buttonbar.isOkPressed();
    }

    public boolean isCancelPressed() {
        return this.buttonbar == null ? false : this.buttonbar.isCancelPressed();
    }

    public boolean isUnselected() {
        return !this.isOkPressed() & !this.isCancelPressed();
    }

    public void show() {
        ShowDialogRunnable.startDialogsLater(this.childWindows);
        super.show();
    }

    public boolean markSingleton(String string) {
        if (Global.isDialogActive(string)) {
            return false;
        }
        Global.setDialogActive(string, true);
        this.singletonName = string;
        return true;
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                if (this.buttonbar == null) break;
                JButton jButton = this.buttonbar.getCancelButton();
                if (jButton == null) {
                    jButton = this.buttonbar.getOkButton();
                }
                this.buttonbar.performButton(jButton);
            }
        }
        super.processWindowEvent(windowEvent);
    }
}

