/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.Util;

public class FontChooser
extends ButtonBarDialog {
    private static final String[] STYLES = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    private static final String[] SIZES = new String[]{"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "27", "30", "34", "39", "45", "51", "60"};
    private NwList _styleList;
    private NwList _fontList;
    private NwList _sizeList;
    private JLabel _sampleText = new JLabel();

    private FontChooser(Frame frame, Font font) {
        super(frame, 3, true);
        String string;
        this.initAll();
        if (font == null) {
            font = this._sampleText.getFont();
        }
        if ((string = font.getFamily()).equals("dialog")) {
            string = "Dialog";
        }
        this._fontList.setSelectedItem(string);
        this._sizeList.setSelectedItem(String.valueOf(font.getSize()));
        this._styleList.setSelectedItem(STYLES[font.getStyle()]);
        Util.centreWithin(frame, this);
    }

    public static Font showDialog(Frame frame, Component component, String string, Font font) {
        FontChooser fontChooser = new FontChooser(frame, font);
        if (component != null) {
            Util.centreWithin(component, fontChooser);
        }
        fontChooser.setTitle(string);
        fontChooser.setVisible(true);
        Font font2 = null;
        if (fontChooser.isOkPressed()) {
            font2 = fontChooser.getFont();
        }
        return font2;
    }

    public static Font showDialog(Frame frame, Component component) {
        return FontChooser.showDialog(frame, component, "Font Chooser", null);
    }

    private void initAll() {
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        this._sampleText = new JLabel();
        this._sampleText.setForeground(Color.black);
        this._sampleText.setBorder(BorderFactory.createEmptyBorder(20, 0, 10, 0));
        jPanel.add((Component)this._sampleText, "South");
        this._fontList = new NwList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this._styleList = new NwList(STYLES);
        this._sizeList = new NwList(SIZES);
        JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
        jPanel2.setPreferredSize(new Dimension(400, 250));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
        jPanel2.add((Component)this._fontList, "Center");
        jPanel3.add((Component)this._styleList, "Center");
        jPanel3.add((Component)this._sizeList, "East");
        jPanel2.add((Component)jPanel3, "East");
        this.setDialogPanel(jPanel);
    }

    private void showSample() {
        int n = 0;
        try {
            n = Integer.parseInt(this._sizeList.getSelectedValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string = this._styleList.getSelectedValue();
        int n2 = 0;
        if (string.equalsIgnoreCase("Bold")) {
            n2 = 1;
        }
        if (string.equalsIgnoreCase("Italic")) {
            n2 = 2;
        }
        if (string.equalsIgnoreCase("Bold Italic")) {
            n2 = 3;
        }
        this._sampleText.setFont(new Font(this._fontList.getSelectedValue(), n2, n));
        this._sampleText.setText("Sample Text to be used in this JPasswords Category");
        this._sampleText.setVerticalAlignment(1);
    }

    public Font getFont() {
        return this._sampleText == null ? null : this._sampleText.getFont();
    }

    static /* synthetic */ void access$100(FontChooser fontChooser) {
        fontChooser.showSample();
    }

    public class NwList
    extends JPanel {
        Border border = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        ListCellRenderer cellRenderer = new DefaultListCellRenderer(this){
            private final /* synthetic */ NwList this$1;
            {
                this.this$1 = nwList;
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                jLabel.setBorder(this.this$1.border);
                return jLabel;
            }
        };
        JList jlist;
        JScrollPane scroll;
        JLabel jt;
        String si = " ";

        public NwList(String[] stringArray) {
            this.setLayout(new BorderLayout(0, 3));
            this.jlist = new JList<String>(stringArray);
            this.jlist.setCellRenderer(this.cellRenderer);
            this.scroll = new JScrollPane(this.jlist);
            this.jt = new JLabel();
            this.jt.setBackground(Color.white);
            this.jt.setForeground(Color.black);
            this.jt.setOpaque(true);
            this.jt.setBorder(new JTextField().getBorder());
            this.jt.setFont(this.getFont());
            this.jlist.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ NwList this$1;
                {
                    this.this$1 = nwList;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    String string = (String)this.this$1.jlist.getSelectedValue();
                    this.this$1.jt.setText(string);
                    this.this$1.si = string;
                    FontChooser.access$100(NwList.access$000(this.this$1));
                }
            });
            this.add((Component)this.scroll, "Center");
            this.add((Component)this.jt, "North");
        }

        public String getSelectedValue() {
            return this.si;
        }

        public void setSelectedItem(String string) {
            this.jlist.setSelectedValue(string, false);
            this.jlist.ensureIndexIsVisible(Math.min(this.jlist.getSelectedIndex() + 2, this.jlist.getModel().getSize() - 1));
        }

        static /* synthetic */ FontChooser access$000(NwList nwList) {
            return nwList.FontChooser.this;
        }
    }
}

