/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.crypto;

import java.security.DigestException;

public abstract class HashMac {
    private static final int DEFAULT_BLOCKSIZE = 64;
    private final int blockSize;
    private final int hashSize;
    private final byte[] buf;
    private int bufOff;
    private long byteCount;
    private final int mode;
    private byte[] result;
    protected static final int MODE_MD = 0;
    protected static final int MODE_SHA = 1;
    protected static final int MODE_TIGER = 2;

    protected HashMac(int n, int n2) {
        this(64, n, n2);
    }

    protected HashMac(int n, int n2, int n3) {
        if (n != 64 && n != 128) {
            throw new RuntimeException("blockSize must be 64 or 128!");
        }
        this.blockSize = n;
        this.hashSize = n2;
        this.buf = new byte[n];
        this.bufOff = 0;
        this.byteCount = 0L;
        this.mode = n3;
    }

    protected HashMac(HashMac hashMac) {
        this.blockSize = hashMac.blockSize;
        this.hashSize = hashMac.hashSize;
        this.buf = (byte[])hashMac.buf.clone();
        this.bufOff = hashMac.bufOff;
        this.byteCount = hashMac.byteCount;
        this.mode = hashMac.mode;
        this.result = hashMac.result;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int getDigestLength() {
        return this.hashSize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void update(byte by) {
        if (this.result != null) {
            throw new IllegalStateException("instance used up");
        }
        ++this.byteCount;
        this.buf[this.bufOff++] = by;
        if (this.bufOff == this.blockSize) {
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
    }

    public void update(int n) {
        for (int i = 3; i > -1; --i) {
            this.update((byte)(n >>> i * 8));
        }
    }

    public void update(long l) {
        for (int i = 1; i > -1; --i) {
            this.update((int)(l >>> i * 32));
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3;
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("length overflow");
        }
        if (this.result != null) {
            throw new IllegalStateException("instance used up");
        }
        this.byteCount += (long)n2;
        while (n2 >= (n3 = this.blockSize - this.bufOff)) {
            System.arraycopy(byArray, n, this.buf, this.bufOff, n3);
            this.coreUpdate(this.buf, 0);
            n2 -= n3;
            n += n3;
            this.bufOff = 0;
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
    }

    public void update(char[] cArray) {
        this.update(cArray, 0, cArray.length);
    }

    public void update(char[] cArray, int n, int n2) {
        if (n + n2 > cArray.length) {
            throw new IllegalArgumentException("length overflow");
        }
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            this.update((byte)(c >>> 8));
            this.update((byte)c);
        }
    }

    public void update(String string) {
        this.update(string, 0, string.length());
    }

    public void update(String string, int n, int n2) {
        if (n + n2 > string.length()) {
            throw new IllegalArgumentException("length overflow");
        }
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            this.update((byte)(c >>> 8));
            this.update((byte)c);
        }
    }

    public byte[] digest() {
        byte[] byArray = new byte[this.hashSize];
        this.privateDigest(byArray, 0, this.hashSize);
        return byArray;
    }

    public int readDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 0 || n2 > this.hashSize) {
            throw new DigestException();
        }
        return this.privateDigest(byArray, n, n2);
    }

    private int privateDigest(byte[] byArray, int n, int n2) {
        if (this.result == null) {
            int n3;
            this.buf[this.bufOff++] = this.mode == 2 ? 1 : -128;
            int n4 = this.blockSize == 128 ? 16 : 8;
            int n5 = this.blockSize - n4;
            if (this.bufOff > n5) {
                while (this.bufOff < this.blockSize) {
                    this.buf[this.bufOff++] = 0;
                }
                this.coreUpdate(this.buf, 0);
                this.bufOff = 0;
            }
            while (this.bufOff < n5) {
                this.buf[this.bufOff++] = 0;
            }
            long l = this.byteCount * 8L;
            if (this.blockSize == 128) {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.buf[this.bufOff++] = 0;
                }
            }
            if (this.mode == 1) {
                for (n3 = 56; n3 >= 0; n3 -= 8) {
                    this.buf[this.bufOff++] = (byte)(l >>> n3);
                }
            } else {
                for (n3 = 0; n3 < 64; n3 += 8) {
                    this.buf[this.bufOff++] = (byte)(l >>> n3);
                }
            }
            this.coreUpdate(this.buf, 0);
            this.result = new byte[this.hashSize];
            this.coreDigest(this.result, 0);
        }
        System.arraycopy(this.result, 0, byArray, n, n2);
        return this.hashSize;
    }

    public void finalize() {
        if (this.result != null) {
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = 0;
            }
        }
    }

    public void reset() {
        this.bufOff = 0;
        this.byteCount = 0L;
        this.result = null;
        this.coreReset();
    }

    protected abstract void coreDigest(byte[] var1, int var2);

    protected abstract void coreReset();

    protected abstract void coreUpdate(byte[] var1, int var2);
}

