/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.util.BitSet;
import java.util.Iterator;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.data.RawFieldList;
import org.jpws.pwslib.global.Log;

public class HeaderFieldList
extends RawFieldList {
    private static final BitSet VALIDTYPES = new BitSet();

    public HeaderFieldList() {
    }

    public HeaderFieldList(HeaderFieldList headerFieldList) {
        super(headerFieldList);
    }

    public static boolean isCanonicalField(int n) {
        return VALIDTYPES.get(n);
    }

    public PwsRawField setField(PwsRawField pwsRawField) {
        if (pwsRawField.type == 255) {
            throw new IllegalArgumentException("illegal field type 0xff");
        }
        return super.setField(pwsRawField);
    }

    public void clearUnknownFields() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            PwsRawField pwsRawField = (PwsRawField)iterator.next();
            if (HeaderFieldList.isCanonicalField(pwsRawField.type)) continue;
            iterator.remove();
            Log.debug(7, "(HeaderFieldList.clearUnknownFields) removed UKF: " + pwsRawField.type);
        }
    }

    public int getUnknownFieldCount() {
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (HeaderFieldList.isCanonicalField(((PwsRawField)iterator.next()).type)) continue;
            ++n;
        }
        return n;
    }

    public long getUnknownFieldSize(int n) {
        Iterator iterator = this.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            PwsRawField pwsRawField = (PwsRawField)iterator.next();
            if (HeaderFieldList.isCanonicalField(pwsRawField.type)) continue;
            l += (long)pwsRawField.getBlockedSize(n);
        }
        return l;
    }

    public long blockedDataSize(int n) {
        return super.blockedDataSize(n) + (long)(n == 3 ? 16 : 0);
    }

    static {
        VALIDTYPES.set(0, 11);
        VALIDTYPES.set(255);
        VALIDTYPES.set(64);
    }
}

