/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jpws.pwslib.data.ContextFile;
import org.jpws.pwslib.data.HeaderFieldList;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsFileInputSocket;
import org.jpws.pwslib.data.PwsFileOutputSocket;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsPassphrasePolicy;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.data.PwsRawFieldReader;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.exception.ApplicationFailureException;
import org.jpws.pwslib.exception.DuplicateEntryException;
import org.jpws.pwslib.exception.InvalidPassphraseException;
import org.jpws.pwslib.exception.InvalidPassphrasePolicy;
import org.jpws.pwslib.exception.PasswordSafeException;
import org.jpws.pwslib.exception.UnsupportedFileVersionException;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.persist.ApplicationAdapter;
import org.jpws.pwslib.persist.StreamFactory;

public final class PwsFileFactory {
    public static final int RECIDTYPE = 1;
    public static final int GROUPTYPE = 2;
    public static final int TITLETYPE = 3;
    public static final int UNAMETYPE = 4;
    public static final int NOTESTYPE = 5;
    public static final int PASSWORDTYPE = 6;
    public static final int CREATIMETYPE = 7;
    public static final int PASSMODTIMETYPE = 8;
    public static final int ACCESSTIMETYPE = 9;
    public static final int PASSLIFETIMETYPE = 10;
    public static final int PASSPOLICYTYPE = 11;
    public static final int RECORDMODTIMETYPE = 12;
    public static final int URLTYPE = 13;
    public static final int AUTOTYPETYPE = 14;
    public static final int HISTORYTYPE = 15;
    public static final int ENDBLOCKTYPE = 255;
    public static final int PWF_BLOCKSIZE = 8;
    public static final int DEFAULT_FILEVERSION = 3;
    public static final String V2_VERSION_IDENTTEXT = " !!!Version 2 File Format!!! Please upgrade to PasswordSafe 2.0 or later";
    public static final String UTF_CHARSET = "UTF-8";
    public static final String DEFAULT_CHARSET = Global.getDefaultCharset();
    public static final int DAY = 86400000;
    private static final String SPLITCHAR = "  \u00ad  ";
    private static final byte[] ZEROBYTEARRAY = new byte[0];

    private PwsFileFactory() {
    }

    public static final PwsFile loadFile(String string, PwsPassphrase pwsPassphrase) throws IOException, PasswordSafeException {
        return PwsFileFactory.loadFile(Global.getStandardApplication(), string, pwsPassphrase, 0);
    }

    public static final PwsFile loadFile(ApplicationAdapter applicationAdapter, String string, PwsPassphrase pwsPassphrase) throws IOException, PasswordSafeException {
        return PwsFileFactory.loadFile(applicationAdapter, string, pwsPassphrase, 0);
    }

    public static final PwsFile loadFile(ContextFile contextFile, PwsPassphrase pwsPassphrase, int n) throws IOException, PasswordSafeException {
        return PwsFileFactory.loadFile(contextFile.getAdapter(), contextFile.getFilepath(), pwsPassphrase, n);
    }

    public static final PwsFile loadFile(ContextFile contextFile, PwsPassphrase pwsPassphrase) throws IOException, PasswordSafeException {
        return PwsFileFactory.loadFile(contextFile.getAdapter(), contextFile.getFilepath(), pwsPassphrase, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final PwsFile loadFile(ApplicationAdapter var0, String var1_1, PwsPassphrase var2_2, int var3_3) throws IOException, PasswordSafeException {
        var8_4 = StreamFactory.getInputStream(var0, var1_1);
        var5_5 = new PwsFileInputSocket(var8_4);
        try {
            if (!var5_5.attemptOpen(var2_2, var3_3)) {
                throw new InvalidPassphraseException();
            }
            var10_6 = var5_5.getOptions();
            var14_7 = var5_5.getFileVersion();
            var7_8 = var5_5.getFileUUID();
            var4_9 = new PwsFile(var0, var1_1, var2_2);
            if (var7_8 != null) {
                var4_9.setUUID(var7_8);
            }
            var4_9.setSourceFormat(var14_7);
            var4_9.setSecurityLoops(var5_5.getIterations());
            var4_9.setUserOptions(var10_6);
            var4_9.setHeaderFields(var5_5.getHeaderFields());
            Log.debug(10, "LOADFILE, resulting PWS file format: " + var4_9.getSourceFormat());
            var9_10 = (var14_7 == 3 | var10_6.indexOf("B 24 1") > -1) != false ? "UTF-8" : PwsFileFactory.DEFAULT_CHARSET;
            Log.debug(10, "LOADFILE, PWS file charset: " + var9_10);
            var6_11 = var5_5.getRawFieldReader();
            switch (var14_7) {
                case 1: {
                    PwsFileFactory.readRecordsV1(var4_9, var6_11);
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    PwsFileFactory.readRecordsV23(var4_9, var6_11, var9_10, var14_7);
                    var12_12 = var5_5.getCalcChecksum();
                    var13_13 = var5_5.getReadChecksum();
                    if (var12_12 != null & var13_13 != null) {
                        var4_9.setChecksumResult(Util.equalArrays(var12_12, var13_13));
                        ** break;
                    }
lbl32:
                    // 3 sources

                    break;
                }
                default: {
                    throw new UnsupportedFileVersionException(String.valueOf(var14_7));
                }
            }
        }
        finally {
            var8_4.close();
        }
        Log.log(2, "(PwsFileFactory.loadFile) load of PwsFile complete, UUID = " + var4_9.getUUID().toHexString());
        Log.debug(2, "(PwsFileFactory.loadFile) file contains " + var4_9.getRecordCount() + " records");
        var11_15 = var5_5.getReadChecksum();
        if (var11_15 != null) {
            Log.debug(2, "File HMAC read: " + Util.bytesToHex(var11_15));
        }
        if ((var11_15 = var5_5.getCalcChecksum()) != null) {
            Log.debug(2, "File HMAC calc: " + Util.bytesToHex(var11_15));
        }
        var4_9.resetModified();
        return var4_9;
    }

    private static void readRecordsV23(PwsFile pwsFile, PwsRawFieldReader pwsRawFieldReader, String string, int n) {
        PwsRecord pwsRecord = new PwsRecord(0L);
        pwsRecord.setInitialize(true);
        while (pwsRawFieldReader.hasNext()) {
            PwsRawField pwsRawField = (PwsRawField)pwsRawFieldReader.next();
            switch (pwsRawField.getType()) {
                case 1: {
                    try {
                        pwsRecord.setRecordID(new UUID(pwsRawField.getData()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.error(3, "(PwsFileFactory.readRecordsV2) bad record UUID: " + Util.bytesToHex(pwsRawField.getData()) + "\r\ncreated new UUID: " + pwsRecord);
                        pwsFile.setPreserveOld(true);
                    }
                    break;
                }
                case 255: {
                    try {
                        pwsRecord.setInitialize(false);
                        try {
                            pwsFile.addReadRecord(pwsRecord);
                        }
                        catch (DuplicateEntryException duplicateEntryException) {
                            Log.error(3, "(PwsFileFactory.readRecordsV2) duplicate record (not added): " + pwsRecord);
                            pwsFile.setPreserveOld(true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    pwsRecord = new PwsRecord(0L);
                    pwsRecord.setInitialize(true);
                    break;
                }
                case 2: {
                    pwsRecord.setGroup(pwsRawField.getString(string));
                    break;
                }
                case 3: {
                    pwsRecord.setTitle(pwsRawField.getString(string));
                    break;
                }
                case 4: {
                    PwsPassphrase pwsPassphrase = pwsRawField.getPassphrase(string);
                    pwsRecord.setUsername(pwsPassphrase);
                    pwsPassphrase.clear();
                    break;
                }
                case 5: {
                    PwsPassphrase pwsPassphrase = pwsRawField.getPassphrase(string);
                    pwsRecord.setNotes(pwsPassphrase);
                    pwsPassphrase.clear();
                    break;
                }
                case 6: {
                    PwsPassphrase pwsPassphrase = pwsRawField.getPassphrase(string);
                    pwsRecord.setPassword(pwsPassphrase);
                    pwsPassphrase.clear();
                    break;
                }
                case 11: {
                    byte[] byArray = pwsRawField.getData();
                    try {
                        pwsRecord.setPassPolicy(new PwsPassphrasePolicy(Util.readIntLittle(byArray, 0)));
                    }
                    catch (InvalidPassphrasePolicy invalidPassphrasePolicy) {
                        System.err.println("*** invalid passphrase policy! " + pwsRecord);
                    }
                    break;
                }
                case 10: {
                    pwsRecord.setPassLifeTime(PwsFileFactory.readTimeField(pwsRawField, pwsRecord));
                    break;
                }
                case 8: {
                    pwsRecord.setPassModTime(PwsFileFactory.readTimeField(pwsRawField, pwsRecord));
                    break;
                }
                case 7: {
                    pwsRecord.setCreateTime(PwsFileFactory.readTimeField(pwsRawField, pwsRecord));
                    break;
                }
                case 12: {
                    pwsRecord.setModifyTime(PwsFileFactory.readTimeField(pwsRawField, pwsRecord));
                    break;
                }
                case 9: {
                    pwsRecord.setAccessTime(PwsFileFactory.readTimeField(pwsRawField, pwsRecord));
                    break;
                }
                case 13: {
                    if (n > 2) {
                        pwsRecord.setUrl(pwsRawField.getPassphrase(string));
                        break;
                    }
                    pwsRecord.addUnknownField(pwsRawField.getType(), pwsRawField.getData());
                    break;
                }
                case 15: {
                    if (n > 2) {
                        pwsRecord.setHistory(pwsRawField.getPassphrase(string));
                        break;
                    }
                    pwsRecord.addUnknownField(pwsRawField.getType(), pwsRawField.getData());
                    break;
                }
                case 14: {
                    if (n > 2) {
                        pwsRecord.setAutotype(pwsRawField.getString(string));
                        break;
                    }
                    pwsRecord.addUnknownField(pwsRawField.getType(), pwsRawField.getData());
                    break;
                }
                default: {
                    pwsRecord.addUnknownField(pwsRawField.getType(), pwsRawField.getData());
                }
            }
            pwsRawField.destroy();
        }
    }

    private static void readRecordsV1(PwsFile pwsFile, PwsRawFieldReader pwsRawFieldReader) {
        PwsRecord pwsRecord = null;
        int n = -1;
        int n2 = SPLITCHAR.length();
        while (pwsRawFieldReader.hasNext()) {
            PwsRawField pwsRawField = (PwsRawField)pwsRawFieldReader.next();
            switch (++n % 3) {
                case 0: {
                    pwsRecord = new PwsRecord(0L);
                    String string = pwsRawField.getString(DEFAULT_CHARSET);
                    Log.debug(10, "V1, read TITLE raw: " + Util.bytesToHex(pwsRawField.getData()));
                    int n3 = string.indexOf(SPLITCHAR);
                    if (n3 > -1) {
                        pwsRecord.setTitle(string.substring(0, n3));
                        pwsRecord.setUsername(string.substring(n3 + n2));
                        break;
                    }
                    pwsRecord.setTitle(string);
                    break;
                }
                case 1: {
                    PwsPassphrase pwsPassphrase = pwsRawField.getPassphrase(DEFAULT_CHARSET);
                    pwsRecord.setPassword(pwsPassphrase);
                    pwsPassphrase.clear();
                    break;
                }
                case 2: {
                    PwsPassphrase pwsPassphrase = pwsRawField.getPassphrase(DEFAULT_CHARSET);
                    pwsRecord.setNotes(pwsPassphrase);
                    pwsPassphrase.clear();
                    try {
                        pwsFile.addReadRecord(pwsRecord);
                        break;
                    }
                    catch (DuplicateEntryException duplicateEntryException) {
                        // empty catch block
                    }
                }
            }
            pwsRawField.destroy();
        }
    }

    public static final UUID saveFile(Iterator iterator, String string, PwsPassphrase pwsPassphrase, HeaderFieldList headerFieldList, int n, int n2) throws IOException, ApplicationFailureException {
        return PwsFileFactory.saveFile(iterator, Global.getStandardApplication(), string, pwsPassphrase, headerFieldList, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UUID saveFile(Iterator iterator, ApplicationAdapter applicationAdapter, String string, PwsPassphrase pwsPassphrase, HeaderFieldList headerFieldList, int n, int n2) throws IOException, ApplicationFailureException {
        UUID uUID;
        String string2 = null;
        Log.log(5, "(PwsFileFactory) saveFile mark A0");
        if (applicationAdapter == null | pwsPassphrase == null | string == null) {
            throw new NullPointerException("missing save parameter(s)");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("filepath is empty");
        }
        if (iterator == null) {
            iterator = new ArrayList().iterator();
        }
        Log.log(5, "(PwsFileFactory) saveFile mark A1");
        boolean bl = applicationAdapter.canDelete(string) && applicationAdapter.existsFile(string);
        if (bl) {
            Log.log(5, "(PwsFileFactory) saveFile mark A2");
            string2 = string;
            string = string + ".temp";
        }
        OutputStream outputStream = StreamFactory.getOutputStream(applicationAdapter, string);
        Log.log(5, "(PwsFileFactory) saveFile mark A3");
        try {
            uUID = PwsFileFactory.saveFile(iterator, outputStream, pwsPassphrase, headerFieldList, n, n2);
        }
        finally {
            Log.log(5, "(PwsFileFactory) saveFile mark A4");
            outputStream.close();
        }
        if (bl) {
            Log.log(5, "(PwsFileFactory) saveFile mark A5");
            applicationAdapter.deleteFile(string2);
            if (!applicationAdapter.renameFile(string, string2)) {
                InputStream inputStream = StreamFactory.getInputStream(applicationAdapter, string);
                Log.log(5, "(PwsFileFactory) saveFile mark A6");
                try {
                    outputStream = StreamFactory.getOutputStream(applicationAdapter, string2);
                    Log.log(5, "(PwsFileFactory) saveFile mark A7");
                    Util.copyStream(inputStream, outputStream);
                }
                finally {
                    Log.log(5, "(PwsFileFactory) saveFile mark A8");
                    inputStream.close();
                    outputStream.close();
                }
                Log.log(5, "(PwsFileFactory) saveFile mark A9");
                applicationAdapter.deleteFile(string);
            }
        }
        Log.log(5, "(PwsFileFactory) saveFile mark A10");
        return uUID;
    }

    public static final UUID saveFile(Iterator iterator, ContextFile contextFile, PwsPassphrase pwsPassphrase, HeaderFieldList headerFieldList, int n, int n2) throws IOException, ApplicationFailureException {
        return PwsFileFactory.saveFile(iterator, contextFile.getAdapter(), contextFile.getFilepath(), pwsPassphrase, headerFieldList, n, n2);
    }

    public static final UUID saveFile(Iterator iterator, OutputStream outputStream, PwsPassphrase pwsPassphrase, HeaderFieldList headerFieldList, int n, int n2) throws IOException {
        Log.log(5, "(PwsFileFactory) saveFile mark B0");
        if (pwsPassphrase == null | outputStream == null) {
            throw new NullPointerException("missing save parameter(s)");
        }
        if (n2 == 0) {
            n2 = 3;
        }
        if (iterator == null) {
            iterator = new ArrayList().iterator();
        }
        Log.log(5, "(PwsFileFactory) saveFile mark B1");
        PwsFileOutputSocket pwsFileOutputSocket = new PwsFileOutputSocket(outputStream, pwsPassphrase, headerFieldList, n2);
        Log.log(5, "(PwsFileFactory) saveFile mark B1.1");
        pwsFileOutputSocket.setIterations(n);
        Log.log(5, "(PwsFileFactory) saveFile mark B1.2");
        PwsFileOutputSocket.RawFieldWriter rawFieldWriter = pwsFileOutputSocket.getRawFieldWriter();
        Log.log(5, "(PwsFileFactory) saveFile mark B2");
        switch (n2) {
            case 1: {
                PwsFileFactory.saveRecordsV1(iterator, rawFieldWriter);
                break;
            }
            case 2: {
                String string = headerFieldList == null ? "" : headerFieldList.getStringValue(64);
                String string2 = string.indexOf("B 24 1") > -1 ? UTF_CHARSET : DEFAULT_CHARSET;
                PwsFileFactory.saveRecordsV2(iterator, rawFieldWriter, string2);
                break;
            }
            case 3: {
                PwsFileFactory.saveRecordsV3(iterator, rawFieldWriter);
                break;
            }
            default: {
                throw new IllegalStateException("unknown save format");
            }
        }
        Log.log(5, "(PwsFileFactory) saveFile mark B3");
        pwsFileOutputSocket.close();
        Log.log(5, "(PwsFileFactory) saveFile mark B4");
        return pwsFileOutputSocket.getFileID();
    }

    private static void saveRecordsV2(Iterator iterator, PwsFileOutputSocket.RawFieldWriter rawFieldWriter, String string) throws IOException {
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            if (!pwsRecord.isValid()) continue;
            PwsFileFactory.saveTextFieldV2(3, pwsRecord.getTitle(), rawFieldWriter, string);
            PwsFileFactory.saveTextFieldV2(2, pwsRecord.getGroup(), rawFieldWriter, string);
            PwsFileFactory.savePasswordFieldV2(6, pwsRecord.getPassword(), rawFieldWriter, string);
            PwsFileFactory.savePasswordFieldV2(5, pwsRecord.getNotesPws(), rawFieldWriter, string);
            PwsFileFactory.savePasswordFieldV2(4, pwsRecord.getUsernamePws(), rawFieldWriter, string);
            PwsPassphrasePolicy pwsPassphrasePolicy = pwsRecord.getPassPolicy();
            if (pwsPassphrasePolicy != null) {
                byte[] byArray = new byte[4];
                Util.writeIntLittle(pwsPassphrasePolicy.getIntForm(), byArray, 0);
                PwsFileFactory.saveByteArray(11, byArray, rawFieldWriter);
            }
            PwsFileFactory.saveTimeField(7, pwsRecord.getCreateTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(9, pwsRecord.getAccessTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(12, pwsRecord.getModifiedTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(8, pwsRecord.getPassModTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(10, pwsRecord.getPassLifeTime(), rawFieldWriter);
            PwsFileFactory.saveUnknownFields(pwsRecord, rawFieldWriter);
            PwsFileFactory.saveByteArray(1, pwsRecord.getRecordID().getBytes(), rawFieldWriter);
            PwsFileFactory.saveByteArray(255, ZEROBYTEARRAY, rawFieldWriter);
        }
    }

    private static void saveRecordsV3(Iterator iterator, PwsFileOutputSocket.RawFieldWriter rawFieldWriter) throws IOException {
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            if (!pwsRecord.isValid()) continue;
            PwsFileFactory.saveTextFieldV3(3, pwsRecord.getTitle(), rawFieldWriter);
            PwsFileFactory.saveTextFieldV3(2, pwsRecord.getGroup(), rawFieldWriter);
            PwsFileFactory.savePasswordFieldV3(6, pwsRecord.getPassword(), rawFieldWriter);
            PwsFileFactory.savePasswordFieldV3(5, pwsRecord.getNotesPws(), rawFieldWriter);
            PwsFileFactory.savePasswordFieldV3(4, pwsRecord.getUsernamePws(), rawFieldWriter);
            PwsPassphrasePolicy pwsPassphrasePolicy = pwsRecord.getPassPolicy();
            if (pwsPassphrasePolicy != null) {
                byte[] byArray = new byte[4];
                Util.writeIntLittle(pwsPassphrasePolicy.getIntForm(), byArray, 0);
                PwsFileFactory.saveByteArray(11, byArray, rawFieldWriter);
            }
            PwsFileFactory.savePasswordFieldV3(13, pwsRecord.getUrlPws(), rawFieldWriter);
            PwsFileFactory.saveTextFieldV3(14, pwsRecord.getAutotype(), rawFieldWriter);
            PwsFileFactory.savePasswordFieldV3(15, pwsRecord.getHistoryPws(), rawFieldWriter);
            PwsFileFactory.saveTimeField(7, pwsRecord.getCreateTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(9, pwsRecord.getAccessTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(12, pwsRecord.getModifiedTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(8, pwsRecord.getPassModTime(), rawFieldWriter);
            PwsFileFactory.saveTimeField(10, pwsRecord.getPassLifeTime(), rawFieldWriter);
            PwsFileFactory.saveUnknownFields(pwsRecord, rawFieldWriter);
            PwsFileFactory.saveByteArray(1, pwsRecord.getRecordID().getBytes(), rawFieldWriter);
            PwsFileFactory.saveByteArray(255, ZEROBYTEARRAY, rawFieldWriter);
        }
    }

    private static void saveUnknownFields(PwsRecord pwsRecord, PwsFileOutputSocket.RawFieldWriter rawFieldWriter) throws IOException {
        Iterator iterator = pwsRecord.getUnknownFields();
        if (iterator != null) {
            while (iterator.hasNext()) {
                PwsRawField pwsRawField = (PwsRawField)iterator.next();
                if ((pwsRawField.type & 0xFFFFFF00) == 0 & !PwsFileFactory.isCanonicalField(pwsRawField.type, rawFieldWriter.getFormat())) {
                    PwsFileFactory.saveByteArray(pwsRawField.type, pwsRawField.getData(), rawFieldWriter);
                    if (Log.getDebugLevel() <= 5) continue;
                    String string = "-- saving UNKNOWN FIELD (" + pwsRecord + ") id=" + Util.byteToHex(pwsRawField.type) + ", val=" + Util.bytesToHex(pwsRawField.data);
                    Log.debug(6, string);
                    continue;
                }
                Log.error(3, "(PwsFileFactory.saveRecord) *** Illegal unknown field type: " + pwsRawField.type + " for " + pwsRecord);
            }
        }
    }

    private static void saveRecordsV1(Iterator iterator, PwsFileOutputSocket.RawFieldWriter rawFieldWriter) throws IOException {
        String string = DEFAULT_CHARSET;
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            if (!pwsRecord.isValid()) continue;
            String string2 = pwsRecord.getTitle();
            String string3 = pwsRecord.getUsername();
            if (string3 != null) {
                string2 = string2 + SPLITCHAR + string3;
            }
            PwsFileFactory.saveTextFieldV2(0, string2, rawFieldWriter, string);
            PwsFileFactory.savePasswordFieldV2(0, pwsRecord.getPassword(), rawFieldWriter, string);
            PwsFileFactory.savePasswordFieldV2(0, pwsRecord.getNotesPws(), rawFieldWriter, string);
        }
    }

    public static boolean isCanonicalField(int n, int n2) {
        int n3 = n2 == 0 | n2 >= 3 ? 16 : 13;
        return n > -1 & (n < n3 | n == 255);
    }

    private static void savePasswordFieldV2(int n, PwsPassphrase pwsPassphrase, PwsFileOutputSocket.RawFieldWriter rawFieldWriter, String string) throws IOException {
        if (pwsPassphrase == null) {
            pwsPassphrase = new PwsPassphrase();
        }
        byte[] byArray = pwsPassphrase.getBytes(string);
        PwsFileFactory.saveByteArray(n, byArray, rawFieldWriter);
        Util.destroyBytes(byArray);
    }

    private static void savePasswordFieldV3(int n, PwsPassphrase pwsPassphrase, PwsFileOutputSocket.RawFieldWriter rawFieldWriter) throws IOException {
        if (pwsPassphrase == null || pwsPassphrase.getLength() == 0) {
            return;
        }
        PwsFileFactory.savePasswordFieldV2(n, pwsPassphrase, rawFieldWriter, UTF_CHARSET);
    }

    private static void saveTextFieldV2(int n, String string, PwsFileOutputSocket.RawFieldWriter rawFieldWriter, String string2) throws IOException {
        if (string == null) {
            string = "";
        }
        try {
            byte[] byArray = string.getBytes(string2);
            PwsRawField pwsRawField = new PwsRawField(n, byArray);
            rawFieldWriter.writeRawField(pwsRawField);
            pwsRawField.destroy();
            Util.destroyBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("*** JPWS big trouble! unsupported text encoding: " + string2);
        }
    }

    private static void saveTextFieldV3(int n, String string, PwsFileOutputSocket.RawFieldWriter rawFieldWriter) throws IOException {
        if (string == null || string.equals("")) {
            return;
        }
        PwsFileFactory.saveTextFieldV2(n, string, rawFieldWriter, UTF_CHARSET);
    }

    private static void saveTimeField(int n, long l, PwsFileOutputSocket.RawFieldWriter rawFieldWriter) throws IOException {
        if (l == 0L) {
            return;
        }
        byte[] byArray = new byte[4];
        Util.writeIntLittle((int)(l / 1000L), byArray, 0);
        rawFieldWriter.writeRawField(new PwsRawField(n, byArray));
    }

    private static long readTimeField(PwsRawField pwsRawField, PwsRecord pwsRecord) {
        try {
            return (pwsRawField.length == 4 ? Util.readUIntLittle(pwsRawField.getData(), 0) : Util.readLongLittle(pwsRawField.getData(), 0)) * 1000L;
        }
        catch (Exception exception) {
            Log.error(3, "(PwsFileFactory.readTimeField) *** invalid time data: " + pwsRecord);
            return 0L;
        }
    }

    private static void saveByteArray(int n, byte[] byArray, PwsFileOutputSocket.RawFieldWriter rawFieldWriter) throws IOException {
        if (byArray == null) {
            return;
        }
        PwsRawField pwsRawField = new PwsRawField(n, byArray);
        rawFieldWriter.writeRawField(pwsRawField);
        pwsRawField.destroy();
    }
}

