/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jpws.pwslib.crypto.BlowfishCipher;
import org.jpws.pwslib.crypto.CryptoRandom;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.crypto.SHA1;
import org.jpws.pwslib.data.BlockInputStream;
import org.jpws.pwslib.data.PwsBlockInputStream;
import org.jpws.pwslib.data.PwsFileFactory;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.exception.WrongFileVersionException;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.Util;

class PwsFileHeaderV2 {
    private static final String VERSION_IDENTTEXT = " !!!Version 2 File Format!!! Please upgrade to PasswordSafe 2.0 or later";
    private byte[] randStuff = new byte[8];
    private byte[] randHash = new byte[20];
    private byte[] salt = new byte[20];
    private byte[] ipThing = new byte[8];
    private boolean isRead;
    private InputStream input;
    private BlockInputStream blockStream;
    private String options = "";

    PwsFileHeaderV2() {
    }

    public PwsFileHeaderV2(InputStream inputStream) throws IOException {
        this.input = inputStream;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(this.randStuff);
        dataInputStream.readFully(this.randHash);
        dataInputStream.readFully(this.salt);
        dataInputStream.readFully(this.ipThing);
        this.isRead = true;
        Log.log(5, "(PwsFileHeaderV2) file header read: " + Util.bytesToHex(this.randStuff, 0, this.randStuff.length));
    }

    public PwsBlockInputStream getInputBlockStream() {
        return this.blockStream;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String string) {
        if (string == null) {
            string = "";
        }
        this.options = string;
    }

    public PwsCipher save(OutputStream outputStream, PwsPassphrase pwsPassphrase, String string) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        PwsCipher pwsCipher = this.update(pwsPassphrase);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.setOptions(string);
        dataOutputStream.write(this.randStuff);
        dataOutputStream.write(this.randHash);
        dataOutputStream.write(this.salt);
        dataOutputStream.write(this.ipThing);
        new PwsRawField(0, VERSION_IDENTTEXT.getBytes("ASCII")).writeEncrypted(outputStream, pwsCipher, 2);
        new PwsRawField(6, "2.0".getBytes("ASCII")).writeEncrypted(outputStream, pwsCipher, 2);
        new PwsRawField(5, this.options.getBytes("ISO-8859-1")).writeEncrypted(outputStream, pwsCipher, 2);
        Log.log(5, "(PwsFileHeaderV2) file header saved: " + Util.bytesToHex(this.randStuff, 0, this.randStuff.length));
        return pwsCipher;
    }

    private PwsCipher update(PwsPassphrase pwsPassphrase) {
        if (pwsPassphrase == null) {
            throw new NullPointerException("passphrase missing");
        }
        CryptoRandom cryptoRandom = Util.getCryptoRand();
        this.randStuff = cryptoRandom.nextBytes(this.randStuff.length);
        this.randHash = PwsFileHeaderV2.genRandHash(pwsPassphrase, this.randStuff);
        this.salt = cryptoRandom.nextBytes(this.salt.length);
        this.ipThing = cryptoRandom.nextBytes(this.ipThing.length);
        this.isRead = true;
        return this.makeFileCipher(pwsPassphrase);
    }

    public PwsBlockInputStream verifyPass(PwsPassphrase pwsPassphrase) throws IOException, WrongFileVersionException {
        if (pwsPassphrase == null) {
            throw new NullPointerException("passphrase missing");
        }
        if (!this.isRead) {
            throw new IllegalStateException("header not initialized");
        }
        byte[] byArray = PwsFileHeaderV2.genRandHash(pwsPassphrase, this.randStuff);
        if (Util.equalArrays(this.randHash, byArray)) {
            try {
                PwsCipher pwsCipher = this.makeFileCipher(pwsPassphrase);
                this.blockStream = new BlockInputStream(this.input, pwsCipher);
                PwsRawField pwsRawField = new PwsRawField(this.blockStream, 2);
                String string = pwsRawField.getString("US-ASCII");
                if (string.equals(VERSION_IDENTTEXT)) {
                    pwsRawField = new PwsRawField(this.blockStream, 2);
                    Log.debug(10, "PWS file format ID = " + pwsRawField.getString("US-ASCII"));
                    pwsRawField = new PwsRawField(this.blockStream, 2);
                    this.options = pwsRawField.getString("ISO-8859-1");
                    this.blockStream.resetCounter();
                    return this.blockStream;
                }
                throw new WrongFileVersionException();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return null;
    }

    private PwsCipher makeFileCipher(PwsPassphrase pwsPassphrase) {
        SHA1 sHA1 = new SHA1();
        if (pwsPassphrase == null) {
            throw new NullPointerException("passphrase missing");
        }
        if (!this.isRead) {
            throw new IllegalStateException("header not initialized");
        }
        byte[] byArray = pwsPassphrase.getBytes(PwsFileFactory.DEFAULT_CHARSET);
        sHA1.update(byArray);
        Util.destroyBytes(byArray);
        sHA1.update(this.salt);
        sHA1.finalize();
        BlowfishCipher blowfishCipher = new BlowfishCipher(sHA1.getDigest(), this.ipThing);
        Log.log(7, "(PwsFileHeaderV2) file cipher created for " + pwsPassphrase);
        return blowfishCipher;
    }

    public static byte[] genRandHash(PwsPassphrase pwsPassphrase, byte[] byArray) {
        SHA1 sHA1 = new SHA1();
        byte[] byArray2 = pwsPassphrase.getBytes(PwsFileFactory.DEFAULT_CHARSET);
        byte[] byArray3 = Util.arraycopy(byArray, 10);
        sHA1.update(byArray3);
        sHA1.update(byArray2);
        Util.destroyBytes(byArray2);
        sHA1.finalize();
        byte[] byArray4 = sHA1.getDigest();
        Log.debug(10, "(PwsFileHeaderV2.genRandHash) digest = " + Util.bytesToHex(byArray4));
        BlowfishCipher blowfishCipher = new BlowfishCipher(byArray4);
        byArray3 = Util.arraycopy(byArray, 8);
        Log.debug(10, "(PwsFileHeaderV2.genRandHash) rnd = " + Util.bytesToHex(byArray3));
        for (int i = 0; i < 1000; ++i) {
            byArray3 = blowfishCipher.encrypt(byArray3);
        }
        Log.debug(10, "(PwsFileHeaderV2.genRandHash) rnd encrypted = " + Util.bytesToHex(byArray3));
        byte[] byArray5 = Util.arraycopy(byArray3, 10);
        sHA1.clearContext();
        sHA1.update(byArray5);
        sHA1.finalize();
        Log.debug(10, "(PwsFileHeaderV2) producing a randHash =" + Util.bytesToHex(sHA1.getDigest()) + " for randStuff =" + Util.bytesToHex(byArray));
        return sHA1.getDigest();
    }
}

