/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.IOException;
import java.io.OutputStream;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.data.HeaderFieldList;
import org.jpws.pwslib.data.PwsBlockOutputStream;
import org.jpws.pwslib.data.PwsFileHeaderV1;
import org.jpws.pwslib.data.PwsFileHeaderV2;
import org.jpws.pwslib.data.PwsFileHeaderV3;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.PwsChecksum;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.global.Util;

public class PwsFileOutputSocket {
    private OutputStream output;
    private PwsCipher cipher;
    private BlockWriter writer;
    private PwsPassphrase key;
    private HeaderFieldList headerFields;
    private UUID fileID;
    private PwsChecksum hmac;
    private int version;
    private int iterations;

    public PwsFileOutputSocket(OutputStream outputStream, PwsPassphrase pwsPassphrase, int n) {
        this(outputStream, pwsPassphrase, null, n);
    }

    public PwsFileOutputSocket(OutputStream outputStream, PwsPassphrase pwsPassphrase, HeaderFieldList headerFieldList, int n) {
        if (outputStream == null | pwsPassphrase == null) {
            throw new NullPointerException();
        }
        this.output = outputStream;
        this.key = (PwsPassphrase)pwsPassphrase.clone();
        this.version = n;
        this.headerFields = headerFieldList;
    }

    public PwsFileOutputSocket(OutputStream outputStream, PwsPassphrase pwsPassphrase, HeaderFieldList headerFieldList) {
        this(outputStream, pwsPassphrase, headerFieldList, 3);
    }

    public void destroy() {
        this.output = null;
        this.cipher = null;
        this.key = null;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        this.destroy();
        Log.debug(2, "(PwsFileOutputSocket) closing output blockstream, HMAC = " + (this.hmac == null ? "void" : Util.bytesToHex(this.hmac.digest())));
    }

    private void initOutput() throws IOException {
        Log.log(5, "(PwsFileOutputSocket) initOutput, 0");
        switch (this.version) {
            case 1: {
                this.cipher = new PwsFileHeaderV1().save(this.output, this.key);
                break;
            }
            case 2: {
                String string = this.headerFields == null ? "" : this.headerFields.getStringValue(64);
                this.cipher = new PwsFileHeaderV2().save(this.output, this.key, string);
                break;
            }
            case 3: {
                PwsFileHeaderV3 pwsFileHeaderV3 = new PwsFileHeaderV3(this.headerFields);
                Log.log(5, "(PwsFileOutputSocket) initOutput, 1");
                pwsFileHeaderV3.setIterations(this.iterations);
                Log.log(5, "(PwsFileOutputSocket) initOutput, 2");
                this.fileID = pwsFileHeaderV3.getFileID();
                this.cipher = pwsFileHeaderV3.save(this.output, this.key);
                this.hmac = pwsFileHeaderV3.getWriteHmac();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown file version");
            }
        }
    }

    public UUID getFileID() {
        return this.fileID;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int n) {
        this.iterations = Math.max(2048, n);
    }

    public RawFieldWriter getRawFieldWriter() throws IOException {
        return (RawFieldWriter)((Object)this.getBlockOutputStream());
    }

    public PwsBlockOutputStream getBlockOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("output stream in use or consumed");
        }
        Log.log(5, "(PwsFileOutputSocket) getBlockOutputStream");
        this.initOutput();
        this.writer = new BlockWriter(this.output, this.cipher, this.version);
        return this.writer;
    }

    private class BlockWriter
    implements PwsBlockOutputStream,
    RawFieldWriter {
        OutputStream out;
        PwsCipher cipher;
        int blocksize;
        int blockCount;
        int fileVersion;

        public BlockWriter(OutputStream outputStream, PwsCipher pwsCipher, int n) {
            if (outputStream == null | pwsCipher == null) {
                throw new NullPointerException();
            }
            this.out = outputStream;
            this.cipher = pwsCipher;
            this.blocksize = pwsCipher.getBlockSize();
            this.fileVersion = n;
        }

        public int getCount() {
            return this.blockCount;
        }

        public int getFormat() {
            return this.fileVersion;
        }

        public int getBlockSize() {
            return this.blocksize;
        }

        public boolean isClosed() {
            return this.out == null;
        }

        public void writeBlocks(byte[] byArray) throws IOException {
            if (this.out == null) {
                throw new IllegalStateException("outputstream closed");
            }
            int n = byArray.length / this.blocksize;
            byte[] byArray2 = byArray.length % this.blocksize > 0 ? Util.arraycopy(byArray, ++n * this.blocksize) : byArray;
            byArray2 = this.cipher.encrypt(byArray2);
            this.out.write(byArray2);
            this.blockCount += n;
        }

        public void writeRawField(PwsRawField pwsRawField) throws IOException {
            pwsRawField.writeEncrypted(this.out, this.cipher, this.fileVersion, PwsFileOutputSocket.this.hmac);
        }

        public void close() throws IOException {
            if (this.fileVersion == 3) {
                this.out.write(Global.FIELDSTREAM_ENDBLOCK_V3);
                this.out.write(PwsFileOutputSocket.this.hmac.digest());
            }
            this.out = null;
        }

        public PwsBlockOutputStream getBlockStream() {
            return this;
        }
    }

    public static interface RawFieldWriter {
        public void close() throws IOException;

        public int getBlockSize();

        public int getFormat();

        public void writeRawField(PwsRawField var1) throws IOException;

        public int getCount();

        public PwsBlockOutputStream getBlockStream();
    }
}

