/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.global;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import org.jpws.pwslib.crypto.BlowfishCipher;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.crypto.SHA1;
import org.jpws.pwslib.crypto.SHA256;
import org.jpws.pwslib.crypto.TwofishCipher;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.persist.ApplicationAdapter;
import org.jpws.pwslib.persist.DefaultFilesystemAdapter;

public final class Global {
    public static final String LIBRARY_VERSION = "2.1.0";
    public static final String LIBRARY_IDENT = "KSE-PWSLIB 2.1.0";
    public static final long DAY = 86400000L;
    public static final long DEFAULT_EXPIRESCOPE = 2592000000L;
    public static boolean haveApplications;
    public static final int FILEVERSION_1 = 1;
    public static final int FILEVERSION_2 = 2;
    public static final int FILEVERSION_3 = 3;
    public static final int FILEVERSION_LATEST = 3;
    public static final byte[] FIELDSTREAM_ENDBLOCK_V3;
    private static final int MAX_DEBUG = 10;
    private static ApplicationAdapter standardApplication;
    private static PwsCipher standardCipher;
    private static String programName;
    private static boolean displayUsernames;
    private static boolean isInitialized;

    public static String getProgramName() {
        return programName;
    }

    public static void setProgramName(String string) {
        if (string != null) {
            if (string.length() > 60) {
                string = string.substring(0, 60);
            }
            programName = string;
        }
    }

    public static void setStandardApplication(ApplicationAdapter applicationAdapter) {
        haveApplications = applicationAdapter != null;
        standardApplication = applicationAdapter;
        if (haveApplications && applicationAdapter.getName() == null | applicationAdapter.getName().equals("")) {
            throw new IllegalArgumentException("must have a name");
        }
        String string = haveApplications ? "Standard Application: " + applicationAdapter.getName() : "Standard Application cleared";
        Log.log(1, "(Global) " + string);
    }

    public static ApplicationAdapter getStandardApplication() {
        return standardApplication;
    }

    public static PwsCipher getStandardCipher() {
        return standardCipher;
    }

    public static String getDefaultCharset() {
        return new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    public static boolean isDisplayUsernames() {
        return displayUsernames;
    }

    public static void setDisplayUsernames(boolean bl) {
        displayUsernames = bl;
    }

    public static void init() {
        if (!isInitialized) {
            Log.setDebugLevel(1);
            Log.setLogLevel(1);
            boolean bl = new SHA1().selfTest();
            boolean bl2 = SHA256.self_test();
            boolean bl3 = BlowfishCipher.self_test();
            boolean bl4 = TwofishCipher.self_test();
            Log.debug(9, "SHA1 Test : " + bl);
            Log.debug(9, "SHA256 Test : " + bl2);
            Log.debug(9, "Blowfish Test : " + bl3);
            Log.debug(9, "Twofish Test : " + bl4);
            if (!(bl & bl3 & bl4 & bl2)) {
                throw new IllegalStateException("** encryption module corruption **");
            }
            standardCipher = new BlowfishCipher();
            Global.setStandardApplication(new DefaultFilesystemAdapter());
            isInitialized = true;
            Log.log(1, "(Global) Global initialized");
        }
    }

    private static void securityTest() {
        boolean bl = new SHA1().selfTest();
        boolean bl2 = SHA256.self_test();
        boolean bl3 = BlowfishCipher.self_test();
        boolean bl4 = TwofishCipher.self_test();
        Log.debug(1, "SHA1 Test : " + bl);
        Log.debug(1, "SHA256 Test : " + bl2);
        Log.debug(1, "Blowfish Test : " + bl3);
        Log.debug(1, "Twofish Test : " + bl4);
        if (!(bl & bl3 & bl4 & bl2)) {
            Log.debug(1, "** PWSLIB encryption module corruption!! **\r\n** Do not use this library!! **");
        } else {
            Log.debug(1, "PWSLIB selftest passed");
        }
    }

    private Global() {
    }

    public static void main(String[] stringArray) {
        Global.securityTest();
    }

    static {
        FIELDSTREAM_ENDBLOCK_V3 = "PWS3-EOFPWS3-EOF".getBytes();
        programName = LIBRARY_IDENT;
        Global.init();
    }
}

