/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.order;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.order.Collatable;

public class DefaultRecordWrapper
implements Comparable,
Collatable,
Cloneable {
    public static final int EXPIRED = 1;
    public static final int EXPIRE_SOON = 2;
    public static final int IMPORTED = 1;
    public static final int IMPORTED_CONFLICT = 2;
    public static String defaultTitle = "?";
    private Locale locale;
    private CollationKey key;
    private PwsRecord record;
    private String sortValue;
    private int index = -1;
    private int expiry;
    private int importry;

    public DefaultRecordWrapper(PwsRecord pwsRecord, Locale locale) {
        if (pwsRecord == null) {
            throw new NullPointerException("record void");
        }
        this.record = pwsRecord;
        this.refresh();
        this.setLocale(locale);
    }

    public Object clone() {
        DefaultRecordWrapper defaultRecordWrapper;
        try {
            defaultRecordWrapper = (DefaultRecordWrapper)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        defaultRecordWrapper.record = (PwsRecord)this.record.clone();
        defaultRecordWrapper.key = Collator.getInstance(this.locale).getCollationKey(this.sortValue);
        return defaultRecordWrapper;
    }

    public static DefaultRecordWrapper[] makeWrappers(PwsRecord[] pwsRecordArray, Locale locale) {
        DefaultRecordWrapper[] defaultRecordWrapperArray = new DefaultRecordWrapper[pwsRecordArray.length];
        for (int i = 0; i < pwsRecordArray.length; ++i) {
            defaultRecordWrapperArray[i] = new DefaultRecordWrapper(pwsRecordArray[i], locale);
        }
        return defaultRecordWrapperArray;
    }

    public void refreshExpiry(long l) {
        this.expiry = this.record.hasExpired() ? 1 : (this.record.willExpire(System.currentTimeMillis() + l) ? 2 : 0);
    }

    public void refresh() {
        this.sortValue = DefaultRecordWrapper.sortValueOf(this.record);
        this.importry = this.record.getImportStatus();
        this.refreshExpiry(2592000000L);
        if (this.locale != null) {
            this.key = Collator.getInstance(this.locale).getCollationKey(this.sortValue);
        }
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            this.key = Collator.getInstance(this.locale).getCollationKey(this.sortValue);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static String sortValueOf(PwsRecord pwsRecord) {
        return DefaultRecordWrapper.sortValueOf(pwsRecord.getGroup(), pwsRecord.getTitle());
    }

    public static String sortValueOf(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string + ":" + string2;
    }

    public PwsRecord getRecord() {
        return this.record;
    }

    public UUID getRecordID() {
        return this.record.getRecordID();
    }

    public String getGroup() {
        String string = this.record.getGroup();
        return string == null ? "" : string;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public int getImportStatus() {
        return this.importry;
    }

    public boolean equals(Object object) {
        return object != null && ((DefaultRecordWrapper)object).getRecord().equals(this.record);
    }

    public int compareTo(DefaultRecordWrapper defaultRecordWrapper) {
        return this.key.compareTo(defaultRecordWrapper.key);
    }

    public int compareTo(Object object) {
        return this.compareTo((DefaultRecordWrapper)object);
    }

    public String getSortValue() {
        return this.sortValue;
    }

    public int hashCode() {
        return this.record.hashCode();
    }

    public CollationKey getCollationKey() {
        return this.key;
    }

    public String toString() {
        String string = this.record.getUsername();
        String string2 = this.record.getTitle();
        if (string2 == null) {
            string2 = defaultTitle;
        }
        return string == null || !Global.isDisplayUsernames() ? string2 : string2 + " [" + string + "]";
    }

    void setIndex(int n) {
        this.index = n;
    }

    int getIndex() {
        return this.index;
    }

    private boolean isBoundingChar(char c) {
        return !Character.isLetterOrDigit(c);
    }

    private boolean textMatch(char[] cArray, char[] cArray2, boolean bl, boolean bl2) {
        int n;
        if (cArray2.length > cArray.length) {
            return false;
        }
        if (!bl) {
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = Character.toLowerCase(cArray[n]);
            }
        }
        int n2 = cArray.length - cArray2.length + 1;
        for (n = 0; n < n2; ++n) {
            boolean bl3 = true;
            for (int i = 0; i < cArray2.length; ++i) {
                if (cArray[n + i] == cArray2[i]) continue;
                bl3 = false;
                break;
            }
            if (!bl3) continue;
            if (bl2) {
                boolean bl4;
                boolean bl5 = bl4 = n == 0 || this.isBoundingChar(cArray[n - 1]);
                if (!bl4 || n != n2 - 1 && !this.isBoundingChar(cArray[n + cArray2.length])) continue;
            }
            return true;
        }
        return false;
    }

    public boolean hasText(String string, boolean bl, boolean bl2) {
        boolean bl3;
        char[] cArray;
        char[] cArray2 = (bl ? string : string.toLowerCase()).toCharArray();
        String string2 = this.record.getGroup();
        if (string2 != null && this.textMatch(string2.toCharArray(), cArray2, bl, bl2)) {
            return true;
        }
        string2 = this.record.getTitle();
        if (string2 != null && this.textMatch(string2.toCharArray(), cArray2, bl, bl2)) {
            return true;
        }
        PwsPassphrase pwsPassphrase = this.record.getUsernamePws();
        if (pwsPassphrase != null) {
            cArray = pwsPassphrase.getValue();
            bl3 = this.textMatch(cArray, cArray2, bl, bl2);
            Util.destroyChars(cArray);
            if (bl3) {
                return true;
            }
        }
        if ((pwsPassphrase = this.record.getNotesPws()) != null) {
            cArray = pwsPassphrase.getValue();
            bl3 = this.textMatch(cArray, cArray2, bl, bl2);
            Util.destroyChars(cArray);
            if (bl3) {
                return true;
            }
        }
        if ((pwsPassphrase = this.record.getUrlPws()) != null) {
            cArray = pwsPassphrase.getValue();
            bl3 = this.textMatch(cArray, cArray2, bl, bl2);
            Util.destroyChars(cArray);
            if (bl3) {
                return true;
            }
        }
        return false;
    }
}

