/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.persist;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.exception.InputInterruptedException;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.persist.ApplicationAdapter;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpLoginException;

public abstract class AbstractFTPAdapter
implements ApplicationAdapter {
    protected static int classID = 33;
    protected static HashMap logins = new HashMap();

    protected static synchronized void putLoginEntry(String string, String string2) {
        if (string == null | string2 == null) {
            throw new NullPointerException();
        }
        PwsPassphrase pwsPassphrase = new PwsPassphrase(string2);
        logins.put(string, pwsPassphrase);
    }

    protected static synchronized String getLoginEntry(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        PwsPassphrase pwsPassphrase = (PwsPassphrase)logins.get(string);
        return pwsPassphrase == null ? null : pwsPassphrase.getString();
    }

    protected static synchronized void removeLoginEntry(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        logins.remove(string);
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getConnected(string).getInputStream();
    }

    private URLConnection getConnected(String string) throws IOException {
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        String string3 = AbstractFTPAdapter.getLoginEntry(string2);
        int n = string3 == null ? 0 : 1;
        while (true) {
            switch (n) {
                case 0: {
                    try {
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setAllowUserInteraction(true);
                        if (Log.getDebugLevel() > 4) {
                            System.out.println("--- (FTP) Connecting to domain: " + uRL.toString());
                        }
                        uRLConnection.connect();
                        return uRLConnection;
                    }
                    catch (FtpLoginException ftpLoginException) {
                        ++n;
                        break;
                    }
                }
                case 1: {
                    if (string3 == null) {
                        string3 = this.getUserLogin(string2);
                        if (string3 == null) {
                            throw new InputInterruptedException();
                        }
                        if (string3.equals("")) {
                            throw new ConnectException("login not supplied");
                        }
                        AbstractFTPAdapter.putLoginEntry(string2, string3);
                    }
                    try {
                        String string4 = "ftp://" + string3 + "@" + string2 + ":21/" + uRL.getFile();
                        uRL = new URL(string4);
                        if (Log.getDebugLevel() > 4) {
                            System.out.println("--- (FTP) Connecting to domain: " + uRL.toString());
                        }
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setAllowUserInteraction(true);
                        uRLConnection.connect();
                        return uRLConnection;
                    }
                    catch (IOException iOException) {
                        AbstractFTPAdapter.removeLoginEntry(string2);
                        throw iOException;
                    }
                }
            }
        }
    }

    public abstract String getUserLogin(String var1);

    public OutputStream getOutputStream(String string) throws IOException {
        return this.getConnected(string).getOutputStream();
    }

    public String getName() {
        return "FTP File Locations";
    }

    public int getType() {
        return 1;
    }

    public boolean deleteFile(String string) throws IOException {
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        String string3 = AbstractFTPAdapter.getLoginEntry(string2);
        if (string3 == null) {
            return false;
        }
        OurFtpClient ourFtpClient = new OurFtpClient(string2);
        int n = string3.indexOf(58);
        ourFtpClient.login(string3.substring(0, n), string3.substring(n + 1));
        ourFtpClient.delete(uRL.getFile());
        ourFtpClient.closeServer();
        if (Log.getDebugLevel() > 4) {
            System.out.println("--- (FTP) Deleted file: " + uRL.toString());
        }
        return true;
    }

    public boolean existsFile(String string) throws IOException {
        try {
            InputStream inputStream = this.getConnected(string).getInputStream();
            boolean bl = inputStream != null;
            inputStream.close();
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public boolean renameFile(String string, String string2) throws IOException {
        URL uRL = new URL(string);
        URL uRL2 = new URL(string2);
        String string3 = uRL.getHost();
        String string4 = AbstractFTPAdapter.getLoginEntry(string3);
        if (string4 == null) {
            return false;
        }
        OurFtpClient ourFtpClient = new OurFtpClient(string3);
        int n = string4.indexOf(58);
        ourFtpClient.login(string4.substring(0, n), string4.substring(n + 1));
        ourFtpClient.rename(uRL.getFile(), uRL2.getFile());
        ourFtpClient.closeServer();
        if (Log.getDebugLevel() > 4) {
            System.out.println("--- (FTP) Renamed file [" + uRL.toString() + "] to [" + uRL2.toString() + "]");
        }
        return true;
    }

    public String[] list(String string, String string2, boolean bl) throws IOException {
        if (bl) {
            return null;
        }
        URL uRL = new URL(string);
        String string3 = uRL.getHost();
        String string4 = uRL.getPath();
        String string5 = string.substring(0, string.indexOf(string3) + string3.length());
        String string6 = AbstractFTPAdapter.getLoginEntry(string3);
        if (string6 == null) {
            return null;
        }
        OurFtpClient ourFtpClient = new OurFtpClient(string3);
        int n = string6.indexOf(58);
        ourFtpClient.login(string6.substring(0, n), string6.substring(n + 1));
        InputStream inputStream = ourFtpClient.nameList(string4.concat("*"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Util.transferData(inputStream, byteArrayOutputStream, 2048);
        ((FilterInputStream)inputStream).close();
        String string7 = byteArrayOutputStream.toString("utf-8");
        String[] stringArray = string7.split("\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            string7 = stringArray[n];
            if (string2 != null && !string7.endsWith(string2)) continue;
            arrayList.add(string5.concat(string7));
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    public String separator() {
        return "/";
    }

    public boolean canWrite(String string) {
        return true;
    }

    public boolean canDelete(String string) {
        return true;
    }

    public long getFileLength(String string) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifiedTime(String string) throws IOException {
        long l = 0L;
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        String string3 = AbstractFTPAdapter.getLoginEntry(string2);
        if (string3 == null) {
            return 0L;
        }
        OurFtpClient ourFtpClient = new OurFtpClient(string2);
        int n = string3.indexOf(58);
        ourFtpClient.login(string3.substring(0, n), string3.substring(n + 1));
        try {
            l = ourFtpClient.getFileTime(uRL.getPath());
        }
        catch (IOException iOException) {
            long l2 = 0L;
            return l2;
        }
        finally {
            ourFtpClient.closeServer();
        }
        return l;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof AbstractFTPAdapter;
    }

    public int hashCode() {
        return classID;
    }

    public class OurFtpClient
    extends FtpClient {
        public OurFtpClient(String string) throws IOException {
            super(string);
        }

        public OurFtpClient(String string, int n) throws IOException {
            super(string, n);
        }

        public OurFtpClient() {
        }

        public void delete(String string) throws IOException {
            this.issueCommandCheck("DELE " + string);
        }

        public long getFileTime(String string) throws IOException {
            GregorianCalendar gregorianCalendar;
            String string2 = "";
            try {
                this.issueCommandCheck("MDTM " + string);
                string2 = super.getResponseString();
                if (string2.equals("") | string2.charAt(0) != '2') {
                    return 0L;
                }
                gregorianCalendar = new GregorianCalendar();
                int n = Integer.parseInt(string2.substring(4, 8));
                int n2 = Integer.parseInt(string2.substring(8, 10)) - 1;
                int n3 = Integer.parseInt(string2.substring(10, 12));
                int n4 = Integer.parseInt(string2.substring(12, 14));
                int n5 = Integer.parseInt(string2.substring(14, 16));
                int n6 = Integer.parseInt(string2.substring(16, 18));
                gregorianCalendar.set(n, n2, n3, n4, n5, n6);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return 0L;
            }
            return gregorianCalendar.getTimeInMillis();
        }
    }
}

