/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.persist.ApplicationAdapter;

public class DefaultFilesystemAdapter
implements ApplicationAdapter {
    protected static int classID = 11;

    public InputStream getInputStream(String string) throws IOException {
        return new FileInputStream(string);
    }

    public OutputStream getOutputStream(String string) throws IOException {
        return new FileOutputStream(string);
    }

    public String getName() {
        return "Local Files";
    }

    public int getType() {
        return 0;
    }

    public boolean deleteFile(String string) throws IOException {
        return new File(string).delete();
    }

    public boolean existsFile(String string) throws IOException {
        return new File(string).isFile();
    }

    public boolean renameFile(String string, String string2) throws IOException {
        return new File(string).renameTo(new File(string2));
    }

    public String separator() {
        return File.separator;
    }

    private String directoryPart(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.separator();
        int n = string.lastIndexOf(string2);
        String string3 = n == -1 ? "" : string.substring(0, n + 1);
        return string3;
    }

    public String[] list(String string, String string2, boolean bl) throws IOException {
        ArrayList arrayList = new ArrayList();
        if (this.separator().equals("\\")) {
            string = Util.substituteText(string, "/", "\\");
            string2 = Util.substituteText(string2, "/", "\\");
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.length() == 0) {
            return new String[0];
        }
        String string3 = this.directoryPart(string);
        if (string3.length() == 0) {
            string3 = System.getProperty("user.dir");
        }
        this.analyseDirectory(string3, arrayList, string, string2, bl);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    private void analyseDirectory(String string, List list, String string2, String string3, boolean bl) {
        String[] stringArray;
        if (string == null || (stringArray = new File(string).list()) == null || stringArray.length == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = this.separator();
        if (!string.endsWith(string4)) {
            string = string.concat(string4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = string + stringArray[i];
            if (new File(string5).isDirectory()) {
                arrayList.add(string5);
                continue;
            }
            if (!string5.startsWith(string2) || !string5.endsWith(string3)) continue;
            list.add(Util.substituteText(string5, "\\", "/"));
        }
        if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.analyseDirectory((String)iterator.next(), list, string2, string3, true);
            }
        }
    }

    public boolean canWrite(String string) {
        if (string == null) {
            return true;
        }
        File file = new File(string);
        return file.exists() ? file.canWrite() : true;
    }

    public boolean canDelete(String string) {
        return this.canWrite(string);
    }

    public long getFileLength(String string) {
        return new File(string).length();
    }

    public long getModifiedTime(String string) throws IOException {
        return new File(string).lastModified();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DefaultFilesystemAdapter;
    }

    public int hashCode() {
        return classID;
    }
}

