/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.persist;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jpws.pwslib.exception.ApplicationFailureException;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.persist.ApplicationAdapter;

public class StreamFactory {
    private StreamFactory() {
    }

    public static InputStream getInputStream(String string) throws IOException, ApplicationFailureException {
        return StreamFactory.getInputStream(Global.getStandardApplication(), string);
    }

    public static OutputStream getOutputStream(String string) throws IOException, ApplicationFailureException {
        return StreamFactory.getOutputStream(Global.getStandardApplication(), string);
    }

    public static InputStream getInputStream(ApplicationAdapter applicationAdapter, String string) throws IOException, ApplicationFailureException {
        if (applicationAdapter == null | string == null) {
            throw new NullPointerException();
        }
        if (string.equals("")) {
            throw new IllegalArgumentException();
        }
        InputStream inputStream = applicationAdapter.getInputStream(string);
        if (inputStream == null) {
            throw new ApplicationFailureException("void input stream [" + string + "] <- " + applicationAdapter.getName());
        }
        return new SFInputStream(inputStream, applicationAdapter, string);
    }

    public static OutputStream getOutputStream(ApplicationAdapter applicationAdapter, String string) throws IOException, ApplicationFailureException {
        if (applicationAdapter == null || string == null || string.equals("")) {
            throw new IllegalArgumentException();
        }
        if (!applicationAdapter.canWrite(string)) {
            String string2 = "adapter not qualified for output: [" + string + "] <- " + applicationAdapter.getName();
            throw new ApplicationFailureException(string2);
        }
        OutputStream outputStream = applicationAdapter.getOutputStream(string);
        if (outputStream == null) {
            String string3 = "void output stream [" + string + "] <- " + applicationAdapter.getName();
            throw new ApplicationFailureException(string3);
        }
        return new SFOutputStream(outputStream, applicationAdapter, string);
    }

    private static class SFOutputStream
    extends BufferedOutputStream {
        private String filepath;
        private ApplicationAdapter application;
        private boolean isClosed;

        public SFOutputStream(OutputStream outputStream, ApplicationAdapter applicationAdapter, String string) {
            super(outputStream);
            this.filepath = string;
            this.application = applicationAdapter;
            Log.log(9, "(StreamFactory) opened OutputStream for \"" + this.application.getName() + "\" -> " + string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            try {
                super.flush();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.close();
                this.isClosed = true;
                Log.log(9, "(StreamFactory) closed OutputStream for \"" + this.application.getName() + "\" -> " + this.filepath);
                throw throwable;
            }
            super.close();
            this.isClosed = true;
            Log.log(9, "(StreamFactory) closed OutputStream for \"" + this.application.getName() + "\" -> " + this.filepath);
        }
    }

    private static class SFInputStream
    extends BufferedInputStream {
        private String filepath;
        private ApplicationAdapter application;

        public SFInputStream(InputStream inputStream, ApplicationAdapter applicationAdapter, String string) {
            super(inputStream);
            this.filepath = string;
            this.application = applicationAdapter;
            Log.log(9, "(StreamFactory) opened InputStream for \"" + this.application.getName() + "\" -> " + string);
        }

        public void close() throws IOException {
            super.close();
            Log.log(9, "(StreamFactory) closed InputStream for \"" + this.application.getName() + "\" -> " + this.filepath);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n3 = super.read(byArray, n, n2);
            while (n4 > -1 && n3 < n2) {
                n4 = super.read(byArray, n + n3, n2 - n3);
                if (n4 <= 0) continue;
                n3 += n4;
            }
            return n3;
        }
    }
}

