/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.data;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.jpws.data.PersistentOptions;
import org.jpws.front.util.PropertiesUTF;

class OptionBag
implements PersistentOptions {
    private PropertiesUTF properties = new PropertiesUTF();
    private Properties defaults = new Properties();
    private String head;

    public OptionBag() {
    }

    public OptionBag(Properties properties) {
        this.setDefaults(properties);
    }

    public OptionBag(String string) throws IOException {
        this.load(string);
    }

    public synchronized void load(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        this.properties.load(byteArrayInputStream, "UTF-8");
    }

    public OptionBag(InputStream inputStream, String string) throws IOException {
        this.properties.load(inputStream, string);
    }

    public void setDefaults(Properties properties) {
        this.properties.setDefaults(properties);
        this.defaults = properties;
        if (this.defaults == null) {
            this.defaults = new Properties();
        }
    }

    public void setHeadText(String string) {
        this.head = string;
    }

    public void clear() {
        this.properties.clear();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public synchronized void load(InputStream inputStream, String string) throws IOException {
        this.properties.load(inputStream, string);
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        this.properties.store(outputStream, this.head, string);
    }

    public byte[] toByteArray(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.store(byteArrayOutputStream, string);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        try {
            return new String(this.toByteArray("UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public int getIntOption(String string) {
        int n = 0;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                string2 = this.defaults.getProperty(string);
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public long getLongOption(String string) {
        long l = 0L;
        String string2 = this.getProperty(string);
        if (string2 != null) {
            try {
                l = Long.parseLong(string2);
            }
            catch (Exception exception) {
                string2 = this.defaults.getProperty(string);
                try {
                    l = Long.parseLong(string2);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    public String getOption(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public boolean isOptionSet(String string) {
        String string2 = this.getProperty(string);
        return string2 != null && string2.equals("true");
    }

    public void setIntOption(String string, int n) {
        this.setOption(string, String.valueOf(n));
    }

    public void setLongOption(String string, long l) {
        this.setOption(string, String.valueOf(l));
    }

    public void setOption(String string, boolean bl) {
        String string2 = bl ? "true" : "false";
        this.setOption(string, string2);
    }

    public void setOption(String string, String string2) {
        if (string2 == null || string2.length() == 0 || string2.equals(this.defaults.getProperty(string))) {
            this.properties.remove(string);
        } else {
            this.setProperty(string, string2);
        }
    }

    public void setBounds(String string, Rectangle rectangle) {
        Dimension dimension = rectangle.getSize();
        this.setIntOption(string.concat("-framedim"), dimension.width << 16 | dimension.height & 0xFFFF);
        Point point = rectangle.getLocation();
        this.setIntOption(string.concat("-framepos"), point.x << 16 | point.y & 0xFFFF);
    }

    public Rectangle getBounds(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.getIntOption(string.concat("-framedim"));
        if (n == 0) {
            return null;
        }
        Dimension dimension = new Dimension(n >> 16, (short)n);
        n = this.getIntOption(string.concat("-framepos"));
        if (n == 0) {
            return null;
        }
        Point point = new Point(n >> 16, (short)n);
        Rectangle rectangle = new Rectangle(point, dimension);
        return rectangle;
    }
}

