/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.data;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jpws.data.OptionBag;
import org.jpws.data.PersistentOptions;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.Util;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.Util;

public class Options {
    public static final String HISTORY_OPTIONS = "browserApplication=8,lookAndFeel=4,Font.menu=8,Font.data=8,Font.password=8,Font.notes=8,Font.display=8,Font.control=8,Font.tooltip=8";
    public static byte[] randomSeed;
    public static boolean wasReset;
    private static HashMap historyMap;
    private static PersistentOptions optionInstance;
    private static Properties defaults;
    private static OptionBag obag;
    private static File optionFile;
    private static File persistFile;

    public static void init(File file) {
        File file2 = null;
        File file3 = new File(System.getProperty("user.home"), Global.OPTIONFILENAME);
        optionFile = file;
        for (int i = 0; i < 2; ++i) {
            try {
                File file4 = file2 = i == 0 ? file : file3;
                if (file2 == null) continue;
                System.out.println("- attempting OPTION FILE: " + file2.getAbsolutePath());
                int n = (int)file2.length();
                byte[] byArray = new byte[n];
                FileInputStream fileInputStream = new FileInputStream(file2);
                ((InputStream)fileInputStream).read(byArray);
                ((InputStream)fileInputStream).close();
                persistFile = file2;
                randomSeed = Util.fingerPrint(byArray);
                org.jpws.front.util.Util.scatter(byArray, n, false);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                obag.load(byteArrayInputStream, "UTF-8");
                if (!Options.getOption("optionkind").equals("0002")) {
                    Options.reset();
                    System.out.println("*** OPTIONS INVALID: " + file2.getAbsolutePath());
                    if (i != 1) continue;
                    System.out.println("- assuming option defaults instead");
                    continue;
                }
                String[] stringArray = Util.CSV.decodeLine(HISTORY_OPTIONS, 0, ',');
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    int n2 = string.indexOf(61);
                    String string2 = string.substring(0, n2);
                    int n3 = Integer.parseInt(string.substring(n2 + 1));
                    RecentList recentList = new RecentList(n3);
                    string = Options.getOption(string2.concat(".history"));
                    recentList.setContent(string);
                    historyMap.put(string2, recentList);
                }
                break;
            }
            catch (IOException iOException) {
                System.err.println("*** CANNOT LOAD PROGRAM OPTIONS under : " + file2.getAbsolutePath());
                System.err.println(iOException);
                if (file2.equals(file3)) break;
            }
        }
    }

    public static void reset() {
        wasReset = true;
        obag.clear();
    }

    public static void save() {
        obag.setOption("optionkind", "0002");
        obag.setHeadText("JPASSWORDS PREFERENCES V. 0002");
        File file = new File(System.getProperty("user.home"), Global.OPTIONFILENAME);
        for (int i = 0; i < 2; ++i) {
            try {
                File file2;
                Iterator iterator = historyMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    String string2 = ((RecentList)entry.getValue()).getStringContent();
                    obag.setOption(string.concat(".history"), string2);
                }
                byte[] byArray = obag.toByteArray("UTF-8");
                org.jpws.front.util.Util.scatter(byArray, byArray.length, true);
                File file3 = file2 = i == 0 ? optionFile : file;
                if (file2 == null) continue;
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                ((OutputStream)fileOutputStream).write(byArray);
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                GUIService.failureMessage("msg.failsaveprefs", iOException);
                if (optionFile == null || !optionFile.equals(file)) continue;
            }
            break;
        }
    }

    public static boolean isOptionSet(String string) {
        return obag.isOptionSet(string);
    }

    public static void setDefaultOption(String string, String string2) {
        defaults.setProperty(string, string2);
    }

    public static void setOption(String string, boolean bl) {
        Options.setOption(string, Boolean.toString(bl));
    }

    public static void setOption(String string, String string2) {
        obag.setOption(string, string2);
        Options.updateOptionHistory(string, string2);
    }

    private static void updateOptionHistory(String string, String string2) {
        RecentList recentList;
        if (string2 != null && (recentList = (RecentList)historyMap.get(string)) != null) {
            recentList.pushRecent(string2);
            Log.debug(5, "-- updated option histroy of [" + string + "] with " + string2);
        }
    }

    public static String getOption(String string) {
        return obag.getOption(string);
    }

    public static RecentList getOptionHistory(String string) {
        return (RecentList)historyMap.get(string);
    }

    public static File getPersistentFile() {
        return persistFile;
    }

    public static int getIntOption(String string) {
        return obag.getIntOption(string);
    }

    public static long getLongOption(String string) {
        return obag.getLongOption(string);
    }

    public static void setIntOption(String string, int n) {
        Options.setOption(string, Integer.toString(n));
    }

    public static void setLongOption(String string, long l) {
        Options.setOption(string, Long.toString(l));
    }

    public static PersistentOptions getOptions() {
        return optionInstance;
    }

    public static void setBounds(String string, Rectangle rectangle) {
        obag.setBounds(string, rectangle);
        Options.updateOptionHistory(string, obag.getOption(string));
    }

    public static Rectangle getBounds(String string) {
        return obag.getBounds(string);
    }

    private Options() {
    }

    static {
        wasReset = false;
        historyMap = new HashMap();
        optionInstance = new PO_Interface();
        defaults = new Properties();
        obag = new OptionBag(defaults);
        defaults.setProperty("useRecentList", "true");
        defaults.setProperty("useUndoRedo", "true");
        defaults.setProperty("reopenFile", "true");
        defaults.setProperty("autoflush", "false");
        defaults.setProperty("monitorSystem", "false");
        defaults.setProperty("rememberScreen", "true");
        defaults.setProperty("expiryCheck", "true");
        defaults.setProperty("checkProjectNews", "true");
        defaults.setProperty("storeMinorChanges", "true");
        defaults.setProperty("confirmSave", "false");
        defaults.setProperty("confirmBackup", "true");
        defaults.setProperty("confirmRevert", "true");
        defaults.setProperty("confirmCopyClipboard", "true");
        defaults.setProperty("confirmUpdatePass", "false");
        defaults.setProperty("confirmDeleteRecord", "true");
        defaults.setProperty("confirmCancelRecord", "true");
        defaults.setProperty("lockIdleState", "true");
        defaults.setProperty("lockMinimize", "false");
        defaults.setProperty("clearClipboard", "true");
        defaults.setProperty("autoBackup", "true");
        defaults.setProperty("createFileCheck", "false");
        defaults.setProperty("openPassEdit", "false");
        defaults.setProperty("treeUsername", "true");
        defaults.setProperty("useTableColors", "true");
        defaults.setProperty("autoExpandTree", "false");
        defaults.setProperty("editFullNotes", "false");
        defaults.setProperty("editLineWrap", "false");
        defaults.setProperty("editActiveHistory", "true");
        defaults.setProperty("logicalFilenames", "true");
        defaults.setProperty("useEntryOnBrowse", "true");
        defaults.setProperty("useEntryOnOpen", "false");
        defaults.setProperty("locale", "en");
        String string = System.getProperty("user.language");
        if (string.equals("de") || string.equals("fr") || string.equals("ru")) {
            defaults.setProperty("locale", string);
        }
        defaults.setProperty("defaultViewType", "tree");
        defaults.setProperty("viewtype", String.valueOf(1));
        defaults.setProperty("maxIdleTime", String.valueOf(300000L));
        defaults.setProperty("clipboardTime", String.valueOf(30000L));
        defaults.setProperty("expireScope", String.valueOf(2592000000L));
        defaults.setProperty("maxUndoEntries", String.valueOf(25));
        defaults.setProperty("autoBackupFiles", "5");
    }

    private static class PO_Interface
    implements PersistentOptions {
        private PO_Interface() {
        }

        public int getIntOption(String string) {
            return Options.getIntOption(string);
        }

        public long getLongOption(String string) {
            return Options.getLongOption(string);
        }

        public String getOption(String string) {
            return Options.getOption(string);
        }

        public boolean isOptionSet(String string) {
            return Options.isOptionSet(string);
        }

        public void setIntOption(String string, int n) {
            Options.setIntOption(string, n);
        }

        public void setLongOption(String string, long l) {
            Options.setLongOption(string, l);
        }

        public void setOption(String string, boolean bl) {
            Options.setOption(string, bl);
        }

        public void setOption(String string, String string2) {
            Options.setOption(string, string2);
        }

        public void setBounds(String string, Rectangle rectangle) {
            Options.setBounds(string, rectangle);
        }

        public Rectangle getBounds(String string) {
            return Options.getBounds(string);
        }
    }
}

