/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.data;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.jpws.data.IO_OverrunException;
import org.jpws.data.JPWS_Exception;
import org.jpws.data.OptionBag;
import org.jpws.data.Options;
import org.jpws.data.PersistentOptions;
import org.jpws.data.UndefinedPersistencyException;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.ContextFile;
import org.jpws.pwslib.data.HeaderFieldList;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsFileEvent;
import org.jpws.pwslib.data.PwsFileListener;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.data.PwsRecordList;
import org.jpws.pwslib.exception.DuplicateEntryException;
import org.jpws.pwslib.exception.NoSuchRecordException;
import org.jpws.pwslib.exception.PasswordSafeException;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.order.FilterRecordList;
import org.jpws.pwslib.order.OrderedRecordList;
import org.jpws.pwslib.persist.ApplicationAdapter;

public class PwsFileSocket {
    public static final int MODIFY_STATUS = 4;
    public static final int MODIFY_EVENT = 6;
    public static final int FILTER_MODE = 5;
    public static final int FILTER_OFF = 0;
    public static final int FILTER_EXPIRING = 1;
    public static final int FILTER_IMPORTED = 2;
    public static final int FILTER_MODIFIED = 3;
    public static final int HEADERFIELD_DBNAME = 9;
    public static final int HEADERFIELD_DBDESCRIPT = 10;
    private static final String FILEOPTION_TOKEN = "JPWS-OPTIONS=";
    private ArrayList changeListeners = new ArrayList();
    private FileListener fileListener;
    private OptionBag fOptions = new FileOptions();
    private String optionString;
    protected BackupManager backupManager = new BackupManager();
    private URL url;
    private int filterOption;
    protected long lastSaveTime;
    private boolean isOpen;
    private boolean modified;
    private boolean eventPause;
    private int reportedFilterMode;
    private boolean reportedModifyState;
    protected PwsFile dbf;
    private OrderedRecordList sortList;
    private FilterRecordList filterList;
    private RecentList recentFinds;

    public PwsFileSocket(PwsFile pwsFile) {
        if (pwsFile == null) {
            throw new NullPointerException();
        }
        this.dbf = pwsFile;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChangeListener(ChangeListener changeListener) {
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            if (!this.changeListeners.contains(changeListener)) {
                this.changeListeners.add(changeListener);
                changeListener.stateChanged(new ChangeEvent(this, 5));
                changeListener.stateChanged(new ChangeEvent(this, 4));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            this.changeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(int n) {
        if (this.eventPause) {
            return;
        }
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            ChangeEvent changeEvent = new ChangeEvent(this, n);
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                ((ChangeListener)this.changeListeners.get(i)).stateChanged(changeEvent);
            }
        }
    }

    private void init() {
        this.getUrl();
        this.initFileOptions();
        this.initSortLists();
        this.fileListener = new FileListener();
        this.dbf.addFileListener(this.fileListener);
        this.lastSaveTime = System.currentTimeMillis();
        this.isOpen = true;
        this.backupManager.refresh();
    }

    private void initFileOptions() {
        this.optionString = this.dbf.getUserOptions();
        String string = FILEOPTION_TOKEN;
        int n = this.optionString.indexOf(string);
        if (n > -1) {
            int n2;
            try {
                n2 = Util.CSV.searchQuoteEnd(this.optionString, n + string.length() + 1);
                String string2 = this.optionString.substring(n + string.length(), n2);
                string2 = Util.CSV.unquoteText(string2);
                this.fOptions.load(string2);
            }
            catch (Exception exception) {
                n2 = -1;
                exception.printStackTrace();
                GUIService.warningMessage(null, null, "<html>Encountered corrupted file options in: " + this.getFileName() + "<br>" + exception);
            }
            String string3 = this.optionString.substring(0, n);
            if (n2 != -1) {
                string3 = string3 + this.optionString.substring(n2);
            }
            this.optionString = string3;
        }
        this.recentFinds = new RecentList(16);
        this.recentFinds.setContent(this.fOptions.getOption("recentFindTexts"));
    }

    private void initSortLists() {
        this.sortList = new OrderedRecordList(this.dbf);
        this.filterList = new RecordFilter(this.sortList);
        this.sortList.loadDatabase(this.dbf, Options.getLongOption("expireScope"));
    }

    public boolean isModified() {
        return this.modified || this.dbf.isModified() || this.recentFinds.isModified() && Options.isOptionSet("storeMinorChanges");
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean hasPersistentFile() {
        return this.dbf.hasResource();
    }

    public String getCharset() {
        return this.dbf.getCharset();
    }

    public String getFileFormatText() {
        return PwsFileSocket.getFileFormatText(this.dbf.getFormatVersion());
    }

    public static final String getFileFormatText(int n) {
        if (n > 0 & n <= 3) {
            return "PW" + n;
        }
        return null;
    }

    public int getFileFormat() {
        return this.dbf.getFormatVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilePath(String string) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.setFilePath(string);
            this.backupManager.refresh();
        }
    }

    public void setFileFormat(int n) {
        this.dbf.setFormatVersion(n);
    }

    public int getUKFCount() {
        return this.dbf.getUnknownFieldCount();
    }

    public long getUKFSize() {
        return this.dbf.getUnknownFieldSize();
    }

    public PersistentOptions getOptions() {
        return this.fOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PwsRecord pwsRecord) throws NoSuchRecordException {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.updateRecord(pwsRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PwsRecordList updateRecordList(PwsRecordList pwsRecordList) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            return this.dbf.updateRecordList(pwsRecordList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PwsRecordList updateRecordList(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            return this.dbf.updateRecordList(new PwsRecordList(defaultRecordWrapperArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(PwsRecord pwsRecord) throws DuplicateEntryException {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.addRecord(pwsRecord);
        }
    }

    public static PwsRecord duplicateRecord(PwsRecord pwsRecord) {
        PwsRecord pwsRecord2 = (PwsRecord)pwsRecord.clone();
        pwsRecord2.setRecordID(new UUID());
        long l = System.currentTimeMillis();
        pwsRecord2.setCreateTime(l);
        pwsRecord2.setModifyTime(l);
        return pwsRecord2;
    }

    public static DefaultRecordWrapper[] duplicateRecords(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        DefaultRecordWrapper[] defaultRecordWrapperArray2 = new DefaultRecordWrapper[defaultRecordWrapperArray.length];
        for (int i = 0; i < defaultRecordWrapperArray.length; ++i) {
            DefaultRecordWrapper defaultRecordWrapper = defaultRecordWrapperArray[i];
            PwsRecord pwsRecord = PwsFileSocket.duplicateRecord(defaultRecordWrapper.getRecord());
            defaultRecordWrapperArray2[i] = new DefaultRecordWrapper(pwsRecord, defaultRecordWrapper.getLocale());
        }
        return defaultRecordWrapperArray2;
    }

    public PwsRecord[] groupDuplicates(String string) {
        DefaultRecordWrapper[] defaultRecordWrapperArray = this.getGroupRecords(string);
        ArrayList<PwsRecord> arrayList = new ArrayList<PwsRecord>(defaultRecordWrapperArray.length);
        for (int i = 0; i < defaultRecordWrapperArray.length; ++i) {
            PwsRecord pwsRecord = PwsFileSocket.duplicateRecord(defaultRecordWrapperArray[i].getRecord());
            arrayList.add(pwsRecord);
        }
        return arrayList.toArray(new PwsRecord[0]);
    }

    public String getNewGroupName(String string) {
        String string2 = string;
        int n = 0;
        while (this.dbf.containsGroup(string2)) {
            string2 = string + "-" + ++n;
        }
        return string2;
    }

    protected void storeFileOptions() {
        this.fOptions.setOption("recentFindTexts", this.recentFinds.getStringContent());
        String string = this.optionString.trim();
        if (!this.fOptions.isEmpty()) {
            String string2 = this.fOptions.toString();
            while (string2.charAt(0) == '#') {
                string2 = string2.substring(string2.indexOf(10) + 1);
            }
            string2 = Util.CSV.quoteText(string2);
            string = string + " JPWS-OPTIONS=" + string2;
        }
        this.dbf.setUserOptions(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() throws JPWS_Exception, PasswordSafeException, IOException {
        if (this.isModified()) {
            PwsFile pwsFile = this.dbf;
            synchronized (pwsFile) {
                if (!this.hasPersistentFile()) {
                    throw new UndefinedPersistencyException();
                }
                if (!Global.requestCriticalPhase(this.getUrl())) {
                    throw new IO_OverrunException();
                }
                try {
                    if (Options.isOptionSet("autoBackup")) {
                        this.backupManager.performBackup();
                    }
                    this.storeFileOptions();
                    this.dbf.save();
                    this.resetModified();
                }
                finally {
                    Global.endCriticalPhase(this.url);
                }
            }
        }
    }

    public boolean emergencySave() {
        boolean bl = this.isModified();
        if (!bl) {
            return true;
        }
        if (this.isCriticalPhase()) {
            return false;
        }
        System.out.println("# starting EMERGENCY SAVE");
        boolean bl2 = !this.dbf.hasResource();
        this.setEventPause(true);
        try {
            if (bl2) {
                File file = File.createTempFile("jpws-", ".dat", Global.getUserDir());
                this.dbf.setApplication(Global.getLocalFileAdapter());
                this.dbf.setFilePath(file.getAbsolutePath().replaceAll("\\\\", "/"));
                Options.setOption("emergency", this.dbf.getFilePath());
            } else if (!Options.isOptionSet("autoBackup")) {
                try {
                    String string = this.getFilePath().concat(".sec");
                    this.dbf.getContextFile().copyTo(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.saveFile();
        }
        catch (Exception exception) {
            System.out.println("# *** EMERGENCY SAVE FAULT !! ".concat(exception.toString()));
            return false;
        }
        System.out.println("# DATABASE saved ok");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(URL uRL, boolean bl) throws JPWS_Exception, PasswordSafeException, IOException {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            UUID uUID = this.saveCopyIntern(uRL, null, bl);
            this.dbf.setApplication(Global.getAdapter(uRL));
            this.setFilePath(Global.getFilePath(uRL));
            if (uUID != null) {
                this.dbf.setUUID(uUID);
            }
            this.resetModified();
            this.fileSaved();
        }
    }

    public void saveCopy(URL uRL, PwsPassphrase pwsPassphrase, boolean bl) throws IO_OverrunException, PasswordSafeException, IOException {
        this.saveCopyIntern(uRL, pwsPassphrase, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID saveCopyIntern(URL uRL, PwsPassphrase pwsPassphrase, boolean bl) throws IO_OverrunException, PasswordSafeException, IOException {
        if (uRL == null) {
            throw new NullPointerException();
        }
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            UUID uUID;
            if (!Global.requestCriticalPhase(uRL)) {
                throw new IO_OverrunException();
            }
            ApplicationAdapter applicationAdapter = Global.getAdapter(uRL);
            try {
                this.storeFileOptions();
                uUID = this.dbf.saveCopy(applicationAdapter, Global.getFilePath(uRL), pwsPassphrase, this.getFileFormat(), bl);
            }
            finally {
                Global.endCriticalPhase(uRL);
            }
            return uUID;
        }
    }

    public DefaultRecordWrapper[] deleteGroup(String string) {
        DefaultRecordWrapper[] defaultRecordWrapperArray = this.getGroupRecords(string);
        if (defaultRecordWrapperArray.length != 0) {
            this.deleteEntries(defaultRecordWrapperArray);
        }
        return defaultRecordWrapperArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntries(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        if (defaultRecordWrapperArray != null && defaultRecordWrapperArray.length > 0) {
            PwsFile pwsFile = this.dbf;
            synchronized (pwsFile) {
                PwsRecordList pwsRecordList = new PwsRecordList(defaultRecordWrapperArray);
                this.dbf.removeRecordList(pwsRecordList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveEntries(DefaultRecordWrapper[] defaultRecordWrapperArray, String string, boolean bl) {
        if (defaultRecordWrapperArray != null && defaultRecordWrapperArray.length > 0) {
            PwsFile pwsFile = this.dbf;
            synchronized (pwsFile) {
                this.dbf.moveRecords(defaultRecordWrapperArray, string, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PwsRecordList mergeDatabase(PwsRecordList pwsRecordList, int n) {
        if (pwsRecordList == null) {
            throw new NullPointerException();
        }
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            return this.dbf.merge(pwsRecordList, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void substituteContent(PwsRecordList pwsRecordList) throws PasswordSafeException {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            if (pwsRecordList instanceof PwsFile) {
                boolean bl = this.dbf.getEventPause();
                this.dbf.setEventPause(true);
                PwsFile pwsFile2 = (PwsFile)pwsRecordList;
                this.dbf.setFormatVersion(pwsFile2.getFormatVersion());
                this.dbf.setSecurityLoops(pwsFile2.getSecurityLoops());
                this.dbf.setHeaderFields(pwsFile2.getHeaderFields());
                this.dbf.setPassphrase(pwsFile2.getPassphrase());
                this.initFileOptions();
                this.dbf.setEventPause(bl);
            }
            this.dbf.clear();
            this.addRecordList(pwsRecordList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordList(DefaultRecordWrapper[] defaultRecordWrapperArray) throws PasswordSafeException {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.addRecordList(new PwsRecordList(defaultRecordWrapperArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordList(PwsRecordList pwsRecordList) throws PasswordSafeException {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.addRecordList(pwsRecordList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecordList(PwsRecordList pwsRecordList) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.removeRecordList(pwsRecordList);
        }
    }

    public void resetModified() {
        this.modified = false;
        this.dbf.resetModified();
        this.recentFinds.resetModified();
        this.reportPropertyChange(4);
    }

    public void setModified() {
        this.modified = true;
        this.reportPropertyChange(4);
    }

    public void setEventPause(boolean bl) {
        this.eventPause = bl;
        this.dbf.setEventPause(bl);
    }

    public boolean isCriticalPhase() {
        return this.hasPersistentFile() && Global.isCriticalPhase(this.getUrl());
    }

    public boolean canWrite() {
        return this.hasPersistentFile() && this.dbf.getApplication().canWrite(this.dbf.getFilePath());
    }

    public void close(boolean bl) throws JPWS_Exception, PasswordSafeException, IOException {
        if (this.isOpen & bl) {
            this.saveFile();
        }
        this.isOpen = false;
        this.changeListeners.clear();
        this.sortList = null;
        this.filterList = null;
        this.dbf.removeFileListener(this.fileListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnknownFields() {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.clearUnknownFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStoredSize() {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            return this.dbf.getBlockedDataSize(this.dbf.getFormatVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStoreTime() {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            try {
                return this.dbf.getApplication().getModifiedTime(this.dbf.getFilePath());
            }
            catch (Exception exception) {
                return 0L;
            }
        }
    }

    public List getAutoBackups() {
        return this.backupManager.getBackupList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findMatching(int n, String string, boolean bl, boolean bl2) {
        if (string != null && string.length() != 0) {
            PwsFile pwsFile = this.dbf;
            synchronized (pwsFile) {
                this.getRecentFinds().pushRecent(string);
                this.reportPropertyChange(4);
                for (int i = n + 1; i < this.filterList.size(); ++i) {
                    if (!this.filterList.getItemAt(i).hasText(string, bl, bl2)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public RecentList getRecentFinds() {
        return Options.isOptionSet("storeMinorChanges") ? this.recentFinds : Global.recentFinds;
    }

    public PwsFile getPwsFile() {
        return this.dbf;
    }

    public OrderedRecordList getOrderedList() {
        return this.filterList;
    }

    public String getFileName() {
        String string = "?";
        String string2 = this.dbf.getFilePath();
        if (string2 != null) {
            string = Util.fileNameOfPath(string2);
        }
        return string;
    }

    public String getDatabaseName() {
        String string;
        if (!Options.isOptionSet("logicalFilenames") || (string = this.getHeaderValue(9)) == null) {
            string = this.getFileName();
        }
        return string;
    }

    public UUID getUUID() {
        return this.dbf.getUUID();
    }

    public String getFilePath() {
        return this.dbf.getFilePath();
    }

    public PwsRecord getRecord(UUID uUID) {
        return this.dbf.getRecord(uUID);
    }

    public int getRecordCount() {
        return this.dbf.getRecordCount();
    }

    public int getFilteredSize() {
        return this.filterList.size();
    }

    public ApplicationAdapter getApplication() {
        return this.dbf.getApplication();
    }

    public URL getUrl() {
        if (this.url != null) {
            return this.url;
        }
        String string = this.getFilePath();
        if (string == null) {
            return null;
        }
        try {
            this.url = Util.makeFileURL(string);
            return this.url;
        }
        catch (IOException iOException) {
            System.out.println("*** Illegal Filepath: " + string);
            System.out.println(iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeaderValue(int n) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            PwsRawField pwsRawField = this.dbf.getHeaderFields().getField(n);
            return pwsRawField == null ? null : pwsRawField.getString("utf-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderFieldList getHeaderFields() {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            return (HeaderFieldList)this.dbf.getHeaderFields().clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeaderFields(HeaderFieldList headerFieldList) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.setHeaderFields(headerFieldList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeaderField(int n, String string) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            try {
                if (string == null || string.length() == 0) {
                    this.dbf.getHeaderFields().removeField(n);
                } else {
                    byte[] byArray = string.getBytes("utf-8");
                    this.dbf.getHeaderFields().setField(new PwsRawField(n, byArray));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecurityLoops(int n) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.setSecurityLoops(n);
        }
    }

    public int getSecurityLoops() {
        return this.dbf.getSecurityLoops();
    }

    public PwsPassphrase getPassphrase() {
        return this.dbf.getPassphrase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassphrase(PwsPassphrase pwsPassphrase) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            this.dbf.setPassphrase(pwsPassphrase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRecordWrapper[] getGroupRecords(String string) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            return this.getOrderedList().getGroup(string, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRecordWrapper[] getAbsoluteGroupRecords(String string) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            DefaultRecordWrapper[] defaultRecordWrapperArray = new DefaultRecordWrapper[this.dbf.getGrpRecordCount(string, true)];
            Iterator iterator = this.dbf.getGroupedRecords(string, true);
            int n = 0;
            while (iterator.hasNext()) {
                defaultRecordWrapperArray[n] = new DefaultRecordWrapper((PwsRecord)iterator.next(), null);
                ++n;
            }
            return defaultRecordWrapperArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRecordWrapper[] getImportedRecords(PwsRecordList pwsRecordList) {
        ArrayList<PwsRecord> arrayList;
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            arrayList = new ArrayList<PwsRecord>();
            Iterator iterator = this.dbf.iterator();
            while (iterator.hasNext()) {
                PwsRecord pwsRecord = (PwsRecord)iterator.next();
                if (pwsRecord.getImportStatus() == 0 || pwsRecordList != null && !pwsRecordList.contains(pwsRecord)) continue;
                arrayList.add(pwsRecord);
            }
        }
        PwsRecord[] pwsRecordArray = new PwsRecord[arrayList.size()];
        arrayList.toArray(pwsRecordArray);
        return DefaultRecordWrapper.makeWrappers(pwsRecordArray, null);
    }

    public List getGroupList() {
        return this.dbf.getGroupList();
    }

    public int getGroupCount() {
        return this.dbf.getGroupCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSignature() {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            return this.dbf.getSignature();
        }
    }

    protected void fileUpdated() {
        this.fireChangeEvent(6);
        this.reportPropertyChange(4);
    }

    protected void fileSaved() {
        if (this.eventPause) {
            return;
        }
        this.fileUpdated();
        this.lastSaveTime = System.currentTimeMillis();
        if (this.getFilterStatus() == 3) {
            this.filterList.refresh();
        }
    }

    public void setFilterStatus(int n) {
        if (n == this.filterOption) {
            return;
        }
        this.filterOption = n;
        this.filterList.refresh();
        this.reportPropertyChange(5);
    }

    public int getFilterStatus() {
        return this.filterOption;
    }

    public void setExpireScope(long l) {
        this.filterList.setExpireScope(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRecordWrapper[] renameGroup(String string, String string2) {
        PwsFile pwsFile = this.dbf;
        synchronized (pwsFile) {
            DefaultRecordWrapper[] defaultRecordWrapperArray = new DefaultRecordWrapper[]{};
            if (this.dbf.getGrpRecordCount(string, true) > 0) {
                String string3 = this.groupAncestors(string);
                if (string2 != null) {
                    defaultRecordWrapperArray = this.dbf.renameGroup(string, string3 + string2).toRecordWrappers(null);
                }
            }
            return defaultRecordWrapperArray;
        }
    }

    private String groupAncestors(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string2 = string.substring(0, n + 1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveGroup(String string, String string2) {
        if (string2 != null) {
            PwsFile pwsFile = this.dbf;
            synchronized (pwsFile) {
                String string3 = this.groupAncestors(string);
                DefaultRecordWrapper[] defaultRecordWrapperArray = this.getGroupRecords(string);
                for (int i = 0; i < defaultRecordWrapperArray.length; ++i) {
                    PwsRecord pwsRecord = defaultRecordWrapperArray[i].getRecord();
                    String string4 = pwsRecord.getGroup();
                    String string5 = string2 + "." + string4.substring(string3.length());
                    pwsRecord.setGroup(string5);
                    try {
                        this.dbf.updateRecord(pwsRecord);
                        continue;
                    }
                    catch (NoSuchRecordException noSuchRecordException) {
                        throw new IllegalStateException("PwsFileSocket.moveGroup():\r\n" + noSuchRecordException);
                    }
                }
            }
        }
    }

    protected void reportPropertyChange(int n) {
        if (this.eventPause) {
            return;
        }
        switch (n) {
            case 5: {
                int n2 = this.getFilterStatus();
                if (n2 != this.reportedFilterMode) {
                    this.fireChangeEvent(5);
                }
                this.reportedFilterMode = n2;
                break;
            }
            case 4: {
                boolean bl = this.isModified();
                if (bl != this.reportedModifyState) {
                    this.fireChangeEvent(4);
                }
                this.reportedModifyState = bl;
            }
        }
    }

    public void eraseBackups() {
        this.backupManager.eraseFiles();
    }

    private class FileOptions
    extends OptionBag {
        private FileOptions() {
        }

        public void setIntOption(String string, int n) {
            int n2 = this.getIntOption(string);
            if (n2 != n) {
                super.setIntOption(string, n);
                if (Options.isOptionSet("storeMinorChanges")) {
                    PwsFileSocket.this.setModified();
                }
            }
        }

        public void setLongOption(String string, long l) {
            long l2 = this.getLongOption(string);
            if (l2 != l) {
                super.setLongOption(string, l);
                if (Options.isOptionSet("storeMinorChanges")) {
                    PwsFileSocket.this.setModified();
                }
            }
        }

        public void setOption(String string, boolean bl) {
            boolean bl2 = this.isOptionSet(string);
            if (bl2 != bl) {
                super.setOption(string, bl);
                if (Options.isOptionSet("storeMinorChanges")) {
                    PwsFileSocket.this.setModified();
                }
            }
        }

        public void setOption(String string, String string2) {
            String string3 = this.getOption(string);
            if (!string3.equals(string2)) {
                super.setOption(string, string2);
                if (Options.isOptionSet("storeMinorChanges")) {
                    PwsFileSocket.this.setModified();
                }
            }
        }

        public void setProperty(String string, String string2) {
            String string3 = this.getOption(string);
            if (!string3.equals(string2)) {
                super.setProperty(string, string2);
                if (Options.isOptionSet("storeMinorChanges")) {
                    PwsFileSocket.this.setModified();
                }
            }
        }
    }

    private class BackupManager {
        private ArrayList backups = new ArrayList();
        private boolean active = true;

        private BackupManager() {
        }

        public void refresh() {
            String[] stringArray;
            String string;
            this.backups.clear();
            if (!PwsFileSocket.this.hasPersistentFile()) {
                return;
            }
            ApplicationAdapter applicationAdapter = PwsFileSocket.this.getApplication();
            String string2 = string = PwsFileSocket.this.getFilePath();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            try {
                stringArray = applicationAdapter.list(string, ".bak", false);
                if (stringArray == null) {
                    this.active = false;
                    return;
                }
            }
            catch (IOException iOException) {
                System.out.println("*** ERROR in Backup Manager (refresh): \r\n" + iOException);
                this.active = false;
                return;
            }
            for (n = 0; n < stringArray.length; ++n) {
                String string3 = stringArray[n];
                int n2 = string3.lastIndexOf("SEC-");
                if (n2 != string.length() + 1 || string3.equals(string2)) continue;
                try {
                    String string4 = string3.substring(n2 + 4, n2 + 19);
                    long l = Util.timeFromString(string4, null);
                    if (l == -1L) continue;
                    this.sortIn(new ContextFile(applicationAdapter, string3));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortIn(ContextFile contextFile) {
            ArrayList arrayList = this.backups;
            synchronized (arrayList) {
                int n = this.backups.size();
                for (int i = 0; i < this.backups.size(); ++i) {
                    ContextFile contextFile2 = (ContextFile)this.backups.get(i);
                    if (contextFile2.getFilepath().compareTo(contextFile.getFilepath()) > 0) continue;
                    n = i;
                    break;
                }
                this.backups.add(n, contextFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void truncate(int n) throws IOException {
            ArrayList arrayList = this.backups;
            synchronized (arrayList) {
                while (this.backups.size() > n) {
                    int n2 = this.backups.size() - 1;
                    ContextFile contextFile = (ContextFile)this.backups.get(n2);
                    if (!contextFile.delete()) {
                        throw new IOException("unable to remove file: " + contextFile.getFilepath());
                    }
                    this.backups.remove(n2);
                }
            }
        }

        private String targetPath(String string) throws IOException {
            long l = PwsFileSocket.this.dbf.lastModified();
            if (l == 0L) {
                l = System.currentTimeMillis();
            }
            String string2 = Util.standardTimeString(l, Util.GMT);
            string2 = Util.substituteText(string2, ":", "");
            string2 = Util.substituteText(string2, "-", "");
            string2 = Util.substituteText(string2, " ", "-");
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            String string3 = string + " SEC-" + string2 + ".bak";
            return string3;
        }

        public boolean performBackup() {
            ApplicationAdapter applicationAdapter;
            String string;
            System.out.println("- starting PERFORM AUTO-BACKUP");
            if (!this.active || (string = PwsFileSocket.this.getFilePath()) == null || (applicationAdapter = PwsFileSocket.this.getApplication()) == null) {
                return false;
            }
            ContextFile contextFile = new ContextFile(applicationAdapter, string);
            ContextFile contextFile2 = null;
            try {
                String string2 = this.targetPath(string);
                contextFile2 = new ContextFile(applicationAdapter, string2);
                if (!contextFile2.canWrite()) {
                    return false;
                }
                int n = Math.max(0, Options.getIntOption("autoBackupFiles") - 1);
                this.truncate(n);
                contextFile.copyTo(contextFile2);
                this.sortIn(contextFile2);
                return true;
            }
            catch (Exception exception) {
                System.out.println("*** ERROR in Backup Manager (perform): \r\n" + exception);
                return false;
            }
        }

        public void eraseFiles() {
            try {
                this.truncate(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public List getBackupList() {
            return (List)this.backups.clone();
        }
    }

    private static class EventReporter
    implements ChangeListener {
        private EventReporter() {
        }

        public void stateChanged(javax.swing.event.ChangeEvent changeEvent) {
            int n = ((ChangeEvent)changeEvent).getState();
            PwsFileSocket pwsFileSocket = (PwsFileSocket)changeEvent.getSource();
            String string = null;
            String string2 = "?";
            if (n == 5) {
                int n2 = pwsFileSocket.getFilterStatus();
                string = "FILTER MODE";
                switch (n2) {
                    case 0: {
                        string2 = "FILTER OFF";
                        break;
                    }
                    case 1: {
                        string2 = "FILTER EXPIRING";
                        break;
                    }
                    case 2: {
                        string2 = "FILTER IMPORTED";
                        break;
                    }
                    case 3: {
                        string2 = "FILTER MODIFIED";
                    }
                }
            } else if (n == 4) {
                string = "MODIFY_STATUS";
                String string3 = string2 = pwsFileSocket.isModified() ? "MODIFIED" : "UNMODIFIED";
            }
            if (string != null) {
                System.out.println("+++ New Socket State: " + string + " == " + string2);
            }
        }
    }

    public static class ChangeEvent
    extends javax.swing.event.ChangeEvent {
        private int changeProperty;

        public ChangeEvent(Object object, int n) {
            super(object);
            this.changeProperty = n;
        }

        public int getState() {
            return this.changeProperty;
        }
    }

    private class FileListener
    implements PwsFileListener {
        private FileListener() {
        }

        public void fileStateChanged(PwsFileEvent pwsFileEvent) {
            switch (pwsFileEvent.getType()) {
                case 7: {
                    PwsFileSocket.this.fileSaved();
                    break;
                }
                case 5: {
                    PwsFileSocket.this.url = null;
                }
                default: {
                    PwsFileSocket.this.fileUpdated();
                }
            }
        }
    }

    private class RecordFilter
    extends FilterRecordList
    implements PwsFileListener {
        public RecordFilter(OrderedRecordList orderedRecordList) {
            super(orderedRecordList);
        }

        public boolean acceptEntry(PwsRecord pwsRecord) {
            switch (PwsFileSocket.this.filterOption) {
                case 1: {
                    return pwsRecord.willExpire(System.currentTimeMillis() + Options.getLongOption("expireScope"));
                }
                case 2: {
                    return pwsRecord.getImportStatus() == 1 || pwsRecord.getImportStatus() == 2;
                }
                case 3: {
                    return pwsRecord.getModifiedTime() > PwsFileSocket.this.lastSaveTime;
                }
            }
            return true;
        }
    }
}

