/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import org.jpws.front.Global;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.ResourceLoader;

public class AboutDialog
extends ButtonBarDialog {
    private JEditorPane epane = new JEditorPane();
    private JPanel content;
    private HyperlinkListener hyperListener;

    public AboutDialog() throws HeadlessException {
        super((Frame)Global.mainFrame, 1, true);
        this.setTitle(ResourceLoader.getDisplay("about.title"));
        this.content = new JPanel(new BorderLayout());
        this.buildTopPanel();
        this.buildCentrePanel();
        Global.mainFrame.addChildDialog(this);
        this.setDialogPanel(this.content);
        this.setVisible(true);
    }

    private void destruct() {
        this.epane.removeHyperlinkListener(this.hyperListener);
        this.hyperListener = null;
    }

    public void dispose() {
        super.dispose();
        this.destruct();
    }

    private void buildCentrePanel() {
        this.hyperListener = this.createHyperLinkListener();
        this.epane.setPreferredSize(new Dimension(550, 412));
        this.epane.setBorder(new EmptyBorder(0, 40, 0, 40));
        this.epane.setEditable(false);
        this.epane.setOpaque(false);
        this.epane.setContentType("text/html;charset=ISO-8859-1");
        this.epane.addHyperlinkListener(this.hyperListener);
        try {
            String string = ResourceLoader.getCommand("html.file.about");
            URL uRL = ResourceLoader.getResourceURL("#standards/" + string);
            this.epane.setPage(uRL);
        }
        catch (IOException iOException) {
            this.epane.setContentType("text/plain");
            this.epane.setText(iOException.toString());
        }
        JScrollPane jScrollPane = new JScrollPane(this.epane);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.content.add((Component)jScrollPane, "Center");
    }

    private void buildTopPanel() {
    }

    public HyperlinkListener createHyperLinkListener() {
        return Global.createHyperLinkListener();
    }
}

