/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jpws.data.Options;
import org.jpws.front.AboutDialog;
import org.jpws.front.DatabaseDialog;
import org.jpws.front.FileOpenDialog;
import org.jpws.front.FindTextDialog;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.ImportCSVDialog;
import org.jpws.front.MenuHandler;
import org.jpws.front.PasswordDialog;
import org.jpws.front.PolicyDialog;
import org.jpws.front.PreferencesDialog;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.Service;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.DefaultButtonBarListener;
import org.jpws.front.util.HtmlBrowserDialog;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsFileFactory;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.data.PwsRecordList;
import org.jpws.pwslib.exception.InputInterruptedException;
import org.jpws.pwslib.exception.InvalidPassphraseException;
import org.jpws.pwslib.exception.NoSuchRecordException;
import org.jpws.pwslib.exception.UnsupportedFileVersionException;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.persist.ApplicationAdapter;
import sun.net.ftp.FtpLoginException;

public class ActionHandler {
    private static ActionListener actionListener = new MainActionListener();
    private static ObjectChangeListener changableObjListener = new ObjectChangeListener();
    private static long lastUseTime;
    private static Action clearClipAction;
    public static final int OP_SENDCLIPBOARD = 1;
    public static final int OP_PASSMODIFIED = 2;

    private ActionHandler() {
    }

    public static void init() {
        lastUseTime = System.currentTimeMillis();
        clearClipAction = new AbstractAction(ResourceLoader.getCommand("menu.edit.clearclip"), ResourceLoader.getImageIcon("clearclip")){

            public void actionPerformed(ActionEvent actionEvent) {
                actionListener.actionPerformed(actionEvent);
            }
        };
        clearClipAction.putValue("ShortDescription", ResourceLoader.getCommand("toolbar.clearclip.tooltip"));
        clearClipAction.putValue("ActionCommandKey", "menu.edit.clearclip");
    }

    public static Action getClearClipAction() {
        return clearClipAction;
    }

    public static ActionListener getMainActionListener() {
        return actionListener;
    }

    public static long getIdleTime() {
        return System.currentTimeMillis() - lastUseTime;
    }

    public static void resetIdleTime() {
        lastUseTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PwsFileContainer newFileToShelf(final PwsRecordList pwsRecordList) {
        final PwsFile pwsFile = new PwsFile();
        final PwsFileContainer pwsFileContainer = new PwsFileContainer(pwsFile);
        pwsFileContainer.setSecurityLoops(Options.getIntOption("newFileSecurity"));
        final DatabaseDialog databaseDialog = new DatabaseDialog(pwsFileContainer, "dlg.database.new", pwsRecordList == null);
        Global.mainFrame.addChildDialog(databaseDialog);
        DatabaseDialog databaseDialog2 = databaseDialog;
        databaseDialog2.getClass();
        databaseDialog.setButtonBarListener(new DatabaseDialog.BarListener(databaseDialog2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean okButtonPerformed() {
                boolean bl = false;
                if (super.okButtonPerformed()) {
                    PwsPassphrase pwsPassphrase = GUIService.enterNewPassphrase(ResourceLoader.getDisplay("ui.newtitle"));
                    if (pwsPassphrase != null) {
                        pwsFile.setPassphrase(pwsPassphrase);
                        if (pwsRecordList != null) {
                            pwsFile.merge(pwsRecordList, 0);
                        }
                        if (!Global.hasSelectedFile() || Global.getSelectedFile().close()) {
                            Global.setSelectedFile(pwsFileContainer);
                            bl = true;
                        }
                    }
                    DatabaseDialog databaseDialog2 = databaseDialog;
                    synchronized (databaseDialog2) {
                        databaseDialog.notify();
                    }
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancelButtonPerformed() {
                super.cancelButtonPerformed();
                DatabaseDialog databaseDialog2 = databaseDialog;
                synchronized (databaseDialog2) {
                    databaseDialog.notify();
                }
            }
        });
        databaseDialog.show();
        DatabaseDialog databaseDialog3 = databaseDialog;
        synchronized (databaseDialog3) {
            try {
                databaseDialog.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return pwsFileContainer == Global.getSelectedFile() ? pwsFileContainer : null;
    }

    public static void openFileToShelfUrl() {
        JTextField jTextField;
        JComboBox jComboBox;
        RecentList recentList;
        if (Global.isDialogActive("OpenFileToShelf_URL")) {
            return;
        }
        final boolean bl = Options.isOptionSet("useRecentList");
        final ButtonBarDialog buttonBarDialog = new ButtonBarDialog(Global.getActiveFrame(), 4, false);
        buttonBarDialog.markSingleton("OpenFileToShelf_URL");
        buttonBarDialog.setTitle(ResourceLoader.getDisplay("dlg.urlcon"));
        buttonBarDialog.moveRelatedTo(Global.mainFrame);
        Global.mainFrame.addChildDialog(buttonBarDialog);
        final JButton jButton = new JButton(ResourceLoader.getDisplay("button.clear"));
        buttonBarDialog.getButtonBar().add(jButton);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("URL: "));
        if (bl) {
            recentList = new RecentList(8);
            recentList.setContent(Options.getOption("connector.URL.recent"));
            jComboBox = new JComboBox(recentList);
            Dimension dimension = jComboBox.getPreferredSize();
            jComboBox.setPreferredSize(new Dimension(350, dimension.height));
            if (recentList.getSize() > 0) {
                jComboBox.setSelectedItem(recentList.getFirst());
            }
            jComboBox.setEditable(true);
            jPanel.add(jComboBox);
            jTextField = null;
        } else {
            jTextField = new JTextField(35);
            jPanel.add(jTextField);
            jComboBox = null;
            recentList = null;
        }
        buttonBarDialog.setButtonBarListener(new DefaultButtonBarListener(buttonBarDialog){

            public boolean okButtonPerformed() {
                block7: {
                    buttonBarDialog.dispose();
                    String string = bl ? (String)jComboBox.getSelectedItem() : jTextField.getText();
                    try {
                        URL uRL;
                        block8: {
                            if (string == null || string.length() == 0) break block7;
                            try {
                                uRL = new URL(string);
                            }
                            catch (MalformedURLException malformedURLException) {
                                String string2 = string;
                                string = "http://".concat(string);
                                uRL = new URL(string);
                                if (!bl) break block8;
                                recentList.replaceRecent(string2, string);
                            }
                        }
                        if (bl) {
                            Options.setOption("connector.URL.recent", recentList.getStringContent());
                        }
                        if (Util.isFileProtocol(uRL)) {
                            ActionHandler.openFileToShelf(uRL.getPath());
                        } else {
                            ActionHandler.openFileToShelf(uRL);
                        }
                    }
                    catch (Exception exception) {
                        GUIService.infoMessage(null, "msg.url.formerror");
                    }
                }
                return false;
            }

            public void helpButtonPerformed() {
                GUIService.startHelpDialog(buttonBarDialog, "dlg.help.open_url");
            }

            public boolean extraButtonPerformed(Object object) {
                if (object == jButton & recentList != null) {
                    recentList.clear();
                    Options.setOption("connector.URL.recent", recentList.getStringContent());
                }
                return true;
            }
        });
        buttonBarDialog.setDialogPanel(jPanel);
        buttonBarDialog.show();
    }

    public static void openFileToShelf() {
        FileOpenDialog fileOpenDialog = new FileOpenDialog(3, Global.currentDir);
        if (fileOpenDialog.showOpenDialog(Global.mainFrame) == 0) {
            ActionHandler.openFileToShelf(fileOpenDialog.getSelectedFile().getPath());
        }
        Global.currentDir = fileOpenDialog.getCurrentDirectory();
    }

    public static PwsFile openOrNewFile(Component component, String string, File file) {
        PwsFile pwsFile;
        FileOpenDialog fileOpenDialog = new FileOpenDialog(1, file != null ? file : Global.currentDir);
        fileOpenDialog.setDialogTitle(ResourceLoader.codeOrRealDisplay(string));
        if (fileOpenDialog.showOpenDialog(component) != 0) {
            return null;
        }
        try {
            File file2 = fileOpenDialog.getSelectedFile();
            String string2 = Service.normalizedFilepath(file2.getPath(), ".dat");
            if (file2.isFile()) {
                pwsFile = ActionHandler.openFilePws(Util.makeFileURL(string2));
            } else {
                PwsPassphrase pwsPassphrase = GUIService.enterNewPassphrase(Util.fileNameOfPath(string2));
                if (pwsPassphrase == null) {
                    return null;
                }
                pwsFile = new PwsFile();
                pwsFile.setPassphrase(pwsPassphrase);
                pwsFile.setApplication(Global.getLocalFileAdapter());
                pwsFile.setFilePath(string2);
            }
        }
        catch (IOException iOException) {
            GUIService.failureMessage("msg.url.formerror", iOException);
            return null;
        }
        return pwsFile;
    }

    public static void openFileToShelf(String string) {
        try {
            ActionHandler.openFileToShelf(Util.makeFileURL(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GUIService.failureMessage("msg.url.formerror", exception);
            return;
        }
    }

    public static void openFileToShelf(URL uRL) {
        if (!Global.requestCriticalPhase(uRL)) {
            return;
        }
        String string = Global.getFilePath(uRL);
        if (Global.isOpenFile(string)) {
            GUIService.infoMessage(null, "msg.doubleopen");
            Global.endCriticalPhase(uRL);
            return;
        }
        PwsFile pwsFile = ActionHandler.openFilePws(uRL);
        if (pwsFile == null) {
            Global.endCriticalPhase(uRL);
            return;
        }
        ActionHandler.putFileToShelf(pwsFile);
        Global.endCriticalPhase(uRL);
    }

    public static synchronized void putFileToShelf(PwsFile pwsFile) {
        if (pwsFile.getFormatVersion() == 3 && !pwsFile.isChecksumVerified()) {
            String string = ResourceLoader.getDisplay("msg.warning.badfilecrc");
            if (!GUIService.userConfirm(string = Util.substituteText(string, "$file", pwsFile.getFilePath()))) {
                return;
            }
        }
        if (Global.hasSelectedFile() && !Global.getSelectedFile().close()) {
            pwsFile.clear();
            return;
        }
        PwsFileContainer pwsFileContainer = new PwsFileContainer(pwsFile);
        Global.setSelectedFile(pwsFileContainer);
        Global.pushRecent(pwsFileContainer);
        pwsFileContainer.convert();
        if (Options.isOptionSet("expiryCheck")) {
            pwsFileContainer.showExpiredMessage(false);
        }
        if (Options.getOption("emergency").equals(pwsFile.getFilePath())) {
            Options.setOption("emergency", null);
        }
    }

    private static boolean testFileExistence(URL uRL) throws IOException {
        if (uRL == null) {
            return false;
        }
        ApplicationAdapter applicationAdapter = Global.getAdapter(uRL);
        return applicationAdapter.existsFile(Global.getFilePath(uRL));
    }

    public static PwsFile openFilePws(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            if (!ActionHandler.testFileExistence(uRL)) {
                return ActionHandler.openFilePws(uRL, new PwsPassphrase());
            }
        }
        catch (FtpLoginException ftpLoginException) {
            String string = ResourceLoader.getDisplay("msg.url.loginfailed");
            string = Util.substituteText(string, "$domain", uRL.getHost());
            GUIService.infoMessage("dlg.connect.failure", string);
            return null;
        }
        catch (InputInterruptedException inputInterruptedException) {
            return null;
        }
        catch (IOException iOException) {
            GUIService.failureMessage("msg.url.failconnect", iOException);
            return null;
        }
        PwsFile pwsFile = null;
        while (pwsFile == null) {
            boolean bl;
            String string = Util.fileNameOfPath(uRL.getFile());
            PasswordDialog passwordDialog = new PasswordDialog((Frame)Global.mainFrame, string, 0, bl = Global.getSelectedFile() == null);
            if (!passwordDialog.isOkPressed()) {
                return null;
            }
            PwsPassphrase pwsPassphrase = new PwsPassphrase(passwordDialog.getEnteredPassword());
            pwsFile = ActionHandler.openFilePws(uRL, pwsPassphrase);
        }
        return pwsFile;
    }

    public static PwsFile openFilePws(URL uRL, PwsPassphrase pwsPassphrase) {
        PwsFile pwsFile = null;
        if (uRL == null | pwsPassphrase == null) {
            return null;
        }
        String string = Global.getFilePath(uRL);
        try {
            if (!ActionHandler.testFileExistence(uRL)) {
                String string2 = ResourceLoader.getDisplay("msg.filenotfound");
                string2 = Util.substituteText(string2, "$path", string);
                GUIService.infoMessage("dlg.operrejected", string2);
                return null;
            }
        }
        catch (IOException iOException) {
            GUIService.failureMessage("msg.url.failconnect", iOException);
            return null;
        }
        try {
            pwsFile = PwsFileFactory.loadFile(Global.getAdapter(uRL), string, pwsPassphrase);
        }
        catch (InvalidPassphraseException invalidPassphraseException) {
            GUIService.infoMessage("dlg.accessdenied", "msg.failpassword");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = exception instanceof EOFException || exception instanceof UnsupportedFileVersionException ? "msg.wrongfile" : "msg.failure";
            GUIService.failureMessage(string3, exception);
        }
        return pwsFile;
    }

    public static void reopenFileFromRecents() {
        if (Global.recentFiles.getFirst() != null) {
            String string = Global.recentFiles.getFirst().toString();
            if (Global.isPortable()) {
                if (string != null && !Util.isFileProtocol(string)) {
                    System.out.println("-- Start Recent (PORTABLE III): ".concat(string));
                    ActionHandler.openFileToShelf(string);
                    return;
                }
                String string2 = Util.fileNameOfPath(string);
                Iterator iterator = Global.recentFiles.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    string = iterator.next().toString();
                    if (Util.isFileProtocol(string) && string.endsWith(string2) && new File(string).exists()) {
                        System.out.println("-- Start Recent (PORTABLE I): ".concat(string));
                        ActionHandler.openFileToShelf(string);
                        if (n != 0) {
                            GUIService.warningMessage(Global.mainFrame, null, "msg.file.notmostrecent");
                        }
                        return;
                    }
                    ++n;
                }
                iterator = Global.recentFiles.iterator();
                while (iterator.hasNext()) {
                    string = iterator.next().toString();
                    if (!Util.isFileProtocol(string) || !new File(string).exists()) continue;
                    System.out.println("-- Start Recent (PORTABLE II): ".concat(string));
                    ActionHandler.openFileToShelf(string);
                    GUIService.warningMessage(Global.mainFrame, null, "msg.file.notmostrecent");
                    return;
                }
                PwsFile pwsFile = ActionHandler.openOrNewFile(Global.mainFrame, "dlg.open.existornewfile", null);
                if (pwsFile != null) {
                    ActionHandler.putFileToShelf(pwsFile);
                }
            } else if (string != null) {
                System.out.println("-- Start Recent (NORMAL): ".concat(string));
                ActionHandler.openFileToShelf(string);
            }
        }
    }

    static void editGlobalPWPolicy() {
        final PolicyDialog policyDialog = new PolicyDialog((Frame)Global.mainFrame, Global.passphrasePolicy, 0);
        Global.mainFrame.addChildDialog(policyDialog);
        DefaultButtonBarListener defaultButtonBarListener = new DefaultButtonBarListener(){

            public boolean okButtonPerformed() {
                Global.passphrasePolicy = policyDialog.getEditedPolicy();
                return true;
            }
        };
        policyDialog.setButtonBarListener(defaultButtonBarListener);
        policyDialog.show();
    }

    public static void confirmOperation(int n, String string) {
        String string2;
        switch (n) {
            case 1: {
                string2 = ResourceLoader.getDisplay("confirm.clipsend");
                break;
            }
            default: {
                string2 = "? confirm operation ? : $action";
            }
        }
        String string3 = string == null ? "??" : ResourceLoader.codeOrRealDisplay(string);
        string2 = Util.substituteText(string2, "$action", string3);
        GUIService.infoMessage("confirm.operation", string2);
    }

    public static void clipboardUpdated() {
        boolean bl;
        try {
            bl = Global.clipboard.getContents(null).getTransferData(DataFlavor.stringFlavor) != null;
        }
        catch (Exception exception) {
            bl = false;
        }
        clearClipAction.setEnabled(bl);
    }

    public static void registerTextEditor(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(changableObjListener);
    }

    public static void registerChangeableObject(Object object) {
        if (object instanceof JTabbedPane) {
            ((JTabbedPane)object).addChangeListener(changableObjListener);
        } else if (object instanceof AbstractButton) {
            ((AbstractButton)object).addChangeListener(changableObjListener);
        } else if (object instanceof JComboBox) {
            ((JComboBox)object).addActionListener(changableObjListener);
        }
    }

    public static int editBrowserOption() {
        File file;
        FileOpenDialog fileOpenDialog = new FileOpenDialog(4, System.getProperty("user.home"));
        fileOpenDialog.setDialogTitle(ResourceLoader.getDisplay("dlg.choosebrowser"));
        int n = fileOpenDialog.showOpenDialog(Global.mainFrame);
        fileOpenDialog.dispose();
        if (n == 0 && (file = fileOpenDialog.getSelectedFile()) != null) {
            String string;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = "";
            }
            Options.setOption("browserApplication", string);
        }
        return n;
    }

    public static void showSystemInfo() {
        String string = "SystemInfoDialog";
        if (Global.isDialogActive("SystemInfoDialog")) {
            return;
        }
        TreeSet<Map.Entry<Object, Object>> treeSet = new TreeSet<Map.Entry<Object, Object>>(new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == null | object2 == null) {
                    throw new IllegalArgumentException();
                }
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return entry.getKey().toString().compareTo((String)entry2.getKey());
            }
        });
        Iterator<Map.Entry<Object, Object>> iterator = System.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<html><body><h3><u>Application Properties</u></h3>");
        stringBuffer.append("<font color=\"blue\"><b>Init Modus</b></font> = ");
        stringBuffer.append(Global.isPortable() ? "PORTABLE" : "NORMAL");
        stringBuffer.append("<br><font color=\"blue\"><b>OS Modus</b></font> = ");
        stringBuffer.append(Global.isUnixDerivate() ? "UNIX/LINUX" : "WINDOWS");
        stringBuffer.append("<br><font color=\"blue\"><b>Locale</b></font> = ");
        stringBuffer.append(Global.getLocaleString());
        stringBuffer.append("<br><font color=\"blue\"><b>Option File</b></font> = ");
        File file = Options.getPersistentFile();
        stringBuffer.append(file == null ? "- undefined -" : file.getAbsolutePath());
        String string2 = "";
        for (int i = 0; i < Global.commandlineArgs.length; ++i) {
            string2 = string2.concat(Global.commandlineArgs[i]).concat(" ");
        }
        stringBuffer.append("<br><font color=\"blue\"><b>Command Line</b></font> = ");
        stringBuffer.append(string2);
        if (Global.isPortable()) {
            stringBuffer.append("<br><font color=\"blue\"><b>Portable Root</b></font> = ");
            stringBuffer.append(Global.portableDir.getAbsolutePath());
        }
        stringBuffer.append("<br><font color=\"blue\"><b>Program Dir</b></font> = ");
        stringBuffer.append(Global.programDir.getAbsolutePath());
        stringBuffer.append("<br><font color=\"blue\"><b>Current Dir</b></font> = ");
        stringBuffer.append(Global.currentDir.getAbsolutePath());
        stringBuffer.append("<br><font color=\"blue\"><b>Backup Dir</b></font> = ");
        stringBuffer.append(Global.backDir.getAbsolutePath());
        stringBuffer.append("<br><font color=\"blue\"><b>Exchange Dir</b></font> = ");
        stringBuffer.append(Global.exchangeDir.getAbsolutePath());
        stringBuffer.append("<body><h3><u>Runtime System Properties</u></h3>");
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Map.Entry<Object, Object> entry = iterator.next();
            stringBuffer.append("<font color=\"maroon\"><b>");
            string2 = (String)entry.getKey();
            stringBuffer.append(Util.htmlEncoded(string2));
            stringBuffer.append("</b></font> = ");
            if (string2.startsWith("user.")) {
                stringBuffer.append("<font color=\"green\"><b>");
                bl = true;
            }
            if (string2.startsWith("java.vm.") || string2.startsWith("os.")) {
                stringBuffer.append("<font color=\"#005FBF\"><b>");
                bl = true;
            } else if (string2.startsWith("java.")) {
                stringBuffer.append("<font color=\"black\"><b>");
                bl = true;
            }
            stringBuffer.append(Util.htmlEncoded((String)entry.getValue()));
            if (bl) {
                stringBuffer.append("</b></font>");
            }
            stringBuffer.append("<br>");
        }
        stringBuffer.append("#</p></body></html>");
        String string3 = ResourceLoader.getDisplay("dlg.systeminfo");
        HtmlBrowserDialog htmlBrowserDialog = new HtmlBrowserDialog((Frame)Global.mainFrame, string3, false);
        htmlBrowserDialog.moveRelatedTo(Global.mainFrame);
        htmlBrowserDialog.markSingleton(string);
        Global.mainFrame.addChildDialog(htmlBrowserDialog);
        if (Toolkit.getDefaultToolkit().getScreenSize().width > 800) {
            htmlBrowserDialog.setSize(new Dimension(600, 400));
        }
        htmlBrowserDialog.setText(stringBuffer.toString());
        htmlBrowserDialog.show();
    }

    public static boolean sendClipboardPassword(PwsRecord pwsRecord) {
        PwsPassphrase pwsPassphrase = pwsRecord.getPassword();
        if (pwsPassphrase == null) {
            return false;
        }
        Global.setClipboardText(pwsPassphrase.getString());
        boolean bl = Global.hasClipboardTransfer();
        if (bl) {
            if (Options.isOptionSet("storeMinorChanges")) {
                pwsRecord.setAccessTime(System.currentTimeMillis());
            }
            GUIService.statusConfirm("msg.confirm.copyclippass", pwsRecord.getTitle());
            if (Options.isOptionSet("confirmCopyClipboard")) {
                ActionHandler.confirmOperation(1, "confirm.password");
            }
        }
        return bl;
    }

    public static void sendClipboardUsername(PwsRecord pwsRecord) {
        Global.setClipboardText(pwsRecord.getUsername());
        if (Global.hasClipboardTransfer()) {
            GUIService.statusConfirm("msg.confirm.copyclipuser", pwsRecord.getTitle());
            if (Options.isOptionSet("confirmCopyClipboard")) {
                ActionHandler.confirmOperation(1, "confirm.username");
            }
        }
    }

    public static Thread startTask(Runnable runnable) {
        Thread thread = new Thread(runnable, "ActionHandler OrderedTask");
        thread.start();
        return thread;
    }

    public static TimedThread startTaskDelayed(Runnable runnable, long l) {
        return new TimedThread(runnable, l);
    }

    public static void invokeActionLater(String string) {
        ActionHandler.startTask(new ActionRunner(string));
    }

    public static void invokeActionNow(String string) throws InterruptedException {
        ActionHandler.startTask(new ActionRunner(string)).join();
    }

    public static PwsFile passTryOpen(URL uRL, PwsPassphrase pwsPassphrase) {
        PwsFile pwsFile;
        if (uRL == null || !Global.requestCriticalPhase(uRL)) {
            return null;
        }
        try {
            pwsFile = PwsFileFactory.loadFile(Global.getAdapter(uRL), Global.getFilePath(uRL), pwsPassphrase);
        }
        catch (Exception exception) {
            pwsFile = ActionHandler.openFilePws(uRL);
        }
        Global.endCriticalPhase(uRL);
        return pwsFile;
    }

    public static Action getAction(String string) {
        return new HandlerAction(string);
    }

    public static class TimedThread
    extends Thread {
        private Timer timer;

        public TimedThread(Runnable runnable, long l) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(this, runnable){
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ TimedThread this$0;
                {
                    this.this$0 = timedThread;
                    this.val$r = runnable;
                }

                public void run() {
                    new Thread(this.val$r, "Ordered Timed Task").start();
                }
            }, l);
        }

        public void cancel() {
            this.timer.cancel();
        }
    }

    private static class MainActionListener
    implements ActionListener {
        private MainActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionHandler.invokeActionLater(actionEvent.getActionCommand());
        }
    }

    private static class ActionRunner
    implements Runnable {
        private String cmd;

        ActionRunner(String string) {
            this.cmd = string;
        }

        public void run() {
            boolean bl;
            lastUseTime = System.currentTimeMillis();
            if (this.cmd.equals("")) {
                return;
            }
            PwsFileContainer pwsFileContainer = Global.getSelectedFile();
            boolean bl2 = bl = pwsFileContainer != null;
            if (this.cmd.equals("menu.file.new")) {
                if (!Global.isDialogActive("DatabaseDialog.NewFile") && !Global.isDialogActive("ImportCSVDialog.NewFile")) {
                    ActionHandler.newFileToShelf(null);
                }
            } else if (this.cmd.equals("menu.file.open")) {
                ActionHandler.openFileToShelf();
            } else if (this.cmd.equals("menu.file.import")) {
                if (!Global.isDialogActive("DatabaseDialog.NewFile") && !Global.isDialogActive("ImportCSVDialog.NewFile")) {
                    ImportCSVDialog importCSVDialog = new ImportCSVDialog(null);
                    Global.mainFrame.addChildDialog(importCSVDialog);
                    importCSVDialog.setVisible(true);
                    Global.setDialogActive("ImportCSVDialog.NewFile", true);
                }
            } else if (this.cmd.equals("menu.file.exit")) {
                Global.exit();
            } else if (this.cmd.equals("menu.manage.policy")) {
                ActionHandler.editGlobalPWPolicy();
            } else if (this.cmd.equals("menu.view.idle")) {
                if (Global.hasOpenFiles()) {
                    Global.switchIdleState(true);
                } else {
                    Global.mainFrame.iconify();
                }
            } else if (this.cmd.equals("menu.edit.undo")) {
                Global.undoManager.undo();
            } else if (this.cmd.equals("menu.edit.redo")) {
                Global.undoManager.redo();
            } else if (this.cmd.equals("menu.edit.clearclip")) {
                Global.setClipboardText(null);
                GUIService.statusConfirm("msg.confirm.clearclip");
            } else if (this.cmd.equals("menu.edit.options")) {
                ActionHandler.startTask(new PreferencesDialog((Frame)Global.mainFrame, true));
            } else if (this.cmd.startsWith("load.recent")) {
                ActionHandler.openFileToShelf(this.cmd.substring(11));
            } else if (this.cmd.equals("menu.file.openurl")) {
                ActionHandler.openFileToShelfUrl();
            } else if (!this.cmd.equals("menu.help.docs")) {
                if (this.cmd.equals("menu.help.wipefile")) {
                    Service.secureWipeFile();
                } else if (this.cmd.equals("menu.help.about")) {
                    new AboutDialog();
                } else if (this.cmd.equals("menu.help.system")) {
                    ActionHandler.showSystemInfo();
                } else if (this.cmd.equals("menu.help.support")) {
                    String string = ResourceLoader.getCommand("html.supportpage");
                    try {
                        Global.startBrowser(new URL(string));
                    }
                    catch (Exception exception) {
                        Global.setStatusText("msg.illegalurl");
                    }
                } else if (this.cmd.equals("menu.help.checknews")) {
                    Service.controlProjectNews(true);
                } else if (this.cmd.equals("menu.help.monitor")) {
                    Options.setOption("monitorSystem", MenuHandler.isMonitorSelected());
                    Global.setStatusText(null);
                } else if (bl) {
                    if (this.cmd.equals("menu.file.convert")) {
                        pwsFileContainer.convert();
                    } else if (this.cmd.startsWith("menu.file.revert.")) {
                        pwsFileContainer.revert(this.cmd.substring(17));
                    } else if (this.cmd.equals("menu.file.erasebackups")) {
                        pwsFileContainer.eraseBackups();
                    } else if (this.cmd.equals("menu.file.deleterecents")) {
                        if (GUIService.userConfirm(null, "msg.ask.delete.recentlist")) {
                            Global.recentFiles.clear();
                        }
                    } else if (this.cmd.equals("menu.file.save")) {
                        pwsFileContainer.saveFile(true);
                    } else if (this.cmd.equals("menu.file.close")) {
                        Global.setStatusText(null);
                        if (pwsFileContainer.close()) {
                            Global.setSelectedFile(null);
                        }
                    } else if (this.cmd.equals("menu.file.savecopy")) {
                        pwsFileContainer.saveCopy(false);
                    } else if (this.cmd.equals("menu.file.saveas")) {
                        pwsFileContainer.saveAs();
                    } else if (this.cmd.equals("menu.edit.psw.add")) {
                        pwsFileContainer.addEntry();
                    } else if (this.cmd.equals("menu.edit.psw.edit")) {
                        PwsRecord pwsRecord = pwsFileContainer.getSelectedRecord();
                        if (pwsRecord != null) {
                            pwsFileContainer.editEntry(pwsRecord);
                        }
                    } else if (this.cmd.equals("menu.edit.psw.delete")) {
                        DefaultRecordWrapper[] defaultRecordWrapperArray = pwsFileContainer.getSelectedRecords();
                        if (defaultRecordWrapperArray != null) {
                            pwsFileContainer.deleteCommand();
                        }
                    } else if (this.cmd.startsWith("edit.recent")) {
                        String string = this.cmd.substring(11);
                        UUID uUID = new UUID(org.jpws.pwslib.global.Util.hexToBytes(string));
                        PwsRecord pwsRecord = pwsFileContainer.getRecord(uUID);
                        if (pwsRecord != null) {
                            pwsFileContainer.editEntry(pwsRecord);
                        }
                    } else if (this.cmd.equals("menu.edit.copypass")) {
                        PwsRecord pwsRecord = Global.getSelectedRecord();
                        if (pwsRecord != null && ActionHandler.sendClipboardPassword(pwsRecord) & Options.isOptionSet("storeMinorChanges")) {
                            try {
                                pwsFileContainer.recordUsed(pwsRecord);
                                pwsFileContainer.updateRecord(pwsRecord);
                            }
                            catch (NoSuchRecordException noSuchRecordException) {}
                        }
                    } else if (this.cmd.equals("menu.edit.copyuser")) {
                        PwsRecord pwsRecord = Global.getSelectedRecord();
                        if (pwsRecord != null) {
                            ActionHandler.sendClipboardUsername(pwsRecord);
                        }
                    } else if (this.cmd.equals("menu.edit.delete") | this.cmd.equals("menu.edit.delete.group") | this.cmd.equals("menu.edit.delete.record")) {
                        pwsFileContainer.deleteCommand();
                    } else if (this.cmd.equals("menu.edit.duplicate")) {
                        DefaultRecordWrapper[] defaultRecordWrapperArray = pwsFileContainer.getSelectedRecords();
                        if (defaultRecordWrapperArray != null) {
                            pwsFileContainer.addDuplicates(defaultRecordWrapperArray);
                        }
                    } else if (this.cmd.equals("menu.edit.duplicategroup")) {
                        String string = pwsFileContainer.getSelectedGroupName();
                        if (string != null) {
                            pwsFileContainer.duplicateGroup(string);
                        }
                    } else if (this.cmd.equals("menu.edit.selectall")) {
                        pwsFileContainer.selectAll();
                    } else if (this.cmd.equals("menu.edit.selectrecords")) {
                        pwsFileContainer.selectRecords();
                    } else if (this.cmd.equals("menu.edit.rename.group")) {
                        String string = pwsFileContainer.getSelectedGroupName();
                        if (string != null) {
                            pwsFileContainer.renameGroupDlg(string);
                        }
                    } else if (this.cmd.equals("menu.edit.moveentries")) {
                        pwsFileContainer.moveSelectedDlg();
                    } else if (this.cmd.equals("menu.edit.expandbranch")) {
                        if (pwsFileContainer.getSelectionStatus() == 1) {
                            pwsFileContainer.setExpandedBranch(pwsFileContainer.getSelectedGroupName(), true);
                        }
                    } else if (this.cmd.equals("menu.edit.foldbranch")) {
                        if (pwsFileContainer.getSelectionStatus() == 1) {
                            pwsFileContainer.setExpandedBranch(pwsFileContainer.getSelectedGroupName(), false);
                        }
                    } else if (this.cmd.equals("menu.edit.foldall")) {
                        pwsFileContainer.setExpandedBranch("", false);
                    } else if (this.cmd.equals("menu.edit.find")) {
                        new FindTextDialog(Global.mainFrame);
                    } else if (this.cmd.equals("menu.edit.export.csv")) {
                        pwsFileContainer.exportSelectionCSV();
                    } else if (this.cmd.equals("menu.edit.export.file")) {
                        pwsFileContainer.exportSelectionFile(null);
                    } else if (this.cmd.equals("menu.edit.starturl")) {
                        URL uRL;
                        PwsRecord pwsRecord = pwsFileContainer.getSelectedRecord();
                        if (pwsRecord != null && (uRL = Util.extractURL(pwsRecord.getUrl())) != null) {
                            Global.startBrowser(uRL);
                            if (Options.isOptionSet("useEntryOnBrowse")) {
                                pwsFileContainer.recordUsed(pwsRecord);
                            }
                        }
                    } else if (this.cmd.equals("menu.manage.changepass")) {
                        pwsFileContainer.changePassphrase();
                    } else if (this.cmd.equals("menu.manage.importfile.csv")) {
                        pwsFileContainer.importFileCSV();
                    } else if (this.cmd.equals("menu.manage.backup")) {
                        pwsFileContainer.saveCopy(true);
                    } else if (this.cmd.equals("menu.manage.restore")) {
                        pwsFileContainer.restoreBackup();
                    } else if (this.cmd.equals("menu.manage.mergefile")) {
                        pwsFileContainer.mergeDatabase();
                    } else if (this.cmd.equals("menu.manage.exportfile.csv")) {
                        pwsFileContainer.exportFileCSV();
                    } else if (this.cmd.equals("menu.view.list")) {
                        pwsFileContainer.setViewType(2);
                    } else if (this.cmd.equals("menu.view.tree")) {
                        pwsFileContainer.setViewType(1);
                    } else if (this.cmd.equals("menu.view.filter.all")) {
                        pwsFileContainer.setFilterStatus(0);
                    } else if (this.cmd.equals("menu.view.filter.modify")) {
                        pwsFileContainer.setFilterStatus(3);
                    } else if (this.cmd.equals("menu.view.filter.expiry")) {
                        pwsFileContainer.setFilterStatus(1);
                    } else if (this.cmd.equals("menu.view.filter.import")) {
                        pwsFileContainer.setFilterStatus(2);
                    } else if (this.cmd.equals("menu.help.fileinfo")) {
                        pwsFileContainer.showFileInfo();
                    } else if (this.cmd.equals("viewport.cancelfilter")) {
                        pwsFileContainer.setFilterStatus(0);
                    } else if (this.cmd.startsWith("export.targetfile.")) {
                        pwsFileContainer.exportSelectionFile(this.cmd.substring(18));
                    } else {
                        System.out.println("** unrecognized command: " + this.cmd);
                    }
                } else {
                    System.out.println("** unrecognized command: " + this.cmd);
                }
            }
        }
    }

    private static class ObjectChangeListener
    implements ChangeListener,
    DocumentListener,
    ActionListener {
        private ObjectChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ActionHandler.resetIdleTime();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ActionHandler.resetIdleTime();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ActionHandler.resetIdleTime();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionHandler.resetIdleTime();
        }
    }

    private static class HandlerAction
    extends AbstractAction {
        private String command;

        public HandlerAction(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (!string.equalsIgnoreCase("DELETE")) {
                throw new IllegalArgumentException("unknown Action type: ".concat(string));
            }
            this.command = "menu.edit.delete";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionHandler.invokeActionLater(this.command);
        }
    }
}

