/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jpws.data.Options;
import org.jpws.data.UserBreakException;
import org.jpws.front.ActionHandler;
import org.jpws.front.DisplayManager;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.HistoryHandler;
import org.jpws.front.PolicyDialog;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.ToolbarHandler;
import org.jpws.front.util.BlinkingLabel;
import org.jpws.front.util.ButtonBar;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.EditorTextField;
import org.jpws.front.util.NotesTextArea;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.SpringUtilities;
import org.jpws.front.util.TooltipComboBoxRenderer;
import org.jpws.front.util.Util;
import org.jpws.front.util.VerticalFlowLayout;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsPassphrasePolicy;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.exception.InvalidPassphrasePolicy;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.PassphraseUtils;

public class AddDialog
extends ButtonBarDialog {
    public static final int YES_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final int DIALOG_EDIT = 0;
    public static final int DIALOG_NEW = 1;
    private static final int DAYSECS = 86400;
    private static final int TEXTFIELDSIZE = 25;
    private static final String HIDEDUMMY = "**********";
    private static final Color INVALID_COLOR = Color.GRAY;
    private static final Color TIME_COLOR = new Color(24511);
    private static final Color HOTFIELD_COLOR = new Color(0x8B0000);
    private static String badFieldText;
    private JTabbedPane tabPane;
    private JComboBox group;
    private EditorTextField title;
    private EditorTextField username;
    private EditorTextField passFld;
    private EditorTextField urlFld;
    private JScrollPane notesScrollPane;
    private NotesTextArea notes;
    private ButtonBarDialog tearoffNotesDialog;
    private JLabel passModLabel;
    private JLabel accessLabel;
    private JLabel explainLabel;
    private BlinkingLabel expiryLabel;
    private BlinkingLabel expiryIcon;
    private JPanel contentPanel;
    private JPanel statsPanel;
    private JPanel historyPanel;
    private JPanel notesPanel;
    private JToolBar toolBar;
    private JButton copyPassIcon;
    private JButton copyUserIcon;
    private JButton policyIcon;
    private JButton historyIcon;
    private JButton clearClipIcon;
    private JButton undoIcon;
    private JButton redoIcon;
    private Border tabbedPaneBorder;
    private History pwHistory;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JButton genpassButton;
    private JButton revertButton;
    private JButton coverButton;
    private JButton uncoverButton;
    private JPanel coverPanel;
    private CardLayout coverCard;
    private JButton timeButton;
    private JButton urlButton;
    private JButton tearOffButton;
    private JComboBox expireCombo;
    private Icon icon1;
    private Icon icon2;
    private Component recentFocusOwner;
    private Font dataFont;
    private Font dataFontBold;
    private PwsFileContainer container;
    private Actions actions = new Actions();
    private ActionListener externalActions;
    private EditUndoManager undoManager;
    private PwsRecord record;
    private PwsRecord initRec;
    private PwsPassphrase password;
    private PwsPassphrase initPass;
    private PwsPassphrasePolicy policy;
    private String initGroup;
    private String actGroup;
    private long actPassLifeTime;
    private boolean policyEditOk;
    private boolean policyClosed;
    private boolean editing;
    private boolean passwordHidden;
    private int userOption;
    private int crc;
    private int dataCrc;
    private int timelabel_width;
    private static final int LIFE_UNLIMITED = 0;
    private static final int LIFE_SPECIAL = 9;

    public AddDialog(Frame frame, String string) throws HeadlessException {
        super(frame, 0, true);
        this.setTitle(ResourceLoader.getDisplay("adddlg.title"));
        this.record = new PwsRecord();
        this.password = new PwsPassphrase();
        this.passwordHidden = false;
        this.initGroup = string;
        this.init(frame);
    }

    public AddDialog(Frame frame, PwsRecord pwsRecord) throws HeadlessException {
        super(frame, 0, true);
        this.setTitle(ResourceLoader.getDisplay("edidlg.title"));
        this.record = pwsRecord;
        this.editing = true;
        this.password = pwsRecord.getPassword();
        if (this.password == null) {
            this.password = new PwsPassphrase();
        }
        this.passwordHidden = !Options.isOptionSet("openPassEdit");
        this.initGroup = pwsRecord.getGroup();
        this.init(frame);
    }

    public void finalize() {
    }

    private void init(Component component) {
        this.container = Global.getSelectedFile();
        this.undoManager = new EditUndoManager();
        this.policy = this.record.getPassPolicy();
        if (this.policy == null) {
            this.policy = (PwsPassphrasePolicy)Global.passphrasePolicy.clone();
        }
        this.crc = this.record.getCRC();
        this.initRec = (PwsRecord)this.record.clone();
        this.initPass = (PwsPassphrase)this.password.clone();
        this.dataFont = DisplayManager.getFont("data");
        this.dataFontBold = this.dataFont.deriveFont(1 + (this.dataFont.isItalic() ? 2 : 0));
        this.contentPanel = new JPanel(new BorderLayout());
        this.tabbedPaneBorder = BorderFactory.createEmptyBorder(18, 18, 15, 16);
        this.buildTopPanel();
        this.buildCentrePanel();
        this.buildRightPanel();
        this.updateMenu();
        this.setupDisplay(this.initGroup);
        this.dataCrc = this.dataCRC();
        this.undoManager.clear();
        this.title.clearUndoList();
        this.username.clearUndoList();
        this.notes.clearUndoList();
        this.urlFld.clearUndoList();
        this.passFld.clearUndoList();
        this.setDialogPanel(this.contentPanel);
        if (Options.isOptionSet("rememberScreen")) {
            this.gainLocation(Options.getOptions(), "entry_editor", true);
        }
    }

    public void setExternalActions(ActionListener actionListener) {
        this.externalActions = actionListener;
    }

    public void dispose() {
        if (Options.isOptionSet("rememberScreen")) {
            this.storeBounds(Options.getOptions(), "entry_editor", true);
        }
        super.dispose();
        Global.removeTimePulseListener(this.expiryLabel);
        Global.removeTimePulseListener(this.expiryIcon);
        this.getContentPane().removeAll();
    }

    private void undoUpdated() {
        String string;
        boolean bl = this.undoManager.canUndo();
        boolean bl2 = this.undoManager.canRedo();
        if (bl) {
            string = this.undoManager.getUndoPresentationName();
            this.undoIcon.setToolTipText(string);
        }
        this.undoIcon.setVisible(bl);
        if (bl2) {
            string = this.undoManager.getRedoPresentationName();
            this.redoIcon.setToolTipText(string);
        }
        this.redoIcon.setVisible(bl2);
    }

    private void updateMenu() {
        this.undoUpdated();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 202: {
                break;
            }
            case 201: {
                this.actions.actionPerformed(new ActionEvent(this, 0, "button.cancel"));
                return;
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private void setupDisplay(String string) {
        if (string == null) {
            string = this.record.getGroup();
        }
        if ((this.actGroup = string) == null) {
            this.actGroup = "";
        }
        this.group.setSelectedItem(string);
        this.title.setText(this.record.getTitle());
        this.username.setText(this.record.getUsername());
        this.notes.setText(this.record.getNotes());
        this.urlFld.setText(this.record.getUrl());
        this.pwHistory.setContentPw3(this.record.getHistory());
        if (this.passwordHidden && this.password.getLength() > 0) {
            this.passFld.setText(HIDEDUMMY);
            this.passFld.setEditable(false);
        } else {
            this.passFld.setText(this.password.getString());
        }
        this.setPassLifeTime(this.record.getPassLifeTime(), false);
        this.refreshTimeFields();
    }

    private void controlHistoryPanel() {
        if (this.container.getFileFormat() <= 2 | this.historyPanel == null) {
            return;
        }
        boolean bl = this.pwHistory.getListSize() > 0 & this.pwHistory.getMaxEntries() > 0 & this.pwHistory.isActive();
        if (bl & this.historyPanel.getClientProperty("installed") == null) {
            this.tabPane.add(this.historyPanel);
            this.historyPanel.putClientProperty("installed", "true");
            this.historyIcon.setVisible(false);
        } else if (!bl) {
            this.tabPane.remove(this.historyPanel);
            this.historyPanel.putClientProperty("installed", null);
            this.historyIcon.setVisible(this.pwHistory.getMaxEntries() == 0 | !this.pwHistory.isActive());
        }
    }

    private void buildCentrePanel() {
        this.tabPane = new JTabbedPane();
        ActionHandler.registerChangeableObject(this.tabPane);
        this.tabPane.addChangeListener(this.actions);
        this.contentPanel.add((Component)this.tabPane, "Center");
        this.tabPane.add(this.buildLoginPanel());
        if (Options.isOptionSet("editFullNotes")) {
            this.tabPane.add(this.buildNotesPanel());
        }
        this.statsPanel = this.buildStatsPanel();
        if (this.container.getFileFormat() > 1) {
            this.tabPane.add(this.statsPanel);
        }
        this.historyPanel = this.buildHistoryPanel();
    }

    private JPanel buildLoginPanel() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3 = new JPanel(new SpringLayout());
        List list = this.container == null ? new ArrayList() : this.container.getGroupList();
        int n = 3;
        JLabel jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.group"));
        this.group = new JComboBox<Object>(list.toArray());
        this.group.setEditable(true);
        this.group.setFont(this.dataFont);
        this.group.addItemListener(this.actions);
        ActionHandler.registerChangeableObject(this.group);
        jLabel.setLabelFor(this.group);
        int n2 = this.group.getPreferredSize().width;
        if (n2 > 450) {
            this.group.setPrototypeDisplayValue("DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD");
            this.group.setRenderer(new TooltipComboBoxRenderer());
        }
        if (this.container.getFileFormat() > 1) {
            jPanel3.add(jLabel);
            jPanel3.add(this.group);
            ++n;
        }
        this.title = new EditorTextField(25);
        this.title.setFont(this.dataFont);
        this.title.addFocusListener(this.actions);
        jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.title"));
        ActionHandler.registerTextEditor(this.title);
        jLabel.setLabelFor(this.title);
        jPanel3.add(jLabel);
        jPanel3.add(this.title);
        jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.username"));
        this.username = new EditorTextField(25);
        this.username.setFont(this.dataFont);
        this.username.addFocusListener(this.actions);
        ActionHandler.registerTextEditor(this.username);
        jPanel3.add(jLabel);
        jPanel3.add(this.username);
        jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.password"));
        this.passFld = new EditorTextField(25);
        this.passFld.setFont(DisplayManager.getFont("password"));
        this.passFld.addFocusListener(this.actions);
        ActionHandler.registerTextEditor(this.passFld);
        jPanel3.add(jLabel);
        jPanel3.add(this.passFld);
        this.notes = new NotesTextArea(){

            protected JPopupMenu getPopupMenu() {
                JPopupMenu jPopupMenu = super.getPopupMenu();
                if (Options.isOptionSet("editFullNotes") & AddDialog.this.tearoffNotesDialog == null) {
                    JMenuItem jMenuItem = new JMenuItem(ResourceLoader.getCommand("menu.edit.tearoff"));
                    jMenuItem.setActionCommand("button.tearoff.notes");
                    jMenuItem.addActionListener(AddDialog.this.actions);
                    jPopupMenu.insert(jMenuItem, jPopupMenu.getComponentCount() - 2);
                }
                return jPopupMenu;
            }
        };
        this.notes.setFont(DisplayManager.getFont("notes"));
        this.notes.addFocusListener(this.actions);
        ActionHandler.registerTextEditor(this.notes);
        this.notesScrollPane = new JScrollPane(this.notes);
        this.tearOffButton = new JButton(ResourceLoader.getImageIcon("edittearoff"));
        this.notesPanel = new JPanel(new BorderLayout());
        this.notesPanel.setPreferredSize(new Dimension(280, 128));
        this.notesPanel.add(this.notesScrollPane);
        if (!Options.isOptionSet("editFullNotes")) {
            jPanel2 = new JPanel(new BorderLayout());
            jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.notes"));
            jPanel2.add((Component)jLabel, "West");
            this.tearOffButton.setActionCommand("button.tearoff.notes");
            this.tearOffButton.addActionListener(this.actions);
            this.tearOffButton.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 3));
            this.tearOffButton.setBackground(jPanel2.getBackground());
            this.tearOffButton.setToolTipText(ResourceLoader.getCommand("tooltip.button.tearoffnotes"));
            this.tearOffButton.setFocusPainted(false);
            jPanel = new JPanel(new FlowLayout(2, 0, 0));
            jPanel.add(this.tearOffButton);
            jPanel2.add((Component)jPanel, "East");
            jPanel3.add(jPanel2);
            jPanel3.add(this.notesPanel);
            ++n;
        }
        jPanel2 = new JPanel(new BorderLayout());
        jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.urlfield"));
        jPanel2.add((Component)jLabel, "West");
        this.urlButton = new JButton(ResourceLoader.getImageIcon("webicon"));
        this.urlButton.setActionCommand("button.starturl");
        this.urlButton.addActionListener(this.actions);
        this.urlButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 3));
        this.urlButton.setBackground(jPanel2.getBackground());
        this.urlButton.setToolTipText(ResourceLoader.getCommand("tooltip.button.starturl"));
        this.urlButton.setFocusPainted(false);
        jPanel2.add((Component)this.urlButton, "East");
        this.urlFld = new EditorTextField(25);
        this.urlFld.setFont(this.dataFont);
        this.urlFld.addFocusListener(this.actions);
        ActionHandler.registerTextEditor(this.urlFld);
        if (this.container.getFileFormat() > 2) {
            jPanel3.add(jPanel2);
            jPanel3.add(this.urlFld);
            ++n;
        }
        SpringUtilities.makeCompactGrid(jPanel3, n, 2, 0, 0, 6, 6);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.tabbedPaneBorder);
        jPanel.setName(ResourceLoader.getDisplay("pane.edit.front"));
        jPanel.putClientProperty("explain", ResourceLoader.getDisplay("adddlg.explain.login"));
        jPanel.add((Component)jPanel3, "North");
        return jPanel;
    }

    private void setTimeLabel(JLabel jLabel, long l) {
        Date date = new Date(l);
        jLabel.setText(l == 0L ? "?" : date.toLocaleString());
    }

    private JPanel makeTimeValuePanel(JLabel jLabel, String string, int n, long l, Color color) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel jLabel2 = new JLabel(ResourceLoader.getDisplay(string));
        if (color != null) {
            jLabel2.setForeground(color);
        }
        Dimension dimension = jLabel2.getSize();
        dimension.width = n;
        jLabel2.setPreferredSize(new Dimension(n, 16));
        jPanel.add(jLabel2);
        this.setTimeLabel(jLabel, l);
        jLabel.setForeground(color == null ? TIME_COLOR : color);
        jLabel.setFont(this.dataFont.deriveFont(1));
        jPanel.add(jLabel);
        return jPanel;
    }

    private void setPassLifeCombo() {
        int n;
        long l = (this.record.getPassLifeTime() - this.record.getPassModTime()) / 1000L;
        if (this.record.getPassLifeTime() == 0L) {
            n = 0;
        } else if (l < 0L | l > Integer.MAX_VALUE) {
            n = 9;
        } else {
            switch ((int)l) {
                case 2592000: {
                    n = 1;
                    break;
                }
                case 5184000: {
                    n = 2;
                    break;
                }
                case 7776000: {
                    n = 3;
                    break;
                }
                case 15552000: {
                    n = 4;
                    break;
                }
                case 31536000: {
                    n = 5;
                    break;
                }
                case 63072000: {
                    n = 6;
                    break;
                }
                case 94608000: {
                    n = 7;
                    break;
                }
                case 157680000: {
                    n = 8;
                    break;
                }
                default: {
                    n = 9;
                }
            }
        }
        this.expireCombo.setSelectedIndex(n);
    }

    private void setPassLifeTimeAfterIndex(int n, boolean bl) {
        long l = 0L;
        if (n < 0 | n > 8) {
            return;
        }
        if (n > 0) {
            switch (n) {
                case 1: {
                    l = 2592000L;
                    break;
                }
                case 2: {
                    l = 5184000L;
                    break;
                }
                case 3: {
                    l = 7776000L;
                    break;
                }
                case 4: {
                    l = 15552000L;
                    break;
                }
                case 5: {
                    l = 31536000L;
                    break;
                }
                case 6: {
                    l = 63072000L;
                    break;
                }
                case 7: {
                    l = 94608000L;
                    break;
                }
                case 8: {
                    l = 157680000L;
                }
            }
            long l2 = this.record.getPassModTime();
            if (l2 == 0L) {
                l2 = System.currentTimeMillis();
                this.record.setPassModTime(l2);
                this.refreshTimeFields();
                l2 = this.record.getPassModTime();
            }
            l = l2 + l * 1000L;
        }
        this.setPassLifeTime(l, bl);
    }

    private void setPassLifeTime(long l, boolean bl) {
        this.record.setPassLifeTime(l);
        l = this.record.getPassLifeTime();
        this.setTimeLabel(this.expiryLabel, l);
        this.setPassLifeCombo();
        long l2 = System.currentTimeMillis() + Options.getLongOption("expireScope");
        boolean bl2 = this.record.willExpire(l2);
        boolean bl3 = this.record.hasExpired();
        Icon icon = bl2 ? (bl3 ? this.icon1 : this.icon2) : null;
        String string = bl3 ? "tooltip.expired" : "tooltip.expiresoon";
        this.expiryLabel.setBlinking(bl3);
        this.expiryIcon.setBlinking(bl2);
        this.expiryIcon.setIcon(icon);
        this.expiryIcon.setToolTipText(bl2 ? ResourceLoader.getDisplay(string) : null);
        if (bl && this.actPassLifeTime != l) {
            EditUndoManager editUndoManager = this.undoManager;
            editUndoManager.getClass();
            EditUndoManager.FieldEdit fieldEdit = editUndoManager.new EditUndoManager.FieldEdit(2, String.valueOf(this.actPassLifeTime), String.valueOf(l));
            this.undoManager.undoableEditHappened(new UndoableEditEvent(this, fieldEdit));
        }
        this.actPassLifeTime = l;
    }

    private JPanel buildStatsPanel() {
        this.timelabel_width = 100;
        JPanel jPanel = new JPanel(new VerticalFlowLayout(4));
        jPanel.setName(ResourceLoader.getDisplay("pane.edit.stats"));
        jPanel.setBorder(this.tabbedPaneBorder);
        JLabel jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.record") + " ");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel.add(jLabel);
        jLabel = new JLabel();
        jPanel.add(this.makeTimeValuePanel(jLabel, "adddlg.time.create", this.timelabel_width, this.record.getCreateTime(), null));
        jLabel = new JLabel();
        jPanel.add(this.makeTimeValuePanel(jLabel, "adddlg.time.modify", this.timelabel_width, this.record.getModifiedTime(), null));
        jPanel.add(Box.createVerticalStrut(10));
        jLabel = new JLabel(ResourceLoader.getDisplay("adddlg.label.password") + " ");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel.add(jLabel);
        this.accessLabel = new JLabel();
        Color color = Options.isOptionSet("storeMinorChanges") ? null : INVALID_COLOR;
        jPanel.add(this.makeTimeValuePanel(this.accessLabel, "adddlg.time.access", this.timelabel_width, this.record.getAccessTime(), color));
        this.passModLabel = new JLabel();
        jPanel.add(this.makeTimeValuePanel(this.passModLabel, "adddlg.time.modify", this.timelabel_width, this.record.getPassModTime(), null));
        this.expiryLabel = new BlinkingLabel();
        this.expiryLabel.setForeground(HOTFIELD_COLOR);
        Global.addTimePulseListener(this.expiryLabel);
        jPanel.add(this.makeTimeValuePanel(this.expiryLabel, "adddlg.time.expire", this.timelabel_width, 0L, HOTFIELD_COLOR));
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        jPanel2.add(Box.createHorizontalStrut(this.timelabel_width - 10));
        String string = ResourceLoader.getCommand("combo.passlifetime");
        this.expireCombo = new JComboBox<String>(string.split(","));
        this.expireCombo.addActionListener(this.actions);
        this.expireCombo.setToolTipText(ResourceLoader.getCommand("tooltip.combo.expiry"));
        this.expireCombo.setFont(this.dataFontBold);
        jPanel2.add(this.expireCombo);
        this.timeButton = new JButton(ResourceLoader.getImageIcon("button.enter.16"));
        this.timeButton.setActionCommand("button.expirydate");
        this.timeButton.addActionListener(this.actions);
        this.timeButton.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
        this.timeButton.setBackground(jPanel2.getBackground());
        this.timeButton.setToolTipText(ResourceLoader.getCommand("tooltip.edit.expiry"));
        this.timeButton.setFocusPainted(false);
        jPanel2.add(this.timeButton);
        jPanel.putClientProperty("explain", ResourceLoader.getDisplay("adddlg.explain.stats"));
        return jPanel;
    }

    private JPanel buildNotesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName(ResourceLoader.getDisplay("pane.edit.notes"));
        jPanel.setBorder(this.tabbedPaneBorder);
        jPanel.putClientProperty("explain", ResourceLoader.getDisplay("adddlg.explain.login"));
        jPanel.add(this.notesPanel);
        jPanel.setPreferredSize(new Dimension(10, 270));
        return jPanel;
    }

    private JPanel buildHistoryPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.tabbedPaneBorder);
        jPanel.setName(ResourceLoader.getDisplay("pane.edit.history"));
        this.pwHistory = new History();
        jPanel.add((Component)this.pwHistory, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        JButton jButton = new JButton(ResourceLoader.getDisplay("button.clear"));
        jButton.setActionCommand("button.clearhistory");
        jButton.addActionListener(this.actions);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
        jButton.setToolTipText(ResourceLoader.getCommand("tooltip.edit.clearhistory"));
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(ResourceLoader.getDisplay("adddlg.button.setmax"));
        jButton2.setActionCommand("button.historysettings");
        jButton2.addActionListener(this.actions);
        jButton2.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
        jButton2.setToolTipText(ResourceLoader.getCommand("tooltip.edit.historysettings"));
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(ResourceLoader.getDisplay("button.off"));
        jButton3.setActionCommand("button.historyoff");
        jButton3.addActionListener(this.actions);
        jButton3.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
        jButton3.setToolTipText(ResourceLoader.getCommand("tooltip.edit.historyoff"));
        jPanel2.add(jButton3);
        this.historyPanel = jPanel;
        this.refreshHistoryComment();
        return jPanel;
    }

    private void buildRightPanel() {
        ButtonBar buttonBar = new ButtonBar(4, 0, new Insets(18, 10, 0, 0));
        this.okButton = this.makeButton("button.ok");
        buttonBar.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = this.makeButton("button.cancel");
        buttonBar.add(this.cancelButton);
        this.helpButton = this.makeButton("button.help");
        buttonBar.add(this.helpButton);
        this.revertButton = this.makeButton("button.revert");
        buttonBar.add(this.revertButton);
        this.coverCard = new CardLayout();
        this.coverPanel = new JPanel(this.coverCard);
        this.coverButton = this.makeButton("button.cover");
        this.coverPanel.add((Component)this.coverButton, "button.cover");
        this.uncoverButton = this.makeButton("button.uncover");
        this.coverPanel.add((Component)this.uncoverButton, "button.uncover");
        buttonBar.add(this.coverPanel);
        this.setCoverButton();
        this.genpassButton = this.makeButton("button.randpassword");
        buttonBar.add(this.genpassButton);
        this.contentPanel.add((Component)buttonBar, "East");
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(ResourceLoader.getDisplay(string));
        jButton.setActionCommand(string);
        jButton.addActionListener(this.actions);
        jButton.setName(string);
        return jButton;
    }

    private void setCoverButton() {
        String string = this.passwordHidden ? "button.uncover" : "button.cover";
        this.coverCard.show(this.coverPanel, string);
    }

    private JButton makeButton(String string, String string2, String string3) {
        JButton jButton = ToolbarHandler.makeButton(string, string2);
        jButton.setActionCommand(string3);
        jButton.removeActionListener(Global.mainActionListener);
        jButton.addActionListener(this.actions);
        return jButton;
    }

    private void buildTopPanel() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.copyPassIcon = this.makeButton("copypass", "toolbar.copypass", "menu.edit.copypass");
        this.toolBar.add(this.copyPassIcon);
        this.copyUserIcon = this.makeButton("copyuser", "toolbar.copyuser", "menu.edit.copyuser");
        this.toolBar.add(this.copyUserIcon);
        this.clearClipIcon = ToolbarHandler.makeButton(ActionHandler.getClearClipAction());
        this.toolBar.add(this.clearClipIcon);
        this.undoIcon = this.makeButton("undo", "toolbar.entry.undo", "menu.edit.undo");
        this.toolBar.add(this.undoIcon);
        this.redoIcon = this.makeButton("redo", "toolbar.entry.redo", "menu.edit.redo");
        this.toolBar.add(this.redoIcon);
        this.toolBar.addSeparator(new Dimension(10, 0));
        this.policyIcon = this.makeButton("policy", "toolbar.recpolicy", "menu.edit.policy");
        this.policyIcon.setVisible(this.record.getPassPolicy() != null);
        this.toolBar.add(this.policyIcon);
        this.historyIcon = this.makeButton("editor-history", "toolbar.history", "button.historysettings");
        this.historyIcon.setVisible(false);
        this.toolBar.add(this.historyIcon);
        this.toolBar.addSeparator(new Dimension(10, 0));
        int n = this.record.getImportStatus();
        if (n == 1 | n == 2) {
            String string = n == 1 ? "editor-imported" : "editor-importedconflict";
            ImageIcon imageIcon = ResourceLoader.getImageIcon(string);
            JLabel jLabel = new JLabel(imageIcon);
            jLabel.setToolTipText(ResourceLoader.getDisplay("tooltip.imported"));
            this.toolBar.add(jLabel);
            this.toolBar.addSeparator(new Dimension(3, 0));
        }
        this.icon1 = ResourceLoader.getImageIcon("editor-expired");
        this.icon2 = ResourceLoader.getImageIcon("editor-expiresoon");
        this.expiryIcon = new BlinkingLabel();
        this.expiryIcon.setPreferredSize(new Dimension(20, 20));
        Global.addTimePulseListener(this.expiryIcon);
        this.toolBar.add(this.expiryIcon);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.toolBar, "North");
        this.explainLabel = new JLabel();
        jPanel.add((Component)this.explainLabel, "Center");
        this.explainLabel.setBorder(new EmptyBorder(16, 16, 10, 16));
        Font font = this.explainLabel.getFont().deriveFont(0);
        this.explainLabel.setFont(font);
        this.contentPanel.add((Component)jPanel, "North");
    }

    private String getUrl() {
        return this.urlFld.getText();
    }

    private String getPasswordHistory() {
        if (this.pwHistory.getListSize() == 0 & this.pwHistory.getMaxEntries() > 0 & this.pwHistory.isActive() == Options.isOptionSet("editActiveHistory")) {
            return "";
        }
        return this.pwHistory.getContentPw3();
    }

    private String getNotes() {
        String string = this.notes.getText();
        string = string.replaceAll("\n", "\r\n");
        string = Util.substituteText(string, "\r\r", "\r");
        return string;
    }

    private String getTitleFld() {
        return this.title.getText();
    }

    private String getUsername() {
        return this.username.getText();
    }

    private String getGroup() {
        Object object = this.group.getSelectedItem();
        return object == null ? "" : object.toString();
    }

    private PwsPassphrase getPassword() {
        if (!this.passwordHidden) {
            this.password.setValue(this.passFld.getText().toCharArray());
        }
        return this.password;
    }

    public int getUserOption() {
        return this.userOption;
    }

    private void setPasswordHidden(boolean bl) {
        if (bl != this.passwordHidden) {
            if (bl) {
                this.password.setValue(this.passFld.getText().toCharArray());
                if (this.password.getLength() > 0) {
                    this.passFld.setText(HIDEDUMMY);
                }
            } else {
                this.passFld.setText(this.password.getString());
                this.tabPane.setSelectedIndex(0);
            }
            this.passFld.clearUndoList();
            this.passFld.setEditable(!bl);
            this.passwordHidden = bl;
            this.setCoverButton();
        }
    }

    public PwsRecord getInitRecord() {
        return this.initRec;
    }

    public PwsRecord getRecord() {
        String string = this.getNotes();
        this.record.setUsername(this.getUsername());
        this.record.setTitle(this.getTitleFld());
        this.record.setNotes(string);
        this.record.setGroup(this.getGroup());
        this.record.setUrl(this.getUrl());
        this.record.setHistory(this.getPasswordHistory());
        PwsPassphrase pwsPassphrase = this.getPassword();
        PwsPassphrase pwsPassphrase2 = this.record.getPassword();
        if (pwsPassphrase2 == null || !pwsPassphrase2.equals(pwsPassphrase)) {
            this.record.setPassword(pwsPassphrase);
            this.passwordModified(pwsPassphrase2);
        }
        return this.record;
    }

    private int dataCRC() {
        CRC32 cRC32 = new CRC32();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.getPassword();
            if (this.password != null) {
                dataOutputStream.writeInt(this.password.hashCode());
            }
            if (this.policy != null) {
                dataOutputStream.writeInt(this.policy.getIntForm());
            }
            dataOutputStream.writeLong(this.record.getPassLifeTime());
            dataOutputStream.writeChars(this.getTitleFld());
            dataOutputStream.writeChars(this.getGroup());
            dataOutputStream.writeChars(this.getUsername());
            dataOutputStream.writeChars(this.getNotes());
            dataOutputStream.writeChars(this.getUrl());
            dataOutputStream.writeChars(this.getPasswordHistory());
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("*** ERROR in PwsRecord CRC : " + iOException);
            return -1;
        }
        cRC32.update(byteArrayOutputStream.toByteArray());
        return (int)cRC32.getValue();
    }

    private void revertContent() {
        Log.debug(5, "- reverting edit record to initial state");
        this.password = (PwsPassphrase)this.initPass.clone();
        this.record.setUsername(this.initRec.getUsernamePws());
        this.record.setTitle(this.initRec.getTitle());
        this.record.setNotes(this.initRec.getNotesPws());
        this.record.setGroup(this.initRec.getGroup());
        this.record.setUrl(this.initRec.getUrlPws());
        this.record.setHistory(this.initRec.getHistoryPws());
        this.record.setPassword(this.initRec.getPassword());
        try {
            this.record.setPassPolicy(this.initRec.getPassPolicy());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.record.setAccessTime(this.initRec.getAccessTime());
        this.record.setPassLifeTime(this.initRec.getPassLifeTime());
        this.record.setPassModTime(this.initRec.getPassModTime());
        this.record.setModifyTime(this.initRec.getModifiedTime());
        this.crc = this.record.getCRC();
        this.policyIcon.setVisible(this.record.getPassPolicy() != null);
        this.policy = this.record.getPassPolicy();
        if (this.policy == null) {
            this.policy = (PwsPassphrasePolicy)Global.passphrasePolicy.clone();
        }
        this.refreshTimeFields();
        this.setPassLifeCombo();
    }

    private void refreshTimeFields() {
        this.setTimeLabel(this.passModLabel, this.record.getPassModTime());
        this.setTimeLabel(this.accessLabel, this.record.getAccessTime());
        this.setTimeLabel(this.expiryLabel, this.record.getPassLifeTime());
    }

    private void refreshHistoryComment() {
        if (this.historyPanel == null) {
            return;
        }
        String string = ResourceLoader.getDisplay("adddlg.explain.history");
        string = Util.substituteTextS(string, "$items", String.valueOf(this.pwHistory.getListSize()));
        string = Util.substituteTextS(string, "$maxitems", String.valueOf(this.pwHistory.getMaxEntries()));
        this.historyPanel.putClientProperty("explain", string);
        if (this.tabPane.getSelectedComponent() == this.historyPanel) {
            this.explainLabel.setText(string);
        }
    }

    private void passwordModified(PwsPassphrase pwsPassphrase) {
        int n;
        String string = this.pwHistory.getContentPw3();
        long l = this.record.getPassLifeTime();
        long l2 = this.record.getPassModTime();
        long l3 = this.record.getAccessTime();
        this.record.passwordUpdated();
        if (pwsPassphrase != null) {
            this.pwHistory.pushPassword(pwsPassphrase.getString(), l2);
        }
        this.refreshTimeFields();
        if (l > 0L && (n = this.expireCombo.getSelectedIndex()) > 0 & n < 9) {
            String string2 = ResourceLoader.getDisplay("msg.update_lifetime");
            string2 = Util.substituteText(string2, "$life", this.expireCombo.getSelectedItem().toString());
            this.tabPane.setSelectedComponent(this.statsPanel);
            if (GUIService.userConfirm(this, string2)) {
                this.setPassLifeTimeAfterIndex(n, false);
            } else {
                this.setPassLifeCombo();
            }
        }
        if (!this.password.equals(pwsPassphrase)) {
            EditUndoManager editUndoManager = this.undoManager;
            editUndoManager.getClass();
            EditUndoManager.FieldEdit fieldEdit = editUndoManager.new EditUndoManager.FieldEdit(1, pwsPassphrase, string, l2, l, l3);
            this.undoManager.undoableEditHappened(new UndoableEditEvent(this, fieldEdit));
        }
    }

    public boolean recordModified() {
        PwsRecord pwsRecord = (PwsRecord)this.getRecord().clone();
        pwsRecord.setModifyTime(this.initRec.getModifiedTime());
        return this.crc != pwsRecord.getCRC();
    }

    public boolean dataModified() {
        return this.dataCrc != this.dataCRC();
    }

    public boolean isNewRecord() {
        return !this.editing;
    }

    public class EditUndoManager
    extends UndoManager {
        public EditUndoManager() {
            int n = Options.getIntOption("maxUndoEntries");
            int n2 = n > 0 ? n : 25;
            this.setLimit(n2);
        }

        public void clear() {
            this.discardAllEdits();
            AddDialog.this.undoUpdated();
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (Options.isOptionSet("useUndoRedo")) {
                super.undoableEditHappened(undoableEditEvent);
                AddDialog.this.undoUpdated();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            AddDialog.this.undoUpdated();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            AddDialog.this.undoUpdated();
        }

        public void removeHistoryEdits() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.edits.size()) {
                FieldEdit fieldEdit;
                Object e = this.edits.get(n2);
                if (e instanceof FieldEdit && (fieldEdit = (FieldEdit)e).type == 4 | fieldEdit.type == 3) {
                    this.trimEdits(n2, n2);
                    ++n;
                    continue;
                }
                ++n2;
            }
            if (n > 0) {
                AddDialog.this.undoUpdated();
            }
        }

        public class RevertEdit
        extends AbstractUndoableEdit {
            private PwsRecord oldRecord;
            private long updateTime;

            public RevertEdit(PwsRecord pwsRecord) {
                this.oldRecord = pwsRecord;
                this.updateTime = System.currentTimeMillis();
            }

            public long getUpdateTime() {
                return this.updateTime;
            }

            public void die() {
                super.die();
            }

            public String toString() {
                return this.getPresentationName() + " *** " + super.toString();
            }

            public String getPresentationName() {
                return ResourceLoader.getDisplay("undo.editor.revert");
            }

            public void redo() throws CannotRedoException {
                super.redo();
                AddDialog.this.revertContent();
                AddDialog.this.setupDisplay(AddDialog.this.initGroup);
            }

            public void undo() throws CannotUndoException {
                super.undo();
                AddDialog.this.record = (PwsRecord)this.oldRecord.clone();
                AddDialog.this.password.setValue(AddDialog.this.record.getPassword());
                AddDialog.this.setupDisplay(null);
            }
        }

        public class FieldEdit
        extends AbstractUndoableEdit {
            public static final int GROUP = 0;
            public static final int PASSWORD = 1;
            public static final int EXPIRY = 2;
            public static final int HISTORY_DEL = 3;
            public static final int HISTORY_MAX = 4;
            public static final int FIELD_TOPVALUE = 4;
            private int type;
            private String oldText;
            private String newText;
            private PwsPassphrase oldPass;
            private PwsPassphrase newPass;
            private String oldHistory;
            private String newHistory;
            private long oldExpireTime;
            private long newExpireTime;
            private long oldAccessTime;
            private long newAccessTime;
            private long oldPassModTime;
            private long newPassModTime;
            private long updateTime;

            public FieldEdit(int n, String string, String string2) {
                if (n < 0 | n > 4 | n == 1) {
                    throw new IllegalArgumentException("illegal edit type");
                }
                if (string2 == null) {
                    string2 = "";
                }
                if (string == null) {
                    string = "";
                }
                this.type = n;
                this.oldText = string;
                this.newText = string2;
                if (n == 2) {
                    this.oldExpireTime = Util.longFromString(string);
                    this.newExpireTime = AddDialog.this.record.getPassLifeTime();
                }
                this.updateTime = System.currentTimeMillis();
            }

            public FieldEdit(int n, PwsPassphrase pwsPassphrase, String string, long l, long l2, long l3) {
                if (n != 1) {
                    throw new IllegalArgumentException("illegal edit type");
                }
                this.type = n;
                this.oldPass = pwsPassphrase == null ? null : (PwsPassphrase)pwsPassphrase.clone();
                this.newPass = (PwsPassphrase)AddDialog.this.getPassword().clone();
                this.oldHistory = string;
                this.newHistory = AddDialog.this.pwHistory.getContentPw3();
                this.oldPassModTime = l;
                this.newPassModTime = AddDialog.this.record.getPassModTime();
                this.oldExpireTime = l2;
                this.newExpireTime = AddDialog.this.record.getPassLifeTime();
                this.oldAccessTime = l3;
                this.newAccessTime = AddDialog.this.record.getAccessTime();
                this.updateTime = System.currentTimeMillis();
            }

            public long getUpdateTime() {
                return this.updateTime;
            }

            public void die() {
                super.die();
            }

            public String toString() {
                return this.getPresentationName() + " *** " + super.toString();
            }

            public String getPresentationName() {
                String string;
                switch (this.type) {
                    case 0: {
                        string = "adddlg.label.group";
                        break;
                    }
                    case 2: {
                        string = "adddlg.label.expire";
                        break;
                    }
                    case 1: {
                        string = "adddlg.label.password";
                        break;
                    }
                    case 3: {
                        return ResourceLoader.getDisplay("undo.editor.historydel");
                    }
                    case 4: {
                        string = "adddlg.label.history_max";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                return ResourceLoader.getDisplay("undo.editor.field") + " " + ResourceLoader.getDisplay(string);
            }

            private void setHistory(String string) {
                string = (AddDialog.this.pwHistory.isActive() ? "1" : "0").concat(string.substring(1));
                AddDialog.this.pwHistory.setContentPw3(string);
            }

            public void redo() throws CannotRedoException {
                super.redo();
                switch (this.type) {
                    case 0: {
                        AddDialog.this.actGroup = this.newText;
                        AddDialog.this.group.setSelectedItem(this.newText);
                        break;
                    }
                    case 3: 
                    case 4: {
                        AddDialog.this.pwHistory.setContentPw3(this.newText);
                        break;
                    }
                    case 2: {
                        AddDialog.this.setPassLifeTime(this.newExpireTime, false);
                        break;
                    }
                    case 1: {
                        AddDialog.this.password.setValue(this.newPass);
                        if (!AddDialog.this.passwordHidden) {
                            AddDialog.this.passFld.setText(AddDialog.this.password.getString());
                        }
                        AddDialog.this.setPassLifeTime(this.newExpireTime, false);
                        this.setHistory(this.newHistory);
                        AddDialog.this.record.setPassword(AddDialog.this.password);
                        AddDialog.this.record.setPassModTime(this.newPassModTime);
                        AddDialog.this.record.setAccessTime(this.newAccessTime);
                        AddDialog.this.refreshTimeFields();
                        AddDialog.this.setPassLifeCombo();
                    }
                }
            }

            public void undo() throws CannotUndoException {
                super.undo();
                switch (this.type) {
                    case 0: {
                        AddDialog.this.actGroup = this.oldText;
                        AddDialog.this.group.setSelectedItem(this.oldText);
                        break;
                    }
                    case 2: {
                        AddDialog.this.setPassLifeTime(this.oldExpireTime, false);
                        break;
                    }
                    case 3: 
                    case 4: {
                        AddDialog.this.pwHistory.setContentPw3(this.oldText);
                        break;
                    }
                    case 1: {
                        AddDialog.this.password.setValue(this.oldPass);
                        if (!AddDialog.this.passwordHidden) {
                            AddDialog.this.passFld.setText(AddDialog.this.password.getString());
                        }
                        AddDialog.this.setPassLifeTime(this.oldExpireTime, false);
                        AddDialog.this.record.setPassword(AddDialog.this.password);
                        AddDialog.this.record.setPassModTime(this.oldPassModTime);
                        AddDialog.this.record.setAccessTime(this.oldAccessTime);
                        this.setHistory(this.oldHistory);
                        AddDialog.this.refreshTimeFields();
                        AddDialog.this.setPassLifeCombo();
                    }
                }
            }
        }
    }

    private class Actions
    implements Runnable,
    ActionListener,
    FocusListener,
    ChangeListener,
    ItemListener {
        Thread actionThread;
        String command;
        Object source;

        public Actions() {
        }

        private Actions(String string) {
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actionThread != null && this.actionThread.isAlive()) {
                return;
            }
            this.command = actionEvent.getActionCommand();
            this.source = actionEvent.getSource();
            this.actionThread = ActionHandler.startTask(this);
        }

        public void callAction(String string) {
            new Actions(string).run();
        }

        public void run() {
            ActionHandler.resetIdleTime();
            if (this.source == AddDialog.this.expireCombo) {
                AddDialog.this.setPassLifeTimeAfterIndex(AddDialog.this.expireCombo.getSelectedIndex(), true);
                return;
            }
            if (this.command.equals("button.ok")) {
                boolean bl = true;
                if (AddDialog.this.getTitleFld().equals("") || AddDialog.this.getPassword().isEmpty()) {
                    if (badFieldText == null) {
                        badFieldText = ResourceLoader.getDisplay("msg.badfieldvalue");
                    }
                    String string = AddDialog.this.getTitleFld().equals("") ? "adddlg.label.title" : "adddlg.label.password";
                    String string2 = Util.substituteText(badFieldText, "$field", ResourceLoader.getDisplay(string));
                    GUIService.infoMessage(AddDialog.this, "dlg.badrecord", string2);
                    bl = false;
                } else if (AddDialog.this.editing && !AddDialog.this.initPass.equals(AddDialog.this.getPassword()) && Options.isOptionSet("confirmUpdatePass")) {
                    bl = GUIService.userConfirm(AddDialog.this, "msg.ask.passmodify");
                }
                if (bl) {
                    if (AddDialog.this.externalActions != null) {
                        if (!AddDialog.this.dataModified()) {
                            AddDialog.this.record.setModifyTime(AddDialog.this.initRec.getModifiedTime());
                        }
                        int n = AddDialog.this.editing ? 0 : 1;
                        ActionEvent actionEvent = new ActionEvent(AddDialog.this, n, "dialog.action.ok");
                        AddDialog.this.externalActions.actionPerformed(actionEvent);
                    }
                    AddDialog.this.dispose();
                    AddDialog.this.userOption = 0;
                }
            } else if (this.command.equals("button.cancel")) {
                boolean bl = true;
                boolean bl2 = AddDialog.this.dataModified();
                if (AddDialog.this.editing && Options.isOptionSet("confirmCancelRecord") && bl2) {
                    bl = GUIService.userConfirm(AddDialog.this, "msg.ask.cancelrecord");
                }
                if (bl) {
                    if (AddDialog.this.externalActions != null) {
                        if (!bl2) {
                            AddDialog.this.record.setModifyTime(AddDialog.this.initRec.getModifiedTime());
                        }
                        int n = AddDialog.this.editing ? 0 : 1;
                        ActionEvent actionEvent = new ActionEvent(AddDialog.this, n, "dialog.action.cancel");
                        AddDialog.this.externalActions.actionPerformed(actionEvent);
                    }
                    AddDialog.this.revertContent();
                    AddDialog.this.dispose();
                    AddDialog.this.userOption = 2;
                } else if (AddDialog.this.recentFocusOwner != null) {
                    AddDialog.this.recentFocusOwner.requestFocus();
                }
            } else if (this.command.equals("button.help")) {
                GUIService.startHelpDialog(AddDialog.this, "dlg.help.entryeditor");
            } else if (this.command.equals("button.revert")) {
                if (AddDialog.this.dataModified()) {
                    boolean bl = true;
                    if (!Options.isOptionSet("useUndoRedo")) {
                        bl = GUIService.userConfirm(AddDialog.this, "msg.ask.revertrecord");
                    }
                    if (bl) {
                        PwsRecord pwsRecord = (PwsRecord)AddDialog.this.getRecord().clone();
                        AddDialog.this.revertContent();
                        AddDialog.this.setupDisplay(AddDialog.this.initGroup);
                        EditUndoManager editUndoManager = AddDialog.this.undoManager;
                        editUndoManager.getClass();
                        EditUndoManager.RevertEdit revertEdit = editUndoManager.new EditUndoManager.RevertEdit(pwsRecord);
                        AddDialog.this.undoManager.undoableEditHappened(new UndoableEditEvent(this, revertEdit));
                    }
                }
            } else if (this.command.equals("button.cover")) {
                AddDialog.this.setPasswordHidden(true);
            } else if (this.command.equals("button.uncover")) {
                AddDialog.this.setPasswordHidden(false);
            } else if (this.command.equals("button.randpassword")) {
                try {
                    Object object;
                    String string = ResourceLoader.getDisplay("msg.genpassword");
                    String string3 = ResourceLoader.getDisplay("button.yes");
                    String string4 = ResourceLoader.getDisplay("button.no");
                    String string5 = ResourceLoader.getDisplay("button.cancel");
                    String string6 = ResourceLoader.getDisplay("button.policy");
                    Object[] objectArray = new Object[]{string3, string4, string6, string5};
                    AddDialog.this.policyEditOk = true;
                    String string7 = "";
                    String string8 = "";
                    do {
                        if (AddDialog.this.policyEditOk) {
                            string8 = new String(PassphraseUtils.makePassword(AddDialog.this.policy));
                            string7 = Util.htmlEncoded(string8);
                        }
                        String string9 = Util.substituteText(string, "$password", string7);
                        AddDialog.this.policyEditOk = true;
                        JOptionPane jOptionPane = new JOptionPane(string9, 3, 1);
                        jOptionPane.setOptions(objectArray);
                        String string10 = ResourceLoader.getDisplay("dlg.confirm");
                        jOptionPane.createDialog(AddDialog.this, string10).setVisible(true);
                        object = jOptionPane.getValue();
                        if (object == null) {
                            object = string5;
                        }
                        if (!object.equals(string6)) continue;
                        this.callAction("menu.edit.policy");
                        object = string4;
                    } while (object.equals(string4) & !AddDialog.this.policyClosed);
                    if (object.equals(string3)) {
                        if (AddDialog.this.passwordHidden) {
                            AddDialog.this.password = new PwsPassphrase(string8.toCharArray());
                            AddDialog.this.passFld.setText(AddDialog.HIDEDUMMY);
                        } else {
                            AddDialog.this.passFld.setText(string8);
                        }
                        AddDialog.this.getRecord();
                        AddDialog.this.refreshTimeFields();
                    }
                }
                catch (InvalidPassphrasePolicy invalidPassphrasePolicy) {
                    invalidPassphrasePolicy.printStackTrace();
                    GUIService.failureMessage("msg.badpasspolicy", null);
                }
            } else if (this.command.equals("button.expirydate")) {
                long l = AddDialog.this.record.getPassLifeTime();
                String string = l == 0L ? null : Util.standardTimeString(l);
                string = (String)JOptionPane.showInputDialog(AddDialog.this.tabPane, ResourceLoader.getDisplay("format.standarddate"), ResourceLoader.getDisplay("dlg.input.expirydate"), 3, null, null, string);
                ActionHandler.resetIdleTime();
                if (string != null) {
                    l = Util.timeFromString(string, null);
                    if (l == -1L) {
                        GUIService.infoMessage(AddDialog.this.tabPane, "dlg.badvalue", "msg.badtimevalue");
                    } else {
                        AddDialog.this.setPassLifeTime(l, true);
                    }
                }
            } else if (this.command.equals("button.clearhistory")) {
                if (GUIService.userConfirm(AddDialog.this.pwHistory, "msg.passhist.delete")) {
                    String string = AddDialog.this.pwHistory.getContentPw3();
                    AddDialog.this.pwHistory.clear();
                    ActionHandler.resetIdleTime();
                    EditUndoManager editUndoManager = AddDialog.this.undoManager;
                    editUndoManager.getClass();
                    EditUndoManager.FieldEdit fieldEdit = editUndoManager.new EditUndoManager.FieldEdit(3, string, AddDialog.this.pwHistory.getContentPw3());
                    AddDialog.this.undoManager.undoableEditHappened(new UndoableEditEvent(this, fieldEdit));
                }
            } else if (this.command.equals("button.historysettings")) {
                int n = AddDialog.this.pwHistory.getMaxEntries();
                boolean bl = this.source == AddDialog.this.historyIcon;
                try {
                    int n2 = n == 0 | !bl ? GUIService.integerInput(AddDialog.this.tabPane, ResourceLoader.getDisplay("dlg.input.historymax"), null, 0, 255, n) : n;
                    String string = AddDialog.this.pwHistory.getContentPw3();
                    AddDialog.this.pwHistory.setMaxItems(n2);
                    AddDialog.this.pwHistory.setActive(n2 > 0);
                    if (bl & AddDialog.this.pwHistory.isActive() & AddDialog.this.pwHistory.getListSize() > 0) {
                        AddDialog.this.tabPane.setSelectedComponent(AddDialog.this.historyPanel);
                    }
                    if (n2 != n) {
                        EditUndoManager editUndoManager = AddDialog.this.undoManager;
                        editUndoManager.getClass();
                        EditUndoManager.FieldEdit fieldEdit = editUndoManager.new EditUndoManager.FieldEdit(4, string, AddDialog.this.pwHistory.getContentPw3());
                        AddDialog.this.undoManager.undoableEditHappened(new UndoableEditEvent(this, fieldEdit));
                    }
                }
                catch (UserBreakException userBreakException) {}
            } else if (this.command.equals("button.historyoff")) {
                AddDialog.this.pwHistory.setActive(false);
            } else if (this.command.equals("menu.edit.copypass")) {
                if (ActionHandler.sendClipboardPassword(AddDialog.this.getRecord()) & Options.isOptionSet("storeMinorChanges")) {
                    AddDialog.this.container.recordUsed(AddDialog.this.record);
                    AddDialog.this.refreshTimeFields();
                }
            } else if (this.command.equals("button.starturl")) {
                String string = AddDialog.this.getUrl();
                if (string.length() == 0) {
                    string = Global.getClipboardText();
                    try {
                        new URL(string);
                        AddDialog.this.urlFld.setText(string);
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    URL uRL = Util.extractURL(string);
                    if (uRL != null) {
                        Global.startBrowser(uRL);
                        if (Options.isOptionSet("useEntryOnBrowse")) {
                            AddDialog.this.container.recordUsed(AddDialog.this.record);
                        }
                    } else {
                        GUIService.infoMessage(AddDialog.this, "dlg.operfailure", "msg.url.failurl");
                    }
                }
            } else if (this.command.equals("button.tearoff.notes")) {
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setPreferredSize(new Dimension(300, 180));
                jPanel.add((Component)AddDialog.this.notesScrollPane, "Center");
                AddDialog.this.tearoffNotesDialog = new ButtonBarDialog(this, AddDialog.this, jPanel, 1, false){
                    private final /* synthetic */ Actions this$1;
                    {
                        this.this$1 = actions;
                    }

                    public void dispose() {
                        if (AddDialog.access$000(Actions.access$3700(this.this$1)) != null) {
                            if (Options.isOptionSet("rememberScreen")) {
                                this.storeBounds(Options.getOptions(), "tearoff_notes", true);
                            }
                            AddDialog.access$3800(Actions.access$3700(this.this$1)).add(AddDialog.access$3600(Actions.access$3700(this.this$1)));
                            AddDialog.access$3800(Actions.access$3700(this.this$1)).getParent().validate();
                            AddDialog.access$3900(Actions.access$3700(this.this$1)).setEnabled(true);
                            AddDialog.access$002(Actions.access$3700(this.this$1), null);
                        }
                        super.dispose();
                    }
                };
                AddDialog.this.tearoffNotesDialog.setTitle(ResourceLoader.getDisplay("adddlg.label.notes"));
                AddDialog.this.tearoffNotesDialog.moveRelatedTo(AddDialog.this);
                AddDialog.this.tearoffNotesDialog.setResizable(true);
                if (Options.isOptionSet("rememberScreen")) {
                    AddDialog.this.tearoffNotesDialog.gainBounds(Options.getOptions(), "tearoff_notes", true);
                }
                AddDialog.this.tearOffButton.setEnabled(false);
                AddDialog.this.notesPanel.repaint();
                AddDialog.this.tearoffNotesDialog.show();
            } else if (this.command.equals("menu.edit.copyuser")) {
                ActionHandler.sendClipboardUsername(AddDialog.this.getRecord());
            } else if (this.command.equals("menu.edit.policy")) {
                PolicyDialog policyDialog = new PolicyDialog((Dialog)AddDialog.this, AddDialog.this.policy, 1);
                policyDialog.setVisible(true);
                policyDialog.dispose();
                AddDialog.this.policyClosed = policyDialog.isUnselected();
                if (AddDialog.this.policyEditOk = policyDialog.isOkPressed()) {
                    AddDialog.this.policy = policyDialog.getEditedPolicy();
                    boolean bl = !AddDialog.this.policy.equals(Global.passphrasePolicy);
                    AddDialog.this.policyIcon.setVisible(bl);
                    try {
                        AddDialog.this.record.setPassPolicy(bl ? AddDialog.this.policy : null);
                    }
                    catch (InvalidPassphrasePolicy invalidPassphrasePolicy) {
                        GUIService.failureMessage(null, invalidPassphrasePolicy);
                    }
                }
            } else if (this.command.equals("menu.edit.undo")) {
                AddDialog.this.undoManager.undo();
            } else if (this.command.equals("menu.edit.redo")) {
                AddDialog.this.undoManager.redo();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JPanel jPanel;
            if (changeEvent.getSource() == AddDialog.this.tabPane && (jPanel = (JPanel)AddDialog.this.tabPane.getSelectedComponent()) != null) {
                AddDialog.this.explainLabel.setText((String)jPanel.getClientProperty("explain"));
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            String string = (String)itemEvent.getItem();
            if (itemEvent.getSource() == AddDialog.this.group && itemEvent.getStateChange() == 1 && !string.equals(AddDialog.this.actGroup)) {
                EditUndoManager editUndoManager = AddDialog.this.undoManager;
                editUndoManager.getClass();
                EditUndoManager.FieldEdit fieldEdit = editUndoManager.new EditUndoManager.FieldEdit(0, AddDialog.this.actGroup, string);
                AddDialog.this.undoManager.undoableEditHappened(new UndoableEditEvent(this, fieldEdit));
                AddDialog.this.actGroup = string;
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            AddDialog.this.recentFocusOwner = focusEvent.getComponent();
            Component component = focusEvent.getOppositeComponent();
            boolean bl = component == AddDialog.this.revertButton | component == AddDialog.this.cancelButton;
            if (focusEvent.getComponent() == AddDialog.this.passFld && !AddDialog.this.getPassword().equals(AddDialog.this.record.getPassword()) & !bl) {
                AddDialog.this.getRecord();
            }
        }

        static /* synthetic */ AddDialog access$3700(Actions actions) {
            return actions.AddDialog.this;
        }
    }

    private class History
    extends HistoryHandler {
        public History() {
            this.setFont(DisplayManager.getFont("data"));
        }

        public void pushPassword(String string, long l) {
            super.pushPassword(string, l);
            AddDialog.this.refreshHistoryComment();
            AddDialog.this.controlHistoryPanel();
        }

        public void setMaxItems(int n) {
            super.setMaxItems(n);
            AddDialog.this.refreshHistoryComment();
            AddDialog.this.controlHistoryPanel();
        }

        public void setContentPw3(String string) {
            int n = AddDialog.this.tabPane.getSelectedIndex();
            super.setContentPw3(string);
            if (string == null && !Options.isOptionSet("editActiveHistory")) {
                super.setActive(false);
            }
            AddDialog.this.refreshHistoryComment();
            AddDialog.this.controlHistoryPanel();
            if (n < AddDialog.this.tabPane.getTabCount()) {
                AddDialog.this.tabPane.setSelectedIndex(n);
            }
        }

        public void clear() {
            super.clear();
            AddDialog.this.controlHistoryPanel();
        }

        public void setActive(boolean bl) {
            super.setActive(bl);
            AddDialog.this.controlHistoryPanel();
            if (!bl) {
                AddDialog.this.undoManager.removeHistoryEdits();
            }
        }
    }
}

